/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import org.eclipse.aperi.snmp.GenericFilter;
import org.eclipse.aperi.snmp.GenericListener;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpBERlength;
import org.eclipse.aperi.snmp.SnmpDecodeException;
import org.eclipse.aperi.snmp.SnmpMetaPDU;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpV2PDU;
import org.eclipse.aperi.snmp.SnmpV2Trap;
import org.eclipse.aperi.snmp.TrapFilter;
import org.eclipse.aperi.snmp.TrapListener;
import org.eclipse.aperi.snmp.V2TrapFilter;
import org.eclipse.aperi.snmp.V2TrapListener;
import org.eclipse.aperi.snmp.data.IPAddress;

public class TrapReceiver
implements Runnable {
    private DatagramSocket sock;
    private final byte[] buffer = new byte[1500];
    private DatagramPacket packet;
    private Vector V1listeners = new Vector();
    private Vector V2listeners = new Vector();
    private Vector genericListeners = new Vector();
    private boolean receiverRunning = false;

    public TrapReceiver() throws SocketException {
        this.initialize(162, 2099);
    }

    public TrapReceiver(int port) throws SocketException {
        this.initialize(port, 2099);
    }

    public TrapReceiver(int trapPort, int registryPort) throws SocketException {
        this.initialize(trapPort, registryPort);
    }

    private void initialize(int trapPort, int registryPort) throws SocketException {
        final int port = trapPort;
        try {
            this.sock = (DatagramSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new DatagramSocket(port);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            Exception e = pe.getException();
            if (e instanceof SocketException) {
                throw (SocketException)e;
            }
            e.printStackTrace();
        }
    }

    public synchronized void subscribe(TrapListener listener, TrapFilter filter) {
        SingleListener l = new SingleListener(listener, filter);
        this.V1listeners.addElement(l);
    }

    public synchronized void subscribeV2(V2TrapListener listener, V2TrapFilter filter) {
        SingleListener l = new SingleListener(listener, filter);
        this.V2listeners.addElement(l);
    }

    public synchronized void subscribeGeneric(GenericListener listener, GenericFilter filter) {
        SingleListener l = new SingleListener(listener, filter);
        this.genericListeners.addElement(l);
    }

    public synchronized void changeFilter(TrapListener listener, TrapFilter oldFilter, TrapFilter newFilter) {
        this.changeFilter(listener, oldFilter, newFilter, true);
    }

    public synchronized void changeFilter(V2TrapListener listener, V2TrapFilter oldFilter, TrapFilter newFilter) {
        this.changeFilter(listener, oldFilter, newFilter, false);
    }

    public synchronized void changeFilter(Object listener, Object oldFilter, Object newFilter, boolean v1) {
        if (listener != null) {
            Vector list = v1 ? this.V1listeners : this.V2listeners;
            int limit = list.size();
            for (int i = 0; i < limit; ++i) {
                SingleListener inst = (SingleListener)list.elementAt(i);
                if (!listener.equals(inst.listener) || !oldFilter.equals(inst.filter)) continue;
                inst.filter = newFilter;
                break;
            }
        }
    }

    public void unsubscribe(TrapListener listener, TrapFilter filter) {
        this.unsubscribe(listener, filter, true);
    }

    public void unsubscribe(V2TrapListener listener, V2TrapFilter filter) {
        this.unsubscribe(listener, filter, false);
    }

    synchronized void unsubscribe(Object listener, Object filter, boolean v1) {
        if (listener != null) {
            Vector list = v1 ? this.V1listeners : this.V2listeners;
            int limit = list.size();
            for (int i = 0; i < limit; ++i) {
                SingleListener inst = (SingleListener)list.elementAt(i);
                if (!listener.equals(inst.listener) || !filter.equals(inst.filter)) continue;
                list.removeElementAt(i);
                break;
            }
        }
    }

    public void terminate() {
        block2: {
            byte[] terminateData = new byte[1];
            try {
                final DatagramPacket d = new DatagramPacket(terminateData, terminateData.length, InetAddress.getLocalHost(), this.sock.getLocalPort());
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        TrapReceiver.this.sock.send(d);
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                if (!this.receiverRunning) break block2;
                System.out.println("TrapReceiver: not terminated:" + t.toString());
            }
        }
    }

    public void run() {
        this.receiverRunning = true;
        Thread.currentThread().setName("TrapReceiver");
        block11: while (true) {
            block35: {
                try {
                    this.packet = (DatagramPacket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            DatagramPacket tmpPdu = new DatagramPacket(TrapReceiver.this.buffer, TrapReceiver.this.buffer.length);
                            TrapReceiver.this.sock.receive(tmpPdu);
                            return tmpPdu;
                        }
                    });
                }
                catch (PrivilegedActionException pe) {
                    if (!SnmpV1API.isTracing()) break block35;
                    SnmpV1API.trace("TrapReceiver - error on receive - " + pe.getException().toString());
                }
            }
            try {
                SingleListener l;
                int i;
                int limit;
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("TrapReceiver - received packet");
                }
                if (this.packet.getLength() == 1) {
                    this.receiverRunning = false;
                    this.sock.close();
                    return;
                }
                byte[] buf = this.packet.getData();
                int versionOffset = 1;
                versionOffset += SnmpBERlength.size(buf, versionOffset);
                byte version = buf[versionOffset += 2];
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace(" version of trap is " + version);
                }
                SnmpMetaPDU pdu = null;
                if (version == 0) {
                    SnmpTrap trap = SnmpAsn1.decodeTrap(buf);
                    if (SnmpV1API.isTracing()) {
                        SnmpV1API.trace("Received Trap - " + trap.toString());
                    }
                    if ((pdu = trap) == null) continue;
                    trap.senderAddr = new IPAddress(this.packet.getAddress().getAddress(), 0);
                    trap.senderPort = this.packet.getPort();
                    limit = this.V1listeners.size();
                    for (i = 0; i < limit; ++i) {
                        try {
                            l = (SingleListener)this.V1listeners.elementAt(i);
                            if (((TrapFilter)l.filter).filter(trap)) {
                                if (SnmpV1API.isTracing()) {
                                    SnmpV1API.trace("passing trap to listener");
                                }
                                ((TrapListener)l.listener).handle(trap);
                                continue;
                            }
                            if (!SnmpV1API.isTracing()) continue;
                            SnmpV1API.trace("filter failed, skipping listener");
                            continue;
                        }
                        catch (Throwable t) {
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("TrapListener threw an error - removing it." + t.toString());
                            }
                            this.V1listeners.removeElementAt(i);
                            --i;
                            --limit;
                        }
                    }
                } else if (version == 1) {
                    SnmpV2Trap trap = null;
                    trap = (SnmpV2Trap)SnmpAsn1.decodeV2PDU(buf, this.packet.getLength(), false);
                    trap.senderAddr = new IPAddress(this.packet.getAddress().getAddress(), 0);
                    trap.senderPort = this.packet.getPort();
                    pdu = trap;
                    if (pdu == null) continue;
                    if (SnmpV1API.isTracing()) {
                        SnmpV1API.trace("Received Trap - " + trap.toString());
                    }
                    limit = this.V2listeners.size();
                    for (i = 0; i < limit; ++i) {
                        try {
                            l = (SingleListener)this.V2listeners.elementAt(i);
                            if (!((V2TrapFilter)l.filter).filter(trap)) continue;
                            ((V2TrapListener)l.listener).handle(trap);
                            continue;
                        }
                        catch (Throwable t) {
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("V2TrapListener threw an error - removing it." + t.toString());
                            }
                            this.V2listeners.removeElementAt(i);
                            --i;
                            --limit;
                        }
                    }
                } else if (version == 3) {
                    if (SnmpV1API.isTracing()) {
                        SnmpV1API.trace("Received V3 message - discarding");
                    }
                } else if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("Received Trap with version " + version);
                }
                if (pdu == null) continue;
                int limit2 = this.genericListeners.size();
                int i2 = 0;
                while (true) {
                    if (i2 >= limit2) continue block11;
                    try {
                        SingleListener l2 = (SingleListener)this.genericListeners.elementAt(i2);
                        if (((GenericFilter)l2.filter).filter(pdu)) {
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("passing trap to genericListener");
                            }
                            ((GenericListener)l2.listener).handle(pdu);
                        }
                    }
                    catch (Throwable t) {
                        if (SnmpV1API.isTracing()) {
                            SnmpV1API.trace("Generic Listener threw an error - removing it." + t.toString());
                        }
                        this.genericListeners.removeElementAt(i2);
                        --i2;
                        --limit2;
                        System.out.println("error in handling listener:" + t.toString());
                        t.printStackTrace();
                    }
                    ++i2;
                }
            }
            catch (SnmpDecodeException s) {
                if (!SnmpV1API.isTracing()) continue;
                SnmpV1API.trace(s.toString());
                continue;
            }
            catch (Throwable t2) {
                if (!SnmpV1API.isTracing()) continue;
                SnmpV1API.trace("error in handling Trap:" + t2.toString());
                continue;
            }
            break;
        }
    }

    class SingleListener
    implements TrapFilter,
    V2TrapFilter,
    GenericFilter {
        protected Object listener;
        protected Object filter;

        protected SingleListener(Object listener, Object filter) {
            this.listener = listener;
            this.filter = filter != null ? filter : this;
        }

        public boolean filter(SnmpTrap trap) {
            return true;
        }

        public boolean filter(SnmpV2PDU trap) {
            return true;
        }

        public boolean filter(SnmpMetaPDU message) {
            return true;
        }
    }
}

