/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import org.eclipse.aperi.snmp.SnmpAsn1;
import org.eclipse.aperi.snmp.SnmpV2PDU;

public class V2TrapReceiver
implements Runnable {
    private DatagramSocket sock;
    private byte[] buffer = new byte[1500];
    private DatagramPacket packet;
    private SnmpV2PDU trap;
    private Vector listeners = new Vector();

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                V2TrapReceiver r = new V2TrapReceiver(Integer.parseInt(args[0]), -1);
                Thread t = new Thread(r);
                t.start();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        } else {
            System.out.println("usage : java V2TrapReceiver <port number>");
        }
    }

    public V2TrapReceiver() throws SocketException, RemoteException {
        this.initialize(162, 2099);
    }

    public V2TrapReceiver(int port) throws SocketException, RemoteException {
        this.initialize(port, 2099);
    }

    public V2TrapReceiver(int trapPort, int registryPort) throws SocketException, RemoteException {
        this.initialize(trapPort, registryPort);
    }

    private void initialize(int trapPort, int registryPort) throws SocketException {
        final int port = trapPort;
        try {
            this.sock = (DatagramSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new DatagramSocket(port);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            Exception e = pe.getException();
            if (e instanceof SocketException) {
                throw (SocketException)e;
            }
            e.printStackTrace();
        }
    }

    public void terminate() {
        byte[] terminateData = new byte[1];
        try {
            final DatagramPacket d = new DatagramPacket(terminateData, terminateData.length, InetAddress.getLocalHost(), this.sock.getLocalPort());
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    V2TrapReceiver.this.sock.send(d);
                    return null;
                }
            });
        }
        catch (Exception e) {
            System.out.println("V2TrapReceiver: not terminated:" + e.toString());
        }
    }

    public void run() {
        Thread.currentThread().setName("V2TrapReceiver");
        while (true) {
            try {
                this.packet = (DatagramPacket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        DatagramPacket tmpPdu = new DatagramPacket(V2TrapReceiver.this.buffer, V2TrapReceiver.this.buffer.length);
                        V2TrapReceiver.this.sock.receive(tmpPdu);
                        return tmpPdu;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                System.out.println("Receive failed - error : " + e.getException().toString());
            }
            if (this.packet.getLength() == 1) {
                this.sock.close();
                return;
            }
            byte[] buf = this.packet.getData();
            this.trap = SnmpAsn1.decodeV2PDU(buf, this.packet.getLength());
            System.out.println("Received V2 PDU : " + this.trap.toString());
        }
    }
}

