/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class OrderedHashtable
extends Dictionary
implements Serializable {
    Vector keys;
    Vector values;

    public OrderedHashtable(int initialCapacity, float loadFactor) {
        this.keys = new Vector(initialCapacity, (int)(loadFactor * (float)initialCapacity));
        this.values = new Vector(initialCapacity, (int)(loadFactor * (float)initialCapacity));
    }

    public OrderedHashtable(int initialCapacity) {
        this.keys = new Vector(initialCapacity);
        this.values = new Vector(initialCapacity);
    }

    public OrderedHashtable() {
        this.keys = new Vector();
        this.values = new Vector();
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.size() == 0;
    }

    public synchronized Enumeration keys() {
        return new KeyEnumeration();
    }

    public synchronized Enumeration elements() {
        return new ValueEnumeration();
    }

    public synchronized boolean contains(Object value) {
        return this.values.indexOf(value) >= 0;
    }

    public synchronized boolean containsKey(Object key) {
        return this.keys.indexOf(key) >= 0;
    }

    public synchronized Object get(Object key) {
        int answer = this.keys.indexOf(key);
        if (answer >= 0) {
            return this.values.elementAt(answer);
        }
        return null;
    }

    protected void rehash() {
    }

    public synchronized Object put(Object key, Object value) {
        int answer = this.keys.indexOf(key);
        if (answer >= 0) {
            this.keys.setElementAt(key, answer);
            this.values.setElementAt(value, answer);
            return null;
        }
        this.keys.addElement(key);
        this.values.addElement(value);
        return null;
    }

    public synchronized Object remove(Object key) {
        Object previous = null;
        int answer = this.keys.indexOf(key);
        if (answer >= 0) {
            previous = this.values.elementAt(answer);
            this.keys.removeElementAt(answer);
            this.values.removeElementAt(answer);
        }
        return previous;
    }

    public synchronized void clear() {
        this.keys.removeAllElements();
        this.values.removeAllElements();
    }

    public synchronized Object clone() {
        return new Object();
    }

    public synchronized String toString() {
        return new String("");
    }

    private class ValueEnumeration
    implements Enumeration {
        int currentIndex = 0;

        private ValueEnumeration() {
        }

        public boolean hasMoreElements() {
            return this.currentIndex < OrderedHashtable.this.values.size();
        }

        public Object nextElement() {
            if (this.currentIndex < OrderedHashtable.this.values.size()) {
                return OrderedHashtable.this.values.elementAt(this.currentIndex++);
            }
            return null;
        }
    }

    private class KeyEnumeration
    implements Enumeration {
        int currentIndex = 0;

        private KeyEnumeration() {
        }

        public boolean hasMoreElements() {
            return this.currentIndex < OrderedHashtable.this.keys.size();
        }

        public Object nextElement() {
            if (this.currentIndex < OrderedHashtable.this.keys.size()) {
                return OrderedHashtable.this.keys.elementAt(this.currentIndex++);
            }
            return null;
        }
    }
}

