/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.rmi.ConnectException;
import java.util.Hashtable;

public class PHashtable
extends Hashtable {
    public static final String configDirectory = "config";
    private static final int MAX_INVALIDS = 15;
    private static final int MIN_FILE_SIZE = 100000;
    private int numInvalids = 0;
    private RandomAccessFile theRAF;
    private String filename;
    private Hashtable offsetTable = new Hashtable();
    private FileOutputStream ostream;
    private ObjectOutputStream theOOS;
    private static final String PARSECHAR = ":`:";
    private static Hashtable locks = new Hashtable();

    public static void main(String[] args) {
        PHashtable x = new PHashtable("\\work\\foo\\bar\\whee", false);
    }

    public PHashtable(String filename, boolean addDir) {
        if (addDir) {
            File configDir = new File(configDirectory);
            if (!configDir.isDirectory()) {
                configDir.mkdirs();
            }
            String sep = System.getProperty("file.separator");
            this.filename = configDirectory + sep + filename;
        } else {
            if (filename != null && (filename.indexOf(47) >= 0 || filename.indexOf(92) >= 0)) {
                File dir;
                String dir1 = null;
                if (filename.indexOf(47) >= 0) {
                    dir1 = filename.substring(0, filename.lastIndexOf(47));
                }
                String dir2 = null;
                if (filename.indexOf(92) >= 0) {
                    dir2 = filename.substring(0, filename.lastIndexOf(92));
                }
                String dirName = null;
                dirName = dir1 != null && dir2 != null ? (dir1.length() > dir2.length() ? dir1 : dir2) : (dir1 != null ? dir1 : dir2);
                if (dirName != null && !(dir = new File(dirName)).isDirectory()) {
                    dir.mkdirs();
                }
            }
            this.filename = filename;
        }
        this.restore();
    }

    public PHashtable(String subDirectory, String filename) {
        if (subDirectory != null) {
            if (subDirectory.length() > 0) {
                File configDir;
                char last = subDirectory.charAt(subDirectory.length() - 1);
                if (last == '/' || last == '\\') {
                    subDirectory = subDirectory.substring(0, subDirectory.length() - 1);
                }
                if (!(configDir = new File(subDirectory)).isDirectory()) {
                    configDir.mkdirs();
                }
            } else {
                subDirectory = ".";
            }
        }
        String sep = System.getProperty("file.separator");
        this.filename = subDirectory + sep + filename;
        this.restore();
    }

    public static String createKey(String key1, String key2) {
        return key1 + PARSECHAR + key2;
    }

    public static String createKey(String key1, String key2, String key3) {
        return key1 + PARSECHAR + key2 + PARSECHAR + key3;
    }

    public static String[] parseKey(String key) {
        String[] returnString = new String[2];
        int pCharPos = key.indexOf(PARSECHAR);
        returnString[0] = key.substring(0, pCharPos - 1);
        returnString[1] = key.substring(pCharPos + PARSECHAR.length());
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean backup() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            boolean returnValue = true;
            if (this.theRAF != null) {
                this.theRAF.close();
            }
            if (this.theOOS != null) {
                this.theOOS.close();
            }
            File objectSourceFile = new File(this.filename + ".db");
            File objectDestFile = new File(this.filename + ".db" + ".bak");
            File sourceFile = new File(this.filename + ".tb");
            File destFile = new File(this.filename + ".tb" + ".bak");
            if (!sourceFile.exists() || !objectSourceFile.exists()) {
                returnValue = false;
            } else {
                objectDestFile.delete();
                destFile.delete();
                sourceFile.renameTo(destFile);
                objectSourceFile.renameTo(objectDestFile);
            }
            this.theRAF = new RandomAccessFile(this.filename + ".tb", "rw");
            this.ostream = new FileOutputStream(this.filename + ".db");
            this.theOOS = new ObjectOutputStream(this.ostream);
            return returnValue;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        try {
            if (this.theRAF != null) {
                this.theRAF.close();
            }
            if (this.theOOS != null) {
                this.theOOS.close();
            }
            if (this.ostream != null) {
                this.ostream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        Object object = this.getLock();
        synchronized (object) {
            ObjectInputStream backupOIS = null;
            RandomAccessFile backup = null;
            this.offsetTable = new Hashtable();
            try {
                if (this.backup()) {
                    long start = System.currentTimeMillis();
                    super.clear();
                    FileInputStream backupFIS = new FileInputStream(this.filename + ".db" + ".bak");
                    backupOIS = new ObjectInputStream(backupFIS);
                    backup = new RandomAccessFile(this.filename + ".tb" + ".bak", "r");
                    long fileLength = backup.length();
                    while (backup.getFilePointer() != fileLength) {
                        boolean validRecord = backup.readBoolean();
                        Object key = backupOIS.readObject();
                        Object value = backupOIS.readObject();
                        if (!validRecord) continue;
                        this.put(key, value);
                    }
                    backup.close();
                    backupOIS.close();
                }
            }
            catch (ConnectException ce) {
                System.out.println("Tried to restore a remote reference, but did not succeed...");
            }
            catch (Exception e) {
                System.out.println("PHashtable: an exception occurred restoring data:" + e.toString());
                try {
                    if (backup != null) {
                        backup.close();
                    }
                    if (backupOIS != null) {
                        backupOIS.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
    }

    public String dumpStats() {
        StringBuffer returnString = new StringBuffer("PHhashtable Stats");
        returnString.append("\nFilename: ");
        returnString.append(this.filename);
        returnString.append("\nsize: ");
        returnString.append(this.size());
        returnString.append("\ninvalids: ");
        returnString.append(this.numInvalids);
        returnString.append("\nfile size: ");
        File oFile = new File(this.filename + ".db");
        returnString.append(oFile.length());
        return returnString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        super.clear();
        try {
            if (this.theRAF != null) {
                this.theRAF.close();
            }
            if (this.theOOS != null) {
                this.theOOS.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object object = this.getLock();
        synchronized (object) {
            File fileP = new File(this.filename + ".tb");
            if (fileP.exists()) {
                fileP.delete();
            }
            if ((fileP = new File(this.filename + ".db")).exists()) {
                fileP.delete();
            }
            try {
                this.theRAF = new RandomAccessFile(this.filename + ".tb", "rw");
                this.ostream = new FileOutputStream(this.filename + ".db");
                this.theOOS = new ObjectOutputStream(this.ostream);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object returnObject = null;
        Object object = this.getLock();
        synchronized (object) {
            File oFile = new File(this.filename + ".db");
            if (key != null) {
                returnObject = super.remove(key);
                try {
                    long curPos = this.theRAF.getFilePointer();
                    this.theRAF.seek((Long)this.offsetTable.get(key));
                    this.theRAF.writeBoolean(false);
                    this.theRAF.seek(curPos);
                    if (++this.numInvalids > 15 && oFile.length() > 100000L) {
                        System.out.println("PHashtable : remove : compacting (size/invalids " + this.size() + "/" + this.numInvalids + ")");
                        this.numInvalids = 0;
                        this.clear();
                        this.restore();
                    }
                }
                catch (Exception e) {
                    returnObject = null;
                    System.out.println("PHashtable:remove: an exception occurred:");
                    e.printStackTrace();
                }
            }
        }
        return returnObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Object returnObject = null;
        Object object = this.getLock();
        synchronized (object) {
            if (key != null && value != null) {
                try {
                    if (super.get(key) != null) {
                        this.remove(key);
                        this.theOOS.reset();
                    }
                    this.offsetTable.put(key, new Long(this.theRAF.getFilePointer()));
                    this.theRAF.writeBoolean(true);
                    this.theOOS.writeObject(key);
                    this.theOOS.writeObject(value);
                    this.theOOS.flush();
                    returnObject = super.put(key, value);
                }
                catch (Exception e) {
                    System.out.println("an exception occurred:");
                    e.printStackTrace();
                }
            }
        }
        return returnObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLock() {
        Object l;
        Hashtable hashtable = locks;
        synchronized (hashtable) {
            l = locks.get(this.filename);
            if (l == null) {
                l = new Object();
                locks.put(this.filename, l);
            }
        }
        return l;
    }
}

