/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;

public abstract class SetOperatorNode
extends TableOperatorNode {
    boolean all;
    OrderByList orderByList;
    PredicateList leftOptPredicates;
    PredicateList rightOptPredicates;
    PredicateList pushedPredicates;
    HashMap leftScopedPreds;
    HashMap rightScopedPreds;

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        super.init(object, object2, object4);
        this.all = (Boolean)object3;
        this.resultColumns = this.leftResultSet.getResultColumns().copyListAndObjects();
    }

    public Optimizable modifyAccessPath(JBitSet jBitSet, PredicateList predicateList) throws StandardException {
        if (predicateList != null && !this.getTrulyTheBestAccessPath().getJoinStrategy().isHashJoin()) {
            for (int i = predicateList.size() - 1; i >= 0; --i) {
                if (!this.pushOptPredicate(predicateList.getOptPredicate(i))) continue;
                predicateList.removeOptPredicate(i);
            }
        }
        CostEstimate costEstimate = this.getFinalCostEstimate();
        ResultSetNode resultSetNode = (ResultSetNode)((Object)this.modifyAccessPath(jBitSet));
        if (this.hasUnPushedPredicates()) {
            ResultSetNode resultSetNode2 = (ResultSetNode)this.getNodeFactory().getNode(151, resultSetNode, resultSetNode.getResultColumns(), null, this.pushedPredicates, null, null, null, this.getContextManager());
            resultSetNode2.costEstimate = costEstimate.cloneMe();
            resultSetNode2.setReferencedTableMap(resultSetNode.getReferencedTableMap());
            resultSetNode = resultSetNode2;
        }
        return (Optimizable)((Object)resultSetNode);
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        if (!(this instanceof UnionNode)) {
            return false;
        }
        Predicate predicate = (Predicate)optimizablePredicate;
        if (!predicate.pushableToSubqueries()) {
            return false;
        }
        boolean bl = false;
        JBitSet jBitSet = new JBitSet(this.getReferencedTableMap().size());
        BaseTableNumbersVisitor baseTableNumbersVisitor = new BaseTableNumbersVisitor(jBitSet);
        this.leftResultSet.accept(baseTableNumbersVisitor);
        boolean bl2 = bl = jBitSet.getFirstSetBit() != -1;
        if (!bl) {
            return false;
        }
        jBitSet.clearAll();
        this.rightResultSet.accept(baseTableNumbersVisitor);
        boolean bl3 = bl = jBitSet.getFirstSetBit() != -1;
        if (!bl) {
            return false;
        }
        jBitSet.clearAll();
        this.accept(baseTableNumbersVisitor);
        int[] nArray = new int[]{-1};
        Predicate predicate2 = null;
        if (this.leftScopedPreds == null) {
            this.leftScopedPreds = new HashMap();
        } else {
            predicate2 = (Predicate)this.leftScopedPreds.get(predicate);
        }
        if (predicate2 == null) {
            predicate2 = predicate.getPredScopedForResultSet(jBitSet, this.leftResultSet, nArray);
            this.leftScopedPreds.put(predicate, predicate2);
        }
        this.getLeftOptPredicateList().addOptPredicate(predicate2);
        predicate2 = null;
        if (this.rightScopedPreds == null) {
            this.rightScopedPreds = new HashMap();
        } else {
            predicate2 = (Predicate)this.rightScopedPreds.get(predicate);
        }
        if (predicate2 == null) {
            predicate2 = predicate.getPredScopedForResultSet(jBitSet, this.rightResultSet, nArray);
            this.rightScopedPreds.put(predicate, predicate2);
        }
        this.getRightOptPredicateList().addOptPredicate(predicate2);
        if (this.pushedPredicates == null) {
            this.pushedPredicates = new PredicateList();
        }
        this.pushedPredicates.addOptPredicate(predicate);
        return true;
    }

    public void pullOptPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        if (this.pushedPredicates == null) {
            return;
        }
        if (this.leftOptPredicates != null) {
            this.leftOptPredicates.removeAllElements();
        }
        if (this.rightOptPredicates != null) {
            this.rightOptPredicates.removeAllElements();
        }
        Predicate predicate = null;
        RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(false);
        for (int i = 0; i < this.pushedPredicates.size(); ++i) {
            predicate = (Predicate)this.pushedPredicates.getOptPredicate(i);
            if (predicate.isScopedForPush()) {
                predicate.getAndNode().accept(remapCRsVisitor);
                continue;
            }
            optimizablePredicateList.addOptPredicate(predicate);
        }
        this.pushedPredicates.removeAllElements();
    }

    protected boolean hasUnPushedPredicates() {
        if (this.leftOptPredicates != null && this.leftOptPredicates.size() > 0 || this.rightOptPredicates != null && this.rightOptPredicates.size() > 0) {
            return true;
        }
        if (this.leftResultSet instanceof SetOperatorNode && ((SetOperatorNode)this.leftResultSet).hasUnPushedPredicates()) {
            return true;
        }
        return this.rightResultSet instanceof SetOperatorNode && ((SetOperatorNode)this.rightResultSet).hasUnPushedPredicates();
    }

    public String toString() {
        return "";
    }

    public void bindResultColumns(FromList fromList) throws StandardException {
        super.bindResultColumns(fromList);
        this.buildRCL();
    }

    public void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        super.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
        this.buildRCL();
    }

    private void buildRCL() throws StandardException {
        if (this.leftResultSet.getResultColumns().size() != this.rightResultSet.getResultColumns().size()) {
            throw StandardException.newException("42X58", this.getOperatorName());
        }
        this.resultColumns = this.leftResultSet.getResultColumns().copyListAndObjects();
        this.resultColumns.setUnionResultExpression(this.rightResultSet.getResultColumns(), this.tableNumber, this.level, this.getOperatorName());
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList == null) {
            ResultColumnList resultColumnList2 = this.rightResultSet.getResultColumns();
            ResultColumnList resultColumnList3 = this.leftResultSet.getResultColumns();
            this.leftResultSet.bindUntypedNullsToResultColumns(resultColumnList3);
            this.rightResultSet.bindUntypedNullsToResultColumns(resultColumnList2);
        } else {
            this.leftResultSet.bindUntypedNullsToResultColumns(resultColumnList);
            this.rightResultSet.bindUntypedNullsToResultColumns(resultColumnList);
        }
    }

    int getParamColumnTypes(DataTypeDescriptor[] dataTypeDescriptorArray, RowResultSetNode rowResultSetNode) {
        int n = 0;
        for (int i = 0; i < dataTypeDescriptorArray.length; ++i) {
            ResultColumn resultColumn;
            if (dataTypeDescriptorArray[i] != null || (resultColumn = (ResultColumn)rowResultSetNode.getResultColumns().elementAt(i)).getExpression().isParameterNode()) continue;
            dataTypeDescriptorArray[i] = resultColumn.getExpressionType();
            ++n;
        }
        return n;
    }

    void setParamColumnTypes(DataTypeDescriptor[] dataTypeDescriptorArray, RowResultSetNode rowResultSetNode) throws StandardException {
        ResultColumnList resultColumnList = rowResultSetNode.getResultColumns();
        int n = resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            if (!resultColumn.getExpression().isParameterNode()) continue;
            ((ParameterNode)resultColumn.getExpression()).setDescriptor(dataTypeDescriptorArray[i]);
        }
    }

    public void bindTargetExpressions(FromList fromList) throws StandardException {
        this.leftResultSet.bindTargetExpressions(fromList);
        this.rightResultSet.bindTargetExpressions(fromList);
    }

    void pushOrderByList(OrderByList orderByList) {
        this.orderByList = orderByList;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        SetOperatorNode setOperatorNode = this;
        this.leftResultSet = this.leftResultSet.preprocess(n, groupByList, fromList);
        this.rightResultSet = this.rightResultSet.preprocess(n, groupByList, fromList);
        this.referencedTableMap = (JBitSet)this.leftResultSet.getReferencedTableMap().clone();
        this.referencedTableMap.or(this.rightResultSet.getReferencedTableMap());
        if (!this.all && this.orderByList != null && this.orderByList.allAscending() && this.orderByList.isInOrderPrefix(this.resultColumns)) {
            this.orderByList = null;
        }
        return setOperatorNode;
    }

    public ResultSetNode ensurePredicateList(int n) throws StandardException {
        return this.genProjectRestrict(n);
    }

    public void verifySelectStarSubquery(FromList fromList, int n) throws StandardException {
        this.leftResultSet.verifySelectStarSubquery(fromList, n);
        this.rightResultSet.verifySelectStarSubquery(fromList, n);
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        return this.leftResultSet.getFromTableByName(string, string2, bl);
    }

    public void setResultToBooleanTrueNode(boolean bl) throws StandardException {
        super.setResultToBooleanTrueNode(bl);
        this.leftResultSet.setResultToBooleanTrueNode(bl);
        this.rightResultSet.setResultToBooleanTrueNode(bl);
    }

    public ResultSetNode enhanceRCLForInsert(int n, int[] nArray, DataDictionary dataDictionary, TableDescriptor tableDescriptor, FromVTI fromVTI) throws StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n2 = this.resultColumns.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn;
            if (nArray[i] != -1) {
                ResultColumn resultColumn2 = this.resultColumns.getResultColumn(nArray[i] + 1);
                ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn2.getName(), null, this.getContextManager());
                columnReference.setSource(resultColumn2);
                columnReference.setType(resultColumn2.getExpressionType());
                columnReference.setNestingLevel(0);
                columnReference.setSourceLevel(0);
                resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, resultColumn2.getType(), columnReference, this.getContextManager());
            } else {
                resultColumn = this.genNewRCForInsert(tableDescriptor, fromVTI, i + 1, dataDictionary);
            }
            resultColumnList.addResultColumn(resultColumn);
        }
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, resultColumnList, null, null, null, null, this.tableProperties, this.getContextManager());
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    public boolean performMaterialization(JBitSet jBitSet) throws StandardException {
        return false;
    }

    abstract String getOperatorName();

    protected PredicateList getLeftOptPredicateList() throws StandardException {
        if (this.leftOptPredicates == null) {
            this.leftOptPredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        return this.leftOptPredicates;
    }

    protected PredicateList getRightOptPredicateList() throws StandardException {
        if (this.rightOptPredicates == null) {
            this.rightOptPredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        return this.rightOptPredicates;
    }
}

