/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Level;
import com.ibm.log.LevelLoggerSupport;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public class CorporateLevelLogger
extends LevelLoggerSupport {
    static final long serialVersionUID = -6664860421036231300L;
    private String client = "";
    private String component = "";
    private String organization = "";
    private String product = "";
    private String server = "";

    public CorporateLevelLogger() {
    }

    public CorporateLevelLogger(String name) {
        super(name);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("organization", this.getOrganization());
        props.put("product", this.getProduct());
        props.put("component", this.getComponent());
        props.put("client", this.getClient());
        props.put("server", this.getServer());
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("organization");
        if (prop != null) {
            this.setOrganization(prop);
        }
        if ((prop = props.getProperty("product")) != null) {
            this.setProduct(prop);
        }
        if ((prop = props.getProperty("component")) != null) {
            this.setComponent(prop);
        }
        if ((prop = props.getProperty("client")) != null) {
            this.setClient(prop);
        }
        if ((prop = props.getProperty("server")) != null) {
            this.setServer(prop);
        }
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String name) {
        if (name != null) {
            this.organization = name;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setOrganization");
            LogUtil.errorMsg(msg);
        }
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String name) {
        if (name != null) {
            this.product = name;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setProduct");
            LogUtil.errorMsg(msg);
        }
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String name) {
        if (name != null) {
            this.component = name;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setComponent");
            LogUtil.errorMsg(msg);
        }
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String name) {
        if (name != null) {
            this.client = name;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setClient");
            LogUtil.errorMsg(msg);
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String name) {
        if (name != null) {
            this.server = name;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setServer");
            LogUtil.errorMsg(msg);
        }
    }

    public void message(Level level, Object loggingClass, String loggingMethod, String key) {
        if (this.isLoggable(level)) {
            this.logMessage(level, loggingClass, loggingMethod, key, this.getMessageFile(), null);
        }
    }

    public void message(Level level, Object loggingClass, String loggingMethod, String key, Object insert1) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1};
            this.logMessage(level, loggingClass, loggingMethod, key, this.getMessageFile(), inserts);
        }
    }

    public void message(Level level, Object loggingClass, String loggingMethod, String key, Object insert1, Object insert2) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logMessage(level, loggingClass, loggingMethod, key, this.getMessageFile(), inserts);
        }
    }

    public void message(Level level, Object loggingClass, String loggingMethod, String key, Object[] inserts) {
        if (this.isLoggable(level)) {
            this.logMessage(level, loggingClass, loggingMethod, key, this.getMessageFile(), inserts);
        }
    }

    public void msg(Level level, Object loggingClass, String loggingMethod, String key, String file) {
        if (this.isLoggable(level)) {
            this.logMessage(level, loggingClass, loggingMethod, key, file, null);
        }
    }

    public void msg(Level level, Object loggingClass, String loggingMethod, String key, String file, Object insert1) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1};
            this.logMessage(level, loggingClass, loggingMethod, key, file, inserts);
        }
    }

    public void msg(Level level, Object loggingClass, String loggingMethod, String key, String file, Object insert1, Object insert2) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logMessage(level, loggingClass, loggingMethod, key, file, inserts);
        }
    }

    public void msg(Level level, Object loggingClass, String loggingMethod, String key, String file, Object[] inserts) {
        if (this.isLoggable(level)) {
            this.logMessage(level, loggingClass, loggingMethod, key, file, inserts);
        }
    }

    public void text(Level level, Object loggingClass, String loggingMethod, String text) {
        if (this.isLoggable(level)) {
            this.logText(level, loggingClass, loggingMethod, text, null);
        }
    }

    public void text(Level level, Object loggingClass, String loggingMethod, String text, Object insert1) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1};
            this.logText(level, loggingClass, loggingMethod, text, inserts);
        }
    }

    public void text(Level level, Object loggingClass, String loggingMethod, String text, Object insert1, Object insert2) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logText(level, loggingClass, loggingMethod, text, inserts);
        }
    }

    public void text(Level level, Object loggingClass, String loggingMethod, String text, Object[] inserts) {
        if (this.isLoggable(level)) {
            this.logText(level, loggingClass, loggingMethod, text, inserts);
        }
    }

    public void entry(Level level, Object loggingClass, String loggingMethod) {
        if (this.isLoggable(level)) {
            this.logText(level, loggingClass, loggingMethod, "Entry", null);
        }
    }

    public void entry(Level level, Object loggingClass, String loggingMethod, Object parm1) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{CorporateLevelLogger.objToStr(parm1)};
            this.logText(level, loggingClass, loggingMethod, "Entry, parm 1 = {0}", parms);
        }
    }

    public void entry(Level level, Object loggingClass, String loggingMethod, Object parm1, Object parm2) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{CorporateLevelLogger.objToStr(parm1), CorporateLevelLogger.objToStr(parm2)};
            this.logText(level, loggingClass, loggingMethod, "Entry, parm 1 = {0}, parm 2 = {1}", parms);
        }
    }

    public void entry(Level level, Object loggingClass, String loggingMethod, Object[] parms) {
        if (this.isLoggable(level)) {
            StringBuffer bfr = new StringBuffer("Entry");
            Object[] strs = null;
            if (parms != null) {
                strs = new String[parms.length];
                for (int j = 0; j < parms.length; ++j) {
                    bfr.append(", parm " + (j + 1) + " = {" + j + "}");
                    strs[j] = CorporateLevelLogger.objToStr(parms[j]);
                }
            }
            this.logText(level, loggingClass, loggingMethod, bfr.toString(), strs);
        }
    }

    public void exit(Level level, Object loggingClass, String loggingMethod) {
        if (this.isLoggable(level)) {
            this.logText(level, loggingClass, loggingMethod, "Exit", null);
        }
    }

    public void exit(Level level, Object loggingClass, String loggingMethod, byte retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Byte(retValue)};
            this.logText(level, loggingClass, loggingMethod, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, Object loggingClass, String loggingMethod, short retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Short(retValue)};
            this.logText(level, loggingClass, loggingMethod, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, Object loggingClass, String loggingMethod, int retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Integer(retValue)};
            this.logText(level, loggingClass, loggingMethod, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, Object loggingClass, String loggingMethod, long retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Long(retValue)};
            this.logText(level, loggingClass, loggingMethod, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, Object loggingClass, String loggingMethod, float retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Float(retValue)};
            this.logText(level, loggingClass, loggingMethod, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, Object loggingClass, String loggingMethod, double retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Double(retValue)};
            this.logText(level, loggingClass, loggingMethod, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, Object loggingClass, String loggingMethod, char retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Character(retValue)};
            this.logText(level, loggingClass, loggingMethod, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, Object loggingClass, String loggingMethod, boolean retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Boolean(retValue)};
            this.logText(level, loggingClass, loggingMethod, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, Object loggingClass, String loggingMethod, Object retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{CorporateLevelLogger.objToStr(retValue)};
            this.logText(level, loggingClass, loggingMethod, "Exit, return value = {0}", parms);
        }
    }

    public void exception(Level level, Object loggingClass, String loggingMethod, Throwable throwable) {
        if (this.isLoggable(level)) {
            LogEvent event = new LogEvent(level, loggingClass, loggingMethod, throwable, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer());
            this.logAndWarn(event);
        }
    }

    public void exception(Level level, Object loggingClass, String loggingMethod, Throwable throwable, String text) {
        if (this.isLoggable(level)) {
            LogEvent event = new LogEvent(level, loggingClass, loggingMethod, throwable, text, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer());
            this.logAndWarn(event);
        }
    }

    protected void logMessage(Level level, Object loggingClass, String loggingMethod, String key, String file, Object[] inserts) {
        LogEvent event = new LogEvent(level, loggingClass, loggingMethod, key, file, inserts, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer());
        this.logAndWarn(event);
    }

    protected void logText(Level level, Object loggingClass, String loggingMethod, String text, Object[] inserts) {
        LogEvent event = new LogEvent(level, loggingClass, loggingMethod, text, inserts, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer());
        this.logAndWarn(event);
    }

    public String toString() {
        String result = super.toString();
        return result + ", " + this.getLevel().toString();
    }
}

