/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.FileHandler;
import com.ibm.log.Formatter;
import com.ibm.log.util.LogUtil;
import java.text.SimpleDateFormat;
import java.util.Properties;

public class DailyFileHandler
extends FileHandler {
    static final long serialVersionUID = 8861094114973975832L;
    private transient Formatter dateFormatter = new Formatter();
    private transient boolean daylightTime;
    private transient long today = System.currentTimeMillis() / 86400000L;

    public DailyFileHandler() {
        this.init();
    }

    public DailyFileHandler(String name) {
        super(name);
        this.init();
    }

    public DailyFileHandler(String name, String file) {
        super(name, file);
        this.init();
    }

    public DailyFileHandler(String name, String file, String encoding) {
        super(name, file, encoding);
        this.init();
    }

    private void init() {
        this.setMaxFiles(1);
        long time = System.currentTimeMillis();
        this.daylightTime = this.dateFormatter.isDaylightTime(time);
        this.today = this.dateFormatter.getToday(time);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("dateFormat", this.getDateFormat().toPattern());
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("dateFormat");
        if (prop != null) {
            this.setDateFormat(prop);
        }
    }

    protected FileHandler.FileNameParts buildWorkingFileParts(String name, String dir) {
        FileHandler.FileNameParts fp = super.buildWorkingFileParts(name, dir);
        if (this.dateFormatter == null) {
            this.dateFormatter = new Formatter();
        }
        String base = fp.getBaseName() + "_" + this.dateFormatter.getDate(System.currentTimeMillis());
        fp.setBaseName(base);
        fp.setWorkingName(fp.getDirectory() + base + fp.getExtension());
        return fp;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormatter.getDateFormat();
    }

    public void setDateFormat(SimpleDateFormat format) {
        if (format != null) {
            this.dateFormatter.setDateFormat(format);
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setDateFormat(SimpleDateFormat)");
            LogUtil.errorMsg(msg);
        }
    }

    public void setDateFormat(String pattern) {
        if (pattern != null) {
            this.dateFormatter.setDateFormat(pattern);
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setDateFormat(String)");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            boolean full = this.getMaxFiles() != 1 && this.fileSize >= this.getMaxFileSize();
            long time = System.currentTimeMillis();
            long testDay = this.dateFormatter.getToday(time);
            if (!this.open || full || this.today != testDay) {
                this.close();
                this.today = testDay;
                this.daylightTime = this.dateFormatter.isDaylightTime(time);
                this.setFileName(this.getFileName());
                super.open();
            }
        }
    }
}

