/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.EnhancedFormatter;
import com.ibm.log.LogEvent;

public class EnhancedTraceFormatter
extends EnhancedFormatter {
    static final long serialVersionUID = 8121405846919594580L;

    public EnhancedTraceFormatter() {
    }

    public EnhancedTraceFormatter(String name) {
        super(name);
    }

    public String format(LogEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        this.initTitles();
        long timeStamp = event.getTimeStamp();
        bfr.append(this.time + "  " + this.getTime(timeStamp) + this.lineSep);
        String item = event.getLoggingClass();
        if (item != null) {
            bfr.append(this.className + "  " + item + this.lineSep);
        }
        if ((item = event.getLoggingMethod()) != null) {
            bfr.append(this.methodName + "  " + item + this.lineSep);
        }
        if ((item = event.getThreadName()) != null) {
            bfr.append(this.threadName + "  " + item + this.lineSep);
        }
        bfr.append("  " + this.getText(event));
        return bfr.toString();
    }
}

