/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Level;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class LogEvent
implements Serializable {
    static final long serialVersionUID = 8783775590051976528L;
    private boolean typeValid;
    private HashMap extensions = null;
    private Level level = null;
    private long timeStamp;
    private long type = 0L;
    private Object[] inserts = null;
    private String client = null;
    private String component = null;
    private String correlationId = null;
    private String loggingClass = null;
    private String loggingMethod = null;
    private String messageKey = null;
    private String messageFile = null;
    private String messageText = null;
    private String messageId = null;
    private String organization = null;
    private String product = null;
    private String productInstance = null;
    private String server = null;
    private String serverFormat = null;
    private String stackTrace = null;
    private String threadName;
    private Throwable throwable = null;

    public LogEvent() {
        this.typeValid = false;
        this.timeStamp = System.currentTimeMillis();
        this.threadName = Thread.currentThread().getName();
    }

    public LogEvent(Throwable throwable) {
        this();
        this.throwable = throwable;
    }

    public LogEvent(Throwable throwable, String text) {
        this();
        this.throwable = throwable;
        this.messageText = text;
    }

    public LogEvent(String key, String file, Object[] inserts) {
        this();
        this.messageKey = key;
        this.messageFile = file;
        this.inserts = inserts;
    }

    public LogEvent(String text, Object[] inserts) {
        this();
        this.messageText = text;
        this.inserts = inserts;
    }

    public LogEvent(long type, Throwable throwable) {
        this();
        this.typeValid = true;
        this.type = type;
        this.throwable = throwable;
    }

    public LogEvent(long type, Throwable throwable, String text) {
        this();
        this.typeValid = true;
        this.type = type;
        this.throwable = throwable;
        this.messageText = text;
    }

    public LogEvent(long type, String key, String file, Object[] inserts) {
        this();
        this.typeValid = true;
        this.type = type;
        this.messageKey = key;
        this.messageFile = file;
        this.inserts = inserts;
    }

    public LogEvent(long type, String text, Object[] inserts) {
        this();
        this.typeValid = true;
        this.type = type;
        this.messageText = text;
        this.inserts = inserts;
    }

    public LogEvent(Level level, Throwable throwable) {
        this();
        this.level = level;
        this.throwable = throwable;
    }

    public LogEvent(Level level, Throwable throwable, String text) {
        this();
        this.throwable = throwable;
        this.level = level;
        this.messageText = text;
    }

    public LogEvent(Level level, String key, String file, Object[] inserts) {
        this();
        this.level = level;
        this.messageKey = key;
        this.messageFile = file;
        this.inserts = inserts;
    }

    public LogEvent(Level level, String text, Object[] inserts) {
        this();
        this.level = level;
        this.messageText = text;
        this.inserts = inserts;
    }

    public LogEvent(Level level, Object loggingClass, String loggingMethod, Throwable throwable, String org, String prod, String comp, String client, String server) {
        this();
        this.loggingClass = this.convertClassName(loggingClass);
        this.loggingMethod = loggingMethod;
        this.level = level;
        this.throwable = throwable;
        this.organization = org;
        this.product = prod;
        this.component = comp;
        this.client = client;
        this.server = server;
    }

    public LogEvent(Level level, Object loggingClass, String loggingMethod, Throwable throwable, String text, String org, String prod, String comp, String client, String server) {
        this();
        this.loggingClass = this.convertClassName(loggingClass);
        this.loggingMethod = loggingMethod;
        this.throwable = throwable;
        this.level = level;
        this.messageText = text;
        this.organization = org;
        this.product = prod;
        this.component = comp;
        this.client = client;
        this.server = server;
    }

    public LogEvent(Level level, Object loggingClass, String loggingMethod, String key, String file, Object[] inserts, String org, String prod, String comp, String client, String server) {
        this();
        this.loggingClass = this.convertClassName(loggingClass);
        this.loggingMethod = loggingMethod;
        this.level = level;
        this.messageKey = key;
        this.messageFile = file;
        this.inserts = inserts;
        this.organization = org;
        this.product = prod;
        this.component = comp;
        this.client = client;
        this.server = server;
    }

    public LogEvent(Level level, Object loggingClass, String loggingMethod, String text, Object[] inserts, String org, String prod, String comp, String client, String server) {
        this();
        this.loggingClass = this.convertClassName(loggingClass);
        this.loggingMethod = loggingMethod;
        this.level = level;
        this.messageText = text;
        this.inserts = inserts;
        this.organization = org;
        this.product = prod;
        this.component = comp;
        this.client = client;
        this.server = server;
    }

    public LogEvent(Level level, Object loggingClass, String loggingMethod, Throwable throwable, String org, String prod, String comp, String client, String server, String serverFormat, String prodInstance, String correlationId) {
        this();
        this.loggingClass = this.convertClassName(loggingClass);
        this.loggingMethod = loggingMethod;
        this.level = level;
        this.throwable = throwable;
        this.organization = org;
        this.product = prod;
        this.component = comp;
        this.client = client;
        this.server = server;
        this.serverFormat = serverFormat;
        this.productInstance = prodInstance;
        this.correlationId = correlationId;
    }

    public LogEvent(Level level, Object loggingClass, String loggingMethod, Throwable throwable, String text, String org, String prod, String comp, String client, String server, String serverFormat, String prodInstance, String correlationId) {
        this();
        this.loggingClass = this.convertClassName(loggingClass);
        this.loggingMethod = loggingMethod;
        this.throwable = throwable;
        this.level = level;
        this.messageText = text;
        this.organization = org;
        this.product = prod;
        this.component = comp;
        this.client = client;
        this.server = server;
        this.serverFormat = serverFormat;
        this.productInstance = prodInstance;
        this.correlationId = correlationId;
    }

    public LogEvent(Level level, Object loggingClass, String loggingMethod, String key, String file, Object[] inserts, String org, String prod, String comp, String client, String server, String serverFormat, String prodInstance, String correlationId) {
        this();
        this.loggingClass = this.convertClassName(loggingClass);
        this.loggingMethod = loggingMethod;
        this.level = level;
        this.messageKey = key;
        this.messageFile = file;
        this.inserts = inserts;
        this.organization = org;
        this.product = prod;
        this.component = comp;
        this.client = client;
        this.server = server;
        this.serverFormat = serverFormat;
        this.productInstance = prodInstance;
        this.correlationId = correlationId;
    }

    public LogEvent(Level level, Object loggingClass, String loggingMethod, String text, Object[] inserts, String org, String prod, String comp, String client, String server, String serverFormat, String prodInstance, String correlationId) {
        this();
        this.loggingClass = this.convertClassName(loggingClass);
        this.loggingMethod = loggingMethod;
        this.level = level;
        this.messageText = text;
        this.inserts = inserts;
        this.organization = org;
        this.product = prod;
        this.component = comp;
        this.client = client;
        this.server = server;
        this.serverFormat = serverFormat;
        this.productInstance = prodInstance;
        this.correlationId = correlationId;
    }

    public LogEvent(Level level, long type, String loggingClass, String loggingMethod, String key, String file, String text, Object[] inserts, String org, String prod, String comp, String client, String server, String serverFormat, String prodInstance, String correlationId, String stackTrace, long timeStamp, String thread) {
        if (level != null) {
            this.level = level;
        }
        if (type != 0L) {
            this.typeValid = true;
            this.type = type;
        }
        if (loggingClass != null) {
            this.loggingClass = loggingClass;
        }
        if (loggingMethod != null) {
            this.loggingMethod = loggingMethod;
        }
        if (key != null) {
            this.messageKey = key;
        }
        if (file != null) {
            this.messageFile = file;
        }
        if (text != null) {
            this.messageText = text;
        }
        if (inserts != null) {
            this.inserts = inserts;
        }
        if (org != null) {
            this.organization = org;
        }
        if (prod != null) {
            this.product = prod;
        }
        if (comp != null) {
            this.component = comp;
        }
        if (client != null) {
            this.client = client;
        }
        if (server != null) {
            this.server = server;
        }
        if (serverFormat != null) {
            this.serverFormat = serverFormat;
        }
        if (prodInstance != null) {
            this.productInstance = prodInstance;
        }
        if (stackTrace != null) {
            this.stackTrace = stackTrace;
        }
        if (correlationId != null) {
            this.correlationId = correlationId;
        }
        this.timeStamp = timeStamp;
        if (thread != null) {
            this.threadName = thread;
        }
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getStackTrace() {
        if (this.stackTrace == null && this.throwable != null) {
            StringWriter sw = new StringWriter();
            this.throwable.printStackTrace(new PrintWriter(sw));
            this.stackTrace = sw.toString();
        }
        return this.stackTrace;
    }

    public void convertException() {
        if (this.throwable != null) {
            this.getStackTrace();
            this.throwable = null;
        }
    }

    public boolean isTypeValid() {
        return this.typeValid;
    }

    public String getClient() {
        return this.client;
    }

    public String getComponent() {
        return this.component;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Object[] getInserts() {
        return this.inserts;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getLoggingClass() {
        return this.loggingClass;
    }

    public String getLoggingMethod() {
        return this.loggingMethod;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public String getMessageFile() {
        return this.messageFile;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getProduct() {
        return this.product;
    }

    public String getProductInstance() {
        return this.productInstance;
    }

    public String getServer() {
        return this.server;
    }

    public String getServerFormat() {
        return this.serverFormat;
    }

    public String getText() {
        return this.messageText;
    }

    public long getType() {
        return this.type;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    protected String convertClassName(Object loggingClass) {
        String name = loggingClass != null ? (loggingClass instanceof String ? (String)loggingClass : loggingClass.getClass().getName()) : LogUtil.getLogMsg("NULL_OBJECT");
        return name;
    }

    public Object put(String key, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap();
        }
        Object prev = this.extensions.put(key, value);
        return prev;
    }

    public Object get(String key) {
        Object prev = null;
        if (this.extensions != null) {
            prev = this.extensions.get(key);
        }
        return prev;
    }

    public boolean containsKey(String key) {
        boolean result = false;
        if (this.extensions != null) {
            result = this.extensions.containsKey(key);
        }
        return result;
    }

    public Iterator getKeysAndValues() {
        Iterator result = null;
        if (this.extensions != null) {
            Set mapEntries = this.extensions.entrySet();
            result = mapEntries.iterator();
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getStackTrace();
        if (this.inserts != null) {
            for (int j = 0; j < this.inserts.length; ++j) {
                Object insert = this.inserts[j];
                if (null == insert || insert instanceof Serializable) continue;
                this.inserts[j] = insert.toString();
            }
        }
        if (null != out) {
            out.defaultWriteObject();
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public synchronized void setMessageId(String identifier) {
        if (identifier != null) {
            this.messageId = identifier;
        }
    }
}

