/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.CorporateLevelLogger;
import com.ibm.log.Level;
import com.ibm.log.LogEvent;
import com.ibm.log.PDXMLFormatter;
import com.ibm.log.util.LogUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class PDLogger
extends CorporateLevelLogger {
    static final long serialVersionUID = 1542502320936709585L;
    private String productInstance = "";
    private String serverFormat = "";
    private transient PDXMLFormatter msgIdFormatter = new PDXMLFormatter();

    public PDLogger() {
        this.getHostName();
    }

    public PDLogger(String name) {
        super(name);
        this.getHostName();
    }

    private void getHostName() {
        try {
            InetAddress address = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress());
            String hostName = address.getHostName();
            this.setServer(hostName);
            this.setServerFormat("IP");
        }
        catch (UnknownHostException uE) {
            String msg = LogUtil.getLogMsg("ERR_GETTING_HOSTNAME", this.getName());
            LogUtil.errorMsg(msg);
        }
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        if (!this.getProductInstance().equals("")) {
            props.put("productInstance", this.getProductInstance());
        }
        if (!this.getServerFormat().equals("")) {
            props.put("serverFormat", this.getServerFormat());
        }
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("productInstance");
        if (prop != null) {
            this.setProductInstance(prop);
        }
        if ((prop = props.getProperty("serverFormat")) != null) {
            this.setServerFormat(prop);
        }
    }

    public String getProductInstance() {
        return this.productInstance;
    }

    public void setProductInstance(String instance) {
        if (instance != null) {
            this.productInstance = instance;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setProductInstance");
            LogUtil.errorMsg(msg);
        }
    }

    public String getServerFormat() {
        return this.serverFormat;
    }

    public void setServerFormat(String format) {
        if (format != null) {
            this.serverFormat = format;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setServerFormat");
            LogUtil.errorMsg(msg);
        }
    }

    public void exception(Level level, Object loggingClass, String loggingMethod, Throwable throwable) {
        if (this.isLoggable(level)) {
            LogEvent event = new LogEvent(level, loggingClass, loggingMethod, throwable, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer(), this.getServerFormat(), this.getProductInstance(), null);
            this.logAndWarn(event);
        }
    }

    public void exception(Level level, Object loggingClass, String loggingMethod, Throwable throwable, String text) {
        if (this.isLoggable(level)) {
            LogEvent event = new LogEvent(level, loggingClass, loggingMethod, throwable, text, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer(), this.getServerFormat(), this.getProductInstance(), null);
            this.logAndWarn(event);
        }
    }

    protected void logMessage(Level level, Object loggingClass, String loggingMethod, String key, String file, Object[] inserts) {
        LogEvent event = new LogEvent(level, loggingClass, loggingMethod, key, file, inserts, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer(), this.getServerFormat(), this.getProductInstance(), null);
        this.msgIdFormatter.cacheMessageId(event);
        this.logAndWarn(event);
    }

    protected void logText(Level level, Object loggingClass, String loggingMethod, String text, Object[] inserts) {
        LogEvent event = new LogEvent(level, loggingClass, loggingMethod, text, inserts, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer(), this.getServerFormat(), this.getProductInstance(), null);
        this.logAndWarn(event);
    }
}

