/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogEvent;
import com.ibm.log.StreamHandler;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public class SocketHandler
extends StreamHandler {
    static final long serialVersionUID = -2130683178667213483L;
    private static final String DEFAULT_SERVER = "localhost";
    private int port = 9991;
    private transient ObjectOutputStream objectOutput = null;
    private String server = "localhost";
    private transient Socket socket = null;

    public SocketHandler() {
    }

    public SocketHandler(String name) {
        super(name);
    }

    public SocketHandler(String name, String server, int port) {
        super(name);
        this.setServerAndPort(server, port);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("socketPort", new Integer(this.getPort()).toString());
        props.put("socketServer", this.getServer());
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        int newPort = 9991;
        String newServer = DEFAULT_SERVER;
        String prop = props.getProperty("socketPort");
        if (prop != null) {
            newPort = new Integer(prop.trim());
        }
        if ((prop = props.getProperty("socketServer")) != null) {
            newServer = prop;
        }
        this.setServerAndPort(newServer, newPort);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) throws SecurityException {
        if (port > 1024 && port != 9991) {
            this.setServerAndPort(this.getServer(), port);
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) throws SecurityException {
        if (server != null && !server.equals(DEFAULT_SERVER)) {
            this.setServerAndPort(server, this.getPort());
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setServer");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception, AccessControlException {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                SecurityManager sm = System.getSecurityManager();
                if (sm == null) {
                    this.socket = new Socket(this.getServer(), this.getPort());
                } else {
                    try {
                        this.socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return new Socket(SocketHandler.this.getServer(), SocketHandler.this.getPort());
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                }
                this.objectOutput = new ObjectOutputStream(this.socket.getOutputStream());
                this.setOutputStream(this.objectOutput);
                this.open = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            try {
                if (this.objectOutput != null) {
                    this.objectOutput.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.objectOutput = null;
            this.socket = null;
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent event) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open();
            }
            this.objectOutput.writeObject(event);
            this.objectOutput.flush();
        }
    }

    public String toString() {
        String result = super.toString();
        return result + ", server=" + this.getServer() + ", port=" + this.getPort();
    }

    public void setServerAndPort(String server, int port) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SocketPermission sPermission = new SocketPermission(server + ":" + port, "connect");
            sm.checkPermission(sPermission);
        }
        this.server = server;
        this.port = port;
    }
}

