/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import java.awt.Font;
import java.awt.TextArea;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class TextAreaHandler
extends Handler {
    static final long serialVersionUID = -2142392853659685433L;
    private transient TextArea textArea;

    public TextAreaHandler() throws AccessControlException {
        this.createTextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
    }

    public TextAreaHandler(String name) throws AccessControlException {
        super(name);
        this.createTextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
    }

    public TextAreaHandler(String name, TextArea textArea) {
        super(name);
        this.setTextArea(textArea);
    }

    private void createTextArea() throws AccessControlException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            this.textArea = new TextArea();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    TextAreaHandler.this.textArea = new TextArea();
                    return null;
                }
            });
        }
    }

    public TextArea getTextArea() {
        return this.textArea;
    }

    public void setTextArea(TextArea textArea) {
        if (textArea != null) {
            this.textArea = textArea;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setTextArea");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open = true;
                this.writeHeader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.open) {
                try {
                    this.writeTrailer();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent event) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open();
            }
            String msg = this.getFormatter().format(event);
            this.textArea.append(msg + "\n");
        }
    }

    protected void writeHeader() throws Exception {
        String header = this.getFormatter().getHeader();
        if (header != null) {
            this.textArea.append(header);
        }
    }

    protected void writeTrailer() throws Exception {
        String trailer = this.getFormatter().getTrailer();
        if (trailer != null) {
            this.textArea.append(trailer);
        }
    }
}

