/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.cmd;

import com.ibm.log.cmd.Channel;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.DataStoreSupport;
import com.ibm.log.mgr.LogManager;
import com.ibm.log.util.LogException;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class LogCmdProcessor
implements Runnable {
    private Channel channel = null;
    private LogManager mgr = LogManager.getManager();
    private String lineSep = System.getProperty("line.separator");

    public LogCmdProcessor(Socket socket) {
        this.channel = new Channel(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int rc = 1;
        try {
            this.channel.open();
            String command = this.getCommand();
            rc = this.processCommand(command.trim());
        }
        catch (Exception e1) {
            this.reportException(e1);
        }
        finally {
            this.write("RC:");
            this.write(new Integer(rc).toString());
        }
    }

    protected String getCommand() throws IOException, LogException {
        Object args = null;
        String cmd = this.channel.read();
        if (!cmd.equals("Cmd:")) {
            String msg = LogUtil.getLogMsg("ERR_LOG_CMD_PROTOCOL", "Cmd:", cmd);
            throw new LogException(msg);
        }
        return this.channel.read();
    }

    protected int processCommand(String command) {
        int rc = 1;
        StringTokenizer st = new StringTokenizer(command);
        String cmd = st.nextToken();
        if (cmd.equals("config")) {
            rc = this.cmdConfig(command, st);
        } else if (cmd.equals("help")) {
            rc = this.cmdHelp(command, st);
        } else if (cmd.equals("list")) {
            rc = this.cmdList(command, st);
        } else if (cmd.equals("remove")) {
            rc = this.cmdRemove(command, st);
        } else if (cmd.equals("save")) {
            rc = this.cmdSave(command, st);
        } else if (cmd.equals("set")) {
            rc = this.cmdSet(command, st);
        } else if (cmd.equals("dump")) {
            rc = this.cmdDump(command, st);
        } else {
            String msg = LogUtil.getLogMsg("LOG_CMD_INVALID", command);
            this.writeStderr(msg);
        }
        return rc;
    }

    private int cmdConfig(String command, StringTokenizer st) {
        int rc = 0;
        try {
            String name = st.nextToken();
            DataStore ds = this.mgr.getDataStore();
            if (ds.containsConfig(name)) {
                DataStoreConfig config = ds.getConfig(name);
                Enumeration<?> e = config.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = config.getProperty(key);
                    this.writeStdout(key + "=" + value + this.lineSep);
                }
            } else {
                String msg = LogUtil.getLogMsg("LOG_CMD_EMPTY", name);
                this.writeStdout(msg);
            }
        }
        catch (NoSuchElementException e) {
            rc = 1;
            String msg = LogUtil.getLogMsg("LOG_CMD_INVALID", command);
            this.writeStderr(msg);
        }
        catch (NullPointerException npe) {
            rc = 1;
            String msg = LogUtil.getLogMsg("LOG_CMD_INVALID", command);
            this.writeStderr(msg);
        }
        return rc;
    }

    private int cmdHelp(String command, StringTokenizer st) {
        int rc = 0;
        String msg = LogUtil.getLogMsg("LOG_CMD_HELP");
        this.writeStdout(msg);
        return rc;
    }

    private int cmdList(String command, StringTokenizer st) {
        int rc = 0;
        String name = null;
        try {
            name = st.nextToken();
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        DataStore ds = this.mgr.getDataStore();
        if (name == null) {
            if (ds instanceof DataStoreSupport) {
                DataStoreSupport dss = (DataStoreSupport)ds;
                DataStoreConfig config = dss.getRoot();
                this.listChildren(config);
            } else {
                Enumeration e = ds.getConfig();
                while (e.hasMoreElements()) {
                    DataStoreConfig config = (DataStoreConfig)e.nextElement();
                    name = config.getProperty("name");
                    this.writeStdout(name + this.lineSep);
                }
            }
        } else {
            DataStoreConfig config = ds.getConfig(name);
            Iterator it = config.getChildren();
            if (it.hasNext()) {
                this.listChildren(config);
            } else {
                String msg = LogUtil.getLogMsg("LOG_CMD_NO_KIDS", name);
                this.writeStdout(msg);
            }
        }
        return rc;
    }

    private void listChildren(DataStoreConfig config) {
        Iterator it = config.getChildren();
        while (it.hasNext()) {
            DataStoreConfig node = (DataStoreConfig)it.next();
            String name = node.getProperty("name");
            this.writeStdout(name + this.lineSep);
            this.listChildren(node);
        }
    }

    private int cmdRemove(String command, StringTokenizer st) {
        int rc = 0;
        String name = null;
        String key = null;
        try {
            name = st.nextToken();
            try {
                key = st.nextToken();
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            DataStore ds = this.mgr.getDataStore();
            if (ds.containsConfig(name)) {
                DataStoreConfig config = ds.getConfig(name);
                if (key == null) {
                    ds.removeConfig(config);
                } else if (config.containsKey(key)) {
                    config.remove(key);
                } else {
                    rc = 1;
                    String msg = LogUtil.getLogMsg("LOG_CMD_NO_KEY", name, key);
                    this.writeStderr(msg);
                }
            } else {
                rc = 1;
                String msg = LogUtil.getLogMsg("LOG_CMD_NO_CFG", name);
                this.writeStderr(msg);
            }
        }
        catch (NoSuchElementException e) {
            rc = 1;
            String msg = LogUtil.getLogMsg("LOG_CMD_INVALID", command);
            this.writeStderr(msg);
        }
        return rc;
    }

    private int cmdSave(String command, StringTokenizer st) {
        int rc = 0;
        String saveAll = null;
        DataStore ds = this.mgr.getDataStore();
        if (!ds.isWriteable()) {
            String msg = LogUtil.getLogMsg("WARN_CANNOT_SAVE_CFG");
            this.writeStderr(msg);
            return 1;
        }
        try {
            saveAll = st.nextToken();
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        if (saveAll == null) {
            try {
                ds.saveConfig(false);
            }
            catch (Exception e) {
                this.reportException(e);
            }
        } else if (saveAll.equals("all")) {
            try {
                ds.saveConfig(true);
            }
            catch (Exception e) {
                this.reportException(e);
            }
        } else {
            rc = 1;
            String msg = LogUtil.getLogMsg("LOG_CMD_INVALID", command);
            this.writeStderr(msg);
        }
        return rc;
    }

    private int cmdSet(String command, StringTokenizer st) {
        int rc = 0;
        String name = null;
        String key = null;
        String value = null;
        try {
            name = st.nextToken();
            key = st.nextToken(" =");
            value = st.nextToken();
            while (st.hasMoreTokens()) {
                value = value + " " + st.nextToken();
            }
            DataStore ds = this.mgr.getDataStore();
            if (ds.containsConfig(name)) {
                DataStoreConfig config = ds.getConfig(name);
                config.setProperty(key, value);
                ds.updateConfig(config);
            } else {
                DataStoreConfig config = new DataStoreConfig();
                config.setProperty("name", name);
                config.setProperty(key, value);
                ds.addConfig(config);
            }
        }
        catch (NoSuchElementException e) {
            rc = 1;
            String msg = LogUtil.getLogMsg("LOG_CMD_INVALID", command);
            this.writeStderr(msg);
        }
        catch (AccessControlException ace) {
            rc = 1;
            String msg = LogUtil.getLogMsg("ERR_INVALID_PERMISSION", name, ace.getMessage());
            this.writeStderr(msg);
        }
        return rc;
    }

    private int cmdDump(String command, StringTokenizer st) {
        int rc = 0;
        String name = null;
        try {
            name = st.nextToken();
            DataStore ds = this.mgr.getDataStore();
            if (ds.containsConfig(name)) {
                DataStoreConfig config = ds.getConfig(name);
                config.setProperty("dumpEvents", "true");
                ds.updateConfig(config);
                config.remove("dumpEvents");
            } else {
                rc = 1;
                String msg = LogUtil.getLogMsg("ERR_HANDLER_NOT_FOUND", name);
                this.writeStderr(msg);
            }
        }
        catch (NoSuchElementException e) {
            rc = 1;
            String msg = LogUtil.getLogMsg("LOG_CMD_INVALID", command);
            this.writeStderr(msg);
        }
        return rc;
    }

    protected void reportException(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.write("Stderr:");
        this.write(sw.toString());
    }

    protected void write(String msg) {
        try {
            this.channel.write(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeStdout(String msg) {
        this.write("Stdout:");
        this.write(msg);
    }

    protected void writeStderr(String msg) {
        this.write("Stderr:");
        this.write(msg);
    }
}

