/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.util.LogUtil;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageCatalog {
    private static final char CURLY_BRACE_LEFT = '{';
    private static final char CURLY_BRACE_RIGHT = '}';
    private static final char SINGLE_QUOTE = '\'';
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SINGLE_QUOTE = 1;
    private static final int STATE_LITERAL_BRACE = 2;
    private static final int STATE_MSG_ELEMENT = 3;
    private static boolean debugMode = false;
    private int hitCount = 0;
    private Locale locale;
    private MessageFormat msgFormatter = new MessageFormat("");
    private Object formatLock = new Object();
    private ResourceBundle msgBundle;
    private String baseName;

    public static ClassLoader getClassLoader() {
        return LogUtil.getDefaultResourceClassLoader();
    }

    public static void setClassLoader(ClassLoader cl) {
        LogUtil.setDefaultResourceClassLoader(cl);
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean flag) {
        debugMode = flag;
    }

    public MessageCatalog(String baseName) {
        this(baseName, (Locale)null);
    }

    public MessageCatalog(String baseName, Locale locale) {
        this.baseName = baseName;
        this.msgBundle = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setLocale(locale);
    }

    public MessageCatalog(ResourceBundle msgBundle) {
        this(msgBundle, (Locale)null);
    }

    public MessageCatalog(ResourceBundle msgBundle, Locale locale) {
        this.msgBundle = msgBundle;
        this.baseName = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setLocale(locale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
            this.msgFormatter.setLocale(locale);
            if (this.baseName != null) {
                try {
                    ClassLoader cl = LogUtil.getClassLoaderForResource(this.baseName);
                    Class<MessageCatalog> clazz = MessageCatalog.class;
                    synchronized (MessageCatalog.class) {
                        this.msgBundle = cl == null ? ResourceBundle.getBundle(this.baseName, this.getLocale()) : ResourceBundle.getBundle(this.baseName, this.getLocale(), cl);
                        // ** MonitorExit[var3_5] (shouldn't be in output)
                    }
                }
                catch (MissingResourceException e) {
                    this.msgBundle = null;
                }
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setLocale");
            LogUtil.errorMsg(msg);
        }
        {
            return;
        }
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public Enumeration getKeys() {
        return this.msgBundle.getKeys();
    }

    public String getUnformattedMessage(String key) {
        String msg = null;
        if (this.msgBundle != null) {
            try {
                msg = this.msgBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return msg;
    }

    public String getMessage(String key) {
        return this.getMessage(key, null);
    }

    public String getMessage(String key, Object insert1) {
        Object[] inserts = new Object[]{insert1};
        return this.getMessage(key, inserts);
    }

    public String getMessage(String key, Object insert1, Object insert2) {
        Object[] inserts = new Object[]{insert1, insert2};
        return this.getMessage(key, inserts);
    }

    public String getMessage(String key, Object[] inserts) {
        String msg = null;
        if (this.msgBundle != null) {
            try {
                msg = this.formatMessage(this.msgBundle.getString(key), inserts);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (msg == null) {
            StringBuffer bfr = new StringBuffer(256);
            if (this.msgBundle == null) {
                if (this.baseName == null) {
                    bfr.append(LogUtil.getLogMsg("ERR_MISSING_BUNDLE_NO_FILE", key));
                } else {
                    bfr.append(LogUtil.getLogMsg("ERR_MISSING_BUNDLE", this.baseName, key));
                }
            } else if (this.baseName == null) {
                bfr.append(LogUtil.getLogMsg("ERR_MISSING_KEY_NO_FILE", key));
            } else {
                bfr.append(LogUtil.getLogMsg("ERR_MISSING_KEY", key, this.baseName));
            }
            if (MessageCatalog.isDebugMode()) {
                bfr.deleteCharAt(bfr.length() - 1);
            }
            if (inserts == null) {
                bfr.append(".");
            } else {
                inserts = LogUtil.checkNullObjects(inserts);
                for (int j = 0; j < inserts.length; ++j) {
                    bfr.append(", p" + (j + 1) + "=" + inserts[j].toString());
                }
            }
            if (MessageCatalog.isDebugMode()) {
                bfr.append("]");
            }
            msg = bfr.toString();
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatMessage(String pattern, Object[] inserts) {
        String msg = null;
        if (inserts != null) {
            boolean error = false;
            StringBuffer bfr = new StringBuffer();
            inserts = LogUtil.checkNullObjects(inserts);
            try {
                Object object = this.formatLock;
                synchronized (object) {
                    this.msgFormatter.applyPattern(this.fixPattern(pattern));
                    Object object2 = this.formatLock;
                    synchronized (object2) {
                        bfr = this.msgFormatter.format(inserts, bfr, (FieldPosition)null);
                    }
                }
            }
            catch (StringIndexOutOfBoundsException eb1) {
                bfr.setLength(0);
                bfr.append(pattern);
                for (int j = 0; j < inserts.length; ++j) {
                    bfr.append(", p" + (j + 1) + "=" + inserts[j].toString());
                }
            }
            catch (IllegalArgumentException e1) {
                bfr.setLength(0);
                bfr.append(pattern);
                for (int j = 0; j < inserts.length; ++j) {
                    bfr.append(", p" + (j + 1) + "=" + inserts[j].toString());
                }
            }
            msg = bfr.toString();
        } else {
            msg = pattern;
        }
        if (MessageCatalog.isDebugMode()) {
            msg = "[" + msg + "]";
        }
        ++this.hitCount;
        return msg;
    }

    protected String fixPattern(String pattern) {
        if (pattern.indexOf(39) != -1) {
            int length = pattern.length();
            StringBuffer bfr = new StringBuffer(length * 2);
            int state = 0;
            for (int j = 0; j < length; ++j) {
                char c = pattern.charAt(j);
                block0 : switch (state) {
                    case 0: {
                        switch (c) {
                            case '\'': {
                                state = 1;
                                break;
                            }
                            case '{': {
                                state = 3;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (c) {
                            case '\'': {
                                state = 0;
                                break block0;
                            }
                            case '{': 
                            case '}': {
                                state = 2;
                                break block0;
                            }
                        }
                        bfr.append('\'');
                        state = 0;
                        break;
                    }
                    case 2: {
                        switch (c) {
                            case '\'': {
                                state = 0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (c) {
                            case '}': {
                                state = 0;
                            }
                        }
                        break;
                    }
                }
                bfr.append(c);
            }
            if (state == 1) {
                bfr.append('\'');
            }
            pattern = bfr.toString();
        }
        return pattern;
    }

    public char getChar(String key) {
        String temp = this.getMessage(key);
        char c = MessageCatalog.isDebugMode() ? temp.charAt(1) : temp.charAt(0);
        return c;
    }

    public String toString() {
        String name = this.baseName != null ? this.baseName : this.msgBundle.toString();
        return "bundle=" + name + ", locale=" + this.getLocale().toString() + ", debugMode=" + MessageCatalog.isDebugMode();
    }
}

