/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.ConsoleHandler;
import com.ibm.log.FileHandler;
import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.SerialFileHandler;
import com.ibm.log.util.LogUtil;
import java.util.Vector;

public class SerialViewer {
    SerialFileHandler inHandler = new SerialFileHandler();
    Handler outHandler = null;

    public static void main(String[] args) {
        int rc = 0;
        SerialViewer v = null;
        int argCount = args.length;
        if (argCount == 1) {
            v = new SerialViewer(args[0]);
        } else if (argCount == 2) {
            v = new SerialViewer(args[0], args[1]);
        } else {
            LogUtil.errorMsg(LogUtil.getLogMsg("SV_USAGE"));
            rc = 1;
        }
        if (v != null) {
            v.deserialize();
        }
        System.exit(rc);
    }

    public SerialViewer(String inFile) {
        this.inHandler.setFileName(inFile);
        this.outHandler = new ConsoleHandler();
    }

    public SerialViewer(String inFile, String outFile) {
        this.inHandler.setName("SerialViewer");
        this.inHandler.setFileName(inFile);
        FileHandler fh = new FileHandler();
        fh.setFileName(outFile);
        this.outHandler = fh;
    }

    private void deserialize() {
        try {
            Vector events = this.inHandler.readSerializedEvents();
            for (int j = 0; j < events.size(); ++j) {
                LogEvent event = (LogEvent)events.elementAt(j);
                this.outHandler.process(event);
            }
        }
        catch (Exception e) {
            LogUtil.errorMsg(LogUtil.getLogMsg("ERR_READ_EVENTS", this.inHandler.getName(), this.inHandler.getFileName()));
            e.printStackTrace();
        }
        this.inHandler.close();
        this.outHandler.close();
    }
}

