/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import java.text.StringCharacterIterator;
import java.util.ArrayList;

public class XMLUtil {
    public static final char AMPERSAND = '&';
    public static final String XML_AMP = "&amp;";
    public static final char LEFT_ANGLE_BRACKET = '<';
    public static final String XML_LT = "&lt;";
    public static final char RIGHT_ANGLE_BRACKET = '>';
    public static final String XML_GT = "&gt;";
    public static final char APOSTROPHE = '\'';
    public static final String XML_APOS = "&apos;";
    public static final char DOUBLE_QUOTE = '\"';
    public static final String XML_QUOT = "&quot;";
    public static final char CARRIAGE_RETURN = '\r';
    public static final String XML_HEX_CR = "&#xD;";
    public static final char LINEFEED = '\n';
    public static final String XML_HEX_LF = "&#xA;";
    public static final char TAB = '\t';
    public static final String XML_HEX_TAB = "&#x9;";
    public static final String UNKNOWN_CHAR = "?";
    public static final char U0020 = ' ';
    public static final char UD7FF = '\ud7ff';
    public static final char UE000 = '\ue000';
    public static final char UFFFD = '\ufffd';

    private XMLUtil() {
    }

    public static String getXMLEscapeIfNeeded(char c) {
        String escape = null;
        if ('&' == c) {
            escape = XML_AMP;
        } else if ('<' == c) {
            escape = XML_LT;
        } else if ('>' == c) {
            escape = XML_GT;
        } else if ('\'' == c) {
            escape = XML_APOS;
        } else if ('\"' == c) {
            escape = XML_QUOT;
        } else if ('\r' == c) {
            escape = XML_HEX_CR;
        } else if ('\n' == c) {
            escape = XML_HEX_LF;
        } else if ('\t' == c) {
            escape = XML_HEX_TAB;
        } else if (!(c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
            escape = UNKNOWN_CHAR;
        }
        return escape;
    }

    public static String escapeXMLString(String s) {
        StringBuffer buff = new StringBuffer();
        if (s != null) {
            StringCharacterIterator iter = new StringCharacterIterator(s);
            char c = iter.first();
            while (c != '\uffff') {
                String escapeSeq = XMLUtil.getXMLEscapeIfNeeded(c);
                if (null == escapeSeq) {
                    buff.append(c);
                } else {
                    buff.append(escapeSeq);
                }
                c = iter.next();
            }
        }
        return buff.toString();
    }

    public static String[] escapeXMLChunks(String s, int maxChunkLen) {
        ArrayList<String> chunks = new ArrayList<String>();
        if (maxChunkLen <= 0) {
            throw new IllegalArgumentException("maxChunkLen<=0");
        }
        if (null != s) {
            StringBuffer thisChunk = new StringBuffer();
            int chunkIndex = 0;
            StringCharacterIterator iter = new StringCharacterIterator(s);
            char c = iter.first();
            while (c != '\uffff') {
                int nCharsToAdd;
                String escapeSeq = XMLUtil.getXMLEscapeIfNeeded(c);
                int n = nCharsToAdd = null == escapeSeq ? 1 : escapeSeq.length();
                if (chunkIndex + nCharsToAdd > maxChunkLen) {
                    chunks.add(thisChunk.toString());
                    thisChunk.setLength(0);
                    chunkIndex = 0;
                } else {
                    chunkIndex += nCharsToAdd;
                }
                if (null == escapeSeq) {
                    thisChunk.append(c);
                } else {
                    thisChunk.append(escapeSeq);
                }
                c = iter.next();
            }
            chunks.add(thisChunk.toString());
        }
        String[] retVal = new String[chunks.size()];
        return chunks.toArray(retVal);
    }
}

