/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public abstract class CIMIndicationHandler
implements ICIMIndicationHandler {
    public final String ROLLBACK_MSG = "Database update failed, calling rollback()";
    private static final String PROCESSID_PREFIX = "I";
    public static final String DEDICATED_BLOCK_SERVER = "15";
    private String cIndicationClassname = null;
    private String cCIMClassname = null;
    private CIMIndicationEvent cEvent = null;

    public CIMIndicationHandler(String pIndicationClassname, String pCIMClassname, CIMIndicationEvent pEvent) {
        this.cIndicationClassname = pIndicationClassname;
        this.cCIMClassname = pCIMClassname;
        this.cEvent = pEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HandlingResult handleCIMIndication() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"handleCIMIndication", null);
        HandlingResult mResult = HandlingResult.FAILURE;
        try {
            String mProcessID = PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString();
            mResult = this.handle(mLTH, mProcessID);
        }
        catch (Exception e) {
            mLTH.traceError("handler failed", (Throwable)e);
        }
        finally {
            this.cEvent.close();
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    public abstract HandlingResult handle(LogTraceHelper var1, String var2);

    public String getCIMClassname() {
        return this.cCIMClassname;
    }

    public String getIndicationClassname() {
        return this.cIndicationClassname;
    }

    public CIMIndicationEvent getEvent() {
        return this.cEvent;
    }

    protected CIMInstance getAttachedTopLevelSystem(CIMObjectPath pLogicalDevice) throws CIMException, DiskManagerTimeoutException {
        LogTraceHelper mLTH;
        block4: {
            Enumeration mComputerSystemEnum;
            CIMInstance mCSInstance;
            block5: {
                CIMInstance cIMInstance;
                mLTH = LogTraceHelper.entry((Object)this, (String)"getAttachedTopLevelSystem", (Object[])new Object[]{pLogicalDevice});
                mCSInstance = null;
                try {
                    mComputerSystemEnum = this.getEvent().getCIMClient().associators(pLogicalDevice, "CIM_SystemDevice", "CIM_ComputerSystem", "PartComponent", "GroupComponent", true, false, null, mLTH);
                    if (!mComputerSystemEnum.hasMoreElements()) break block4;
                    mCSInstance = (CIMInstance)mComputerSystemEnum.nextElement();
                    if (!this.isTopLevelSystem(mCSInstance)) break block5;
                    cIMInstance = mCSInstance;
                }
                catch (Throwable throwable) {
                    mLTH.exit(mCSInstance);
                    throw throwable;
                }
                mLTH.exit((Object)mCSInstance);
                return cIMInstance;
            }
            mComputerSystemEnum = this.getEvent().getCIMClient().associators(mCSInstance.getObjectPath(), "CIM_ComponentCS", "CIM_ComputerSystem", "PartComponent", "GroupComponent", true, false, null, mLTH);
            if (!mComputerSystemEnum.hasMoreElements() || !this.isTopLevelSystem(mCSInstance = (CIMInstance)mComputerSystemEnum.nextElement())) break block4;
            CIMInstance cIMInstance = mCSInstance;
            mLTH.exit((Object)mCSInstance);
            return cIMInstance;
        }
        mLTH.traceWarning("Failed to determine TopLevelComputerSystem");
        throw new RuntimeException("Failed to determine TopLevelComputerSystem");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTopLevelSystem(CIMInstance pCSInstance) throws DiskManagerTimeoutException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"isTopLevelSystem", (Object[])new Object[]{pCSInstance});
        Enumeration mProfileEnum = null;
        try {
            mProfileEnum = this.getEvent().getCIMClient().associatorNames(pCSInstance.getObjectPath(), "CIM_ElementConformsToProfile", "CIM_RegisteredProfile", "ManagedElement", "ConformantStandard", mLTH);
            mLTH.exit((Object)(mProfileEnum.hasMoreElements() ? Boolean.TRUE : Boolean.FALSE));
        }
        catch (Throwable throwable) {
            mLTH.exit((Object)(mProfileEnum.hasMoreElements() ? Boolean.TRUE : Boolean.FALSE));
            throw throwable;
        }
        return mProfileEnum.hasMoreElements();
    }

    protected StorageSubsystem getSubsystemFromCimInstance(DBConnection pConnection, CIMInstance pSubsystem) {
        String mName = (String)pSubsystem.getProperty("Name").getValue().getValue();
        String mNameFormat = (String)pSubsystem.getProperty("NameFormat").getValue().getValue();
        try {
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            mWhereClause.put(TResStorageSubsystemTable.getColumnInfo((String)"NAME"), mName);
            mWhereClause.put(TResStorageSubsystemTable.getColumnInfo((String)"NAME_FORMAT"), DBConstants.getValueFromKey((String)"SMISName_Format", (String)mNameFormat));
            return StorageSubsystem.retrieve((DBConnection)pConnection, mWhereClause);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isChangeDetectionSupported() {
        return this.cIndicationClassname.equalsIgnoreCase("CIM_InstModification");
    }

    public static class RegistrationData {
        private String mCIMClassName;
        private String mIndicationClassname;

        public RegistrationData(String pCIMClassnName, String pIndicationClassname) {
            if (pCIMClassnName == null || pCIMClassnName.trim().length() == 0) {
                throw new NullPointerException("Name must be neither null nor whitespace only.");
            }
            this.mCIMClassName = pCIMClassnName;
            this.mIndicationClassname = pIndicationClassname;
        }

        public boolean equals(Object aObj) {
            if (aObj instanceof RegistrationData) {
                RegistrationData rhs = (RegistrationData)aObj;
                return this.mCIMClassName.equals(rhs.mCIMClassName) && this.mIndicationClassname.equals(rhs.mIndicationClassname);
            }
            return false;
        }

        public String getCIMClassName() {
            return this.mCIMClassName;
        }

        public String getIndicationType() {
            return this.mIndicationClassname;
        }
    }
}

