/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;

public class DiskExpiringEventQueue {
    private LinkedList cQueue = new LinkedList();
    private int cCapacity = Integer.MAX_VALUE;
    private long cExpirationPeriod = 60000L;

    public DiskExpiringEventQueue() {
    }

    public DiskExpiringEventQueue(int pCapacity, long pExpirationPeriod) {
        this.cCapacity = pCapacity;
        this.cExpirationPeriod = pExpirationPeriod;
    }

    public synchronized void shutdown() {
        this.cQueue.clear();
    }

    public synchronized void add(CIMIndicationEvent pEvent) {
        this.cQueue.add(new Entry(pEvent));
        if (this.cQueue.size() > this.cCapacity) {
            this.cQueue.removeFirst();
        }
        this.notifyAll();
    }

    public synchronized CIMIndicationEvent remove() throws InterruptedException {
        if (!this.cQueue.isEmpty()) {
            return ((Entry)this.cQueue.removeFirst()).getEvent();
        }
        this.wait();
        return this.remove();
    }

    public synchronized boolean isEmpty() {
        return this.cQueue.isEmpty();
    }

    public synchronized int size() {
        return this.cQueue.size();
    }

    public int capacity() {
        return this.cCapacity;
    }

    public synchronized void expire() {
        long mExpirationLimit = System.currentTimeMillis() - this.cExpirationPeriod;
        while (!this.cQueue.isEmpty()) {
            if (((Entry)this.cQueue.getFirst()).getTimestamp() < mExpirationLimit) {
                this.cQueue.removeFirst();
                continue;
            }
            return;
        }
    }

    public synchronized boolean contains(CIMIndicationEvent pEvent) {
        this.expire();
        ListIterator mIter = this.cQueue.listIterator();
        while (mIter.hasNext()) {
            if (!((Entry)mIter.next()).getEvent().equals(pEvent)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean contains(CIMIndicationEvent pEvent, Comparator pComparator) {
        this.expire();
        ListIterator mIter = this.cQueue.listIterator();
        while (mIter.hasNext()) {
            if (pComparator.compare(((Entry)mIter.next()).getEvent(), pEvent) != 0) continue;
            return true;
        }
        return false;
    }

    private static class Entry {
        private CIMIndicationEvent cEvent;
        private long cTimestamp;

        public Entry(CIMIndicationEvent pEvent) {
            this.cEvent = pEvent;
            this.cTimestamp = System.currentTimeMillis();
        }

        public CIMIndicationEvent getEvent() {
            return this.cEvent;
        }

        public void setEvent(CIMIndicationEvent pEvent) {
            this.cEvent = pEvent;
        }

        public long getTimestamp() {
            return this.cTimestamp;
        }

        public void setTimestamp(long pTimestamp) {
            this.cTimestamp = pTimestamp;
        }
    }
}

