/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.monitor.CIMOMListener;
import org.eclipse.aperi.monitor.CIMOMRegistrator;
import org.eclipse.aperi.monitor.DataSource;
import org.eclipse.aperi.monitor.DataSourceEventProcessor;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.SRMCrypto;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.client.CIMEnumeration;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;
import org.sblim.wbem.client.indications.CIMEventDispatcher;
import org.sblim.wbem.client.indications.CIMIndicationHandler;
import org.sblim.wbem.client.indications.CIMIndicationListenertList;
import org.sblim.wbem.client.indications.CIMListener;
import org.sblim.wbem.http.HttpConnectionHandler;
import org.sblim.wbem.http.HttpContentHandler;
import org.sblim.wbem.http.HttpServerConnection;

public class CIMOMEventProcessor
implements DataSourceEventProcessor {
    private static String CIM_INDICATION_HDL = "CIM_ListenerDestinationCIMXML";
    private static String CIM_SYSTEM = "TPC Indication Handler";
    private static String CIM_INDICATIONHDL_NAME = "CIM Indication Handler";
    private static String CIM_INDI_SUBSCRIPTION = "CIM_IndicationSubscription";
    private static String CIM_INDI_FILTER = "CIM_IndicationFilter";
    private static String CIM_DYNAMIC = "TPC Dynamic";
    private static String CIM_COMPUTER_SYSTEM = "CIM_ComputerSystem";
    private static String CIM_SYSTEM_CLASS = "CIM_System";
    private static CIMIndicationListenertList indicationClient = null;
    private static String className = CIMOMEventProcessor.class.getName();
    private static Map indicationMap = Collections.synchronizedMap(new HashMap());
    private static CIMOMListener newListener = null;
    private static HttpServerConnection indicationServer = null;
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    private static String CONF_LOCAL_ADDRESS = "System.LocalIPAddress";
    private static String DEV_SERVER_GROUP = "DeviceServer";
    private static IConfigService cConfigService = null;

    public CIMOMEventProcessor(EventCorrelatorFactory ecf) throws IOException {
        try {
            CIM_SYSTEM = CIM_SYSTEM + CIMOMEventProcessor.getValidLocalIP();
        }
        catch (Exception e) {
            CIM_SYSTEM = CIM_SYSTEM + "localhost";
        }
        if (indicationClient == null) {
            indicationClient = new CIMIndicationListenertList();
        }
        if (newListener == null) {
            newListener = new CIMOMListener(ecf);
        }
        if (indicationServer == null) {
            CIMEventDispatcher dispatcher = new CIMEventDispatcher(indicationClient);
            CIMIndicationHandler indicationHdlr = new CIMIndicationHandler(dispatcher);
            indicationServer = new HttpServerConnection(new HttpConnectionHandler((HttpContentHandler)indicationHdlr), 0);
            indicationServer.setName("CIMListener - Http Server");
            indicationServer.start();
            indicationClient.addListener((CIMListener)newListener);
        }
        if (msgLogger == null) {
            msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.SanEventCorrelatorFactory");
            msgLogger.setMessageFile(LogConstants.MSG_FILE);
        }
        if (traceLogger == null) {
            traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.SanEventCorrelatorFactory");
        }
    }

    public boolean addDataSource(DataSource ds) throws Exception {
        boolean res;
        String methodName;
        block8: {
            methodName = "addDataSource";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            if (ds.getType() != 1) {
                throw new Exception("Invalid data source type " + ds.getType());
            }
            res = false;
            RegisteredCimom om = (RegisteredCimom)ds.getIdentifier();
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "CIMOM = " + om.toString());
            }
            try {
                if (indicationMap.get(om.getServiceUrl()) != null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                    }
                    return true;
                }
                Object[] request = new Object[]{"register", om};
                JobInfo job = new JobInfo();
                job.setDiscoverRequest(new Integer(ServiceUtils.getJobIdentifier((boolean)true, (int)2)).toString());
                job.setResourceQueue(CIMOMRegistrator.queueName);
                job.setRequestId(request.toString());
                job.setRequest((Response)new ObjectResponse((Object)request, job));
                JobEngine.getInstance().addJob(job);
                res = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!traceLogger.isLogging()) break block8;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return res;
    }

    public boolean removeDataSource(DataSource ds) throws Exception {
        String methodName = "removeDataSource";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (ds.getType() != 1) {
            throw new Exception("Invalid data source type " + ds.getType());
        }
        RegisteredCimom om = (RegisteredCimom)ds.getIdentifier();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "CIMOM = " + om.toString());
        }
        Object[] request = new Object[]{"deregister", om};
        JobInfo job = new JobInfo();
        job.setDiscoverRequest(new Integer(ServiceUtils.getJobIdentifier((boolean)true, (int)2)).toString());
        job.setResourceQueue(CIMOMRegistrator.queueName);
        job.setRequestId(request.toString());
        job.setRequest((Response)new ObjectResponse((Object)request, job));
        JobEngine.getInstance().addJob(job);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    private boolean subscribe(CIMClientWrapper pClient, CIMInstance pDestinationInst, String pNamespace) {
        Vector<Object> mFilterCOPS;
        boolean mSubscriped;
        String methodName;
        block31: {
            methodName = "subscribe";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            mSubscriped = false;
            if (pDestinationInst == null) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                return mSubscriped;
            }
            mFilterCOPS = new Vector<Object>();
            try {
                if (pNamespace.toLowerCase().indexOf("ibm") > 0) {
                    CIMObjectPath mIBMFilters = new CIMObjectPath("IBMTS_IndicationFilter", pNamespace);
                    CIMEnumeration mIBMFilterCOPSEnum = (CIMEnumeration)pClient.enumerateInstanceNames(mIBMFilters);
                    if (mIBMFilterCOPSEnum != null && mIBMFilterCOPSEnum.hasMoreElements()) {
                        while (mIBMFilterCOPSEnum.hasMoreElements()) {
                            mFilterCOPS.add(mIBMFilterCOPSEnum.nextElement());
                        }
                    }
                    mIBMFilterCOPSEnum.close();
                }
            }
            catch (Exception e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block31;
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, methodName, (Throwable)e);
            }
        }
        Vector<CIMInstance> mFilterInstances = new Vector<CIMInstance>();
        if (mFilterCOPS != null && mFilterCOPS.size() == 0) {
            try {
                Vector<String> v = new Vector<String>();
                v.add("CIM_ProcessIndication");
                v.add("CIM_InstCreation");
                v.add("CIM_InstModification");
                v.add("CIM_InstDeletion");
                CIMClass filterClass = this.getClassWrapper(pClient, CIM_INDI_FILTER, pNamespace);
                for (int i = 0; i < v.size(); ++i) {
                    CIMInstance mFilter = this.createIndicationFilterInstance(pClient, pNamespace, (String)v.elementAt(i), filterClass);
                    mFilterInstances.add(mFilter);
                }
            }
            catch (Exception e) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, methodName, (Throwable)e);
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                return mSubscriped;
            }
        }
        try {
            CIMObjectPath mDestinationCOP = this.createInstanceWrapper(pClient, pDestinationInst.getObjectPath(), pDestinationInst);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "handler = " + pDestinationInst);
            }
            if (mFilterCOPS != null && mFilterCOPS.size() == 0) {
                for (int i = 0; i < mFilterInstances.size(); ++i) {
                    CIMObjectPath mFiltersCOP = this.createInstanceWrapper(pClient, ((CIMInstance)mFilterInstances.elementAt(i)).getObjectPath(), (CIMInstance)mFilterInstances.elementAt(i));
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "filter = " + mFilterInstances.elementAt(i));
                    }
                    mFilterCOPS.add(mFiltersCOP);
                }
            }
            Vector<CIMInstance> mSubscriptionInstances = new Vector<CIMInstance>();
            try {
                CIMClass subscriptionClass = this.getClassWrapper(pClient, CIM_INDI_SUBSCRIPTION, pNamespace);
                for (int i = 0; i < mFilterCOPS.size(); ++i) {
                    CIMInstance mSubscription = this.createIndicationSubscriptionInstance(pClient, pNamespace, mDestinationCOP, (CIMObjectPath)mFilterCOPS.elementAt(i), subscriptionClass);
                    mSubscriptionInstances.add(mSubscription);
                }
            }
            catch (Exception e) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, methodName, (Throwable)e);
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                return mSubscriped;
            }
            for (int i = 0; i < mSubscriptionInstances.size(); ++i) {
                try {
                    CIMObjectPath mSubscriptionCOP = this.createInstanceWrapper(pClient, ((CIMInstance)mSubscriptionInstances.elementAt(i)).getObjectPath(), (CIMInstance)mSubscriptionInstances.elementAt(i));
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "subscription = " + mSubscriptionInstances.elementAt(i));
                    }
                    mSubscriped = true;
                    continue;
                }
                catch (Exception e) {
                    if (e.getMessage().toLowerCase().indexOf("cim_err_not_supported") != -1) {
                        if (traceLogger == null || !traceLogger.isLogging()) continue;
                        traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "subscription not supported = " + mSubscriptionInstances.elementAt(i));
                        continue;
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.entry(IRecordType.TYPE_ERROR, (Object)methodName, "subscription failed = " + mSubscriptionInstances.elementAt(i));
                    }
                    return false;
                }
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return mSubscriped;
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, methodName, (Throwable)e);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return false;
        }
    }

    private boolean unsubscribe(CIMClientWrapper pClient, String pNamespace) {
        String methodName = "unsubscribe";
        try {
            CIMClass ihClass = this.getClassWrapper(pClient, CIM_INDICATION_HDL, pNamespace);
            CIMObjectPath mHandlerCOP = this.createIndicationHandlerInstance(pClient, pNamespace, 0, ihClass).getObjectPath();
            return this.unsubscribe(pClient, pNamespace, mHandlerCOP);
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, methodName, (Throwable)e);
            }
            return false;
        }
    }

    private boolean unsubscribe(CIMClientWrapper pClient, String pNamespace, CIMObjectPath pHandlerCOP) {
        String methodName;
        block22: {
            methodName = "unsubscribe";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            try {
                Vector<Object> mSubscriptionCOPs;
                Vector<Object> mFilterCOPs;
                block21: {
                    Vector<String> v = new Vector<String>();
                    v.add("CIM_InstCreation");
                    v.add("CIM_InstModification");
                    v.add("CIM_InstDeletion");
                    v.add("CIM_ProcessIndication");
                    CIMClass filterClass = this.getClassWrapper(pClient, CIM_INDI_FILTER, pNamespace);
                    mFilterCOPs = new Vector<Object>();
                    for (int i = 0; i < v.size(); ++i) {
                        CIMInstance mFilter = this.createIndicationFilterInstance(pClient, pNamespace, (String)v.elementAt(i), filterClass);
                        mFilterCOPs.add(mFilter.getObjectPath());
                    }
                    mSubscriptionCOPs = new Vector<Object>();
                    try {
                        CIMEnumeration mFilterCOPsEnum = (CIMEnumeration)pClient.associatorNames(pHandlerCOP, CIM_INDI_SUBSCRIPTION, CIM_INDI_FILTER, null, null);
                        while (mFilterCOPsEnum != null && mFilterCOPsEnum.hasMoreElements()) {
                            mFilterCOPs.add(mFilterCOPsEnum.nextElement());
                        }
                        mFilterCOPsEnum.close();
                        CIMEnumeration mSubscriptionCOPsEnum = (CIMEnumeration)pClient.referenceNames(pHandlerCOP);
                        while (mSubscriptionCOPsEnum != null && mSubscriptionCOPsEnum.hasMoreElements()) {
                            mSubscriptionCOPs.add(mSubscriptionCOPsEnum.nextElement());
                        }
                        mSubscriptionCOPsEnum.close();
                    }
                    catch (Exception e) {
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.message(IRecordType.TYPE_WARNING, (Object)className, methodName, "Get no Subscriptions for this handler (" + e.getMessage() + ")");
                        }
                        if (!(e.getCause() instanceof SocketTimeoutException)) break block21;
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                        }
                        return false;
                    }
                }
                if (mSubscriptionCOPs != null) {
                    for (int i = 0; i < mSubscriptionCOPs.size(); ++i) {
                        try {
                            this.deleteInstanceWrapper(pClient, (CIMObjectPath)mSubscriptionCOPs.elementAt(i));
                            continue;
                        }
                        catch (Exception e) {
                            if (traceLogger == null || !traceLogger.isLogging()) continue;
                            traceLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "Subscription not instanciated");
                        }
                    }
                }
                for (int i = 0; i < mFilterCOPs.size(); ++i) {
                    try {
                        this.deleteInstanceWrapper(pClient, (CIMObjectPath)mFilterCOPs.elementAt(i));
                        continue;
                    }
                    catch (Exception e) {
                        if (traceLogger == null || !traceLogger.isLogging()) continue;
                        traceLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "Filter not instanciated");
                    }
                }
                try {
                    this.deleteInstanceWrapper(pClient, pHandlerCOP);
                }
                catch (Exception e) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "Handler not instanciated");
                    }
                }
            }
            catch (Exception e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block22;
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, methodName, (Throwable)e);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    protected boolean registerIndicationListener(RegisteredCimom pCIMOM) throws UnknownHostException, CIMException {
        boolean res;
        String methodName = "registerIndicationListener";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String mNamespace = pCIMOM.getInteropSchemaNamespace();
        String mService = pCIMOM.getServiceUrl();
        CIMClientWrapper mCimClient = this.createCimClient(pCIMOM);
        if (mCimClient == null) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_INFO, (Object)methodName, "CIM Client was not created");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return false;
        }
        this.setupVectors(mCimClient);
        CIMInstance destinationInst = null;
        CIMClass ihClass = null;
        try {
            ihClass = this.getClassWrapper(mCimClient, CIM_INDICATION_HDL, mNamespace);
        }
        catch (Exception e) {
            traceLogger.exit(IRecordType.TYPE_INFO, (Object)methodName, "CIM Class was not created");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            return false;
        }
        destinationInst = this.isOldIBMCimom(mCimClient, mNamespace) ? this.createIndicationHandlerInstance(mCimClient, mNamespace, 0, ihClass) : this.createIndicationHandlerInstance(mCimClient, mNamespace, pCIMOM.getRegCimomId(), ihClass);
        if (destinationInst == null) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "Invalid destination instance");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return false;
        }
        if (this.unsubscribe(mCimClient, mNamespace)) {
            if (!this.subscribe(mCimClient, destinationInst, mNamespace)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "Subscribe failed");
                }
                this.unsubscribe(mCimClient, mNamespace);
                res = false;
            } else {
                indicationMap.put(pCIMOM.getServiceUrl(), mCimClient);
                res = true;
            }
        } else {
            res = false;
        }
        if (!res) {
            indicationMap.remove(pCIMOM.getServiceUrl());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return res;
    }

    private CIMClass getClassWrapper(CIMClientWrapper pCimClient, String pClassname, String pNamespace) throws Exception {
        return this.getClassWrapper(pCimClient, pClassname, pNamespace, 0);
    }

    private CIMClass getClassWrapper(CIMClientWrapper pCimClient, String pClassname, String pNamespace, int retry) throws Exception {
        try {
            CIMObjectPath ihCOP = new CIMObjectPath(pClassname, pNamespace);
            CIMClass mReturnClass = pCimClient.getClass(ihCOP, false, null);
            if (mReturnClass != null) {
                return mReturnClass;
            }
            if (retry < 4) {
                return this.getClassWrapper(pCimClient, pClassname, pNamespace, ++retry);
            }
            throw new Exception("Got no CIMClass. Not able to create the instance!");
        }
        catch (CIMException e) {
            if (e.getMessage().toLowerCase().indexOf("cim_err_failed") != -1 && retry < 4) {
                return this.getClassWrapper(pCimClient, pClassname, pNamespace, ++retry);
            }
            throw e;
        }
    }

    private CIMObjectPath createInstanceWrapper(CIMClientWrapper pCimClient, CIMObjectPath pInstanceCOP, CIMInstance pInstance) {
        return this.createInstanceWrapper(pCimClient, pInstanceCOP, pInstance, 0);
    }

    private CIMObjectPath createInstanceWrapper(CIMClientWrapper pCimClient, CIMObjectPath pInstanceCOP, CIMInstance pInstance, int retry) {
        try {
            return pCimClient.createInstance(pInstanceCOP, pInstance, null);
        }
        catch (CIMException e) {
            if (e.getMessage().toLowerCase().indexOf("cim_err_failed") != -1 && retry < 4) {
                return this.createInstanceWrapper(pCimClient, pInstanceCOP, pInstance, ++retry);
            }
            if (e.getMessage().toLowerCase().indexOf("cim_err_already_exists") != -1 && retry > 0) {
                return pInstance.getObjectPath();
            }
            throw e;
        }
        catch (DiskManagerTimeoutException e) {
            throw new CIMException("IBM_ERR_TIMED_OUT");
        }
    }

    private void deleteInstanceWrapper(CIMClientWrapper pCimClient, CIMObjectPath pInstanceCOP) {
        this.deleteInstanceWrapper(pCimClient, pInstanceCOP, 0);
    }

    private void deleteInstanceWrapper(CIMClientWrapper pCimClient, CIMObjectPath pInstanceCOP, int retry) {
        try {
            pCimClient.deleteInstance(pInstanceCOP, null);
        }
        catch (CIMException e) {
            if (e.getMessage().toLowerCase().indexOf("cim_err_failed") != -1 && retry < 4) {
                this.deleteInstanceWrapper(pCimClient, pInstanceCOP, ++retry);
            }
            throw e;
        }
        catch (DiskManagerTimeoutException e) {
            throw new CIMException("IBM_ERR_TIMED_OUT");
        }
    }

    private boolean isOldIBMCimom(CIMClientWrapper pCimClient, String pNamespace) {
        if (pNamespace.toLowerCase().indexOf("ibm") > 0) {
            try {
                CIMObjectPath mIBMObjectManager = new CIMObjectPath("IBMTS_ObjectManager", pNamespace);
                CIMEnumeration mIBMObejctManagerEnum = (CIMEnumeration)pCimClient.enumerateInstances(mIBMObjectManager);
                CIMInstance mObjectManagerInstance = null;
                if (mIBMObejctManagerEnum != null && mIBMObejctManagerEnum.hasMoreElements()) {
                    mObjectManagerInstance = (CIMInstance)mIBMObejctManagerEnum.nextElement();
                }
                mIBMObejctManagerEnum.close();
                String mElementName = (String)mObjectManagerInstance.getProperty("ElementName").getValue().getValue();
                if (mElementName.indexOf("ESS") != -1) {
                    String mSoftwareLevel = (String)mObjectManagerInstance.getProperty("Version").getValue().getValue();
                    if (mSoftwareLevel.startsWith("1.2.")) {
                        return true;
                    }
                    if (mSoftwareLevel.startsWith("5.1.0.")) {
                        StringTokenizer tokenizer = new StringTokenizer(mSoftwareLevel, ".");
                        String fix = tokenizer.nextToken();
                        fix = tokenizer.nextToken();
                        fix = tokenizer.nextToken();
                        fix = tokenizer.nextToken();
                        if (Integer.parseInt(fix) < 18) {
                            return true;
                        }
                    }
                    return false;
                }
                if (mElementName.indexOf("SVC") != -1) {
                    String mSoftwareLevel = (String)mObjectManagerInstance.getProperty("Version").getValue().getValue();
                    if (mSoftwareLevel.startsWith("1.2.")) {
                        return true;
                    }
                    if (mSoftwareLevel.startsWith("2.1.0.2")) {
                        return true;
                    }
                    if (mSoftwareLevel.startsWith("2.1.0.1")) {
                        return true;
                    }
                    return mSoftwareLevel.startsWith("2.1.0.0");
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private void setupVectors(CIMClientWrapper pCimclient) throws CIMException {
        String methodName = "setupVectors";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String[] classVector = new String[]{"CIM_ProcessIndication"};
        for (int i = 0; i < classVector.length; ++i) {
            CIMEnumeration vcEnum = null;
            try {
                vcEnum = (CIMEnumeration)pCimclient.enumerateClasses(new CIMObjectPath(classVector[i]), true, true, false, false);
            }
            catch (Exception e) {
                try {
                    vcEnum = (CIMEnumeration)pCimclient.enumerateClasses(new CIMObjectPath(classVector[i]), null);
                }
                catch (DiskManagerTimeoutException t) {
                    throw new CIMException("IBM_ERR_TIMED_OUT");
                }
            }
            while (vcEnum != null && vcEnum.hasMoreElements()) {
                CIMClass vClass = (CIMClass)vcEnum.nextElement();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "Adding " + vClass.getName() + " to " + classVector[i]);
                }
                CIMOMListener.addToProcessIndicationVector(vClass.getName());
            }
            try {
                if (vcEnum == null) continue;
                vcEnum.close();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    protected boolean deregisterIndicationListener(RegisteredCimom om) {
        CIMClientWrapper cimClient;
        String methodName = "deregisterIndicationListener";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if ((cimClient = (CIMClientWrapper)indicationMap.remove(om.getServiceUrl())) == null) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "Invalid CIMOM reference");
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return false;
        }
        try {
            cimClient.close();
            cimClient = this.createCimClient(om);
            this.unsubscribe(cimClient, om.getInteropSchemaNamespace());
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, methodName, (Throwable)e);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return false;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    private CIMInstance createIndicationHandlerInstance(CIMClientWrapper pCimclient, String pNamespace, int pCimomID, CIMClass pHandlerClass) throws UnknownHostException, CIMException {
        String methodName = "createIndicationHandlerInstance";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String ipAddressLocalHost = CIMOMEventProcessor.getValidLocalIP();
        int port = indicationServer.getPort();
        String mSystemHostName = pCimclient.getNameSpace().getHost();
        try {
            mSystemHostName = InetAddress.getByName(mSystemHostName).getCanonicalHostName();
        }
        catch (Exception e) {
            // empty catch block
        }
        CIMInstance destinationInst = pHandlerClass.newInstance();
        destinationInst.setProperty("CreationClassName", new CIMValue((Object)CIM_INDICATION_HDL, CIMDataType.getPredefinedType((int)8)));
        destinationInst.setProperty("SystemCreationClassName", new CIMValue((Object)CIM_COMPUTER_SYSTEM, CIMDataType.getPredefinedType((int)8)));
        destinationInst.setProperty("Name", new CIMValue((Object)CIM_SYSTEM, CIMDataType.getPredefinedType((int)8)));
        destinationInst.setProperty("SystemName", new CIMValue((Object)mSystemHostName, CIMDataType.getPredefinedType((int)8)));
        destinationInst.setProperty("PersistenceType", new CIMValue((Object)new UnsignedInt16(3), CIMDataType.getPredefinedType((int)2)));
        if (pCimomID == 0) {
            destinationInst.setProperty("Destination", new CIMValue((Object)("http://" + ipAddressLocalHost + ":" + port), CIMDataType.getPredefinedType((int)8)));
        } else {
            destinationInst.setProperty("Destination", new CIMValue((Object)("http://" + ipAddressLocalHost + ":" + port + "/" + pCimomID), CIMDataType.getPredefinedType((int)8)));
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return destinationInst;
    }

    private CIMInstance createIndicationFilterInstance(CIMClientWrapper pCimclient, String pNamespace, String pFilterType, CIMClass pFilterClass) throws UnknownHostException, CIMException {
        String methodName = "createIndicationFilterInstance";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String ipAddressLocalHost = CIMOMEventProcessor.getValidLocalIP();
        String mSystemHostName = pCimclient.getNameSpace().getHost();
        try {
            mSystemHostName = InetAddress.getByName(mSystemHostName).getCanonicalHostName();
        }
        catch (Exception e) {
            // empty catch block
        }
        CIMInstance filterInstance = pFilterClass.newInstance();
        String filterString = "SELECT * FROM " + pFilterType;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "Filter: " + filterString);
        }
        filterInstance.setProperty("Query", new CIMValue((Object)filterString, CIMDataType.getPredefinedType((int)8)));
        filterInstance.setProperty("QueryLanguage", new CIMValue((Object)"WQL", CIMDataType.getPredefinedType((int)8)));
        filterInstance.setProperty("SystemName", new CIMValue((Object)mSystemHostName, CIMDataType.getPredefinedType((int)8)));
        filterInstance.setProperty("Name", new CIMValue((Object)(pFilterType + " for " + ipAddressLocalHost), CIMDataType.getPredefinedType((int)8)));
        filterInstance.setProperty("Description", new CIMValue((Object)CIM_DYNAMIC, CIMDataType.getPredefinedType((int)8)));
        filterInstance.setProperty("CreationClassName", new CIMValue((Object)CIM_INDI_FILTER, CIMDataType.getPredefinedType((int)8)));
        filterInstance.setProperty("SystemCreationClassName", new CIMValue((Object)CIM_COMPUTER_SYSTEM, CIMDataType.getPredefinedType((int)8)));
        filterInstance.setProperty("SourceNamespace", new CIMValue((Object)pNamespace, CIMDataType.getPredefinedType((int)8)));
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return filterInstance;
    }

    public static String getValidLocalIP() throws UnknownHostException {
        String mIPAddress;
        String mConfiguredIPAddress = cConfigService.getProperty(CONF_LOCAL_ADDRESS, DEV_SERVER_GROUP);
        boolean bSuccess = true;
        if (mConfiguredIPAddress != null && !mConfiguredIPAddress.equalsIgnoreCase("NOT SET")) {
            if (CIMOMEventProcessor.validateIP(mConfiguredIPAddress)) {
                return mConfiguredIPAddress;
            }
            bSuccess = false;
        }
        String bLocalHostName = InetAddress.getLocalHost().getHostName();
        InetAddress bLocalAddress = null;
        InetAddress[] bAllAddr = InetAddress.getAllByName(bLocalHostName);
        for (int bI = 0; bI < bAllAddr.length; ++bI) {
            InetAddress bTempAddress = bAllAddr[bI];
            if (bTempAddress.isMulticastAddress() || bTempAddress.isLoopbackAddress()) continue;
            bLocalAddress = bTempAddress;
            break;
        }
        String string = mIPAddress = bLocalAddress != null ? bLocalAddress.getHostAddress() : InetAddress.getLocalHost().getHostAddress();
        if (!bSuccess) {
            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, "getValidLocalIP", "IP Address configured in DB: " + mConfiguredIPAddress + " is not valid. Using " + mIPAddress);
        }
        return mIPAddress;
    }

    private static boolean validateIP(String pIP) {
        try {
            InetAddress.getByName(pIP);
        }
        catch (Exception mEx) {
            traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, "validateIP", (Throwable)mEx);
            return false;
        }
        return true;
    }

    private CIMInstance createIndicationSubscriptionInstance(CIMClientWrapper pCimclient, String pNamespace, CIMObjectPath pHandlerCOP, CIMObjectPath pFilterCOP, CIMClass pSubscriptionClass) throws UnknownHostException, CIMException {
        String methodName = "createIndicationSubscriptionInstance";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        CIMInstance ssInst = pSubscriptionClass.newInstance();
        ssInst.setProperty("Filter", new CIMValue((Object)pFilterCOP, CIMDataType.getPredefinedType((int)14)));
        ssInst.setProperty("Handler", new CIMValue((Object)pHandlerCOP, CIMDataType.getPredefinedType((int)14)));
        ssInst.setProperty("OnFatalErrorPolicy", new CIMValue((Object)new UnsignedInt16(2), CIMDataType.getPredefinedType((int)2)));
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return ssInst;
    }

    private CIMClientWrapper createCimClient(RegisteredCimom pCimom) {
        String user = pCimom.getUserId();
        String password = pCimom.getPassword();
        String service = pCimom.getServiceUrl();
        String nameSpace = pCimom.getInteropSchemaNamespace();
        String methodName = "createCimClient";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        CIMClientWrapper cimClient = null;
        try {
            CIMNameSpace cimNameSpace = new CIMNameSpace(service, nameSpace);
            if (user == null) {
                user = "";
            }
            UserPrincipal userPr = new UserPrincipal(user);
            password = password == null ? "" : SRMCrypto.decrypt((String)password);
            PasswordCredential pwCred = new PasswordCredential(password.toCharArray());
            CIMObjectPath cop = null;
            CIMEnumeration e = null;
            String TESTCLASS = "CIM_RegisteredProfile";
            cimClient = new CIMClientWrapper(user, password, service, nameSpace);
            cop = new CIMObjectPath(TESTCLASS, nameSpace);
            e = (CIMEnumeration)cimClient.enumClass(cop, false, null);
            e.close();
        }
        catch (Exception e1) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_WARNING, (Object)className, methodName, (Throwable)e1);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return cimClient;
    }

    public void exit() {
        indicationServer.close();
        indicationServer = null;
    }

    static {
        cConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
    }
}

