/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.monitor.MonitorActivator;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cimxml.CIMXmlUtil;
import org.sblim.wbem.cimxml.CIMXmlUtilFactory;
import org.sblim.wbem.client.indications.CIMEvent;
import org.sblim.wbem.client.indications.CIMListener;

public class CIMOMListener
implements CIMListener {
    public static Vector instanceIndicationVector = new Vector();
    public static Vector processIndicationVector = new Vector();
    private static final String IND_FILTER_LIST = "Indication.FilterList";
    private static final String IND_FILTER_MODE = "Indication.FilterMode";
    private static final String FILTER_MODE_INCLUDE = "include";
    private static final String DEV_SERVER_GROUP = "DeviceServer";
    private static List stFilterList = null;
    private static boolean stIncludeMode = false;
    private static final int listenerID = 100;
    private IEventMonitorService eventCorrelatorFactory = null;
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    private static String className = CIMOMListener.class.getName();

    public static void addToInstanceIndicationVector(String indicationClassName) {
        if (!instanceIndicationVector.contains(indicationClassName)) {
            instanceIndicationVector.add(indicationClassName);
        }
    }

    public static void addToProcessIndicationVector(String indicationClassName) {
        if (!processIndicationVector.contains(indicationClassName)) {
            processIndicationVector.add(indicationClassName);
        }
    }

    public static boolean isInstanceIndication(String indicationClassName) {
        return true;
    }

    public static boolean isProcessIndication(String indicationClassName) {
        return processIndicationVector.contains(indicationClassName);
    }

    public CIMOMListener(IEventMonitorService eventMonitor) {
        this.eventCorrelatorFactory = eventMonitor;
        if (msgLogger == null) {
            msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.SanEventCorrelatorFactory");
            msgLogger.setMessageFile(LogConstants.MSG_FILE);
        }
        if (traceLogger == null) {
            traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.SanEventCorrelatorFactory");
        }
        IConfigService bConfigService = (IConfigService)MonitorActivator._serviceHelper.bindLocal("ConfigService");
        String bFilterListString = bConfigService.getProperty(IND_FILTER_LIST, DEV_SERVER_GROUP);
        stFilterList = new ArrayList();
        if (bFilterListString != null && bFilterListString.trim().length() > 0) {
            String[] bFilterListArray = bFilterListString.split(";");
            for (int i = 0; i < bFilterListArray.length; ++i) {
                stFilterList.add(bFilterListArray[i]);
            }
        }
        traceLogger.text(IRecordType.TYPE_WARN, (Object)"CIMOMListener", "CIMOMListener", "Using indication filter: " + stFilterList);
        String bFilterModeString = bConfigService.getProperty(IND_FILTER_MODE, DEV_SERVER_GROUP);
        if (bFilterModeString != null && bFilterModeString.trim().length() > 0) {
            stIncludeMode = bFilterModeString.trim().toLowerCase().equals(FILTER_MODE_INCLUDE);
        }
    }

    public int hashCode() {
        return 100;
    }

    public void indicationOccured(CIMEvent arg0) {
        String methodName = "indicationOccured";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        boolean success = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "Indication occured ");
        }
        CIMInstance indicationInstance = arg0.getIndication();
        String indicationClassName = indicationInstance.getClassName().trim();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, indicationClassName);
        }
        try {
            if (CIMOMListener.isProcessIndication(indicationClassName)) {
                this.handleProcessIndication(arg0);
            } else {
                this.handleInstanceIndication(arg0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void handleProcessIndication(CIMEvent indicationEvent) throws Exception {
        String methodName = "handleProcessIndication";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Vector props = indicationEvent.getIndication().getAllProperties();
        for (int i = 0; i < props.size(); ++i) {
            CIMProperty cp = (CIMProperty)props.elementAt(i);
            if (!cp.getName().equals("SystemName") || cp.getValue() == null) continue;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "Alert Indication received from " + cp.getValue().getValue());
            }
            this.eventCorrelatorFactory.postIndicationEvent(indicationEvent);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void handleInstanceIndication(CIMEvent indicationEvent) throws Exception {
        String methodName = "handleInstanceIndication";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (!this.isHandledIndication(indicationEvent)) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return;
        }
        Vector props = indicationEvent.getIndication().getAllProperties();
        String indicationClassName = indicationEvent.getIndication().getClassName().trim();
        CIMInstance sourceInst = null;
        String indicationClass = null;
        for (int i = 0; i < props.size(); ++i) {
            String[] parts;
            CIMProperty cp = (CIMProperty)props.elementAt(i);
            if (!cp.getName().equals("SourceInstance") || cp.getValue() == null) continue;
            String instanceXml = (String)cp.getValue().getValue();
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "InstanceXml1:=" + instanceXml);
            }
            if (instanceXml.startsWith("<C")) {
                String instanceXml2 = "";
                for (int j = 0; j < instanceXml.length(); ++j) {
                    if (instanceXml.charAt(j) == '\\') continue;
                    instanceXml2 = instanceXml2 + instanceXml.charAt(j);
                }
                CIMXmlUtil util = CIMXmlUtilFactory.getCIMXmlUtil();
                sourceInst = (CIMInstance)util.getCIMElement(instanceXml2);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "Received indication of type: " + sourceInst.getClassName() + " " + indicationClassName);
                }
                if (!CIMOMListener.isInstanceIndication(indicationClass = sourceInst.getClassName())) continue;
                this.eventCorrelatorFactory.postIndicationEvent(indicationEvent);
                continue;
            }
            CIMObjectPath cop = new CIMObjectPath(instanceXml);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "Received an indication of type: " + cop.getObjectName() + " " + indicationClassName);
            }
            if (!CIMOMListener.isInstanceIndication(indicationClass = (parts = cop.getObjectName().split("\\."))[0])) continue;
            this.eventCorrelatorFactory.postIndicationEvent(indicationEvent);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private boolean isHandledIndication(CIMEvent pEvent) {
        boolean mIsSuported;
        CIMInstance mIndication = pEvent.getIndication();
        String mSourceCOP = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)mIndication, (String)"SourceInstance");
        boolean bl = stIncludeMode ? this.isContainedInFilterList(mSourceCOP) : (mIsSuported = !this.isContainedInFilterList(mSourceCOP));
        if (!mIsSuported && traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, "isHandledIndication", "Filtering out indication for " + mSourceCOP);
        }
        return mIsSuported;
    }

    private boolean isContainedInFilterList(String pCOP) {
        if (pCOP == null) {
            return false;
        }
        Iterator mListIt = stFilterList.iterator();
        while (mListIt.hasNext()) {
            if (pCOP.indexOf((String)mListIt.next()) <= 0) continue;
            return true;
        }
        return false;
    }

    private void printIndicationsProperties(CIMInstance indicationInstance) {
        String methodName = "printIndicationProperties";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, "Indication: " + indicationInstance.getClassName());
        }
        Vector props = indicationInstance.getProperties();
        for (int i = 0; i < props.size(); ++i) {
            String value;
            CIMProperty cp = (CIMProperty)props.elementAt(i);
            String string = value = cp.getValue() != null ? cp.getValue().toString() : "null";
            if (traceLogger == null || !traceLogger.isLogging()) continue;
            traceLogger.entry(IRecordType.TYPE_INFO, (Object)methodName, cp.getName() + "=" + value);
        }
    }
}

