/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor;

import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.monitor.CIMOMEventProcessor;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;

public class CIMOMRegistrator
extends Thread {
    public static String queueName = "CIMOM Registrator";
    private boolean shutdown = false;
    Thread thread = null;
    transient boolean busy;
    RegisteredCimom cimom;
    CIMOMEventProcessor cEvProcer = null;
    protected static String className = CIMOMRegistrator.class.getName();
    protected static ILogger msgLogger = null;
    protected static ILogger traceLogger = null;

    public CIMOMRegistrator(CIMOMEventProcessor pCimMonitor) {
        this.setName(queueName);
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.cEvProcer = pCimMonitor;
        this.start();
    }

    public void run() {
        String methodName = "run";
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            this.busy = false;
            try {
                if (Configuration.debug) {
                    System.out.println(queueName + ": waiting for a job");
                }
                JobInfo job = QueueController.getInstance().getNextJob(queueName);
                if (this.shutdown) continue;
                if (job == null) {
                    System.out.println(queueName + ": Error - got a NULL job from the queue");
                    continue;
                }
                this.busy = true;
                try {
                    Object[] request = (Object[])job.getRequest().getData();
                    String regType = (String)request[0];
                    this.cimom = (RegisteredCimom)request[1];
                    boolean res = false;
                    if (Configuration.debug) {
                        System.out.println(queueName + ": " + regType + ", CIMOM: " + this.cimom.getServiceUrl());
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Executing " + regType + " job for CIMOM " + this.cimom.getServiceUrl());
                    }
                    if (regType.equals("register")) {
                        res = this.cEvProcer.registerIndicationListener(this.cimom);
                    } else if (regType.equals("deregister")) {
                        res = this.cEvProcer.deregisterIndicationListener(this.cimom);
                    } else if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)className, methodName, "ERROR - Invalid regType: " + regType);
                    }
                    if (Configuration.debug) {
                        System.out.println(queueName + ": completed " + regType + " job " + (res ? "successfully" : "with failure") + " for CIMOM at " + this.cimom.getServiceUrl());
                    }
                    if (res) {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Successfully completed " + regType + " job for CIMOM " + this.cimom.getServiceUrl());
                        }
                    } else if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "Failed to " + regType + ", CIMOM: " + this.cimom.getServiceUrl());
                    }
                    job.setResponse((Response)new ObjectResponse(null, job));
                    job.setReturnCode(0);
                    job.complete(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    job.setReturnCode(103);
                    job.complete(false);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void shutdown() {
        String methodName = "shutdown";
        this.shutdown = true;
        if (this.thread != null) {
            try {
                if (this.busy) {
                    if (Configuration.debug) {
                        System.out.println(queueName + ": Still busy with CIMOM: " + this.cimom.getServiceUrl() + ", interrupting");
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "Still busy with CIMOM: " + this.cimom.getServiceUrl() + ", interrupting");
                    }
                }
                this.thread.interrupt();
                this.thread.join(30000L);
                this.thread = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public RegisteredCimom getCurrentCimom() {
        if (this.busy) {
            return this.cimom;
        }
        return null;
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.SanEventCorrelatorFactory");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.SanEventCorrelatorFactory");
        msgLogger.setMessageFile(LogConstants.MSG_FILE);
    }
}

