/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;

public class EventCorrelatordDBHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer determineCimomType(CIMOM pCIMOM) throws SQLException {
        DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        try {
            RegisteredCimom mRegCimom = new RegisteredCimom();
            mRegCimom.setServiceUrl(pCIMOM.getServiceUrl());
            if (mRegCimom.retrieve(mConnection)) {
                List mNamespaces = EventCorrelatordDBHelper.getNamespacesForCimom(mConnection, mRegCimom);
                List mSwitches = EventCorrelatordDBHelper.getSwitchesForCimom(mConnection, mNamespaces);
                List mSubsystems = EventCorrelatordDBHelper.getSubsystemsForCimom(mConnection, mNamespaces);
                List mTapeLibraries = EventCorrelatordDBHelper.getTapeLibrariesForCimom(mConnection, mNamespaces);
                Integer n = !mSwitches.isEmpty() ? EventCorrelatorFactory.IS_SWITCH : (!mSubsystems.isEmpty() ? EventCorrelatorFactory.IS_SUBSYSTEM : (!mTapeLibraries.isEmpty() ? EventCorrelatorFactory.IS_TAPELIBRARY : EventCorrelatorFactory.IS_NOTHING));
                return n;
            }
            Integer n = EventCorrelatorFactory.IS_NOTHING;
            return n;
        }
        finally {
            if (mConnection != null) {
                mConnection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getNamespacesForCimom(DBConnection pConnection, RegisteredCimom pRegCimom) throws SQLException {
        LinkedList<String> mNamespaceIds = new LinkedList<String>();
        Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>(2);
        mWhereClause.put(TResCimom2namespaceTable.getColumnInfo((String)"CIMOM_ID"), Integer.toString(pRegCimom.getRegCimomId()));
        Cimom2namespace.Cimom2namespaceCursor mC2NCursor = Cimom2namespace.getCursor((DBConnection)pConnection, mWhereClause, null);
        try {
            while (mC2NCursor.next()) {
                mNamespaceIds.add(Integer.toString(mC2NCursor.getObject().getCimNamespaceId()));
            }
        }
        finally {
            mC2NCursor.close();
        }
        return mNamespaceIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getSwitchesForCimom(DBConnection pConnection, List pNamespaces) throws SQLException {
        LinkedList<String> mSwitchWWNs = new LinkedList<String>();
        Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
        for (String mNamespaceId : pNamespaces) {
            mWhereClause.clear();
            mWhereClause.put(TResCimkeySwitchTable.getColumnInfo((String)"CIM_NAMESPACE_ID"), mNamespaceId);
            CimkeySwitch.CimkeySwitchCursor mCKSCursor = CimkeySwitch.getCursor((DBConnection)pConnection, mWhereClause, null);
            try {
                while (mCKSCursor.next()) {
                    mSwitchWWNs.add(mCKSCursor.getObject().getSwitchWwn());
                }
            }
            finally {
                mCKSCursor.close();
            }
        }
        return mSwitchWWNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getSubsystemsForCimom(DBConnection pConnection, List pNamespaces) throws SQLException {
        LinkedList<String> mSubsystemIds = new LinkedList<String>();
        Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
        for (String mNamespaceId : pNamespaces) {
            mWhereClause.clear();
            mWhereClause.put(TResCimkeySubsystemTable.getColumnInfo((String)"CIM_NAMESPACE_ID"), mNamespaceId);
            CimkeySubsystem.CimkeySubsystemCursor mCKSCursor = CimkeySubsystem.getCursor((DBConnection)pConnection, mWhereClause, null);
            try {
                while (mCKSCursor.next()) {
                    mSubsystemIds.add(Integer.toString(mCKSCursor.getObject().getSubsystemId()));
                }
            }
            finally {
                mCKSCursor.close();
            }
        }
        return mSubsystemIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getTapeLibrariesForCimom(DBConnection pConnection, List pNamespaces) throws SQLException {
        LinkedList<String> mLibraryIds = new LinkedList<String>();
        Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
        for (String mNamespaceId : pNamespaces) {
            mWhereClause.clear();
            mWhereClause.put(TResCimkeyTapeLibraryTable.getColumnInfo((String)"CIM_NAMESPACE_ID"), mNamespaceId);
            CimkeyTapeLibrary.CimkeyTapeLibraryCursor mCKSCursor = CimkeyTapeLibrary.getCursor((DBConnection)pConnection, mWhereClause, null);
            try {
                while (mCKSCursor.next()) {
                    mLibraryIds.add(Integer.toString(mCKSCursor.getObject().getTapeLibraryId()));
                }
            }
            finally {
                mCKSCursor.close();
            }
        }
        return mLibraryIds;
    }
}

