/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class EventXMLParser
extends DefaultHandler {
    static ILogger msgLogger = LogConstants.msgLogger;
    static ILogger traceLogger = LogConstants.traceLogger;
    static final String className = EventXMLParser.class.getName();
    private Vector xEventType = new Vector();
    private Vector xTimeStamp = new Vector();
    private Vector xSourceName = new Vector();
    private Vector xSourceAddress = new Vector();
    private Vector xSourceSpecific = new Vector();

    public EventXMLParser() {
        String methodName = "EventXMLParser";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void error(SAXParseException e) {
        String methodName = "error";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "An error was encountered parsing Event XML: " + e.getMessage());
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void warning(SAXParseException e) {
        String methodName = "warning";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "A warning was encountered parsing Event XML: " + e.getMessage());
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void fatalError(SAXParseException e) {
        String methodName = "fatalError";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "EventCorrelator_XMLparsingError");
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "A fatal error was encountered parsing Event XML: " + e.getMessage());
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equalsIgnoreCase("SmartEvent")) {
            this.xTimeStamp.addElement(atts.getValue("TimeStamp"));
            this.xEventType.addElement(atts.getValue("EventId"));
        } else if (qName.equalsIgnoreCase("InbandEvent")) {
            this.xTimeStamp.addElement(atts.getValue("TimeStamp"));
            this.xEventType.addElement(atts.getValue("EventType"));
        } else if (qName.equalsIgnoreCase("Source")) {
            this.xSourceName.addElement(atts.getValue("Name"));
            this.xSourceAddress.addElement(atts.getValue("Address"));
            this.xSourceSpecific.addElement(atts.getValue("Specific"));
        }
    }

    public String[] getEventIds() {
        String[] eventIds = new String[this.xEventType.size()];
        this.xEventType.toArray(eventIds);
        return eventIds;
    }

    public String[] getTimeStamps() {
        String[] timeStamps = new String[this.xTimeStamp.size()];
        this.xTimeStamp.toArray(timeStamps);
        return timeStamps;
    }

    public String[] getSourceNames() {
        String[] sourceNames = new String[this.xSourceName.size()];
        this.xSourceName.toArray(sourceNames);
        return sourceNames;
    }

    public String[] getSourceAddresses() {
        String[] sourceAddresses = new String[this.xSourceAddress.size()];
        this.xSourceAddress.toArray(sourceAddresses);
        return sourceAddresses;
    }

    public String[] getSourceSpecifics() {
        String[] sourceSpecifics = new String[this.xSourceSpecific.size()];
        this.xSourceSpecific.toArray(sourceSpecifics);
        return sourceSpecifics;
    }
}

