/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class HbaAlertPopulator
implements IPopulator {
    public static final String deviceType = "hba";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = HbaAlertPopulator.class.getName();

    public HbaAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getHbaData(deviceId, snmpValues, tecValues)) {
            short alertCondition;
            short resourceType = 1;
            int resourceId = this.determineResourceId(deviceId, snmpValues);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition = 174, deviceId);
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 104;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_NEW_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    System.out.println("value" + i + " = " + value);
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4031I";
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("label");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("HLDType")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("HLDLabel")) == null) {
                    value2 = "";
                }
                msgValues = new Object[]{value0, value2};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined for device: hba" + deviceId);
            }
        } else {
            throw new AlertCreationException("No object found for device: hba" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getHbaData(deviceId, snmpValues, tecValues)) {
            short alertCondition;
            short resourceType = 1;
            int resourceId = this.determineResourceId(deviceId, snmpValues);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition = 174, deviceId);
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                if (newState == 1) {
                    trapType = 112;
                }
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = newState == 1 ? "HARMLESS" : "CRITICAL";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4032W";
                if (newState == 1) {
                    msgId = "ALR4033I";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("label");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("HLDType")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("HLDLabel")) == null) {
                    value2 = "";
                }
                msgValues = new Object[]{value0, value2};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined for device: hba" + deviceId);
            }
        } else {
            throw new AlertCreationException("No object found for device: hba" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) throws AlertCreationException {
        String methodName = "populatePropertyChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        short alertCondition = -1;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        String parameterName = "DRIVER_VERSION";
        String oldValue = (String)oldValues.get(parameterName);
        String newValue = (String)newValues.get(parameterName);
        if (oldValue == null || newValue == null) {
            parameterName = "FIRMWARE_VERSION";
            oldValue = (String)oldValues.get(parameterName);
            newValue = (String)newValues.get(parameterName);
            if (oldValue == null || newValue == null) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "Error populating HBA Properties, " + parameterName + " value is null - old Value=" + oldValue + ", new Value=" + newValue);
                }
                return null;
            }
        }
        if (EventDBAccessor.getHbaData(deviceId, snmpValues, tecValues)) {
            short resourceType = 1;
            int resourceId = this.determineResourceId(deviceId, snmpValues);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition = parameterName.equals("DRIVER_VERSION") ? (short)175 : 176, deviceId);
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 102;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_PROPERTY_CHANGE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    System.out.println("value" + i + "=" + value);
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PEAttributeModifiedEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "MINOR";
                this.addCommonTecAttributes(tecTable, severity);
                this.addAttributeData(snmpTable, tecTable, parameterName, oldValue, newValue);
                String msgId = "ALR4034W";
                if (parameterName.equals("FIRMWARE_VERSION")) {
                    msgId = "ALR4035W";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("label");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("HLDType")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("HLDLabel")) == null) {
                    value2 = "";
                }
                msgValues = new Object[]{value0, value2, oldValue, newValue};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined for device: hba" + deviceId);
            }
        } else {
            throw new AlertCreationException("No object found for device: hba" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) throws AlertCreationException {
        String methodName = "populateOperationalStatusChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getHbaData(deviceId, snmpValues, tecValues)) {
            short alertCondition;
            short resourceType = 1;
            int resourceId = this.determineResourceId(deviceId, snmpValues);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition = 174, deviceId);
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 116;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PEOperationalStatusChangeEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "MINOR";
                this.addCommonTecAttributes(tecTable, severity);
                this.addOperationalStatusData(snmpTable, tecTable, oldStatus, newStatus);
                String msgId = "ALR4036W";
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("label");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("HLDType")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("HLDLabel")) == null) {
                    value2 = "";
                }
                String value3 = "" + oldStatus;
                String value4 = "" + newStatus;
                msgValues = new Object[]{value0, value2, value3, value4};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined for device: hba" + deviceId);
            }
        } else {
            throw new AlertCreationException("No object found for device: hba" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    private void addAttributeData(Hashtable snmpTable, Hashtable tecTable, String attName, String oldValue, String newValue) {
        snmpTable.put(MIBConstants.BTAAttributeName, attName);
        snmpTable.put(MIBConstants.BTAOldAttributeValue, oldValue);
        snmpTable.put(MIBConstants.BTANewAttributeValue, newValue);
        tecTable.put("attributeName", attName);
        tecTable.put("oldValue", oldValue);
        tecTable.put("newValue", newValue);
    }

    private void addOperationalStatusData(Hashtable snmpTable, Hashtable tecTable, int oldStatus, int newStatus) {
        snmpTable.put(MIBConstants.BTAOldStatus, "" + oldStatus);
        snmpTable.put(MIBConstants.BTANewStatus, "" + newStatus);
        tecTable.put("oldStatus", "" + oldStatus);
        tecTable.put("newStatus", "" + newStatus);
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private int determineResourceId(String deviceId, Hashtable snmpValues) {
        int resourceId = -1;
        String hostId = (String)snmpValues.get("HLDUniqueId");
        resourceId = hostId != null && !hostId.equals("") ? Integer.parseInt(hostId) : Integer.parseInt(deviceId);
        return resourceId;
    }

    private String getPEValue(int index, Hashtable values) {
        if (peVarNames[index].equals("description")) {
            return peVarNames[index];
        }
        if (peVarNames[index].equals("messageId")) {
            return peVarNames[index];
        }
        return (String)values.get(peVarNames[index]);
    }

    private int getAlertId(short resourceType, int resourceId, short alertCondition, String deviceId) {
        int alertId = -1;
        alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition);
        if (alertId <= 0) {
            String fabricId = EventDBAccessor.getFabricIdForHBA(deviceId);
            if (fabricId != null && !fabricId.equals("")) {
                alertId = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(fabricId), alertCondition);
            }
            if (alertId <= 0) {
                alertId = EventDBAccessor.getAlertIDByResource(resourceType, -1, alertCondition);
            }
        }
        return alertId;
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

