/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class Zone2MemberAlertPopulator
implements IPopulator {
    public static final String deviceType = "zone2member";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = Zone2MemberAlertPopulator.class.getName();

    public Zone2MemberAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getZone2MemberData(deviceId, snmpValues, tecValues)) {
            int alertCondition;
            short resourceType = 127;
            int resourceId = this.getResourceId(deviceId, snmpValues);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = 121);
            if (alertId <= 0) {
                short tmpResourceType = -1;
                int tmpResourceId = -1;
                String fabricId = (String)snmpValues.get("fabricId");
                if (fabricId != null && !fabricId.equals("")) {
                    tmpResourceId = Integer.parseInt(fabricId);
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 127;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
            }
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 106;
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_NEW_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SANRegionEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4081I";
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("toObjectName");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("zoneName")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("SANName")) == null) {
                    value2 = "";
                }
                msgValues = new Object[]{value0, value1, value2};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: zone2member" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: zone2member" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getZone2MemberData(deviceId, snmpValues, tecValues)) {
            int alertCondition;
            short resourceType = 127;
            int resourceId = this.getResourceId(deviceId, snmpValues);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = 121);
            if (alertId <= 0) {
                short tmpResourceType = -1;
                int tmpResourceId = -1;
                String fabricId = (String)snmpValues.get("fabricId");
                if (fabricId != null && !fabricId.equals("")) {
                    tmpResourceId = Integer.parseInt(fabricId);
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 127;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
            }
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                if (newState == 1) {
                    trapType = 114;
                }
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 0 ? "TPC_MISSING_DEVICE_EVENT" : "TPC_NORMAL_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SANRegionEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = newState == 0 ? "WARNING" : "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4083I";
                if (newState == 0) {
                    msgId = "ALR4082W";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("toObjectName");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("zoneName")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("SANName")) == null) {
                    value2 = "";
                }
                msgValues = new Object[]{value0, value1, value2};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined for device: zone2member" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: zone2member" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) {
        Alert alert = null;
        return alert;
    }

    private int getResourceId(String deviceId, Hashtable values) {
        int resourceId = -1;
        String tmpId = "" + (String)values.get("zoneId");
        resourceId = tmpId.equals("") ? Integer.parseInt(deviceId) : Integer.parseInt(tmpId);
        return resourceId;
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private String getSRValue(int index, Hashtable values) {
        if (srVarNames[index].equals("description")) {
            return srVarNames[index];
        }
        if (peVarNames[index].equals("messageId")) {
            return srVarNames[index];
        }
        return (String)values.get(srVarNames[index]);
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        String methodName = "populateSateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (this.getZone2MemberData(deviceId, snmpValues, tecValues, attributeMap)) {
            int alertCondition;
            short resourceType = 127;
            int resourceId = this.getResourceId(deviceId, snmpValues);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = 121);
            if (alertId <= 0) {
                short tmpResourceType = -1;
                int tmpResourceId = -1;
                String fabricId = (String)snmpValues.get("fabricId");
                if (fabricId != null && !fabricId.equals("")) {
                    tmpResourceId = Integer.parseInt(fabricId);
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 127;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
            }
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                if (newState == 1) {
                    trapType = 114;
                }
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 0 ? "TPC_MISSING_DEVICE_EVENT" : "TPC_NORMAL_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SANRegionEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = newState == 0 ? "WARNING" : "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4083I";
                if (newState == 0) {
                    msgId = "ALR4082W";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("toObjectName");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("zoneName")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("SANName")) == null) {
                    value2 = "";
                }
                msgValues = new Object[]{value0, value1, value2};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined for device: zone2member" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: zone2member" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    private boolean getZone2MemberData(String deviceId, Hashtable snmpValues, Hashtable tecValues, HashMap attributeMap) {
        boolean retrieveOK = false;
        HashMap tempMap = null;
        tempMap = (HashMap)attributeMap.get(deviceType + deviceId);
        Hashtable<String, String> fromValues = new Hashtable<String, String>();
        Hashtable<String, String> toValues = new Hashtable<String, String>();
        Hashtable dummyValues = new Hashtable();
        if (tempMap != null) {
            String zone_id = (String)tempMap.get("ZONE_ID");
            String member_id = (String)tempMap.get("ZONE_MEMBER_ID");
            if (zone_id != null) {
                HashMap zoneMap = (HashMap)attributeMap.get("zone" + zone_id);
                if (zoneMap != null) {
                    fromValues.put("uniqueId", zone_id);
                    fromValues.put("entityName", this.getValue(zoneMap, "ZONE_NAME"));
                    fromValues.put("zoneName", this.getValue(zoneMap, "ZONE_NAME"));
                    fromValues.put("active", this.getValue(zoneMap, "ACTIVE"));
                    fromValues.put("label", this.getValue(zoneMap, "ZONE_NAME"));
                    fromValues.put("entityType", "zone");
                    fromValues.put("type", this.getValue(zoneMap, "ZONE_TYPE"));
                    EventDBAccessor.setSelfAsHLD(fromValues);
                    String fabricWWN = this.getValue(zoneMap, "FABRIC_WWN");
                    retrieveOK = fabricWWN != null && EventDBAccessor.getFabricDataFromFabricWWN(fromValues, fabricWWN);
                } else {
                    retrieveOK = EventDBAccessor.getZoneData(zone_id, fromValues, dummyValues);
                }
            }
            if (retrieveOK && member_id != null) {
                HashMap memberMap = (HashMap)attributeMap.get("zonemember" + member_id);
                if (memberMap != null) {
                    toValues.put("uniqueId", member_id);
                    toValues.put("entityName", this.getValue(memberMap, "MEMBER_NAME"));
                    toValues.put("active", "");
                    toValues.put("label", this.getValue(memberMap, "MEMBER_NAME"));
                    toValues.put("entityType", "zonemember");
                    toValues.put("type", this.getValue(memberMap, "TYPE"));
                    EventDBAccessor.setSelfAsHLD(toValues);
                    retrieveOK = true;
                } else {
                    retrieveOK = EventDBAccessor.getZoneMemberData(member_id, toValues, dummyValues);
                }
            }
            if (retrieveOK) {
                snmpValues.put("uniqueId", deviceId);
                snmpValues.put("entityName", "");
                snmpValues.put("label", "");
                snmpValues.put("entityType", deviceType);
                snmpValues.put("type", "");
                snmpValues.put("state", "");
                snmpValues.put("zoneId", fromValues.get("uniqueId"));
                snmpValues.put("zoneName", fromValues.get("entityName"));
                snmpValues.put("fromObjectUniqueId", fromValues.get("uniqueId"));
                snmpValues.put("fromObjectLabel", fromValues.get("label"));
                snmpValues.put("fromObjectType", fromValues.get("entityType"));
                snmpValues.put("fromObjectName", fromValues.get("entityName"));
                snmpValues.put("fromObjectHLDUniqueId", fromValues.get("HLDUniqueId"));
                snmpValues.put("fromObjectHLDType", fromValues.get("HLDType"));
                snmpValues.put("fromObjectHLDLabel", fromValues.get("HLDLabel"));
                snmpValues.put("fromHighLevelDevice", fromValues.get("highLevelDevice"));
                snmpValues.put("toObjectUniqueId", toValues.get("uniqueId"));
                snmpValues.put("toObjectLabel", toValues.get("label"));
                snmpValues.put("toObjectType", toValues.get("entityType"));
                snmpValues.put("toObjectName", toValues.get("entityName"));
                snmpValues.put("toObjectHLDUniqueId", toValues.get("HLDUniqueId"));
                snmpValues.put("toObjectHLDType", toValues.get("HLDType"));
                snmpValues.put("toObjectHLDLabel", toValues.get("HLDLabel"));
                snmpValues.put("toHighLevelDevice", toValues.get("highLevelDevice"));
                snmpValues.put("SANName", fromValues.get("SANName"));
                snmpValues.put("fabricId", fromValues.get("fabricId"));
                snmpValues.put("active", fromValues.get("active"));
                tecValues.putAll(snmpValues);
                retrieveOK = true;
            }
        }
        return retrieveOK;
    }

    private String getValue(HashMap attributeMap, String valueKey) {
        Object value = null;
        value = attributeMap.get(valueKey);
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

