/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class ZonesetAlertPopulator
implements IPopulator {
    public static final String deviceType = "zset";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = ZonesetAlertPopulator.class.getName();

    public ZonesetAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getZoneSetData(deviceId, snmpValues, tecValues)) {
            short alertCondition;
            String eventType = "TPC_NEW_DEVICE_EVENT";
            short resourceType = 126;
            int resourceId = Integer.parseInt(ID);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = this.determineAlertCondition(eventType));
            if (alertId <= 0) {
                short tmpResourceType = -1;
                int tmpResourceId = -1;
                String fabricId = (String)snmpValues.get("fabricId");
                if (fabricId != null && !fabricId.equals("")) {
                    tmpResourceId = Integer.parseInt(fabricId);
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 126;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
            }
            if (alertId > 0) {
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 104;
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType1 = "TPC_NEW_DEVICE_EVENT";
                snmpValues.put("eventType", eventType1);
                tecValues.put("eventType", eventType1);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SANRegionEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4054I";
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("SANName");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("label")) == null) {
                    value1 = "";
                }
                msgValues = new Object[]{value1, value0};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for new device: zset" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for new device: zset" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getZoneSetData(deviceId, snmpValues, tecValues)) {
            short alertCondition;
            String eventType = "TPC_DEVICE_STATE_CHANGE_EVENT";
            short resourceType = 126;
            int resourceId = Integer.parseInt(ID);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = this.determineAlertCondition(eventType));
            if (alertId <= 0) {
                short tmpResourceType = -1;
                int tmpResourceId = -1;
                String fabricId = (String)snmpValues.get("fabricId");
                if (fabricId != null && !fabricId.equals("")) {
                    tmpResourceId = Integer.parseInt(fabricId);
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 126;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
            }
            if (alertId > 0) {
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                if (newState == 1) {
                    trapType = 112;
                }
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType1 = newState == 0 ? "TPC_MISSING_DEVICE_EVENT" : "TPC_NORMAL_DEVICE_EVENT";
                snmpValues.put("eventType", eventType1);
                tecValues.put("eventType", eventType1);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SANRegionEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = newState == 0 ? "CRITICAL" : "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4056I";
                if (newState == 0) {
                    msgId = "ALR4055W";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("SANName");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("label")) == null) {
                    value1 = "";
                }
                msgValues = new Object[]{value1, value0};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for changed device: zset" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for changed device: zset" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) {
        Alert alert = null;
        return alert;
    }

    private short determineAlertCondition(String eventType) {
        if (eventType.equals("TPC_NEW_DEVICE_EVENT")) {
            return 105;
        }
        return 119;
    }

    private short determineResourceType() {
        return 126;
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private String getSRValue(int index, Hashtable values) {
        if (srVarNames[index].equals("description")) {
            return srVarNames[index];
        }
        if (peVarNames[index].equals("messageId")) {
            return srVarNames[index];
        }
        return (String)values.get(srVarNames[index]);
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (this.getZoneSetData(deviceId, snmpValues, tecValues, attributeMap)) {
            short alertCondition;
            String eventType = "TPC_DEVICE_STATE_CHANGE_EVENT";
            short resourceType = 126;
            int resourceId = Integer.parseInt(ID);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = this.determineAlertCondition(eventType));
            if (alertId <= 0) {
                short tmpResourceType = -1;
                int tmpResourceId = -1;
                String fabricId = (String)snmpValues.get("fabricId");
                if (fabricId != null && !fabricId.equals("")) {
                    tmpResourceId = Integer.parseInt(fabricId);
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 126;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
            }
            if (alertId > 0) {
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                if (newState == 1) {
                    trapType = 112;
                }
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType1 = newState == 0 ? "TPC_MISSING_DEVICE_EVENT" : "TPC_NORMAL_DEVICE_EVENT";
                snmpValues.put("eventType", eventType1);
                tecValues.put("eventType", eventType1);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SANRegionEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = newState == 0 ? "CRITICAL" : "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4056I";
                if (newState == 0) {
                    msgId = "ALR4055W";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("SANName");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("label")) == null) {
                    value1 = "";
                }
                msgValues = new Object[]{value1, value0};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for changed device: zset" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for changed device: zset" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    private boolean getZoneSetData(String deviceId, Hashtable snmpValues, Hashtable tecValues, HashMap attributeMap) {
        boolean retrieveOK = false;
        HashMap tempMap = null;
        tempMap = (HashMap)attributeMap.get(deviceType + deviceId);
        if (tempMap != null) {
            snmpValues.put("uniqueId", deviceId);
            snmpValues.put("entityName", this.getValue(tempMap, "ZSET_NAME"));
            snmpValues.put("zoneSetName", this.getValue(tempMap, "ZSET_NAME"));
            snmpValues.put("active", this.getValue(tempMap, "ACTIVE"));
            snmpValues.put("label", this.getValue(tempMap, "ZSET_NAME"));
            snmpValues.put("entityType", deviceType);
            snmpValues.put("type", deviceType);
            EventDBAccessor.setSelfAsHLD(snmpValues);
            String fabricWWN = this.getValue(tempMap, "FABRIC_WWN");
            if (fabricWWN != null && EventDBAccessor.getFabricDataFromFabricWWN(snmpValues, fabricWWN)) {
                tecValues.putAll(snmpValues);
                retrieveOK = true;
            }
        }
        return retrieveOK;
    }

    private String getValue(HashMap attributeMap, String valueKey) {
        Object value = null;
        value = attributeMap.get(valueKey);
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

