/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class Zset2ZoneAlertPopulator
implements IPopulator {
    public static final String deviceType = "zset2zone";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = Zset2ZoneAlertPopulator.class.getName();

    public Zset2ZoneAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getZset2ZoneData(deviceId, snmpValues, tecValues)) {
            int alertCondition;
            short resourceType = 126;
            int resourceId = this.getResourceId(deviceId, snmpValues);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = 122);
            if (alertId <= 0) {
                short tmpResourceType = -1;
                int tmpResourceId = -1;
                String fabricId = (String)snmpValues.get("fabricId");
                if (fabricId != null && !fabricId.equals("")) {
                    tmpResourceId = Integer.parseInt(fabricId);
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 126;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
            }
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 106;
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = "TPC_NEW_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    System.out.println("value" + i + " = " + value);
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SANRegionEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4084I";
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("toObjectLabel");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("fromObjectLabel")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("SANName")) == null) {
                    value2 = "";
                }
                msgValues = new Object[]{value0, value1, value2};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for new device: zset2zone" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for new device: zset2zone" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getZset2ZoneData(deviceId, snmpValues, tecValues)) {
            int alertCondition;
            short resourceType = 126;
            int resourceId = this.getResourceId(deviceId, snmpValues);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = 122);
            if (alertId <= 0) {
                short tmpResourceType = -1;
                int tmpResourceId = -1;
                String fabricId = (String)snmpValues.get("fabricId");
                if (fabricId != null && !fabricId.equals("")) {
                    tmpResourceId = Integer.parseInt(fabricId);
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 126;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
            }
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                String state = "Missing";
                if (newState == 1) {
                    state = "Normal";
                    trapType = 114;
                }
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 0 ? "TPC_MISSING_DEVICE_EVENT" : "TPC_NORMAL_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SANRegionEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = "WARNING";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4086I";
                if (newState == 0) {
                    msgId = "ALR4085W";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("toObjectLabel");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("fromObjectLabel")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("SANName")) == null) {
                    value2 = "";
                }
                msgValues = new Object[]{value0, value1, value2};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for changed device: zset2zone" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for changed device: zset2zone" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) {
        Alert alert = null;
        return alert;
    }

    private int getResourceId(String deviceId, Hashtable values) {
        int resourceId = -1;
        String tmpId = "" + (String)values.get("zonesetId");
        resourceId = tmpId.equals("") ? Integer.parseInt(deviceId) : Integer.parseInt(tmpId);
        return resourceId;
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private String getSRValue(int index, Hashtable values) {
        if (srVarNames[index].equals("description")) {
            return srVarNames[index];
        }
        if (peVarNames[index].equals("messageId")) {
            return srVarNames[index];
        }
        return (String)values.get(srVarNames[index]);
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (this.getZset2ZoneData(deviceId, snmpValues, tecValues, attributeMap)) {
            int alertCondition;
            short resourceType = 126;
            int resourceId = this.getResourceId(deviceId, snmpValues);
            int alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition = 122);
            if (alertId <= 0) {
                short tmpResourceType = -1;
                int tmpResourceId = -1;
                String fabricId = (String)snmpValues.get("fabricId");
                if (fabricId != null && !fabricId.equals("")) {
                    tmpResourceId = Integer.parseInt(fabricId);
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, tmpResourceId, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 114;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
                if (alertId <= 0) {
                    tmpResourceType = 126;
                    alertId = EventDBAccessor.getAlertIDByResource(tmpResourceType, -1, alertCondition);
                }
            }
            if (alertId > 0) {
                String value2;
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                String state = "Missing";
                if (newState == 1) {
                    state = "Normal";
                    trapType = 114;
                }
                int[] enterprise = MIBConstants.BTAsanRegionEvent;
                int[][] varBindOIDs = MIBConstants.sanRegionVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType = newState == 0 ? "TPC_MISSING_DEVICE_EVENT" : "TPC_NORMAL_DEVICE_EVENT";
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getSRValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "SANRegionEvent";
                for (int i = 0; i < srTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(srTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(srTecSlotNames[i], value);
                }
                String severity = "WARNING";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4086I";
                if (newState == 0) {
                    msgId = "ALR4085W";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("toObjectLabel");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("fromObjectLabel")) == null) {
                    value1 = "";
                }
                if ((value2 = (String)snmpValues.get("SANName")) == null) {
                    value2 = "";
                }
                msgValues = new Object[]{value0, value1, value2};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for changed device: zset2zone" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for changed device: zset2zone" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    private boolean getZset2ZoneData(String deviceId, Hashtable snmpValues, Hashtable tecValues, HashMap attributeMap) {
        boolean retrieveOK = false;
        HashMap tempMap = null;
        tempMap = (HashMap)attributeMap.get(deviceType + deviceId);
        Hashtable<String, String> fromValues = new Hashtable<String, String>();
        Hashtable<String, String> toValues = new Hashtable<String, String>();
        Hashtable dummyValues = new Hashtable();
        if (tempMap != null) {
            String fabricWWN;
            String zset_id = (String)tempMap.get("ZSET_ID");
            String zone_id = (String)tempMap.get("ZONE_ID");
            if (zset_id != null) {
                HashMap zsetMap = (HashMap)attributeMap.get("zset" + zset_id);
                if (zsetMap != null) {
                    fromValues.put("uniqueId", zset_id);
                    fromValues.put("entityName", this.getValue(zsetMap, "ZSET_NAME"));
                    fromValues.put("zoneSetName", this.getValue(zsetMap, "ZSET_NAME"));
                    fromValues.put("active", this.getValue(zsetMap, "ACTIVE"));
                    fromValues.put("label", this.getValue(zsetMap, "ZSET_NAME"));
                    fromValues.put("entityType", "zset");
                    fromValues.put("type", "zset");
                    EventDBAccessor.setSelfAsHLD(fromValues);
                    fabricWWN = this.getValue(zsetMap, "FABRIC_WWN");
                    retrieveOK = fabricWWN != null && EventDBAccessor.getFabricDataFromFabricWWN(fromValues, fabricWWN);
                } else {
                    retrieveOK = EventDBAccessor.getZoneSetData(zset_id, fromValues, dummyValues);
                }
            }
            if (retrieveOK && zone_id != null) {
                HashMap zoneMap = (HashMap)attributeMap.get("zone" + zone_id);
                if (zoneMap != null) {
                    toValues.put("uniqueId", zset_id);
                    toValues.put("entityName", this.getValue(zoneMap, "ZONE_NAME"));
                    toValues.put("zoneName", this.getValue(zoneMap, "ZONE_NAME"));
                    toValues.put("active", this.getValue(zoneMap, "ACTIVE"));
                    toValues.put("label", this.getValue(zoneMap, "ZONE_NAME"));
                    toValues.put("entityType", "zone");
                    toValues.put("type", this.getValue(zoneMap, "ZONE_TYPE"));
                    EventDBAccessor.setSelfAsHLD(toValues);
                    fabricWWN = this.getValue(zoneMap, "FABRIC_WWN");
                    retrieveOK = fabricWWN != null && EventDBAccessor.getFabricDataFromFabricWWN(toValues, fabricWWN);
                } else {
                    retrieveOK = EventDBAccessor.getZoneData(zone_id, toValues, dummyValues);
                }
            }
            if (retrieveOK) {
                snmpValues.put("uniqueId", deviceId);
                snmpValues.put("entityName", "");
                snmpValues.put("label", "");
                snmpValues.put("entityType", deviceType);
                snmpValues.put("type", "");
                snmpValues.put("state", "");
                snmpValues.put("zonesetId", fromValues.get("uniqueId"));
                snmpValues.put("zoneSetName", fromValues.get("entityName"));
                snmpValues.put("zoneId", toValues.get("uniqueId"));
                snmpValues.put("zoneName", toValues.get("entityName"));
                snmpValues.put("fromObjectUniqueId", fromValues.get("uniqueId"));
                snmpValues.put("fromObjectLabel", fromValues.get("label"));
                snmpValues.put("fromObjectType", fromValues.get("entityType"));
                snmpValues.put("fromObjectName", fromValues.get("zoneSetName"));
                snmpValues.put("fromObjectHLDUniqueId", fromValues.get("HLDUniqueId"));
                snmpValues.put("fromObjectHLDType", fromValues.get("HLDType"));
                snmpValues.put("fromObjectHLDLabel", fromValues.get("HLDLabel"));
                snmpValues.put("fromHighLevelDevice", fromValues.get("highLevelDevice"));
                snmpValues.put("toObjectUniqueId", toValues.get("uniqueId"));
                snmpValues.put("toObjectLabel", toValues.get("label"));
                snmpValues.put("toObjectType", toValues.get("entityType"));
                snmpValues.put("toObjectName", toValues.get("zoneName"));
                snmpValues.put("toObjectHLDUniqueId", toValues.get("HLDUniqueId"));
                snmpValues.put("toObjectHLDType", toValues.get("HLDType"));
                snmpValues.put("toObjectHLDLabel", toValues.get("HLDLabel"));
                snmpValues.put("toHighLevelDevice", toValues.get("highLevelDevice"));
                snmpValues.put("SANName", toValues.get("SANName"));
                snmpValues.put("fabricId", toValues.get("fabricId"));
                snmpValues.put("active", fromValues.get("active"));
                tecValues.putAll(snmpValues);
                retrieveOK = true;
            }
        }
        return retrieveOK;
    }

    private String getValue(HashMap attributeMap, String valueKey) {
        Object value = null;
        value = attributeMap.get(valueKey);
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

