/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.snmp;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.IpAddresses;
import org.eclipse.aperi.infrastructure.database.objects.SnmpTrapOid;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.xmsg.IntlMessageFormat;

public class EventFilter {
    static ILogger msgLogger = EventCorrelatorFactory.msgLogger;
    static ILogger traceLogger = EventCorrelatorFactory.traceLogger;
    private static final String FILENAME = "org.eclipse.aperi.discovery.snmp.scanner.SnmpMibOid";
    static ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.monitor.eventcorrelator.resources.EventFilterResources", Locale.getDefault());
    static HashMap eventFilters = null;
    static HashMap eventFiltersByIp = null;
    static HashMap genericFilters = null;
    static final String className = EventFilter.class.getName();
    OID enterprise = null;
    Integer genericTrap = null;
    Integer specificTrap = null;
    HashMap varbinds = new HashMap();

    private static DBConnection getConnection() {
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            return (DBConnection)ds.getPooledConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeEventFilters() {
        String methodName = "initializeEventFilter";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        eventFilters = new HashMap();
        eventFiltersByIp = new HashMap();
        genericFilters = new HashMap();
        DBConnection connection = EventFilter.getConnection();
        try {
            String query = "select \t\tfilter.SNMP_TRAP_ID, \t\tip.IP_ADDRESS, \t\tfilter.ENTERPRISE_TRAP, \t\tfilter.GENERIC_TRAP, \t\tfilter.SPECIFIC_TRAP, \t\tvalue.OBJECT_ID, \t\tvalue.VALUE from " + connection.getSchema() + ".T_RES_SNMP_TRAP filter " + "\t\tleft outer join " + connection.getSchema() + ".T_RES_SNMP_TRAP_OID value on (filter.SNMP_TRAP_ID=value.SNMP_TRAP_ID) " + "\t\tleft outer join " + connection.getSchema() + ".T_RES_IP_ADDRESSES ip on (ip.OBJECT_TYPE=" + DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP") + " and value.SNMP_TRAP_ID=ip.OBJECT_ID) " + "order by " + "\t\tfilter.SNMP_TRAP_ID ";
            DBResultSet dbr = null;
            try {
                dbr = ComplexQuery.sqlQuery((DBConnection)connection, (String)query, new Hashtable());
                while (dbr.next()) {
                    String ipAddress;
                    String enterprise = dbr.getString("ENTERPRISE_TRAP");
                    String genericTrap = dbr.getString("GENERIC_TRAP");
                    String specificTrap = dbr.getString("SPECIFIC_TRAP");
                    String key = dbr.getString("SNMP_TRAP_ID");
                    EventFilter filter = (EventFilter)eventFilters.get(key);
                    if (filter == null) {
                        filter = new EventFilter(enterprise == null ? null : new OID(enterprise), genericTrap == null ? null : new Integer(genericTrap), specificTrap == null ? null : new Integer(specificTrap));
                        eventFilters.put(key, filter);
                    }
                    String varOID = dbr.getString("OBJECT_ID");
                    String varValue = dbr.getString("VALUE");
                    if (varOID != null && varValue != null) {
                        filter.addVarBind(varOID, varValue);
                    }
                    if ((ipAddress = dbr.getString("IP_ADDRESS")) == null) {
                        genericFilters.put(key, filter);
                        continue;
                    }
                    HashMap<String, EventFilter> filters = (HashMap<String, EventFilter>)eventFiltersByIp.get(ipAddress);
                    if (filters == null) {
                        filters = new HashMap<String, EventFilter>();
                        eventFiltersByIp.put(ipAddress, filters);
                    }
                    filters.put(key, filter);
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                block29: {
                    try {
                        if (dbr != null) {
                            dbr.close();
                        }
                    }
                    catch (Exception e) {
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                        if (!traceLogger.isLogging()) break block29;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        finally {
            block30: {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                    if (!traceLogger.isLogging()) break block30;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public static String list() {
        String methodName = "list";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (eventFilters == null) {
            EventFilter.initializeEventFilters();
        }
        if (eventFiltersByIp.isEmpty() && genericFilters.isEmpty()) {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return rb.getString("OutbandChangeAgent.NoFilters");
        }
        StringBuffer out = new StringBuffer();
        for (String key : eventFilters.keySet()) {
            out.append(IntlMessageFormat.format((String)rb.getString("OutbandChangeAgent.filterTitle"), (Object[])new String[]{key, ((EventFilter)eventFilters.get(key)).toString()}));
            if (genericFilters.containsKey(key)) {
                out.append(rb.getString("OutbandChangeAgent.allAddresses"));
            } else {
                boolean first = true;
                for (String ipAddress : eventFiltersByIp.keySet()) {
                    if (!((HashMap)eventFiltersByIp.get(ipAddress)).containsKey(key)) continue;
                    if (first) {
                        out.append(rb.getString("OutbandChangeAgent.addresses"));
                    } else {
                        out.append("\t\t");
                    }
                    out.append(ipAddress + "\n");
                    first = false;
                }
            }
            out.append("\n");
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String addFilter(String[] args) {
        String methodName = "addFilter";
        boolean addOK = true;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object[])args);
        }
        if (eventFilters == null) {
            EventFilter.initializeEventFilters();
        }
        String ID = null;
        String enterprise = null;
        String generic = null;
        String specific = null;
        HashMap<String, String> variables = new HashMap<String, String>();
        for (int i = 1; i < args.length; ++i) {
            int equalsPos = args[i].indexOf("=");
            if (equalsPos < 1) {
                return rb.getString("OutbandChangeAgent.InvalidParameter");
            }
            if (args[i].startsWith("enterprise")) {
                enterprise = args[i].substring(equalsPos + 1);
                continue;
            }
            if (args[i].startsWith("generic")) {
                generic = args[i].substring(equalsPos + 1);
                continue;
            }
            if (args[i].startsWith("specific")) {
                specific = args[i].substring(equalsPos + 1);
                continue;
            }
            variables.put(args[i].substring(0, equalsPos), args[i].substring(equalsPos + 1));
        }
        DBConnection connection = EventFilter.getConnection();
        try {
            connection.setAutoCommit(false);
            int next_id = AutoIdentifier.getIdentifier((int)10, (int)1);
            ID = Integer.toString(next_id);
            SnmpTrapOid snmpTrapOid = new SnmpTrapOid();
            org.eclipse.aperi.infrastructure.database.objects.SnmpTrap snmpTrapTbl = new org.eclipse.aperi.infrastructure.database.objects.SnmpTrap();
            snmpTrapTbl.setSnmpTrapId(next_id);
            if (enterprise != null) {
                snmpTrapTbl.setEnterpriseTrap(enterprise);
            }
            if (generic != null) {
                snmpTrapTbl.setGenericTrap((short)Integer.parseInt(generic));
            }
            if (specific != null) {
                snmpTrapTbl.setSpecificTrap((short)Integer.parseInt(specific));
            }
            snmpTrapTbl.insert(connection);
            snmpTrapOid.setSnmpTrapId(next_id);
            if (!variables.isEmpty()) {
                for (String OID2 : variables.keySet()) {
                    snmpTrapOid.setObjectId(OID2);
                    snmpTrapOid.setValue((String)variables.get(OID2));
                    snmpTrapOid.insert(connection);
                }
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            addOK = false;
        }
        finally {
            if (connection != null) {
                try {
                    if (addOK) {
                        connection.commit();
                    } else {
                        connection.rollback();
                    }
                    connection.close();
                }
                catch (Exception e) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    addOK = false;
                }
            }
        }
        if (addOK) {
            EventFilter.initializeEventFilters();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        if (addOK) {
            return IntlMessageFormat.format((String)rb.getString("OutbandChangeAgent.filterAddOK"), (Object[])new String[]{ID}) + rb.getString("OutbandChangeAgent.filterAllMsg");
        }
        return rb.getString("OutbandChangeAgent.filterAddErr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String addAddress(String[] args) {
        String ID;
        String methodName = "addAddress";
        boolean addOK = true;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object[])args);
        }
        if (eventFilters == null) {
            EventFilter.initializeEventFilters();
        }
        if (eventFilters.get(ID = args[1]) == null) {
            return IntlMessageFormat.format((String)rb.getString("OutbandChangeAgent.noFilter"), (Object[])new String[]{ID});
        }
        DBConnection connection = EventFilter.getConnection();
        IpAddresses ipAddress = null;
        int count = 0;
        try {
            connection.setAutoCommit(false);
            for (int i = 2; i < args.length; ++i) {
                String ip = args[i];
                ipAddress = new IpAddresses(Integer.parseInt(ID), (short)Integer.valueOf(DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP")).intValue(), ip);
                ipAddress.insert(connection);
                ++count;
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            addOK = false;
        }
        finally {
            try {
                if (connection != null) {
                    if (addOK) {
                        connection.commit();
                    } else {
                        connection.rollback();
                    }
                    connection.close();
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                addOK = false;
            }
        }
        if (addOK) {
            EventFilter.initializeEventFilters();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        if (addOK) {
            return IntlMessageFormat.format((String)rb.getString("OutbandChangeAgent.addAddressOK"), (Object[])new String[]{Integer.toString(count), ID});
        }
        return rb.getString("OutbandChangeAgent.filterAddErr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeFilter(String[] args) {
        String ID;
        String methodName = "removeFilter";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object[])args);
        }
        if (eventFilters == null) {
            EventFilter.initializeEventFilters();
        }
        if (eventFilters.get(ID = args[1]) == null) {
            return IntlMessageFormat.format((String)rb.getString("OutbandChangeAgent.noFilter"), (Object[])new String[]{ID});
        }
        int count = 0;
        boolean removeOK = true;
        DBConnection connection = EventFilter.getConnection();
        org.eclipse.aperi.infrastructure.database.objects.SnmpTrap snmpTrapTbl = new org.eclipse.aperi.infrastructure.database.objects.SnmpTrap();
        Hashtable<ColumnInfo, String> h1 = new Hashtable<ColumnInfo, String>();
        Hashtable<ColumnInfo, String> h2 = new Hashtable<ColumnInfo, String>();
        Hashtable<ColumnInfo, String> h3 = new Hashtable<ColumnInfo, String>();
        h1.put(SnmpTrapOid.getColumnInfo((String)"SNMP_TRAP_ID"), ID);
        h2.put(org.eclipse.aperi.infrastructure.database.objects.SnmpTrap.getColumnInfo((String)"SNMP_TRAP_ID"), ID);
        h3.put(IpAddresses.getColumnInfo((String)"OBJECT_ID"), ID);
        h3.put(IpAddresses.getColumnInfo((String)"OBJECT_TYPE"), DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP").toString());
        try {
            connection.setAutoCommit(false);
            SnmpTrapOid.deletes((DBConnection)connection, h1);
            count += snmpTrapTbl.delete(connection, h2);
            IpAddresses.deletes((DBConnection)connection, h3);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            removeOK = false;
        }
        finally {
            try {
                if (connection != null) {
                    if (removeOK) {
                        connection.commit();
                    } else {
                        connection.rollback();
                    }
                    connection.close();
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                removeOK = false;
            }
        }
        if (removeOK) {
            EventFilter.initializeEventFilters();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, count);
        }
        return !removeOK ? IntlMessageFormat.format((String)rb.getString("OutbandChangeAgent.filterRemoveErr"), (Object[])new String[]{ID}) : IntlMessageFormat.format((String)rb.getString("OutbandChangeAgent.filterRemoveOK"), (Object[])new String[]{ID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeAddress(String[] args) {
        String methodName = "removeAddress";
        boolean removeOK = true;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object[])args);
        }
        String ID = args[1];
        if (eventFilters == null) {
            EventFilter.initializeEventFilters();
        }
        if (eventFilters.get(ID) == null) {
            return IntlMessageFormat.format((String)rb.getString("OutbandChangeAgent.noFilter"), (Object[])new String[]{ID});
        }
        DBConnection connection = EventFilter.getConnection();
        IpAddresses ipAddress = new IpAddresses();
        Hashtable<ColumnInfo, String> h = null;
        int count = 0;
        try {
            connection.setAutoCommit(false);
            for (int i = 2; i < args.length; ++i) {
                String ip = args[i];
                h = new Hashtable<ColumnInfo, String>();
                h.put(IpAddresses.getColumnInfo((String)"OBJECT_ID"), ID);
                h.put(IpAddresses.getColumnInfo((String)"OBJECT_TYPE"), DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP").toString());
                h.put(IpAddresses.getColumnInfo((String)"IP_ADDRESS"), ip);
                count += ipAddress.delete(connection, h);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            removeOK = false;
        }
        finally {
            try {
                if (connection != null) {
                    if (removeOK) {
                        connection.commit();
                    } else {
                        connection.rollback();
                    }
                    connection.close();
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                removeOK = false;
            }
        }
        if (removeOK) {
            EventFilter.initializeEventFilters();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        if (removeOK) {
            String out = IntlMessageFormat.format((String)rb.getString("OutbandChangeAgent.removedAddresses"), (Object[])new String[]{Integer.toString(count), ID});
            if (genericFilters.get(ID) == null) {
                return out;
            }
            return out + rb.getString("OutbandChangeAgent.filterAllMsg");
        }
        return IntlMessageFormat.format((String)"OutbandChangeAgent.filterRemoveErr", (Object[])new String[]{ID});
    }

    public static String filterTrap(SnmpTrap trap) {
        HashMap filters;
        String methodName = "filterTrap";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (eventFilters == null) {
            EventFilter.initializeEventFilters();
        }
        if ((filters = (HashMap)eventFiltersByIp.get(trap.agentAddr.getIpAddress())) != null) {
            for (String key : filters.keySet()) {
                if (!((EventFilter)filters.get(key)).filter(trap)) continue;
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)key);
                }
                return key;
            }
        }
        for (String key : genericFilters.keySet()) {
            if (!((EventFilter)genericFilters.get(key)).filter(trap)) continue;
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)key);
            }
            return key;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, null);
        }
        return null;
    }

    private EventFilter(OID OID2, Integer genericTrap, Integer specificTrap) {
        this.genericTrap = genericTrap;
        this.specificTrap = specificTrap;
        this.enterprise = OID2;
    }

    private void addVarBind(String OID2, String value) {
        this.varbinds.put(OID2, value);
    }

    private boolean filter(SnmpTrap trap) {
        if (this.enterprise != null && !trap.enterprise.startsWith(this.enterprise)) {
            return false;
        }
        if (this.genericTrap != null && this.genericTrap != trap.genericTrap) {
            return false;
        }
        if (this.specificTrap != null && this.specificTrap != trap.specificTrap) {
            return false;
        }
        if (!this.varbinds.isEmpty()) {
            Vector varList = trap.varBindList();
            for (SnmpVarBind varbind : varList) {
                String trapValue;
                String string = trapValue = varbind.get_value() instanceof OctetString ? ((OctetString)varbind.get_value()).toDisplayString() : varbind.get_printable_value();
                String value = (String)this.varbinds.get(varbind.get_printable_oid());
                if (value == null || !value.equals(trapValue)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        if (this.enterprise == null && this.genericTrap == null && this.specificTrap == null && this.varbinds.isEmpty()) {
            return rb.getString("OutbandChangeAgent.allTrapsMsg");
        }
        out.append("Enterprise:\t" + (this.enterprise == null ? rb.getString("OutbandChangeAgent.notSpecified") : this.enterprise.toString()) + "\nGeneric Trap:\t" + (this.genericTrap == null ? rb.getString("OutbandChangeAgent.notSpecified") : this.genericTrap.toString()) + "\nSpecific Trap:\t" + (this.specificTrap == null ? rb.getString("OutbandChangeAgent.notSpecified") : this.specificTrap.toString()) + "\n");
        if (!this.varbinds.isEmpty()) {
            for (String oid : this.varbinds.keySet()) {
                out.append("     " + oid + " = " + this.varbinds.get(oid) + "\n");
            }
        }
        return out.toString();
    }
}

