/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.snmp;

import java.net.SocketException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.outbandchangeagent.OutbandChangeAgentProperty;
import org.eclipse.aperi.monitor.snmp.EventFilter;
import org.eclipse.aperi.monitor.snmp.SnmpV2Monitor;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.TrapFilter;
import org.eclipse.aperi.snmp.TrapListener;
import org.eclipse.aperi.snmp.TrapReceiver;
import org.eclipse.aperi.snmp.V2TrapFilter;
import org.eclipse.aperi.snmp.V2TrapListener;
import org.eclipse.aperi.snmp.data.OctetString;

public class SnmpMonitor
implements TrapFilter,
TrapListener {
    static ILogger msgLogger = EventCorrelatorFactory.msgLogger;
    static ILogger traceLogger = EventCorrelatorFactory.traceLogger;
    static final String className = SnmpMonitor.class.getName();
    public OutbandChangeAgentProperty iSnmpCAP = null;
    public ResourceBundle resourceBundle = null;
    private TrapReceiver t = null;
    private EventCorrelatorFactory eventMonitor = null;
    private SnmpV2Monitor snmpV2Monitor = null;

    public SnmpMonitor(EventCorrelatorFactory eventMonitor) {
        String methodName = "SnmpMonitor";
        this.eventMonitor = eventMonitor;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
    }

    private String convertSpecialSymbol(String value) {
        char char3 = '&';
        String newline = new String();
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == char3) {
                if (value.substring(i, value.length()).length() >= 5) {
                    if (!value.substring(i, i + 5).equals("&amp;")) {
                        newline = newline.concat("&amp;");
                        continue;
                    }
                    newline = newline.concat(String.valueOf(value.charAt(i)));
                    continue;
                }
                newline = newline.concat("&amp;");
                continue;
            }
            newline = newline.concat(String.valueOf(value.charAt(i)));
        }
        return newline;
    }

    public void handle(SnmpTrap trap) {
        String methodName = "handle";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        try {
            this.eventMonitor.postSnmpEvent(trap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public boolean filter(SnmpTrap trap) {
        long start = System.currentTimeMillis();
        String methodName = "filter";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger.isLogging()) {
            StringBuffer variables = new StringBuffer();
            Vector varList = trap.varBindList();
            for (SnmpVarBind varbind : varList) {
                variables.append("\t(" + varbind.get_printable_oid() + "=");
                if (varbind.get_value() instanceof OctetString) {
                    variables.append(((OctetString)varbind.get_value()).toDisplayString() + ")\n");
                    continue;
                }
                variables.append(varbind.get_printable_value() + ")\n");
            }
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Trap Received:\n\taddress=" + trap.agentAddr + " enterprise=" + trap.enterprise + " generictrap=" + trap.genericTrap + " specifictrap=" + trap.specificTrap + "\n" + variables);
        }
        String filter = EventFilter.filterTrap(trap);
        if (traceLogger.isLogging() && filter != null) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Filtered by filter " + filter);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, filter == null);
        }
        long end = System.currentTimeMillis();
        return filter == null;
    }

    public boolean initialize() {
        String methodName = "initialize";
        boolean started = false;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (this.iSnmpCAP == null) {
            this.iSnmpCAP = new OutbandChangeAgentProperty();
        }
        try {
            int trapPort = Integer.parseInt(this.iSnmpCAP.getSnmpTrapPort());
            if (traceLogger.isLogging()) {
                traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "SnmpChangeAgent_TrapPort = " + trapPort);
            }
            this.t = new TrapReceiver(trapPort);
            Thread tr = new Thread((Runnable)this.t);
            tr.setName("SNMP Trap Listener");
            this.snmpV2Monitor = new SnmpV2Monitor(this.eventMonitor);
            this.t.subscribe((TrapListener)this, (TrapFilter)this);
            this.t.subscribeV2((V2TrapListener)this.snmpV2Monitor, (V2TrapFilter)this.snmpV2Monitor);
            tr.start();
        }
        catch (SocketException sException) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)sException);
            sException.printStackTrace();
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)sException);
            }
            return false;
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            started = true;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return started;
    }

    public boolean shutdown() {
        String methodName = "shutdown";
        boolean stopped = false;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (this.t != null) {
            this.t.terminate();
        }
        stopped = true;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return stopped;
    }
}

