/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.Agent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.IAgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.DatabaseConnectException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.SqlException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.UnknownAgentException;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class AgentBuilder
implements IAgentBuilder {
    static final String className = AgentBuilder.class.getName();
    private String _hostName;
    private GUID _guid;
    private String _ipAddress;
    private int _agentPort;
    private int _hostID;

    AgentBuilder(GUID guid, int port, AgentTableReader tableAccess) throws SQLException, UnknownAgentException {
        block6: {
            String methodName = "HostBuilder";
            DeviceAgent.DeviceAgentCursor rs = null;
            String uniqueName = guid + ":" + port;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)this, "HostBuilder", (Object)uniqueName);
            }
            if (!(rs = tableAccess.queryHost(guid, port)).next()) {
                SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)this, "HostBuilder", "Agent_notExistDB", (Object)uniqueName);
                String msg = uniqueName + "  is not a known Host.";
                if (SANDiskMgrHostService.trace.isLogging()) {
                    SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "HostBuilder", msg);
                }
                throw new UnknownAgentException();
            }
            DeviceAgent da = rs.getAttributes();
            rs.close();
            rs = null;
            Host host = tableAccess.getResHost(da.getHostId());
            this._hostName = host.getHostUrl();
            this._hostID = da.getDeviceAgentId();
            this._ipAddress = host.getIpAddress();
            this._agentPort = da.getPort();
            try {
                this._guid = new GUID(host.getGuid(), 0);
            }
            catch (Exception e) {
                SANDiskMgrHostService.messages.exception((Object)className, "HostBuilder", (Throwable)e);
                if (!SANDiskMgrHostService.trace.isLogging()) break block6;
                SANDiskMgrHostService.trace.exception((Object)className, "HostBuilder", (Throwable)e);
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)this, "HostBuilder");
        }
    }

    static Agent getHost(GUID guid, int port) throws TdmException {
        String methodName = "getHost";
        AgentBuilder host = null;
        String uniqueName = guid + ":" + port;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getHost", (Object)uniqueName);
        }
        AgentTableReader tableAccess = null;
        try {
            tableAccess = SANDiskMgrHostService.getHostTableReader();
            host = new AgentBuilder(guid, port, tableAccess);
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getHost", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getHost", (Throwable)e);
            }
            throw new SqlException(e);
        }
        catch (InterruptedException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getHost", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getHost", (Throwable)e);
            }
            throw new DatabaseConnectException(e);
        }
        finally {
            if (tableAccess != null) {
                tableAccess.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getHost");
        }
        return new Agent((IAgentBuilder)host);
    }

    AgentBuilder(DeviceAgent.DeviceAgentCursor rs, AgentTableReader tableAccess) throws SQLException {
        block2: {
            String methodName = "HostBuilder";
            DeviceAgent da = rs.getAttributes();
            Host host = tableAccess.getResHost(da.getHostId());
            this._hostName = host.getHostUrl();
            this._hostID = da.getDeviceAgentId();
            this._ipAddress = host.getIpAddress();
            this._agentPort = da.getPort();
            try {
                this._guid = new GUID(host.getGuid(), 0);
            }
            catch (Exception e) {
                SANDiskMgrHostService.messages.exception((Object)className, "HostBuilder", (Throwable)e);
                if (!SANDiskMgrHostService.trace.isLogging()) break block2;
                SANDiskMgrHostService.trace.exception((Object)className, "HostBuilder", (Throwable)e);
            }
        }
    }

    public int getHostID() {
        return this._hostID;
    }

    public String getHostName() {
        return this._hostName;
    }

    public GUID getGUID() {
        return this._guid;
    }

    public String getIPAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._agentPort;
    }
}

