/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.ITdmAgentBuilder;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.DatabaseConnectException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.SqlException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.UnknownAgentException;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class TdmAgentBuilder
extends AgentBuilder
implements ITdmAgentBuilder {
    static final String className = TdmAgentBuilder.class.getName();
    private String _osname;
    private String _status;
    private int _index;
    private String _version;
    private Date _statusLastChanged;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TdmAgentBuilder(GUID guid, int port, AgentTableReader tableAccess) throws SQLException, UnknownAgentException {
        super(guid, port, tableAccess);
        String methodName = "TdmHostBuilder";
        String name = guid + ":" + port;
        Statement hostQuery = null;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)this, "TdmHostBuilder", (Object)name);
        }
        try {
            DeviceAgent.DeviceAgentCursor thisHostResults = tableAccess.queryHost(guid, port);
            if (!thisHostResults.next()) {
                SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)this, "TdmHostBuilder", "Agent_notExistDB", (Object)name);
                if (SANDiskMgrHostService.trace.isLogging()) {
                    String msg = name + " is not a known Agent";
                    SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "TdmHostBuilder", msg);
                }
                throw new UnknownAgentException();
            }
            try {
                DeviceAgent da = thisHostResults.getAttributes();
                Host host = tableAccess.getResHost(da.getHostId());
                this._index = da.getDeviceAgentId();
                this._osname = AgentTableReader.osName(host.getOsType());
                this._status = da.getStatus().trim();
                this._statusLastChanged = da.getStatusLastChanged();
                this._version = da.getVersion();
            }
            catch (SQLException e) {
                SANDiskMgrHostService.messages.exception((Object)className, "TdmHostBuilder", (Throwable)e);
                if (SANDiskMgrHostService.trace.isLogging()) {
                    SANDiskMgrHostService.trace.exception((Object)className, "TdmHostBuilder", (Throwable)e);
                }
                throw e;
            }
            finally {
                thisHostResults.close();
                thisHostResults = null;
            }
            if (SANDiskMgrHostService.trace.isLogging()) {
                String msg = "results = " + this._osname + " " + this._status + " " + this._index + " " + name + " " + this._version;
                SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "TdmHostBuilder", msg);
            }
        }
        finally {
            if (hostQuery != null) {
                hostQuery.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)this, "TdmHostBuilder");
        }
    }

    public TdmAgentBuilder(DeviceAgent.DeviceAgentCursor HostResults, AgentTableReader tableAccess) throws SQLException, UnknownAgentException, TdmException {
        super(HostResults, tableAccess);
        String methodName = "TdmHostBuilder(java.sql.ResultSet)";
        try {
            DeviceAgent da = HostResults.getAttributes();
            Host host = tableAccess.getResHost(da.getHostId());
            this._index = da.getDeviceAgentId();
            this._osname = AgentTableReader.osName(host.getOsType());
            this._status = da.getStatus().trim();
            this._statusLastChanged = da.getStatusLastChanged();
            this._version = da.getVersion();
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "TdmHostBuilder(java.sql.ResultSet)", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "TdmHostBuilder(java.sql.ResultSet)", (Throwable)e);
            }
            throw e;
        }
    }

    public static TdmAgent getTdmHost(GUID guid, int port) throws TdmException {
        String methodName = "getTdmHost";
        String name = guid + ":" + port;
        TdmAgentBuilder thost = null;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getTdmHost", (Object)name);
        }
        AgentTableReader tableAccess = null;
        try {
            tableAccess = SANDiskMgrHostService.getHostTableReader();
            thost = new TdmAgentBuilder(guid, port, tableAccess);
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getTdmHost", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getTdmHost", (Throwable)e);
            }
            throw new SqlException(e);
        }
        catch (InterruptedException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getTdmHost", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getTdmHost", (Throwable)e);
            }
            throw new DatabaseConnectException(e);
        }
        finally {
            if (tableAccess != null) {
                tableAccess.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getTdmHost");
        }
        return new TdmAgent((ITdmAgentBuilder)thost);
    }

    public static TdmAgent getTdmHost(DeviceAgent.DeviceAgentCursor r, AgentTableReader tableAccess) throws TdmException {
        String methodName = "getTdmHost(java.sql.ResultSet)";
        TdmAgentBuilder thost = null;
        try {
            thost = new TdmAgentBuilder(r, tableAccess);
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getTdmHost(java.sql.ResultSet)", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getTdmHost(java.sql.ResultSet)", (Throwable)e);
            }
            throw new SqlException(e);
        }
        return new TdmAgent((ITdmAgentBuilder)thost);
    }

    public String getOSName() {
        return this._osname;
    }

    public String getStatus() {
        return this._status;
    }

    public Date getStatusLastChanged() {
        return this._statusLastChanged;
    }

    public int getIndex() {
        return this._index;
    }

    public String getVersion() {
        return this._version;
    }
}

