/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control.fabric;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneConstants;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.ZoneControlAgent;
import org.eclipse.aperi.util.SRMCrypto;

public class OutbandZoneControl
extends ZoneControlAgent {
    public static String executableLocation;
    static final String className;
    protected Vector openTxns = null;
    protected Object openTxnsVectorLock = null;
    public static int timeOut;
    private static final int DEFAULT_TIMEOUT = 300000;
    private static OutbandZoneControl ozc;

    public static OutbandZoneControl getInstance() {
        if (ozc == null) {
            ozc = new OutbandZoneControl();
        }
        return ozc;
    }

    private OutbandZoneControl() {
        String methodName = "OutbandZoneControl";
        this.openTxns = new Vector();
        this.openTxnsVectorLock = new Object();
        msgLogger = ZoneConstants.zcAgentMsgLogger;
        traceLogger = ZoneConstants.zcAgentTraceLogger;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
    }

    public ZoneCapabilities getCapabilities(String SAN) {
        String methodName = "getCapabilities";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            int handle = (Integer)this.SANtoHandle.get(SAN);
            ZoneCapabilities capabilities = new ZoneCapabilities();
            capabilities.setSupportsAliases(true);
            capabilities.setAllowsNumericNameStart(true);
            capabilities.setSupportsNodeWWN(true);
            capabilities.setSupportsDomainPort(true);
            capabilities.setSupportsEmptyZoneAliases(false);
            capabilities.setSupportsEmptyZones(false);
            capabilities.setSupportsEmptyZoneSets(false);
            capabilities.setSupportsFCID(false);
            capabilities.setSupportsFullZoneDB(true);
            capabilities.setSupportsOrphanZoneAliases(true);
            capabilities.setSupportsOrphanZones(true);
            capabilities.setSupportsSpecialCharacters(false);
            capabilities.setZcAgentType(0);
            capabilities.setMaxZoneAliases(-1);
            capabilities.setMaxZoneMembers(-1);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Capabilities of SAN " + SAN + " are " + capabilities.toString());
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return capabilities;
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            return null;
        }
    }

    public int ping(String san, String[] parameters) {
        String methodName = "ping";
        int err = 1111;
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            int handle = (Integer)this.SANtoHandle.get(san);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Pinged SAN " + san + ". Return code " + err + ".");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            err = 221111;
        }
        return err;
    }

    public int lock(String resource, String[] parameters) {
        int handle;
        block5: {
            String methodName = "lock";
            handle = -1;
            try {
                String encryptedPassword;
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
                }
                String address = parameters[0];
                String userId = parameters[1];
                String password = encryptedPassword = parameters[2];
                password = SRMCrypto.decrypt((String)encryptedPassword);
                handle = 1;
                if (handle > 0 && this.SANtoHandle.get(resource) == null) {
                    this.SANtoHandle.put(resource, Integer.valueOf(Integer.toString(handle)));
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Locked resource: " + address + ".");
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!traceLogger.isLogging()) break block5;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        return handle > 0 ? 0 : 1111;
    }

    public int startTransaction(String SAN) {
        int status = 1111;
        String methodName = "startTransaction";
        try {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            this.activateOnCommit = false;
            this.SANtoCommands.put(SAN, new ArrayList());
            status = this.activateTransactionNative((Integer)this.SANtoHandle.get(SAN));
            if (status != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Unable to activate transaction with switch " + SAN + ".  Err = " + status);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_ErrStartTransaction", (Object)SAN);
                return status;
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Started transaction with SAN: " + SAN);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            return 11111;
        }
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int rollbackTransaction(String SAN) {
        int status = 0;
        String methodName = "rollbackTransaction";
        try {
            ArrayList cmdQueue;
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            if ((cmdQueue = (ArrayList)this.SANtoCommands.remove(SAN)) != null) {
                cmdQueue.clear();
                this.SANtoCommands.put(SAN, cmdQueue);
            }
            Integer handleInt = (Integer)this.SANtoHandle.get(SAN);
            ZoneDefinition zDef = (ZoneDefinition)this.SANtoZoneDef.get(SAN);
            if (handleInt != null && zDef == null) {
                // empty if block
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            status = 21111;
        }
        if (status != 0 && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Failed to rollback transaction on SAN " + SAN + ".  Err = " + status);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        String methodName = "shutdown";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Set shutdownInvoked to true");
        }
        Object object = this.openTxnsVectorLock;
        synchronized (object) {
            for (Integer openHandle : this.openTxns) {
                if (openHandle == null) continue;
            }
            this.openTxnsVectorLock.notifyAll();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    protected int sendCommandsToSwitch(String SAN, ZoneDefinition newZDef, ZoneDefinition oldZDef, int zone_db_code) {
        String methodName = "sendCommandsToSwitch";
        int status = 0;
        int handle = (Integer)this.SANtoHandle.get(SAN);
        ZoneSet currentActZSet = oldZDef.getActiveZoneSet();
        ZoneSet desiredActZSet = newZDef.getActiveZoneSet();
        boolean apply_active = zone_db_code == 1 || zone_db_code == 2;
        status = this.setZoneDB(SAN, newZDef, zone_db_code);
        if (status != 0) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Error occurred while sending zoning commands to SAN " + SAN + ".");
            }
            return status;
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Commited transaction with SAN: " + SAN);
        }
        if (apply_active) {
            if (desiredActZSet == null) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)this, methodName, "Enabling a zoning configuration with no activate ZoneSet  on SAN " + SAN);
                }
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Activated ZoneSet: " + desiredActZSet.getName() + ", SAN: " + SAN);
            }
        }
        return status;
    }

    private int setZoneDB(String SAN, ZoneDefinition definition, int zone_db_code) {
        String methodName = "setZoneDB";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int status = 0;
        int handle = (Integer)this.SANtoHandle.get(SAN);
        ZoneDefinition currentDefinition = (ZoneDefinition)this.SANtoZoneDef.get(SAN);
        HashMap likeZoneSetsMap = new HashMap();
        HashMap likeZoneAliasesMap = new HashMap();
        HashMap likeZonesMap = new HashMap();
        this.findSameZoneEntities(currentDefinition, definition, likeZoneSetsMap, likeZoneAliasesMap, likeZonesMap);
        if (zone_db_code == 1 || zone_db_code == 2) {
            status = this.deactivateAndReset(currentDefinition, definition, handle, SAN);
        }
        if (status == 0) {
            status = this.deleteUnlikeZoneAliases(currentDefinition, likeZoneAliasesMap, handle, SAN);
        }
        if (status == 0) {
            status = this.createUnlikeZoneAliases(definition, likeZoneAliasesMap, handle, SAN);
        }
        if (status == 0) {
            status = this.deleteUnlikeZones(currentDefinition, likeZonesMap, handle, SAN);
        }
        if (status == 0) {
            status = this.createUnlikeZones(definition, likeZonesMap, handle, SAN);
        }
        if (status == 0) {
            status = this.deleteUnlikeZoneSets(currentDefinition, definition, likeZoneSetsMap, handle, SAN);
        }
        if (status == 0) {
            status = this.createUnlikeZoneSets(definition, currentDefinition, likeZoneSetsMap, handle, SAN);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int deactivateAndReset(ZoneDefinition current, ZoneDefinition desired, int handle, String SAN) {
        String methodName = "deactivateAndReset";
        int status = 0;
        String activeZoneSetName = null;
        ZoneSet activeZoneSet = current.getActiveZoneSet();
        if (activeZoneSet != null) {
            activeZoneSetName = activeZoneSet.getName();
            ZoneSet newActiveZoneSet = desired.getActiveZoneSet();
            if (newActiveZoneSet == null && (status = this.activateTransactionNative(handle)) != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Unable to activate transaction with switch " + SAN + ".  Err = " + status);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_ErrStartTransaction", (Object)SAN);
                return status;
            }
        }
        return 0;
    }

    private int deleteUnlikeZoneAliases(ZoneDefinition current, HashMap likeMap, int handle, String SAN) {
        String methodName = "deleteUnlikeZoneAliases";
        boolean status = false;
        ZoneAlias[] aliases = current.getAliases();
        for (int count = 0; count < aliases.length; ++count) {
            if (likeMap.get(aliases[count].getName()) != null) continue;
        }
        return 0;
    }

    private int createUnlikeZoneAliases(ZoneDefinition desired, HashMap likeMap, int handle, String SAN) {
        String methodName = "createUnlikeZoneAliases";
        int status = 0;
        ZoneAlias[] aliases = desired.getAliases();
        for (int count = 0; count < aliases.length; ++count) {
            if (likeMap.get(aliases[count].getName()) != null) continue;
            ZoneMember[] members = desired.getMembers(aliases[count]);
            String[] memberNames = new String[members.length];
            short[] membersType = new short[members.length];
            for (int zoneMemberCount = 0; zoneMemberCount < members.length; ++zoneMemberCount) {
                memberNames[zoneMemberCount] = members[zoneMemberCount].getName();
                membersType[zoneMemberCount] = members[zoneMemberCount].getType();
            }
        }
        return status;
    }

    private int deleteUnlikeZones(ZoneDefinition current, HashMap likeMap, int handle, String SAN) {
        String methodName = "deleteUnlikeZones";
        int status = 0;
        Zone[] zones = current.getZones();
        for (int count = 0; count < zones.length; ++count) {
            String hashKey = zones[count].getName();
            if (likeMap.get(hashKey) != null || zones[count].getVendorType() != 1 || !traceLogger.isLogging()) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Going to delete Zone " + zones[count].getName() + " that has vendorType " + Short.toString(zones[count].getVendorType()));
        }
        return status;
    }

    private int createUnlikeZones(ZoneDefinition desired, HashMap likeMap, int handle, String SAN) {
        String methodName = "createUnlikeZones";
        int status = 0;
        Zone[] zones = desired.getZones();
        for (int zoneCount = 0; zoneCount < zones.length; ++zoneCount) {
            String hashKey = zones[zoneCount].getName();
            if (likeMap.get(hashKey) != null || zones[zoneCount].getVendorType() != 1) continue;
            ZoneMember[] members = desired.getMembers(zones[zoneCount]);
            ZoneAlias[] aliases = desired.getAliases(zones[zoneCount]);
            String[] memberNames = new String[members.length + aliases.length];
            short[] memberTypes = new short[members.length + aliases.length];
            for (int memberCount = 0; memberCount < members.length; ++memberCount) {
                memberNames[memberCount] = members[memberCount].getName();
                memberTypes[memberCount] = members[memberCount].getType();
            }
            for (int aliasCount = 0; aliasCount < aliases.length; ++aliasCount) {
                memberNames[members.length + aliasCount] = aliases[aliasCount].getName();
                memberTypes[members.length + aliasCount] = 15;
            }
        }
        return status;
    }

    private int deleteUnlikeZoneSets(ZoneDefinition current, ZoneDefinition desired, HashMap likeMap, int handle, String SAN) {
        String methodName = "deleteUnlikeZoneSets";
        int status = 0;
        ZoneSet[] old = current.getZoneSets();
        for (int count = 0; count < old.length; ++count) {
            String zsetName = old[count].getName();
            if (likeMap.get(zsetName) == null && this.areChangesInZonesOnly(current, desired, zsetName)) continue;
        }
        return status;
    }

    private int createUnlikeZoneSets(ZoneDefinition desired, ZoneDefinition current, HashMap likeMap, int handle, String SAN) {
        String methodName = "createUnlikeZoneSets";
        int status = 0;
        ZoneSet[] zoneSets = desired.getZoneSets();
        for (int zscount = 0; zscount < zoneSets.length; ++zscount) {
            String zsName = zoneSets[zscount].getName();
            if (likeMap.get(zsName) != null || this.areChangesInZonesOnly(current, desired, zsName)) continue;
            Zone[] zonesInSet = desired.getZones(zoneSets[zscount]);
            Vector<String> zoneNamesV = new Vector<String>();
            for (int zcount = 0; zcount < zonesInSet.length; ++zcount) {
                zoneNamesV.add(zonesInSet[zcount].getName());
            }
            ZoneSet oldZSet = current.getZoneSet(zoneSets[zscount].getName());
            if (oldZSet == null) continue;
            Zone[] candidateNonStdZones = current.getZones(oldZSet);
            for (int cnszindex = 0; cnszindex < candidateNonStdZones.length; ++cnszindex) {
                if (candidateNonStdZones[cnszindex].getVendorType() == 1 || zoneNamesV.contains(candidateNonStdZones[cnszindex].getName())) continue;
                zoneNamesV.add(candidateNonStdZones[cnszindex].getName());
            }
        }
        return status;
    }

    private boolean areChangesInZonesOnly(ZoneDefinition def1, ZoneDefinition def2, String zoneSetName) {
        Zone[] zones2;
        ZoneSet zset1 = def1.getZoneSet(zoneSetName);
        ZoneSet zset2 = def2.getZoneSet(zoneSetName);
        if (zset1 == null || zset2 == null) {
            return false;
        }
        if (zset1.getName() == null || zset2.getName() == null) {
            return false;
        }
        if (!zset1.getName().equalsIgnoreCase(zset2.getName()) || !zset1.getVersion().equalsIgnoreCase(zset2.getVersion())) {
            return false;
        }
        Enumeration params = zset1.getParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            String pval1 = (String)zset1.getParameterValue(param);
            String pval2 = (String)zset2.getParameterValue(param);
            if (pval1 == null || pval2 == null || pval1.equalsIgnoreCase(pval2)) continue;
            return false;
        }
        Zone[] zones1 = def1.getZones(zset1);
        if (zones1.length != (zones2 = def2.getZones(zset2)).length) {
            return false;
        }
        for (int i = 0; i < zones1.length; ++i) {
            boolean has_same_zone = false;
            int j = 0;
            while (j < zones2.length && !has_same_zone) {
                if (!zones1[i].equals((Object)zones2[j++])) continue;
                has_same_zone = true;
            }
            if (has_same_zone) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int activateTransactionNative(int handle) {
        String methodName = "activateTransactionNative";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Object object = this.openTxnsVectorLock;
        synchronized (object) {
            this.openTxns.add(new Integer(handle));
            this.openTxnsVectorLock.notifyAll();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return 0;
    }

    protected int closeSessionNative(int handle) {
        String methodName = "closeSessionNative";
        int status = 0;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    protected String getCurrentZoningInfoNative(int fabHandle) {
        String methodName = "getCurrentZoningInfoNative";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        String currentZoningInfo = null;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return currentZoningInfo;
    }

    public void finalize() {
        block4: {
            String methodName = "finalize";
            try {
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
    }

    static {
        className = OutbandZoneControl.class.getName();
        timeOut = 0;
        ozc = null;
    }
}

