/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPScanner;
import org.eclipse.aperi.discovery.snmp.scanner.data.Entity;
import org.eclipse.aperi.discovery.snmp.scanner.data.Parameter;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.MissingUniqueIdException;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.Response;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;
import org.eclipse.aperi.snmp.SnmpSocketException;

public class SensorEventScanner
extends SNMPScanner {
    public static ILogger msgLogger = SNMPScanner.msgLogger;
    public static ILogger traceLogger = SNMPScanner.traceLogger;
    static final String className = SensorEventScanner.class.getName();
    private String SCANNERNAME = "SensorEvent";
    private String SCANNERTYPE = "outband";
    private int WWNSIZE = 32;
    private String OUTBAND_SENSOREVENT_SCANNER = "OutbandSensorEventScanner:";
    private String version = "5.0.0";
    public static final String Unknown_text = "Unknown";
    public static final String Unused_text = "Unused";
    public static final String OK_text = "OK";
    public static final String Warning_text = "Warning";
    public static final String Failed_text = "Failed";
    public static final String Online_text = "Online";
    public static final String Offline_text = "Offline";
    public static final String Other_text = "Other";
    public static final String Battery_text = "Battery";
    public static final String Fan_text = "Fan";
    public static final String PowerSupply_text = "Power-Supply";
    public static final String Transmitter_text = "Transmitter";
    public static final String Enclosure_text = "Enclosure";
    public static final String Board_text = "Board";
    public static final String Receiver_text = "Receiver";
    public static final String Temperature_text = "Temperature";
    public static final String Pressure_text = "Pressure";
    public static final String Emf_text = "Emf";
    public static final String CurrentValue_text = "Currentvalue";
    public static final String Airflow_text = "Airflow";
    public static final String Frequency_text = "Frequency";
    public static final String Door_text = "Door";
    public static final String Status_text = "Status";
    public static final String Configuration_text = "Configuration";
    public static final String Topology_text = "Topology";
    public static final String Chassis_text = "Chassis";
    public static final String Backplane_text = "Backplane";
    public static final String Container_text = "Container";
    public static final String Sensor_text = "Sensor";
    public static final String Module_text = "Module";
    public static final String Port_text = "Port";
    public static final String Power_text = "Power";
    String result = new String();
    Header header = null;
    Vector connUnitList = new Vector();
    Vector sensorList = new Vector();
    Vector eventList = new Vector();
    Vector sensorEntityList = new Vector();
    Vector sensorPwrList = new Vector();
    Vector sensorFanList = new Vector();

    private void setConnUnitValues(Vector plist) {
        for (int i = 0; i < plist.size(); ++i) {
            Entity pentity = (Entity)plist.elementAt(i);
            for (int k = 0; k < pentity.getParameterList().size(); ++k) {
                Parameter param = (Parameter)pentity.getParameterList().elementAt(k);
                if (param.getName().equals(Status_text)) {
                    String value = param.getActualValue();
                    if (value.equals("1")) {
                        param.setValue(Unknown_text);
                    } else if (value.equals("2")) {
                        param.setValue(Unused_text);
                    } else if (value.equals("3")) {
                        param.setValue(OK_text);
                    } else if (value.equals("4")) {
                        param.setValue(Warning_text);
                    } else if (value.equals("5")) {
                        param.setValue(Failed_text);
                    }
                }
                if (!param.getName().equals("State")) continue;
                if (param.getActualValue().equals("1")) {
                    param.setValue(Unknown_text);
                    continue;
                }
                if (param.getActualValue().equals("2")) {
                    param.setValue(Online_text);
                    continue;
                }
                if (!param.getActualValue().equals("3")) continue;
                param.setValue(Offline_text);
            }
        }
    }

    private void setSensorValues(Vector plist) {
        for (int i = 0; i < plist.size(); ++i) {
            Entity pentity = (Entity)plist.elementAt(i);
            for (int k = 0; k < pentity.getParameterList().size(); ++k) {
                String value;
                Parameter param = (Parameter)pentity.getParameterList().elementAt(k);
                if (param.getName().equals(Status_text)) {
                    value = param.getActualValue();
                    if (value.equals("1")) {
                        param.setValue(Unknown_text);
                    } else if (value.equals("2")) {
                        param.setValue(Other_text);
                    } else if (value.equals("3")) {
                        param.setValue(OK_text);
                    } else if (value.equals("4")) {
                        param.setValue(Warning_text);
                    } else if (value.equals("5")) {
                        param.setValue(Failed_text);
                    }
                }
                if (param.getName().equals("Type")) {
                    value = param.getActualValue();
                    if (value.equals("1")) {
                        param.setValue(Unknown_text);
                    } else if (value.equals("2")) {
                        param.setValue(Other_text);
                    } else if (value.equals("3")) {
                        param.setValue(Battery_text);
                    } else if (value.equals("4")) {
                        param.setValue(Fan_text);
                    } else if (value.equals("5")) {
                        param.setValue(PowerSupply_text);
                    } else if (value.equals("6")) {
                        param.setValue(Transmitter_text);
                    } else if (value.equals("7")) {
                        param.setValue(Enclosure_text);
                    } else if (value.equals("8")) {
                        param.setValue(Board_text);
                    } else if (value.equals("9")) {
                        param.setValue(Receiver_text);
                    }
                }
                if (param.getName().equals("Characteristic")) {
                    value = param.getActualValue();
                    if (value.equals("1")) {
                        param.setValue(Unknown_text);
                    } else if (value.equals("2")) {
                        param.setValue(Other_text);
                    } else if (value.equals("3")) {
                        param.setValue(Temperature_text);
                    } else if (value.equals("4")) {
                        param.setValue(Pressure_text);
                    } else if (value.equals("5")) {
                        param.setValue(Emf_text);
                    } else if (value.equals("6")) {
                        param.setValue(CurrentValue_text);
                    } else if (value.equals("7")) {
                        param.setValue(Airflow_text);
                    } else if (value.equals("8")) {
                        param.setValue(Frequency_text);
                    } else if (value.equals("9")) {
                        param.setValue(Power_text);
                    } else if (value.equals("10")) {
                        param.setValue(Door_text);
                    }
                }
                if (!param.getName().equals("Message")) continue;
                String message = SensorEventScanner.convertHexStringToAscii(param.getActualValue());
                param.setValue(message);
            }
        }
    }

    private void setEventValues(Vector plist) {
        for (int i = 0; i < plist.size(); ++i) {
            Entity pentity = (Entity)plist.elementAt(i);
            for (int k = 0; k < pentity.getParameterList().size(); ++k) {
                Parameter param = (Parameter)pentity.getParameterList().elementAt(k);
                if (param.getName().equals("Type")) {
                    String value = param.getActualValue();
                    if (value.equals("1")) {
                        param.setValue(Unknown_text);
                    } else if (value.equals("2")) {
                        param.setValue(Other_text);
                    } else if (value.equals("3")) {
                        param.setValue(Status_text);
                    } else if (value.equals("4")) {
                        param.setValue(Configuration_text);
                    } else if (value.equals("5")) {
                        param.setValue(Topology_text);
                    }
                }
                if (!param.getName().equals("Description")) continue;
                String message = SensorEventScanner.convertHexStringToAscii(param.getActualValue());
                param.setValue(message);
            }
        }
    }

    private void setCiscoSensorValues(Vector plist) {
        for (int i = 0; i < plist.size(); ++i) {
            Entity pentity = (Entity)plist.elementAt(i);
            for (int k = 0; k < pentity.getParameterList().size(); ++k) {
                String value;
                Parameter param = (Parameter)pentity.getParameterList().elementAt(k);
                if (param.getName().equals(Status_text)) {
                    value = param.getActualValue();
                    if (value.equals("1")) {
                        param.setValue(Unknown_text);
                    } else if (value.equals("2")) {
                        param.setValue(Online_text);
                    } else if (value.equals("3")) {
                        param.setValue(Offline_text);
                    }
                }
                if (param.getName().equals("Type")) {
                    value = param.getActualValue();
                    if (value.equals("1")) {
                        param.setValue(Other_text);
                    } else if (value.equals("2")) {
                        param.setValue(Unknown_text);
                    } else if (value.equals("3")) {
                        param.setValue(Chassis_text);
                    } else if (value.equals("4")) {
                        param.setValue(Backplane_text);
                    } else if (value.equals("5")) {
                        param.setValue(Container_text);
                    } else if (value.equals("6")) {
                        param.setValue(PowerSupply_text);
                    } else if (value.equals("7")) {
                        param.setValue(Fan_text);
                    } else if (value.equals("8")) {
                        param.setValue(Sensor_text);
                    } else if (value.equals("9")) {
                        param.setValue(Module_text);
                    } else if (value.equals("10")) {
                        param.setValue(Port_text);
                    }
                }
                if (!param.getName().equals("Message")) continue;
                String message = SensorEventScanner.convertHexStringToAscii(param.getActualValue());
                param.setValue(message);
            }
        }
    }

    private void fixConnUnitAndIndexValues(Vector connUnitList, Vector plist) {
        String index = null;
        block0: for (int i = 0; i < plist.size(); ++i) {
            Entity pentity = (Entity)plist.elementAt(i);
            for (int k = 0; k < pentity.getParameterList().size(); ++k) {
                Parameter param = (Parameter)pentity.getParameterList().elementAt(k);
                if (!param.getName().equals("Index")) continue;
                index = param.getActualValue();
                if (!index.equals("")) continue block0;
                index = Integer.toString(i + 1);
                param.setValue(index);
                continue block0;
            }
        }
        int numberConnUnitIds = connUnitList.size();
        int connUnitNumber = 0;
        int lastIndex = 0;
        int thisIndex = 0;
        for (int i = 0; i < plist.size(); ++i) {
            boolean setConnUnitId = false;
            Entity pentity = (Entity)plist.elementAt(i);
            for (int k = 0; k < pentity.getParameterList().size(); ++k) {
                String WWN;
                Parameter param = (Parameter)pentity.getParameterList().elementAt(k);
                if (param.getName().equals("Index")) {
                    index = param.getActualValue();
                    thisIndex = Integer.valueOf(index);
                }
                if (!param.getName().equals("ConnUnitWWN") || !(WWN = param.getActualValue()).equals("")) continue;
                setConnUnitId = true;
            }
            if (setConnUnitId) {
                if (thisIndex < lastIndex && ++connUnitNumber > numberConnUnitIds - 1) {
                    connUnitNumber = numberConnUnitIds - 1;
                }
                Entity entity = (Entity)connUnitList.elementAt(connUnitNumber);
                String connUnitWWN = entity.getUniqueId();
                for (int k = 0; k < pentity.getParameterList().size(); ++k) {
                    Parameter param = (Parameter)pentity.getParameterList().elementAt(k);
                    if (!param.getName().equals("ConnUnitWWN")) continue;
                    String WWN = param.getActualValue();
                    if (!WWN.equals("")) break;
                    param.setValue(connUnitWWN);
                    break;
                }
            }
            lastIndex = thisIndex;
        }
    }

    private void setSensorEventUniqueIds(Vector plist) {
        String index = null;
        String connUnitWWN = null;
        for (int i = 0; i < plist.size(); ++i) {
            Entity pentity = (Entity)plist.elementAt(i);
            for (int k = 0; k < pentity.getParameterList().size(); ++k) {
                Parameter param = (Parameter)pentity.getParameterList().elementAt(k);
                if (param.getName().equals("Index")) {
                    index = param.getActualValue();
                }
                if (!param.getName().equals("ConnUnitWWN")) continue;
                connUnitWWN = param.getActualValue();
            }
            pentity.setUniqueId(connUnitWWN + ":" + index);
        }
    }

    private String getSubstring(String wwn) {
        String methodName = "getSubString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter= " + wwn));
        }
        if (wwn.length() >= this.WWNSIZE && this.isZeroSubstring(wwn)) {
            String newid = wwn.substring(0, 16);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return newid;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return wwn;
    }

    private boolean isZeroSubstring(String wwn) {
        String sub = wwn.substring(16, wwn.length());
        boolean flag = true;
        for (int i = 0; i < sub.length(); ++i) {
            if (sub.charAt(i) != '0') {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag;
    }

    private void resetUniqueId(Vector alist) {
        String methodName = "resetUniqueId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < alist.size(); ++i) {
            Entity entity = (Entity)alist.elementAt(i);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Entity's Unique ID Value = " + entity.getUniqueId());
            }
            String newID = this.getSubstring(entity.getUniqueId());
            entity.setUniqueId(newID);
            Vector plist = entity.getParameterList();
            for (int j = 0; j < plist.size(); ++j) {
                Parameter param = (Parameter)plist.elementAt(j);
                String value = param.getActualValue();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Parameter Value = " + value);
                }
                String newvalue = this.getSubstring(value);
                param.setValue(newvalue);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void hardcodeValue(Vector sanList, String name, String value) {
        for (int i = 0; i < sanList.size(); ++i) {
            ((Entity)sanList.elementAt(i)).addParameter(name, value);
        }
    }

    public String getScannerHeader(String scannerName, String targetIp) {
        String result = null;
        String ipaddress = null;
        if (this.header == null) {
            try {
                InetAddress ia = InetAddress.getByName(targetIp);
                ipaddress = ia.getHostAddress();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.header = new Header(targetIp, scannerName, this.SCANNERTYPE, this.OUTBAND_SENSOREVENT_SCANNER + ipaddress, "5.0.0");
        }
        result = this.header.toString();
        return result;
    }

    public org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response invoke(String scannerName, String[] target) throws SnmpSocketException, UnknownHostException, Exception, MissingUniqueIdException {
        boolean isCiscoSwitch = false;
        String methodName = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.switchIpAddress = target[0];
        String[] connUnitParam = new String[]{this.CONNUNITGLOBALID, this.CONNUNITSTATE, this.CONNUNITSTATUS};
        String[] connUnitParam_old = new String[]{this.CONNUNITGLOBALID_OLD, this.CONNUNITSTATE_OLD, this.CONNUNITSTATUS_OLD};
        String[] sensorParam = new String[]{this.CONNUNITSENSORNAME, this.CONNUNITSENSORSTATUS, this.CONNUNITSENSORINFO, this.CONNUNITSENSORMESSAGE, this.CONNUNITSENSORTYPE, this.CONNUNITSENSORCHARACTERISTIC};
        String[] sensorParam_old = new String[]{this.CONNUNITSENSORUNITID_OLD, this.CONNUNITSENSORINDEX_OLD, this.CONNUNITSENSORNAME_OLD, this.CONNUNITSENSORSTATUS_OLD, this.CONNUNITSENSORINFO_OLD, this.CONNUNITSENSORMESSAGE_OLD, this.CONNUNITSENSORTYPE_OLD, this.CONNUNITSENSORCHARACTERISTIC_OLD};
        String[] eventParam = new String[]{this.CONNUNITEVENTINDEX, this.CONNUNITREVENTTIME, this.CONNUNITSEVENTTIME, this.CONNUNITEVENTSEVERITY, this.CONNUNITEVENTTYPE, this.CONNUNITEVENTOBJECT, this.CONNUNITEVENTDESCR};
        String[] eventParam_old = new String[]{this.CONNUNITEVENTUNITID_OLD, this.CONNUNITEVENTINDEX_OLD, this.CONNUNITREVENTTIME_OLD, this.CONNUNITSEVENTTIME_OLD, this.CONNUNITEVENTSEVERITY_OLD, this.CONNUNITEVENTTYPE_OLD, this.CONNUNITEVENTOBJECT_OLD, this.CONNUNITEVENTDESCR_OLD};
        String[] ciscoConnUnitParam = new String[]{this.CISCOFCFEELEMENTNAME};
        String[] ciscoEntityParam = new String[]{this.ENTPHYSICALNAME, this.ENTPHYSICALCLASS, this.ENTPHYSICALDESCR};
        String[] ciscoPwrParam = new String[]{this.CEFCFRUPOWEROPERSTATUS};
        String[] ciscoFanParam = new String[]{this.CEFCFANTRAYOPERSTATUS};
        InetAddress ia = InetAddress.getByName(target[0]);
        String ipaddress = ia.getHostAddress();
        this.header = new Header(target[0], scannerName, this.SCANNERTYPE, this.OUTBAND_SENSOREVENT_SCANNER + ipaddress, "5.0.0");
        this.result = this.header.toString();
        if (this.isCiscoMdsSwitch(target[0]) == 1) {
            isCiscoSwitch = true;
        }
        this.setScanType(2);
        if (isCiscoSwitch) {
            this.connUnitList = this.runProcess(target[0], ciscoConnUnitParam);
            if (this.connUnitList.isEmpty()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Failed to get Fabric Element WWN for target device " + target[0]);
                }
                throw new MissingUniqueIdException();
            }
            this.setScanType(4);
            this.sensorEntityList = this.runProcess(target[0], ciscoEntityParam);
            if (this.sensorEntityList.isEmpty() && traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Failed to get Entity data for target device " + target[0]);
            }
            this.sensorPwrList = this.runProcess(target[0], ciscoPwrParam);
            if (this.sensorPwrList.isEmpty() && traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Failed to get Power options for target device " + target[0]);
            }
            this.sensorFanList = this.runProcess(target[0], ciscoFanParam);
            if (this.sensorFanList.isEmpty() && traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Failed to get Fan data for target device " + target[0]);
            }
            HashMap entityMap = this.createEntityHashMap(this.sensorEntityList);
            this.sensorList = this.compileSensorData(entityMap, this.sensorPwrList, this.sensorFanList);
        } else {
            this.connUnitList = this.runProcess(target[0], connUnitParam);
            if (this.connUnitList.isEmpty()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The target device " + target[0] + " supports old FC MGMT MIB");
                }
                this.connUnitList = this.runProcess(target[0], connUnitParam_old);
            }
            if (this.connUnitList.isEmpty()) {
                throw new MissingUniqueIdException();
            }
            this.setScanType(4);
            this.sensorList = this.runProcess(target[0], sensorParam);
            if (this.sensorList.isEmpty()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The target device " + target[0] + " supports old FC MGMT MIB");
                }
                this.sensorList = this.runProcess(target[0], sensorParam_old);
            }
            this.setScanType(5);
            this.eventList = this.runProcess(target[0], eventParam);
            if (this.eventList.isEmpty()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The target device " + target[0] + " supports old FC MGMT MIB");
                }
                this.eventList = this.runProcess(target[0], eventParam_old);
            }
        }
        this.resetUniqueId(this.connUnitList);
        this.resetUniqueId(this.sensorList);
        this.resetUniqueId(this.eventList);
        this.fixConnUnitAndIndexValues(this.connUnitList, this.sensorList);
        this.fixConnUnitAndIndexValues(this.connUnitList, this.eventList);
        this.setSensorEventUniqueIds(this.sensorList);
        this.setSensorEventUniqueIds(this.eventList);
        this.setConnUnitValues(this.connUnitList);
        if (isCiscoSwitch) {
            this.setCiscoSensorValues(this.sensorList);
        } else {
            this.setSensorValues(this.sensorList);
        }
        this.setEventValues(this.eventList);
        this.result = this.result.concat(this.sensorEventOutputGenerator());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, this.result);
        }
        org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response r = new org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response(Response.RETURN_CODE_OK, this.result);
        this.eventList = null;
        this.connUnitList = null;
        this.sensorList = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return r;
    }

    private HashMap createEntityHashMap(Vector sensorEntityList) {
        HashMap<String, Entity> entityMap = new HashMap<String, Entity>();
        String methodName = "createEntityHashMap";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < sensorEntityList.size(); ++i) {
            Entity pentity = (Entity)sensorEntityList.elementAt(i);
            String eName = pentity.getName();
            String Index = eName.substring(eName.lastIndexOf(".") + 1);
            entityMap.put(Index, pentity);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return entityMap;
    }

    private Vector compileSensorData(HashMap entityMap, Vector sensorPwrList, Vector sensorFanList) throws Exception {
        Vector newVector = new Vector();
        String methodName = "compileSensorData";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        newVector.addAll(sensorPwrList);
        newVector.addAll(sensorFanList);
        this.getIndex(entityMap, newVector);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return newVector;
    }

    private void getIndex(HashMap entityMap, Vector newVector) throws Exception {
        String methodName = "getIndex";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        block0: for (int i = 0; i < newVector.size(); ++i) {
            int j;
            Entity pentity = (Entity)newVector.elementAt(i);
            String eName = pentity.getName();
            String Index = eName.substring(eName.lastIndexOf(".") + 1);
            Entity mapEntity = (Entity)entityMap.get(Index);
            if (mapEntity != null) {
                for (j = 0; j < mapEntity.getParameterList().size(); ++j) {
                    String paramName = mapEntity.getParamNameAt(j);
                    if (paramName == null || !paramName.equals("Name") && !paramName.equals("Info") && !paramName.equals("Type")) continue;
                    pentity.addParameter(paramName, mapEntity.getParamValueAt(j));
                }
            }
            for (j = 0; j < pentity.getParameterList().size(); ++j) {
                if (!pentity.getParamNameAt(j).equals("Index")) continue;
                pentity.setParamValueAt(j, Index);
                continue block0;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public String sensorEventOutputGenerator() {
        Entity pentity;
        int i;
        String methodName = "sensorEventOutputGenerator";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        String result = new String();
        for (i = 0; i < this.connUnitList.size(); ++i) {
            pentity = (Entity)this.connUnitList.elementAt(i);
            result = result.concat(pentity.toString());
        }
        for (i = 0; i < this.sensorList.size(); ++i) {
            pentity = (Entity)this.sensorList.elementAt(i);
            result = result.concat(pentity.toString());
        }
        for (i = 0; i < this.eventList.size(); ++i) {
            pentity = (Entity)this.eventList.elementAt(i);
            result = result.concat(pentity.toString());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    private Vector runProcess(String ipaddress, String[] alist) throws SnmpSocketException, UnknownHostException, Exception {
        String methodName = "runProcess";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Vector result = new Vector();
        boolean isContacted = false;
        int attempts = this.queryRetryCount + 1;
        for (int i = 0; i < attempts; ++i) {
            result = this.runSnmpQuery(ipaddress, alist);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "--------> Statistics:: runProcess: " + ipaddress + " counter =" + i);
            }
            if (this.ERROR_FLAG) continue;
            isContacted = true;
            break;
        }
        if (!isContacted) {
            throw new Exception("Unable to contact the host " + ipaddress + " after " + attempts + " attempts!");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            SensorEventScanner seneventScanner = new SensorEventScanner();
            org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response output = seneventScanner.invoke("SensorEvent", args);
            System.out.println(output);
            System.out.println("==================");
        }
        catch (Exception e) {
            System.out.println("Main: " + e);
        }
    }
}

