/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPScanner;
import org.eclipse.aperi.discovery.snmp.scanner.data.Entity;
import org.eclipse.aperi.discovery.snmp.scanner.data.Parameter;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.MissingUniqueIdException;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.Response;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.snmp.SnmpSocketException;

public class TopologyScanner
extends SNMPScanner {
    public static ILogger msgLogger = SNMPScanner.msgLogger;
    public static ILogger traceLogger = SNMPScanner.traceLogger;
    public static final String MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.MibQueryEngineTMS";
    public static final int NORMALREQ = 0;
    public static final int ZONEREQ = 1;
    public String scanId = null;
    static final String className = TopologyScanner.class.getName();
    private final String SCANNERNAME = "Topology";
    private final int WWNSIZE = 32;
    private final String OUTBAND_TOPOLOGY_SCANNER = "OutbandTopologyScanner:";
    private Vector ePortList = new Vector();
    private String result = new String();
    private Vector sanList = new Vector();
    private Vector sysURL = new Vector();
    private Vector ieList = new Vector();
    private Vector icList = new Vector();
    private Vector portList = new Vector();
    private Vector atpList = new Vector();
    private Vector nodeList = new Vector();
    private Vector sanPortList = new Vector();
    private Vector attachedPort_NxType = new Vector();

    private void setPortTypeValue(Vector plist) {
        for (int i = 0; i < plist.size(); ++i) {
            Entity pentity = (Entity)plist.elementAt(i);
            for (int k = 0; k < pentity.getParameterList().size(); ++k) {
                Parameter param = (Parameter)pentity.getParameterList().elementAt(k);
                if (param.getName().equals("Type")) {
                    String value = param.getValue();
                    if (value.equals("1")) {
                        param.setValue("Unknown");
                    } else if (value.equals("2")) {
                        param.setValue("Other");
                    } else if (value.equals("3")) {
                        param.setValue("Unknown");
                    } else if (value.equals("4")) {
                        param.setValue("E_Port");
                    } else if (value.equals("5")) {
                        param.setValue("N_Port");
                    } else if (value.equals("6")) {
                        param.setValue("L_Port");
                    } else if (value.equals("7")) {
                        param.setValue("FL_Port");
                    } else if (value.equals("8")) {
                        param.setValue("F_Port");
                    } else if (value.equals("9")) {
                        param.setValue("E_Port");
                    } else if (value.equals("10")) {
                        param.setValue("G_Port");
                    } else if (value.equals("11")) {
                        param.setValue("Domain_Ctl");
                    } else if (value.equals("12")) {
                        param.setValue("Hub_Controller");
                    } else if (value.equals("13")) {
                        param.setValue("Scsi");
                    } else if (value.equals("14")) {
                        param.setValue("Escon");
                    } else if (value.equals("15")) {
                        param.setValue("Lan");
                    } else if (value.equals("16")) {
                        param.setValue("Wan");
                    }
                }
                if (!param.getName().equals("State")) continue;
                if (param.getValue().equals("1")) {
                    param.setValue("Unknown");
                    continue;
                }
                if (param.getValue().equals("2")) {
                    param.setValue("Online");
                    continue;
                }
                if (param.getValue().equals("3")) {
                    param.setValue("Offline");
                    continue;
                }
                if (!param.getValue().equals("4")) continue;
                param.setValue("Bypassed");
            }
        }
    }

    private String xrefsHelper(Entity ie, String commonOID) {
        String methodName = "xrefsHelper";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter=" + ie + " and " + commonOID));
        }
        String value = new String();
        for (int i = 0; i < ie.getParameterList().size(); ++i) {
            if (!ie.getParamNameAt(i).startsWith(commonOID) && !ie.getParamNameAt(i).equals(commonOID)) continue;
            value = ie.getParamValueAt(i);
            ie.getParameterList().removeElementAt(i);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return value;
    }

    private void setIeContainsPortXrefs(Vector ieList, Vector portList) {
        String methodName;
        block7: {
            methodName = "setIeContainsPortXrefs";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter=" + ieList + " and " + portList));
            }
            try {
                for (int f = 0; f < ieList.size(); ++f) {
                    this.iEntity = (Entity)ieList.elementAt(f);
                    String ieValue = this.iEntity.getUniqueId();
                    String portValue = null;
                    for (int i = 0; i < portList.size(); ++i) {
                        portValue = this.xrefsHelper((Entity)portList.elementAt(i), this.CONNUNITPORTNODEWWN);
                        if (portValue.equals("")) {
                            portValue = this.xrefsHelper((Entity)portList.elementAt(i), this.CONNUNITPORTUNITID_OLD);
                        }
                        if (!ieValue.equals(portValue)) continue;
                        this.iEntity.addXrefs(this.iEntity.getUniqueId(), ((Entity)portList.elementAt(i)).getUniqueId());
                    }
                }
            }
            catch (Exception e) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "AdvancedTopologyScanner_setIeContainsPortXrefsFailed");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (traceLogger == null || !traceLogger.isLogging()) break block7;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setIeIpAddressValue(Vector ieList, String targetIp) {
        String methodName = "setIeIpAddressValue";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter=" + ieList + " and " + targetIp));
        }
        for (int i = 0; i < ieList.size(); ++i) {
            this.iEntity = (Entity)ieList.elementAt(i);
            this.iEntity.addParameter("IP Address", targetIp);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private String getSubstring(String wwn) {
        String methodName = "getSubString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter= " + wwn));
        }
        if (wwn.length() >= 32 && this.isZeroSubstring(wwn)) {
            String newid = wwn.substring(0, 16);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return newid;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return wwn;
    }

    private boolean isZeroSubstring(String wwn) {
        String sub = wwn.substring(16, wwn.length());
        boolean flag = true;
        for (int i = 0; i < sub.length(); ++i) {
            if (sub.charAt(i) != '0') {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag;
    }

    private void resetUniqueId(Vector alist) {
        String methodName = "resetUniqueId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < alist.size(); ++i) {
            Entity entity = (Entity)alist.elementAt(i);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Entity's Unique ID Value = " + entity.getUniqueId());
            }
            String newID = this.getSubstring(entity.getUniqueId());
            entity.setUniqueId(newID);
            Vector plist = entity.getParameterList();
            for (int j = 0; j < plist.size(); ++j) {
                Parameter param = (Parameter)plist.elementAt(j);
                String value = param.getValue();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Parameter Value = " + value);
                }
                String newvalue = this.getSubstring(value);
                param.setValue(newvalue);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private Vector setNodeContainsPortXrefs(Vector nodeList, Vector nonEportList) throws Exception {
        String methodName = "setNodeContainsPortXrefs";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Vector<Entity> newFcNodeList = new Vector<Entity>();
        for (int n = 0; n < nonEportList.size(); ++n) {
            Entity portEntity = (Entity)nonEportList.elementAt(n);
            for (int i = 0; i < nodeList.size(); ++i) {
                Entity nodeEntity = (Entity)nodeList.elementAt(i);
                for (int j = 0; j < nodeEntity.getParameterList().size(); ++j) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Node Param= " + nodeEntity.getParamValueAt(j));
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Port Param= " + portEntity.getUniqueId());
                    }
                    if (!nodeEntity.getParamValueAt(j).equals(portEntity.getUniqueId())) continue;
                    nodeEntity.getParameterList().removeElementAt(j);
                    nodeEntity.addXrefs(nodeEntity.getUniqueId(), portEntity.getUniqueId());
                    newFcNodeList.addElement(nodeEntity);
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return newFcNodeList;
    }

    private boolean isEPort(String portwwny) {
        for (int i = 0; i < this.ePortList.size(); ++i) {
            if (!this.ePortList.elementAt(i).equals(portwwny)) continue;
            return true;
        }
        return false;
    }

    private Vector removeE_Port(Vector alist, Vector sanport) {
        String methodName = "removeE_Port";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Vector<Entity> newlist = new Vector<Entity>();
        for (int i = 0; i < alist.size(); ++i) {
            Entity ientity = (Entity)alist.elementAt(i);
            if (this.isEPort(ientity.getUniqueId())) continue;
            newlist.addElement(ientity);
        }
        if (!newlist.isEmpty() && !sanport.isEmpty()) {
            for (int k = 0; k < newlist.size(); ++k) {
                boolean OKFlag = false;
                Entity oneEntity = (Entity)newlist.elementAt(k);
                for (int h = 0; h < sanport.size(); ++h) {
                    Entity sanportEn = (Entity)sanport.elementAt(h);
                    if (!oneEntity.getUniqueId().equals(sanportEn.getUniqueId())) continue;
                    OKFlag = true;
                    break;
                }
                if (OKFlag) continue;
                newlist.removeElementAt(k);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return newlist;
    }

    private Vector mergeMultiPortNodes(Vector nodelist) throws Exception {
        String methodName = "mergeMultiPortNodes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Vector<Entity> newlist = new Vector<Entity>();
        block0: for (int i = 0; i < nodelist.size(); ++i) {
            Entity ientity = (Entity)nodelist.elementAt(i);
            if (newlist.contains(ientity)) {
                for (int j = 0; j < newlist.size(); ++j) {
                    Entity jentity = (Entity)newlist.elementAt(j);
                    if (!ientity.equals(jentity)) continue;
                    Hashtable iXrefs = ientity.getXrefs();
                    Vector atpList = (Vector)iXrefs.get(ientity.getUniqueId());
                    for (int p = 0; p < atpList.size(); ++p) {
                        jentity.addXrefs(jentity.getUniqueId(), (String)atpList.elementAt(p));
                    }
                    continue block0;
                }
                continue;
            }
            newlist.addElement(ientity);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return newlist;
    }

    private boolean removedUnidentifiedPorts(Vector sanport) {
        String methodName = "removeUnidentifiedPorts";
        boolean portRemoved = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = sanport.size() - 1; i >= 0; --i) {
            Entity ientity = (Entity)sanport.elementAt(i);
            String WWN = ientity.getUniqueId();
            if (!WWN.equals("0000000000000000") && !WWN.equals("                ") && !WWN.equals("")) continue;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Removing unidentified port entity from scan data for target " + this.switchIpAddress + "\n" + ientity.toString());
            }
            sanport.removeElementAt(i);
            portRemoved = true;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return portRemoved;
    }

    private void setPortContainsPortXrefs(Vector portlist, Vector atplist) throws Exception {
        String methodName = "setPortContainsPortXrefs";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int p = 0; p < atplist.size(); ++p) {
            Entity atpEntity = (Entity)atplist.elementAt(p);
            String commonvalue = this.xrefsHelper(atpEntity, this.getOidName(this.CONNUNITLINKPORTNUMBERX));
            for (int i = 0; i < portlist.size(); ++i) {
                Entity pEntity = (Entity)portlist.elementAt(i);
                for (int j = 0; j < pEntity.getParameterList().size(); ++j) {
                    if (!pEntity.getParamNameAt(j).equals(this.getOidName(this.CONNUNITLINKPORTNUMBERX)) || !pEntity.getParamValueAt(j).equals(commonvalue)) continue;
                    pEntity.addXrefs(pEntity.getUniqueId(), atpEntity.getUniqueId());
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setConnUnitType(Vector ielist) {
        String methodName = "setConnUnitType";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < ielist.size(); ++i) {
            Entity ieEntity = (Entity)ielist.elementAt(i);
            for (int j = 0; j < ieEntity.getParameterList().size(); ++j) {
                String value;
                Parameter param = (Parameter)ieEntity.getParameterList().elementAt(j);
                if (param.getName().equals("Type")) {
                    value = param.getValue();
                    if (value.equals("1")) {
                        param.setValue("Unknown");
                        continue;
                    }
                    if (value.equals("2")) {
                        param.setValue("Other");
                        continue;
                    }
                    if (value.equals("3")) {
                        param.setValue("Hub");
                        continue;
                    }
                    if (value.equals("4")) {
                        param.setValue("Switch");
                        continue;
                    }
                    if (value.equals("5")) {
                        param.setValue("Gateway");
                        continue;
                    }
                    if (value.equals("6")) {
                        param.setValue("Converter");
                        continue;
                    }
                    if (value.equals("7")) {
                        param.setValue("HBA");
                        continue;
                    }
                    if (value.equals("8")) {
                        param.setValue("Proxy-Agent");
                        continue;
                    }
                    if (value.equals("9")) {
                        param.setValue("Storage-Device");
                        continue;
                    }
                    if (value.equals("10")) {
                        param.setValue("Host");
                        continue;
                    }
                    if (value.equals("11")) {
                        param.setValue("Storage-Subsystem");
                        continue;
                    }
                    if (value.equals("12")) {
                        param.setValue("Module");
                        continue;
                    }
                    if (!value.equals("13")) continue;
                    param.setValue("Swdriver");
                    continue;
                }
                if (!param.getName().equals("Domain")) continue;
                value = param.getValue();
                int domain = Integer.parseInt(value, 16);
                if (!value.startsWith("0")) {
                    domain &= 0x3FF;
                }
                param.setValue(Integer.toString(domain));
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setInterconnectElementState(Vector ielist) {
        String methodName = "setInterconnectElementState";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < ielist.size(); ++i) {
            Entity ieEntity = (Entity)ielist.elementAt(i);
            for (int j = 0; j < ieEntity.getParameterList().size(); ++j) {
                Parameter param = (Parameter)ieEntity.getParameterList().elementAt(j);
                if (!param.getName().equals("State")) continue;
                String value = param.getValue();
                if (value.equals("1")) {
                    param.setValue("Online");
                    continue;
                }
                if (value.equals("2")) {
                    param.setValue("Offline");
                    continue;
                }
                if (value.equals("3")) {
                    param.setValue("Testing");
                    continue;
                }
                if (!value.equals("4")) continue;
                param.setValue("Faulty");
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void hardcodeValue(Vector sanList, String name, String value) {
        for (int i = 0; i < sanList.size(); ++i) {
            ((Entity)sanList.elementAt(i)).addParameter(name, value);
        }
    }

    private void setAttachedPortType(Vector splist) {
        String methodName = "setAttachedPortType";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int j = 0; j < splist.size(); ++j) {
            String value;
            Parameter param;
            int k;
            Entity pentity = (Entity)splist.elementAt(j);
            for (k = pentity.getParameterList().size() - 1; k >= 0; --k) {
                param = (Parameter)pentity.getParameterList().elementAt(k);
                if (!param.getName().equals("Type") || (value = param.getValue()).equals("4") || value.equals("3") || value.equals("1")) continue;
                pentity.getParameterList().removeElementAt(k);
            }
            for (k = 0; k < pentity.getParameterList().size(); ++k) {
                param = (Parameter)pentity.getParameterList().elementAt(k);
                if (!param.getName().equals("Type")) continue;
                value = param.getValue();
                if (value.equals("4")) {
                    param.setValue("E_Port");
                    this.ePortList.addElement(pentity.getUniqueId());
                    continue;
                }
                if (value.equals("3")) {
                    param.setValue("E_Port");
                    this.ePortList.addElement(pentity.getUniqueId());
                    continue;
                }
                if (!value.equals("1")) continue;
                param.setValue("Unknown");
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public String getMgmtServerHeader(String address, String name, String uniqueId) {
        String methodName = "getMgmtServerHeader";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        String str = new String();
        Entity IEntity = new Entity();
        this.scanId = "OutbandTopologyScanner:" + uniqueId;
        str = str.concat(IEntity.setDocType(this.SCANNERNAME));
        str = str.concat(IEntity.setXmlHeader(address, name, this.scanId, "5.0.0"));
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return str;
    }

    public org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response invoke(String scannerName, String[] target) throws SnmpSocketException, UnknownHostException, Exception, MissingUniqueIdException {
        String methodName = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.switchIpAddress = target[0];
        String[] sanParam = new String[]{this.FCFEFABRICNAME};
        String[] sanParam_old = new String[]{this.FCFABRICNAME_OLD};
        String[] sanPortParam = new String[]{this.FCFXPORTNXPORTNAME};
        String[] sanPortParam_old = new String[]{this.FCFXPORTNXPORTNAME_OLD};
        String[] systemURLParam_old = new String[]{this.SYSTEMURL_OLD};
        String[] ieParam_old = new String[]{this.CONNUNITGLOBALID_OLD, this.CONNUNITDOMAINID_OLD, this.CONNUNITNAME_OLD, this.CONNUNITTYPE_OLD, this.CONNUNITLOCATION_OLD, this.CONNUNITPRODUCT_OLD, this.CONNURL_OLD, this.CONNUNITSN_OLD};
        String[] BrocadeIeParam_old = new String[]{this.CONNUNITGLOBALID_OLD, this.CONNUNITDOMAINID_OLD, this.CONNUNITNAME_OLD, this.CONNUNITTYPE_OLD, this.CONNUNITLOCATION_OLD, this.CONNUNITREVSREVID_OLD, this.CONNURL_OLD, this.CONNUNITSN_OLD};
        String[] attchedPortParam_old = new String[]{this.CONNUNITLINKPORTWWNY_OLD, this.CONNUNITLINKUNITTYPEY_OLD, this.CONNUNITLINKPORTNUMBERX_OLD};
        String[] portParam_old = new String[]{this.CONNUNITPORTWWN_OLD, this.CONNUNITPORTUNITID_OLD, this.CONNUNITPORTTYPE_OLD, this.CONNUNITPORTPHYSICALNUMBER_OLD, this.CONNUNITPORTSTATE_OLD};
        String[] nodeParam_old = new String[]{this.CONNUNITLINKNODEIDY_OLD, this.CONNUNITLINKPORTWWNY_OLD};
        String[] ieParam = new String[]{this.CONNUNITGLOBALID, this.CONNUNITDOMAINID, this.CONNUNITNAME, this.CONNUNITTYPE, this.CONNUNITLOCATION, this.CONNUNITPRODUCT, this.CONNURL, this.CONNUNITSN};
        String[] attchedPortParam = new String[]{this.CONNUNITLINKPORTWWNY, this.CONNUNITLINKUNITTYPEY, this.CONNUNITLINKPORTNUMBERX};
        String[] portParam = new String[]{this.CONNUNITPORTWWN, this.CONNUNITPORTNODEWWN, this.CONNUNITPORTTYPE, this.CONNUNITPORTPHYSICALNUMBER, this.CONNUNITPORTSTATE};
        String[] nodeParam = new String[]{this.CONNUNITLINKNODEIDY, this.CONNUNITLINKPORTWWNY};
        String[] icParam = new String[]{this.FCFEELEMENTNAME, this.SYSDESCR, this.SYSOBJECTID, this.SYSCONTACT, this.SYSLOCATION, this.SYSNAME, this.FCFEMODULEOPERSTATUS};
        String[] icParam_old = new String[]{this.FCELEMENTNAME_OLD, this.SYSDESCR, this.SYSOBJECTID, this.SYSCONTACT, this.SYSLOCATION, this.SYSNAME, this.FCFEMODULEOPERSTATUS_OLD};
        boolean FEmib = true;
        boolean usedOldFEmib = false;
        if (this.isBrocadeSwitch(this.switchIpAddress) == 1) {
            ieParam_old = BrocadeIeParam_old;
        }
        InetAddress ia = InetAddress.getByName(this.switchIpAddress);
        String ipaddress = ia.getHostAddress();
        this.result = this.getMgmtServerHeader(this.switchIpAddress, scannerName, ipaddress);
        this.setScanType(1);
        this.sanList = this.runProcess(this.switchIpAddress, sanParam);
        if (this.sanList.isEmpty()) {
            usedOldFEmib = true;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The target device " + this.switchIpAddress + " supports old FE MIB");
            }
            this.sanList = this.runProcess(this.switchIpAddress, sanParam_old);
        }
        if (this.sanList.isEmpty()) {
            FEmib = false;
            this.sanList = this.getSANNameFromFCMgmtMIB(this.switchIpAddress);
        }
        if (this.sanList.isEmpty()) {
            throw new MissingUniqueIdException();
        }
        this.sysURL = this.runProcess(this.switchIpAddress, systemURLParam_old);
        this.ieList = this.runProcess(this.switchIpAddress, ieParam);
        if (!this.ieList.isEmpty()) {
            if (FEmib) {
                this.icList = usedOldFEmib ? this.runProcess(this.switchIpAddress, icParam_old) : this.runProcess(this.switchIpAddress, icParam);
            }
            this.portList = this.runProcess(this.switchIpAddress, portParam);
            this.atpList = this.runProcess(this.switchIpAddress, attchedPortParam);
            this.nodeList = this.runProcess(this.switchIpAddress, nodeParam);
        } else {
            this.ieList = this.runProcess(this.switchIpAddress, ieParam_old);
            if (FEmib) {
                this.icList = usedOldFEmib ? this.runProcess(this.switchIpAddress, icParam_old) : this.runProcess(this.switchIpAddress, icParam);
            }
            this.portList = this.runProcess(this.switchIpAddress, portParam_old);
            this.atpList = this.runProcess(this.switchIpAddress, attchedPortParam_old);
            this.nodeList = this.runProcess(this.switchIpAddress, nodeParam_old);
        }
        if (this.ieList.size() > 0) {
            for (int i = 0; i < this.icList.size(); ++i) {
                Entity icListEntity = (Entity)this.icList.elementAt(i);
                Vector paramList = icListEntity.getParameterList();
                Entity ieListEntity = (Entity)this.ieList.elementAt(i);
                for (int p = 0; p < paramList.size(); ++p) {
                    boolean removeThisEntry = false;
                    Parameter parm = (Parameter)paramList.elementAt(p);
                    String icName = parm.getName();
                    Vector ieParamList = ieListEntity.getParameterList();
                    for (int t = 0; t < ieParamList.size(); ++t) {
                        Parameter ietParam = (Parameter)ieParamList.elementAt(t);
                        if (!icName.equals(ietParam.getName())) continue;
                        removeThisEntry = true;
                        break;
                    }
                    if (removeThisEntry) continue;
                    ieListEntity.addParameter(parm.getName(), parm.getValue());
                }
            }
        } else {
            this.ieList = this.icList;
        }
        this.setIeIpAddressValue(this.ieList, ipaddress);
        if (this.isZeroSAN(this.sanList) || this.isZeroSAN(this.ieList)) {
            this.result = this.result.concat(this.iEntity.endResultXml(this.SCANNERNAME));
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "found Zero SAN");
            }
        } else {
            this.result.concat(this.topologyXmlGenerator());
        }
        Vector ePortList = new Vector();
        this.sanList = null;
        this.sysURL = null;
        this.ieList = null;
        this.icList = null;
        this.portList = null;
        this.atpList = null;
        this.nodeList = null;
        this.sanPortList = null;
        this.attachedPort_NxType = null;
        org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response r = this.processXMLDeltaScan(this.scanId, this.result, Response.RETURN_CODE_OK, "MibQueryEngine");
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return r;
    }

    public Vector getSANNameFromFCMgmtMIB(String targetIp) throws SnmpSocketException, UnknownHostException, Exception {
        Vector SANList;
        String methodName;
        block36: {
            methodName = "getSANNameFromFCMgmtMIB";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            SANList = new Vector();
            String[] connUnitFabricId = new String[]{this.CONNUNITFABRICID};
            SANList = this.runProcess(targetIp, connUnitFabricId);
            if (SANList.isEmpty()) {
                Vector connUnitPrincipalList = new Vector();
                Vector connUnitLinkUnitTypeYList = new Vector();
                Vector connUnitLinkAgentAddressYList = new Vector();
                String[] connUnitPrincipalParam = new String[]{this.CONNUNITPRINCIPAL};
                String[] connUnitGlobalIdParam = new String[]{this.CONNUNITGLOBALID};
                String[] connUnitLinkUnitTypeYParam = new String[]{this.CONNUNITLINKUNITTYPEY};
                String[] connUnitLinkAgentAddressYParam = new String[]{this.CONNUNITLINKAGENTADDRESSY};
                connUnitPrincipalList = this.runProcess(targetIp, connUnitPrincipalParam);
                if (!connUnitPrincipalList.isEmpty()) {
                    Entity ePrincipalEntity;
                    String sPrincipal;
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Getting the SAN Name from the temp FC Mgmt MIB");
                    }
                    if ((sPrincipal = (ePrincipalEntity = (Entity)connUnitPrincipalList.elementAt(0)).getParamValueAt(0)).equals("3")) {
                        SANList = this.runProcess(targetIp, connUnitGlobalIdParam);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "This is the principal switch so we are getting the SAN Name from " + targetIp);
                        }
                    } else {
                        connUnitLinkUnitTypeYList = this.runProcess(targetIp, connUnitLinkUnitTypeYParam);
                        this.setConnUnitType(connUnitLinkUnitTypeYList);
                        connUnitLinkAgentAddressYList = this.runProcess(targetIp, connUnitLinkAgentAddressYParam);
                        int i = 0;
                        Enumeration e = connUnitLinkUnitTypeYList.elements();
                        while (e.hasMoreElements()) {
                            Entity entity = (Entity)e.nextElement();
                            if (entity.getParamValueAt(0).equals("Switch")) {
                                Vector vPrincipal;
                                Entity ePEntity;
                                String sPSwitch;
                                Entity addrEntity = (Entity)connUnitLinkAgentAddressYList.elementAt(i);
                                String switchIPAddress = TopologyScanner.convertHexStringToAscii(addrEntity.getParamValueAt(0));
                                boolean validIP = true;
                                try {
                                    InetAddress ia = InetAddress.getByName(switchIPAddress);
                                    switchIPAddress = ia.getHostAddress();
                                }
                                catch (Exception ee) {
                                    validIP = false;
                                }
                                if (validIP && (sPSwitch = (ePEntity = (Entity)(vPrincipal = this.runProcess(switchIPAddress, connUnitPrincipalParam)).elementAt(0)).getParamValueAt(0)).equals("3")) {
                                    SANList = this.runProcess(switchIPAddress, connUnitGlobalIdParam);
                                    if (traceLogger != null && traceLogger.isLogging()) {
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "This is not the principal switch so we are getting the SAN Name from " + switchIPAddress);
                                    }
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                } else {
                    String[] connUnitPrincipalParam_old = new String[]{this.CONNUNITPRINCIPAL_OLD};
                    String[] connUnitGlobalIdParam_old = new String[]{this.CONNUNITGLOBALID_OLD};
                    String[] connUnitLinkUnitTypeYParam_old = new String[]{this.CONNUNITLINKUNITTYPEY_OLD};
                    String[] connUnitLinkAgentAddressYParam_old = new String[]{this.CONNUNITLINKAGENTADDRESSY_OLD};
                    connUnitPrincipalList = this.runProcess(targetIp, connUnitPrincipalParam_old);
                    if (!connUnitPrincipalList.isEmpty()) {
                        Entity ePrincipalEntity;
                        String sPrincipal;
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Getting the SAN Name from the old FC Mgmt MIB");
                        }
                        if ((sPrincipal = (ePrincipalEntity = (Entity)connUnitPrincipalList.elementAt(0)).getParamValueAt(0)).equals("3")) {
                            SANList = this.runProcess(targetIp, connUnitGlobalIdParam_old);
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "This is the principal switch so we are getting the SAN Name from " + targetIp);
                            }
                        } else {
                            connUnitLinkUnitTypeYList = this.runProcess(targetIp, connUnitLinkUnitTypeYParam_old);
                            this.setConnUnitType(connUnitLinkUnitTypeYList);
                            connUnitLinkAgentAddressYList = this.runProcess(targetIp, connUnitLinkAgentAddressYParam_old);
                            int i = 0;
                            Enumeration e = connUnitLinkUnitTypeYList.elements();
                            while (e.hasMoreElements()) {
                                Entity entity = (Entity)e.nextElement();
                                if (entity.getParamValueAt(0).equals("Switch")) {
                                    Vector vPrincipal;
                                    Entity ePEntity;
                                    String sPSwitch;
                                    Entity addrEntity = (Entity)connUnitLinkAgentAddressYList.elementAt(i);
                                    String switchIPAddress = TopologyScanner.convertHexStringToAscii(addrEntity.getParamValueAt(0));
                                    boolean validIP = true;
                                    try {
                                        InetAddress ia = InetAddress.getByName(switchIPAddress);
                                        switchIPAddress = ia.getHostAddress();
                                    }
                                    catch (Exception ee) {
                                        validIP = false;
                                    }
                                    if (validIP && (sPSwitch = (ePEntity = (Entity)(vPrincipal = this.runProcess(switchIPAddress, connUnitPrincipalParam_old)).elementAt(0)).getParamValueAt(0)).equals("3")) {
                                        SANList = this.runProcess(switchIPAddress, connUnitGlobalIdParam_old);
                                        if (traceLogger != null && traceLogger.isLogging()) {
                                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "This is not the principal switch so we are getting the SAN Name from " + switchIPAddress);
                                        }
                                        break;
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
            } else if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The target device supports FC Mgmt MIB 4");
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Getting the SAN Name from the FC Mgmt MIB 4");
            }
            if (SANList.isEmpty()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "We must use the IP address of the switch for the SAN Name.");
                }
                String v = targetIp;
                try {
                    Entity iEntity = new Entity("San", v.toUpperCase());
                    iEntity.addParameter("Name", v.toUpperCase());
                    SANList.addElement(iEntity);
                }
                catch (Exception e) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "Scanner_unableToCreateEntityException");
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (traceLogger == null || !traceLogger.isLogging()) break block36;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        }
        Enumeration e = SANList.elements();
        while (e.hasMoreElements()) {
            Entity entity = (Entity)e.nextElement();
            if ("InterconnectElement".equals(entity.getName())) {
                entity.setName("San");
            }
            Enumeration pe = entity.getParameterList().elements();
            while (pe.hasMoreElements()) {
                Parameter parameter = (Parameter)pe.nextElement();
                if (!"WWN".equals(parameter.getName())) continue;
                parameter.setName("Name");
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return SANList;
    }

    public static String convertHexStringToAscii(String superStr) {
        char y;
        if (superStr == null) {
            return null;
        }
        String newSuperStr = "";
        String subSuperStr = "";
        for (int x = 0; x < superStr.length() && (y = superStr.charAt(x)) != '0'; ++x) {
            subSuperStr = superStr.substring(x, x + 2);
            String newSub = "0x";
            newSub = newSub.concat(subSuperStr);
            Integer i = Integer.decode(newSub);
            char newChar = (char)i.intValue();
            newSuperStr = newSuperStr.concat(String.valueOf(newChar));
            ++x;
        }
        return newSuperStr;
    }

    public String topologyXmlGenerator() {
        String methodName;
        block6: {
            methodName = "topologyXmlGenerator: targetIP=" + this.switchIpAddress;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            try {
                this.resetUniqueId(this.sanList);
                this.resetUniqueId(this.nodeList);
                this.resetUniqueId(this.ieList);
                this.resetUniqueId(this.portList);
                this.resetUniqueId(this.atpList);
                boolean portListPortsRemoved = this.removedUnidentifiedPorts(this.portList);
                boolean atpListPortsRemoved = this.removedUnidentifiedPorts(this.atpList);
                boolean sanPortListPortsRemoved = this.removedUnidentifiedPorts(this.sanPortList);
                if (atpListPortsRemoved || portListPortsRemoved || sanPortListPortsRemoved) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "AdvancedTopologyScanner_unidentifiedPortRemoved");
                }
                this.setIeContainsPortXrefs(this.ieList, this.portList);
                this.setPortContainsPortXrefs(this.portList, this.atpList);
                this.hardcodeValue(this.sanList, "Type", "Fabric");
                this.setConnUnitType(this.ieList);
                this.setInterconnectElementState(this.ieList);
                this.setPortTypeValue(this.portList);
                this.setAttachedPortType(this.atpList);
                this.attachedPort_NxType = this.removeE_Port(this.atpList, this.sanPortList);
                Vector newNodeList = this.setNodeContainsPortXrefs(this.nodeList, this.attachedPort_NxType);
                Vector mergedNodeList = this.mergeMultiPortNodes(newNodeList);
                for (int i = 0; i < this.sanList.size(); ++i) {
                    this.iEntity = (Entity)this.sanList.elementAt(i);
                    this.result = this.result.concat(this.iEntity.toXml());
                    this.result = !this.sanPortList.isEmpty() ? this.result.concat(this.iEntity.toIdXml(new Vector[]{this.ieList, this.sanPortList})) : this.result.concat(this.iEntity.toIdXml(new Vector[]{this.ieList, this.attachedPort_NxType}));
                }
                this.result = this.result.concat(this.iEntity.composeXml(new Vector[]{this.ieList, this.portList, this.atpList, mergedNodeList}));
                this.result = this.result.concat(this.iEntity.endResultXml(this.SCANNERNAME));
            }
            catch (Exception e) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "AdvancedTopolgyScanner_TopolgoyXmlGeneratorError");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (traceLogger == null || !traceLogger.isLogging()) break block6;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.result;
    }

    private boolean isZeroSAN(Vector sanList) {
        String methodName = "isZeroSAN";
        String value = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < sanList.size(); ++i) {
            Entity entity = (Entity)sanList.elementAt(i);
            value = entity.getUniqueId();
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Entity's Unique ID Value = " + value);
            }
            if (value.equals("0000000000000000") || value.equals("                ") || value.equals("")) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                return true;
            }
            Vector plist = entity.getParameterList();
            for (int j = 0; j < plist.size(); ++j) {
                Parameter param = (Parameter)plist.elementAt(j);
                if (!param.getName().equals("WWN") || !(value = param.getValue()).equals("0000000000000000") && !value.equals("                ") && !value.equals("")) continue;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                return true;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return false;
    }

    private Vector runProcess(String ipaddress, String[] alist) throws SnmpSocketException, UnknownHostException, Exception {
        String methodName = "runProcess";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Vector result = new Vector();
        boolean isContacted = false;
        int attempts = this.queryRetryCount + 1;
        for (int i = 0; i < attempts; ++i) {
            result = this.runSnmpQuery(ipaddress, alist);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "--------> AdvTop:: runProcess: " + ipaddress + " counter =" + i);
            }
            if (this.ERROR_FLAG) continue;
            isContacted = true;
            break;
        }
        if (!isContacted) {
            throw new Exception("Unable to contact the host " + ipaddress + " after " + attempts + " attempts!");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public String getScannerHeader(String scannerName, String targetIp) {
        String ipaddress = null;
        String result = null;
        try {
            InetAddress ia = InetAddress.getByName(targetIp);
            ipaddress = ia.getHostAddress();
            result = this.getMgmtServerHeader(targetIp, scannerName, ipaddress);
            result = result.concat("</TopologyXml>");
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response getScannerHeaderResponse(int errorCode, String scannerName, String targetIp) {
        String ipaddress = null;
        String result = null;
        try {
            InetAddress ia = InetAddress.getByName(targetIp);
            ipaddress = ia.getHostAddress();
            result = this.getMgmtServerHeader(targetIp, scannerName, ipaddress);
            result = result.concat("</TopologyXml>");
        }
        catch (Exception e) {
            // empty catch block
        }
        org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response r = this.processXMLDeltaScan(this.scanId, result, errorCode, "MibQueryEngine");
        return r;
    }

    static {
        msgLogger.setMessageFile(MSG_FILE);
    }
}

