/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.CimomAndDeviceStatus;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.LogFileHandler;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMVersion;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.control.ControlRouter;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.LockedException;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.control.interfaces.fabric.IZoneControl;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.RemoveMissingProcessor;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPConfig;
import org.eclipse.aperi.discovery.snmp.scanner.SensorEventScanner;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.fabric.DiscoverMonitor;
import org.eclipse.aperi.fabric.FabricActivator;
import org.eclipse.aperi.fabric.FabricMsgConsts;
import org.eclipse.aperi.fabric.api.DataPath;
import org.eclipse.aperi.fabric.api.DeviceAgent;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.fabric.api.FabricScanner;
import org.eclipse.aperi.fabric.api.FabricVersion;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.fabric.api.TransactionExpiredException;
import org.eclipse.aperi.fabric.api.TransactionInProgressException;
import org.eclipse.aperi.fabric.discovery.Discover;
import org.eclipse.aperi.fabric.interfaces.IFabricInternalService;
import org.eclipse.aperi.fabric.interfaces.InvalidTokenException;
import org.eclipse.aperi.fabric.interfaces.JobInProgressException;
import org.eclipse.aperi.fabric.interfaces.ResourceLockedException;
import org.eclipse.aperi.fabric.interfaces.ResourceNotAvailableException;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.infrastructure.database.objects.Scanner;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.monitor.eventcorrelator.data.AgentEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMOMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DiskMgrAgentEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.ExternalEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.IPTargetEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.InbandEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SNMPTrapEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSObjectMessage;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmpagent.manager.interfaces.ISNMPAgentManager;
import org.eclipse.aperi.util.SRMCrypto;
import org.sblim.wbem.cim.CIMObjectPath;

public class FabricManagerService
implements IService,
IFabricInternalService,
ICliDispatcher,
MessageListener {
    public Status status = new Status(5, 6);
    private static IDiscover discoverServiceProxy = null;
    private static ISNMPAgentManager SNMPAgentManagerProxy = null;
    private static IZoneControl zoneControllerProxy = null;
    static final String TRACE_NAME = "aperi.logger.trace.FabricManager";
    static final String MESSAGE_NAME = "aperi.logger.message.FabricManager";
    static final String MSG_FILE = FabricManagerConstants.MSG_FILE;
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = FabricManagerService.class.getName();
    private static Factory factory = null;
    private static TopicSubscriber agentEventSubscriber;
    private static TopicSubscriber externalEventSubscriber;
    private static Hashtable reservedTokens;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FabricManagerService() {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"FabricManagerService", null);
        try {
            mLTH.objectCreation(FabricManagerService.class.getName());
        }
        finally {
            mLTH.exit(null);
        }
    }

    public String getDescription() {
        return "Service that performs fabric management functions";
    }

    public String getName() {
        return "FabricManagerService";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("FabricManagerService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("FabricManagerService_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public boolean startup() {
        block7: {
            String methodName = "startup";
            this.status.setRunStatus(9);
            try {
                if (factory == null) {
                    factory = FactoryFactory.createFactory((int)2, null);
                }
                if (agentEventSubscriber == null) {
                    agentEventSubscriber = factory.createSubscriber(AgentEvent.class.getName(), null, null, (MessageListener)this);
                }
                if (externalEventSubscriber == null) {
                    externalEventSubscriber = factory.createSubscriber(ExternalEvent.class.getName(), null, null, (MessageListener)this);
                }
            }
            catch (Exception e) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Exception while subscribing to events");
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block7;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        this.status.setRunStatus(8);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message message) {
        String methodName;
        block16: {
            methodName = "onMessage";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            ObjectMessage objMsg = (ObjectMessage)message;
            try {
                SRMEvent event = (SRMEvent)objMsg.getObject();
                if (event instanceof AgentEvent) {
                    if (event instanceof IPTargetEvent) {
                        IPTargetEvent ipTgtEvent = (IPTargetEvent)event;
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Received an IPTargetEvent " + ipTgtEvent.toString());
                        }
                        String ipAddress = ipTgtEvent.geAddress();
                        String[] agents = new String[]{ipAddress};
                        int[] agentType = new int[]{FabricManagerConstants.SNMPType};
                        AsyncResult request = this.discoverFabrics(agents, agentType);
                        DiscoverMonitor.getDiscoverMonitor().monitor(request.getJobId());
                        break block16;
                    }
                    if (event instanceof DiskMgrAgentEvent) {
                        DiskMgrAgentEvent dmAgentEvent = (DiskMgrAgentEvent)event;
                        AsyncResult request = this.discoverFabrics(new String[]{dmAgentEvent.getGUID()}, new int[]{FabricManagerConstants.deviceServerType});
                        DiscoverMonitor.getDiscoverMonitor().monitor(request.getJobId());
                        break block16;
                    } else if (event instanceof CIMOMEvent) {
                        // empty if block
                    }
                    break block16;
                }
                if (!(event instanceof ExternalEvent)) break block16;
                if (event instanceof SNMPTrapEvent || event instanceof InbandEvent) {
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Received an SNMPTrapEvent or InbandEvent " + event.toString() + " from " + ((ExternalEvent)event).getSource() + " of type " + ((ExternalEvent)event).getType());
                    }
                    String ipAddr = ((ExternalEvent)event).getSource();
                    String[] fabrics = null;
                    if (ipAddr != null) {
                        fabrics = FabricDbAccess.getFabricsForIPAddress((String)ipAddr);
                    }
                    if (fabrics != null && fabrics.length > 0) {
                        AsyncResult request = this.probeFabrics(fabrics);
                        DiscoverMonitor.getDiscoverMonitor().monitor(request.getJobId());
                        break block16;
                    } else {
                        AsyncResult request = this.discoverFabrics(null, null);
                        DiscoverMonitor.getDiscoverMonitor().monitor(request.getJobId());
                    }
                    break block16;
                }
                if (!(event instanceof CIMIndicationEvent)) {
                    // empty if block
                }
            }
            catch (Exception e) {
                if (!traceLogger.isLogging()) break block16;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        String methodName = "shutdown";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "shutdown");
        }
        this.status.setRunStatus(11);
        try {
            agentEventSubscriber.close();
            externalEventSubscriber.close();
            factory.close();
            DiscoverMonitor.getDiscoverMonitor().shutdown();
        }
        catch (Exception e) {
            if (msgLogger != null) {
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "shutdown", (Throwable)e);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, "shutdown", "Exception while closing subscribers");
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "shutdown", (Throwable)e);
            }
        }
        finally {
            this.status.setRunStatus(10);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "shutdown");
            }
        }
        return true;
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> roleMap = new Hashtable<String, Integer>();
        roleMap.put("getFabrics", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getFabricAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getComputers", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getComputerAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getPortsForComputer", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getSwitches", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getSwitchAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getPortsForSwitch", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getPortAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getZoneSets", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getZones", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("verifyZoneSet", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("verifyZone", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getPortsInZone", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getZoneMembers", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getZoneMembersInZoneAlias", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getComputerToSubsystemDataPaths", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("startTransaction", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("commitTransaction", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("rollbackTransaction", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("createZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("createZone", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("createZoneAlias", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("addZoneToZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("addZoneMembersToZone", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("addZoneMembersToZoneAlias", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("removeZoneFromZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("removeZoneMembersFromZone", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("removeZoneMembersFromZoneAlias", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("removePortsFromZone", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("deleteZone", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("deleteZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("deleteZoneAlias", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("activateZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("deactivateZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("discoverSNMPAgents", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("addSNMPAgents", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("deleteSNMPAgents", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("getSNMPAgents", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getSNMPAgentIDs", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("modifySNMPAgents", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("testSNMPAgentConnection", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("getDeviceServerAgents", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("discoverCIMOMs", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("addCIMOMs", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("deleteCIMOMs", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("getCIMOMs", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getCIMOMIDs", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("modifyCIMOMs", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("testCIMOMConnection", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("dispatch", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("cancelJob", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("deleteMissingDevices", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("discoverDevicesFromCIMOM", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("discoverFabrics", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("getAPIVersion", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getDescription", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getDiscoverMonitor", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getDiscoverServiceProxy", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getJobStatus", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getLocalizedDescription", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getLocalizedName", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getLog", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getName", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getPortsConnectedTo", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getSNMPAgentIds", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getSNMPAgentManagerProxy", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getScannersForAgent", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getStatus", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getVersion", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("getZoneControllerProxy", new Integer(RoleChecker.FABRIC_VIEWER));
        roleMap.put("monitor", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("onMessage", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("probeFabrics", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("probeSwitchSensorAndEventData", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("release", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("reserve", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("setZoneInfo", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("testBrocadeAgentUserPassword", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("testZoneControlCapabilities", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("waitForJobToComplete", new Integer(RoleChecker.FABRIC_ADMIN));
        return roleMap;
    }

    public String dispatch(String methodName, String[] args) {
        StringBuffer buffer = new StringBuffer();
        if (methodName.equals("getFabrics")) {
            try {
                String[] fabrics = this.getFabrics(new HashMap());
                for (int i = 0; i < fabrics.length; ++i) {
                    buffer.append(fabrics[i] + "\n");
                }
            }
            catch (Exception e) {
                buffer.append(e);
                e.printStackTrace();
            }
        } else if (methodName.equals("getSwitches")) {
            if (args.length < 1) {
                buffer.append("Missing parameter - need to specify the fabric");
            } else {
                try {
                    String[] switches = this.getSwitches(args[0], new HashMap());
                    for (int i = 0; i < switches.length; ++i) {
                        buffer.append(switches[i] + "\n");
                    }
                }
                catch (Exception e) {
                    buffer.append(e);
                    e.printStackTrace();
                }
            }
        } else if (methodName.equals("getPortsForSwitch")) {
            if (args.length < 1) {
                buffer.append("Missing parameter - need to specify the switch");
            } else {
                try {
                    String[] ports = this.getPortsForSwitch(args[0], new HashMap());
                    for (int i = 0; i < ports.length; ++i) {
                        buffer.append(ports[i] + "\n");
                    }
                }
                catch (Exception e) {
                    buffer.append(e);
                    e.printStackTrace();
                }
            }
        } else if (methodName.equals("getComputerToSubsystemDataPath")) {
            if (args.length < 2) {
                buffer.append("Missing parameter - need to specify the computer name and subsystem name");
            } else {
                try {
                    DataPath[] dps = this.getComputerToSubsystemDataPaths(args[0], args[1]);
                    for (int i = 0; i < dps.length; ++i) {
                        buffer.append("CP " + dps[i].getComputerPortWWN() + " to SP " + dps[i].getSubsystemPortWWN() + " through Fabric " + dps[i].getFabricWWN() + ".\n");
                    }
                }
                catch (Exception e) {
                    buffer.append(e);
                    e.printStackTrace();
                }
            }
        } else if (methodName.equals("addAgent")) {
            if (args.length < 5) {
                buffer.append("Missing parameter - need to specify the IP address, dns name, community name, userid, password");
            } else {
                try {
                    SNMPAgent[] agents = new SNMPAgent[]{new SNMPAgent(args[0], args[1], args[2], args[3], args[4])};
                    this.addSNMPAgents(agents);
                }
                catch (Exception e) {
                    buffer.append(e);
                    e.printStackTrace();
                }
            }
        } else if (methodName.equals("deleteAgent")) {
            if (args.length < 1) {
                buffer.append("Missing parameter - need to specify the IP address");
            } else {
                try {
                    this.deleteSNMPAgents(args);
                }
                catch (Exception e) {
                    buffer.append(e);
                    e.printStackTrace();
                }
            }
        } else if (methodName.equals("discoverFabric")) {
            if (args.length < 1) {
                buffer.append("Missing parameter - need to specify the agent address");
            } else {
                try {
                    this.discoverFabrics(args, null);
                }
                catch (Exception e) {
                    buffer.append(e);
                    e.printStackTrace();
                }
            }
        } else if (methodName.equals("probeFabric")) {
            if (args.length < 1) {
                buffer.append("Missing parameter - need to specify the fabric WWN");
            } else {
                try {
                    this.probeFabrics(args);
                }
                catch (Exception e) {
                    buffer.append(e);
                    e.printStackTrace();
                }
            }
        } else if (methodName.equals("addCIMOM")) {
            if (args.length < 4) {
                buffer.append("Missing parameter - need to specify the URL, namespace, userid and password.");
            } else {
                try {
                    CIMOM myCIMOM = new CIMOM();
                    myCIMOM.setServiceUrl(args[0]);
                    myCIMOM.setInteropSchemaNamespace(args[1]);
                    myCIMOM.setUserId(args[2]);
                    myCIMOM.setPassword(args[3]);
                    this.addCIMOMs(new CIMOM[]{myCIMOM});
                }
                catch (Exception e) {
                    buffer.append(e);
                    e.printStackTrace();
                }
            }
        } else if (methodName.equals("discoverFabricViaSMIS")) {
            if (args.length < 1) {
                buffer.append("Missing parameter - need to specify the agent address");
            } else {
                try {
                    this.discoverFabrics(args, new int[]{FabricManagerConstants.CIMType});
                }
                catch (Exception e) {
                    buffer.append(e);
                    e.printStackTrace();
                }
            }
        } else if (methodName.equals("generateEvent")) {
            if (args.length < 2) {
                buffer.append("Missing parameter - need to specify the IP of event source and type");
            } else {
                try {
                    this.onMessage((Message)new MSObjectMessage((Serializable)new SNMPTrapEvent(args[0], args[1], new SnmpTrap())));
                }
                catch (Exception e) {
                    buffer.append(e);
                    e.printStackTrace();
                }
            }
        } else {
            buffer.append("\nFormat is:\ngetFabrics\ngetSwitches <Fabric>\ngetPortsForSwitch <Switch>\n");
        }
        return buffer.toString();
    }

    public SRMVersion getAPIVersion() {
        return new FabricVersion();
    }

    public AsyncResult getJobStatus(String jobId) {
        return ServiceUtils.getJobStatus((String)jobId);
    }

    public AsyncResult waitForJobToComplete(String jobId) {
        return DiscoverUtils.waitForJobToComplete((String)jobId);
    }

    public void cancelJob(String jobId) {
        DiscoverUtils.cancelJob((String)jobId);
    }

    public ReadLogResponse getLog(String name, byte direction, LogFilePos position, int linesDesired) throws ServerException {
        String methodName = "getLog";
        ReadLogResponse rlr = new ReadLogResponse();
        Object linesOut = null;
        try {
            rlr = LogFileHandler.getLog((String)name, (byte)direction, (LogFilePos)position, (int)linesDesired);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return rlr;
    }

    public ReadLogResponse getLog(String name, byte direction, LogFilePos position, String search, int linesDesired) throws ServerException {
        String methodName = "getLog";
        ReadLogResponse rlr = new ReadLogResponse();
        Object linesOut = null;
        try {
            rlr = LogFileHandler.getLog((String)name, (byte)direction, (LogFilePos)position, (String)search, (int)linesDesired);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return rlr;
    }

    public ReadLogResponse getLog(int agentID, String name, byte direction, LogFilePos position, int linesDesired) throws ServerException {
        String methodName = "getLog";
        ReadLogResponse rlr = new ReadLogResponse();
        Object linesOut = null;
        try {
            rlr = LogFileHandler.getLog((int)agentID, (String)name, (byte)direction, (LogFilePos)position, (int)linesDesired);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return rlr;
    }

    public ReadLogResponse getLog(int agentID, String name, byte direction, LogFilePos position, String search, int linesDesired) throws ServerException {
        String methodName = "getLog";
        ReadLogResponse rlr = new ReadLogResponse();
        Object linesOut = null;
        try {
            rlr = LogFileHandler.getLog((int)agentID, (String)name, (byte)direction, (LogFilePos)position, (String)search, (int)linesDesired);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return rlr;
    }

    public AsyncResult discoverSNMPAgents(String[] baseIPAddress, String defaultSNMPCommunity, String defaultUserId, String defaultPassword) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "discoverSNMPAgents";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String request = null;
        try {
            if (baseIPAddress == null) {
                baseIPAddress = new String[]{};
            }
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            properties.put("IPADDRESS", baseIPAddress);
            if (defaultSNMPCommunity == null || defaultSNMPCommunity.trim().length() == 0) {
                properties.put("SNMP Community", "public");
            } else {
                properties.put("SNMP Community", defaultSNMPCommunity);
            }
            properties.put("USERID", defaultUserId);
            properties.put("PASSWORD", defaultPassword);
            request = FabricManagerService.getDiscoverServiceProxy().discover("discoverSNMPAgents", properties);
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return FabricManagerService.getDiscoverServiceProxy().getJobStatus(request);
    }

    public String[] addSNMPAgents(SNMPAgent[] agents) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "addSNMPAgents";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(agents, "SNMPAgent", 1, methodName);
        String[] ipAddresses = null;
        try {
            ArrayList<SNMPAgent> snmpAgents = new ArrayList<SNMPAgent>();
            Object agent = null;
            for (int i = 0; i < agents.length; ++i) {
                if (agents[i] == null) {
                    String[] params = new String[]{agents[i].toString()};
                    SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.INVALID_PARAMETER, params);
                    throw new InvalidParameterException(1, tpcMsg);
                }
                this.checkIP(agents[i].getIpAddress());
                agents[i] = this.checkSNMPAgentCommunity(agents[i]);
                snmpAgents.add(agents[i]);
                ipAddresses = FabricManagerService.getSNMPAgentManagerProxy().addSNMPAgents(snmpAgents);
            }
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return ipAddresses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteSNMPAgents(String[] agents) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "deleteSNMPAgents";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        DBConnection connection = ServiceUtils.getConnection();
        IpTarget target = new IpTarget();
        Scanner scanner = new Scanner();
        Object result = null;
        Object[] msgInserts = new String[]{""};
        boolean failed = false;
        this.checkMandatoryParam(agents, "SNMPAgent", 1, methodName);
        try {
            for (int i = 0; i < agents.length; ++i) {
                target.clear();
                target.setIpAddress(agents[i]);
                if (target.delete(connection) == 1) continue;
                target.clear();
                String ipAddress = InetAddress.getByName(agents[i]).getHostAddress();
                target.setIpAddress(ipAddress);
                if (target.delete(connection) == 1) continue;
                msgInserts[0] = agents[i];
                failed = true;
                msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.AGENT_NOT_FOUND, msgInserts);
            }
            connection.commit();
        }
        catch (Exception e) {
            try {
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
                String[] params = new String[]{methodName};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
            }
            catch (Throwable throwable) {
                try {
                    if (connection == null) throw throwable;
                    connection.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e2);
                    String[] params = new String[]{methodName};
                    throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
                }
            }
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        this.discoverFabrics(null, new int[]{FabricManagerConstants.ScannerProcessMissing});
        if (!failed) return;
        throw new ServerException(new SRMMessage(FabricMsgConsts.AGENT_NOT_FOUND, (String[])msgInserts));
    }

    public SNMPAgent[] getSNMPAgents() throws ServerException {
        String methodName = "getSNMPAgents";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        ArrayList<SNMPAgent> agents = new ArrayList<SNMPAgent>();
        DBConnection connection = ServiceUtils.getConnection();
        IpTarget.IpTargetCursor cursor = null;
        try {
            cursor = IpTarget.getCursor((DBConnection)connection, null, null);
            while (cursor.next()) {
                IpTarget target = cursor.getObject();
                agents.add(new SNMPAgent(target.getIpAddress(), target.getHostName(), target.getReadCommunityName(), target.getRwCommunityName(), target.getUserId(), target.getPassword()));
            }
            connection.commit();
        }
        catch (Exception e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
            }
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            block15: {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    if (!traceLogger.isLogging()) break block15;
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
                }
            }
        }
        return agents.toArray(new SNMPAgent[0]);
    }

    /*
     * Loose catch block
     */
    public String[] getSNMPAgentIds() throws ServerException {
        ArrayList<String> agents;
        block18: {
            IpTarget.IpTargetCursor cursor;
            DBConnection connection;
            String methodName;
            block16: {
                methodName = "getSNMPAgents";
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
                }
                agents = new ArrayList<String>();
                connection = ServiceUtils.getConnection();
                cursor = null;
                cursor = IpTarget.getCursor((DBConnection)connection, null, null);
                while (cursor.next()) {
                    agents.add(cursor.getObject().getIpAddress());
                }
                connection.commit();
                Object var8_5 = null;
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    if (!traceLogger.isLogging()) break block16;
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
                }
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            break block18;
            {
                catch (Exception e) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
                    }
                    String[] params = new String[]{methodName};
                    throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
                }
            }
            catch (Throwable throwable) {
                block17: {
                    Object var8_6 = null;
                    try {
                        if (cursor != null) {
                            cursor.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e) {
                        if (!traceLogger.isLogging()) break block17;
                        traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
                    }
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                throw throwable;
            }
        }
        return agents.toArray(new String[0]);
    }

    public void modifySNMPAgents(SNMPAgent[] agents) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "modifySNMPAgents";
        this.checkMandatoryParam(agents, "SNMPAgent", 1, methodName);
        DBConnection connection = ServiceUtils.getConnection();
        IpTarget target = new IpTarget();
        try {
            String password = null;
            for (int i = 0; i < agents.length; ++i) {
                target.clear();
                target.setHostName(agents[i].getDnsName());
                target.setIpAddress(agents[i].getIpAddress());
                target.setUserId(agents[i].getUserName());
                password = agents[i].getPassword();
                if (password != null) {
                    password = SRMCrypto.encrypt((String)password);
                }
                target.setPassword(password);
                agents[i] = this.checkSNMPAgentCommunity(agents[i]);
                target.setReadCommunityName(agents[i].getCommunityName());
                target.setRwCommunityName(agents[i].getRWCommunityName());
                if (target.update(connection) != 1) {
                    System.out.println("Error updating " + agents[i].getIpAddress());
                }
                SNMPConfig config = (SNMPConfig)SnmpV1API.getConfig();
                config.setSnmpCommunityName(agents[i].getIpAddress(), agents[i].getCommunityName());
                config.setSnmpWriteCommunityName(agents[i].getIpAddress(), agents[i].getRWCommunityName());
            }
            connection.commit();
        }
        catch (Exception e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
            }
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            block15: {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    if (!traceLogger.isLogging()) break block15;
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
                }
            }
        }
    }

    public int[] testSNMPAgentConnection(SNMPAgent[] agents) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "testSNMPAgentConnection";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(agents, "SNMPAgent", 1, methodName);
        int[] connections = new int[agents.length];
        try {
            boolean connected = false;
            String ipAddress = null;
            for (int i = 0; i < agents.length; ++i) {
                ipAddress = agents[i].getIpAddress();
                if (ipAddress == null || ipAddress.equals("")) {
                    String[] params = new String[]{"ipAddress:" + ipAddress};
                    SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.INVALID_PARAMETER, params);
                    throw new InvalidParameterException(1, tpcMsg);
                }
                connected = FabricManagerService.getSNMPAgentManagerProxy().ping(ipAddress);
                connections[i] = connected ? 0 : 1;
            }
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return connections;
    }

    public DeviceAgent[] getDeviceServerAgents() throws RemoteException, ServerException {
        String methodName = "getDeviceServerAgents";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Object[] msgInserts = new String[2];
        DeviceAgent[] result = null;
        try {
            result = FabricDbAccess.getDeviceAgents();
            if (result == null) {
                result = new DeviceAgent[]{};
            }
        }
        catch (Exception exc) {
            msgInserts[0] = "dbAccessor.getDeviceAgents";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error getting Device Server agents.");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        finally {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return result;
    }

    public FabricScanner[] getScannersForAgent(String aAgentId) throws RemoteException, ServerException {
        String methodName = "getScannersForAgent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Object[] msgInserts = new String[2];
        FabricScanner[] result = null;
        try {
            result = FabricDbAccess.getScannersForAgent((String)aAgentId);
            if (result == null) {
                result = new FabricScanner[]{};
            }
        }
        catch (Exception exc) {
            msgInserts[0] = "dbAccessor.getScannersForAgent";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error getting Scanners for Agent with id = " + aAgentId + ".");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        finally {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return result;
    }

    private SNMPAgent checkSNMPAgentCommunity(SNMPAgent snmpAgent) {
        String methodName = "checkSNMPAgentCommunity";
        if (snmpAgent.getCommunityName() == null || snmpAgent.getCommunityName().trim().length() == 0) {
            snmpAgent.setCommunityName("public");
        }
        if (snmpAgent.getRWCommunityName() == null || snmpAgent.getRWCommunityName().trim().length() == 0) {
            snmpAgent.setRWCommunityName("private");
        }
        return snmpAgent;
    }

    private void checkIP(String ip) throws InvalidParameterException {
        String methodName = "checkIP";
        boolean validIP = false;
        validIP = ip == null ? false : (ip.trim().length() == 0 ? false : this.isIPFormatValid(ip));
        if (!validIP) {
            String[] params = new String[]{ip};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.INVALID_PARAMETER, params);
            throw new InvalidParameterException(1, tpcMsg);
        }
    }

    private boolean isIPFormatValid(String ip) {
        boolean formatValid = false;
        if (ip != null && ip.trim().length() != 0) {
            String[] rawIP = new String[4];
            int i = 0;
            int index = 0;
            int firstIndex = 0;
            while ((index = ip.indexOf(46, index)) != -1 && i < 4) {
                rawIP[i++] = ip.substring(firstIndex, index);
                firstIndex = ++index;
            }
            if (i == 3) {
                rawIP[i] = ip.substring(firstIndex);
                formatValid = true;
                while (i >= 0) {
                    block7: {
                        try {
                            if (Integer.parseInt(rawIP[i]) < 0 || Integer.parseInt(rawIP[i]) > 255) {
                                formatValid = false;
                            }
                            break block7;
                        }
                        catch (NumberFormatException nfe) {
                            formatValid = false;
                        }
                        break;
                    }
                    --i;
                }
            }
        }
        return formatValid;
    }

    public Result probeSwitchSensorAndEventData(String switchId) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "probeSwitchSensorAndEventData";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Result result = new Result();
        Object[] msgInserts = new String[2];
        Hashtable properties = new Hashtable();
        if (switchId == null) {
            msgInserts[0] = "switchId";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.MISSING_PARAM, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Parameter error.  Missing a switch Id.");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])msgInserts));
        }
        String[] ipAddresses = new String[1];
        String ipAddress = null;
        String[] requestSwitchIds = new String[]{switchId};
        String[] requestAttributes = new String[]{"IP_ADDRESS"};
        try {
            ipAddresses[0] = ipAddress = (String)FabricDbAccess.getSwitchAttributes((String[])requestSwitchIds, (String[])requestAttributes)[0].get("IP_ADDRESS");
        }
        catch (Exception exc) {
            msgInserts[0] = "dbAccessor.getSwitchAttributes";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error getting IP addresss for the switch id.");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        try {
            SensorEventScanner sensorScanner = new SensorEventScanner();
            Object[] resultObj = new Object[1];
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Calling SensorEventScanner with IP = " + ipAddresses[0]);
            }
            resultObj[0] = sensorScanner.invoke("Sensor Event Scanner", ipAddresses).getData();
            result.setResults(resultObj);
            result.setRc(0);
        }
        catch (Exception exc2) {
            msgInserts[0] = "sensorEventScanner.invoke";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error getting Sensor and Event data for IP addresss." + ipAddresses[0]);
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc2);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public AsyncResult discoverFabrics(String[] agentIds, int[] agentType) throws ServerException, InvalidParameterException {
        int a;
        String methodName = "discoverFabrics";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String[] msgInserts = new String[2];
        ArrayList<String> agentList = new ArrayList<String>();
        ArrayList<Integer> agentTypeList = new ArrayList<Integer>();
        if (agentIds != null) {
            for (a = 0; a < agentIds.length; ++a) {
                agentList.add(agentIds[a]);
            }
        }
        if (agentType != null) {
            for (a = 0; a < agentType.length; ++a) {
                agentTypeList.add(new Integer(agentType[a]));
            }
        }
        Hashtable<String, ArrayList<Object>> properties = new Hashtable<String, ArrayList<Object>>();
        properties.put("AGENTS", agentList);
        properties.put("AGENT_TYPES", agentTypeList);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Attempting discover of agents.");
        }
        String request = FabricManagerService.getDiscoverServiceProxy().discover(Discover.probeFabricAgents, properties);
        AsyncResult result = FabricManagerService.getDiscoverServiceProxy().getJobStatus(request);
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{agentIds, agentType});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (AsyncResult)result);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)result);
        }
        return result;
    }

    public AsyncResult probeFabrics(String[] aFabricID) throws ServerException, InvalidParameterException {
        String methodName = "probeFabrics";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        AsyncResult result = null;
        Object[] msgInserts = new String[2];
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        if (aFabricID == null) {
            aFabricID = new String[]{};
        }
        properties.put("FABRICS", aFabricID);
        try {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Attempting probe Fabric with Id = " + aFabricID);
            }
            String request = FabricManagerService.getDiscoverServiceProxy().discover("ProbeFabrics", properties);
            result = FabricManagerService.getDiscoverServiceProxy().getJobStatus(request);
        }
        catch (Exception exc) {
            msgInserts[0] = "ProbeFabrics";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error during discover(ProbeFabrics) on fabric " + aFabricID + ".");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{aFabricID});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (AsyncResult)result);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public static IDiscover getDiscoverServiceProxy() {
        if (discoverServiceProxy == null) {
            discoverServiceProxy = (IDiscover)FabricActivator._serviceHelper.bindLocal("DiscoverService");
        }
        return discoverServiceProxy;
    }

    public static ISNMPAgentManager getSNMPAgentManagerProxy() {
        if (SNMPAgentManagerProxy == null) {
            SNMPAgentManagerProxy = (ISNMPAgentManager)FabricActivator._serviceHelper.bindLocal("SNMPAgentManager");
        }
        return SNMPAgentManagerProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFabrics(HashMap attributes) throws ServerException, InvalidParameterException {
        String methodName = "getFabrics";
        String[] fabricIds = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (attributes != null && !attributes.isEmpty()) {
            this.validateParam(attributes.keySet().toArray(new String[1]), FabricManagerConstants.FABRIC_ATTRS, 1, FabricMsgConsts.ATTRIBUTE_NOT_FOUND, methodName);
        }
        try {
            fabricIds = FabricDbAccess.getFabrics((HashMap)attributes);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return fabricIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap[] getFabricAttributes(String[] fabricIDs, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getFabricAttributes";
        HashMap[] fabricAttrs = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(fabricIDs, "fabricIDs", 1, methodName);
        String[] allFabrics = this.getFabrics(null);
        this.validateParam(fabricIDs, allFabrics, 1, FabricMsgConsts.FABRIC_NOT_FOUND, methodName);
        if (attribList != null && attribList.length > 0) {
            this.validateParam(attribList, FabricManagerConstants.FABRIC_ATTRS, 2, FabricMsgConsts.ATTRIBUTE_NOT_FOUND, methodName);
        } else {
            attribList = FabricManagerConstants.FABRIC_ATTRS;
        }
        try {
            fabricAttrs = FabricDbAccess.getFabricAttributes((String[])fabricIDs, (String[])attribList);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return fabricAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getComputers(HashMap attributes) throws ServerException, InvalidParameterException {
        String methodName = "getComputers";
        String[] computerIds = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        if (attributes != null && !attributes.isEmpty()) {
            this.validateParam(attributes.keySet().toArray(new String[0]), FabricManagerConstants.COMPUTER_ATTRS, 1, FabricMsgConsts.ATTRIBUTE_NOT_FOUND, methodName);
        }
        try {
            computerIds = FabricDbAccess.getComputers((HashMap)attributes);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return computerIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap[] getComputerAttributes(String[] computerNames, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getComputerAttributes";
        HashMap[] computerAttrs = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(computerNames, "computerNames", 1, methodName);
        String[] allComputers = this.getComputers(null);
        this.validateParam(computerNames, allComputers, 1, FabricMsgConsts.COMPUTER_NOT_FOUND, methodName);
        if (attribList != null && attribList.length > 0) {
            this.validateParam(attribList, FabricManagerConstants.COMPUTER_ATTRS, 2, FabricMsgConsts.ATTRIBUTE_NOT_FOUND, methodName);
        } else {
            attribList = FabricManagerConstants.COMPUTER_ATTRS;
        }
        try {
            computerAttrs = FabricDbAccess.getComputerAttributes((String[])computerNames, (String[])attribList);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return computerAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPortsForComputer(String computerName, HashMap attributes) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getPortsForComputer";
        String[] portIds = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(computerName, "computerName", 1, methodName);
        boolean bExists = false;
        try {
            bExists = FabricDbAccess.verifyComputer((String)computerName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!bExists) {
            this.throwInvalidParameterException(computerName, 1, FabricMsgConsts.COMPUTER_NOT_FOUND, methodName);
        }
        if (attributes != null && !attributes.isEmpty()) {
            this.validateParam(attributes.keySet().toArray(new String[0]), FabricManagerConstants.PORT_ATTRS, 1, FabricMsgConsts.ATTRIBUTE_NOT_FOUND, methodName);
        }
        try {
            portIds = FabricDbAccess.getPortsForComputer((String)computerName, (HashMap)attributes);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return portIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSwitches(String fabricID, HashMap attributes) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getSwitches";
        String[] switchIds = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        boolean bExists = false;
        try {
            bExists = FabricDbAccess.verifyFabric((String)fabricID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!bExists) {
            this.throwInvalidParameterException(fabricID, 1, FabricMsgConsts.FABRIC_NOT_FOUND, methodName);
        }
        if (attributes != null && !attributes.isEmpty()) {
            this.validateParam(attributes.keySet().toArray(new String[0]), FabricManagerConstants.SWITCH_ATTRS, 1, FabricMsgConsts.ATTRIBUTE_NOT_FOUND, methodName);
        }
        try {
            switchIds = FabricDbAccess.getSwitches((String)fabricID, (HashMap)attributes);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return switchIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap[] getSwitchAttributes(String[] switchIDs, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getSwitchAttributes";
        HashMap[] switchAttrs = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(switchIDs, "switchIDs", 1, methodName);
        String[] allSwitches = null;
        try {
            allSwitches = FabricDbAccess.getSwitches(null, null);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        this.validateParam(switchIDs, allSwitches, 1, FabricMsgConsts.SWITCH_NOT_FOUND, methodName);
        if (attribList != null && attribList.length > 0) {
            this.validateParam(attribList, FabricManagerConstants.SWITCH_ATTRS, 2, FabricMsgConsts.ATTRIBUTE_NOT_FOUND, methodName);
        } else {
            attribList = FabricManagerConstants.SWITCH_ATTRS;
        }
        try {
            switchAttrs = FabricDbAccess.getSwitchAttributes((String[])switchIDs, (String[])attribList);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return switchAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPortsForSwitch(String switchID, HashMap attributes) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getPortsForSwitch";
        String[] portIds = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(switchID, "switchID", 1, methodName);
        boolean bExists = false;
        try {
            bExists = FabricDbAccess.verifySwitch((String)switchID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!bExists) {
            this.throwInvalidParameterException(switchID, 1, FabricMsgConsts.SWITCH_NOT_FOUND, methodName);
        }
        if (attributes != null && !attributes.isEmpty()) {
            this.validateParam(attributes.keySet().toArray(new String[0]), FabricManagerConstants.PORT_ATTRS, 1, FabricMsgConsts.ATTRIBUTE_NOT_FOUND, methodName);
        }
        try {
            portIds = FabricDbAccess.getPortsForSwitch((String)switchID, (HashMap)attributes);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return portIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap[] getPortAttributes(String[] portIDs, String[] attribList) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getPortAttributes";
        HashMap[] portAttrs = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(portIDs, "portIDs", 1, methodName);
        if (attribList != null && attribList.length > 0) {
            this.validateParam(attribList, FabricManagerConstants.PORT_ATTRS, 2, FabricMsgConsts.ATTRIBUTE_NOT_FOUND, methodName);
        } else {
            attribList = FabricManagerConstants.PORT_ATTRS;
        }
        for (int i = 0; i < portIDs.length; ++i) {
            String portWWN = portIDs[i];
            boolean bExists = false;
            try {
                bExists = FabricDbAccess.verifyPort((String)portWWN);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (bExists) continue;
            this.throwInvalidParameterException(portWWN, 1, FabricMsgConsts.PORT_NOT_FOUND, methodName);
        }
        try {
            portAttrs = FabricDbAccess.getPortAttributes((String[])portIDs, (String[])attribList);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return portAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getZoneSets(String fabricID, boolean activeOnly) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getZoneSets";
        String[] zonesetNames = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        boolean bExists = false;
        try {
            bExists = FabricDbAccess.verifyFabric((String)fabricID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!bExists) {
            this.throwInvalidParameterException(fabricID, 1, FabricMsgConsts.FABRIC_NOT_FOUND, methodName);
        }
        try {
            zonesetNames = FabricDbAccess.getZoneSets((String)fabricID, (boolean)activeOnly);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return zonesetNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getZones(String fabricID, String zonesetName, boolean activeOnly) throws ServerException, InvalidParameterException, MissingParameterException {
        boolean bExists;
        String methodName = "getZones";
        String[] zoneNames = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        if (zonesetName != null && !zonesetName.equals("")) {
            bExists = false;
            bExists = this.verifyZoneSet(fabricID, zonesetName);
            if (!bExists) {
                this.throwInvalidParameterException(zonesetName, 1, FabricMsgConsts.ZONESET_NOT_FOUND, methodName);
            }
        } else {
            bExists = false;
            try {
                bExists = FabricDbAccess.verifyFabric((String)fabricID);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!bExists) {
                this.throwInvalidParameterException(fabricID, 1, FabricMsgConsts.FABRIC_NOT_FOUND, methodName);
            }
        }
        try {
            zoneNames = FabricDbAccess.getZones((String)fabricID, (String)zonesetName, (boolean)activeOnly);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return zoneNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPortsInZone(String fabricID, String zoneName, boolean active) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getPortsInZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String[] ports = null;
        boolean bExists = false;
        bExists = this.verifyZone(fabricID, zoneName);
        if (!bExists) {
            this.throwInvalidParameterException(zoneName, 1, FabricMsgConsts.ZONE_NOT_FOUND, methodName);
        }
        try {
            ports = FabricDbAccess.getPortsInZone((String)fabricID, (String)zoneName, (boolean)active);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return ports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap[] getZoneMembers(String fabricID, String zoneName, boolean active) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getZoneMembers";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        HashMap[] zoneMembers = null;
        boolean bExists = false;
        bExists = this.verifyZone(fabricID, zoneName);
        if (!bExists) {
            this.throwInvalidParameterException(zoneName, 1, FabricMsgConsts.ZONE_NOT_FOUND, methodName);
        }
        try {
            zoneMembers = FabricDbAccess.getZoneMembers((String)fabricID, (String)zoneName, (boolean)active);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return zoneMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap[] getZoneMembersInZoneAlias(String fabricID, String zoneAliasName) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getZoneMembersInZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneAliasName, "zoneAliasName", 2, methodName);
        boolean bExists = false;
        try {
            bExists = FabricDbAccess.verifyFabric((String)fabricID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!bExists) {
            this.throwInvalidParameterException(fabricID, 1, FabricMsgConsts.FABRIC_NOT_FOUND, methodName);
        }
        bExists = false;
        try {
            bExists = FabricDbAccess.verifyZoneAlias((String)fabricID, (String)zoneAliasName);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        if (!bExists) {
            this.throwInvalidParameterException(fabricID, 1, FabricMsgConsts.ZONEALIAS_NOT_FOUND, methodName);
        }
        HashMap[] zoneMembers = null;
        try {
            zoneMembers = FabricDbAccess.getZoneMembersInZoneAlias((String)fabricID, (String)zoneAliasName);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return zoneMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyZoneSet(String fabricID, String zoneSetName) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "verifyZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneSetName, "zoneSetName", 2, methodName);
        boolean bExists = false;
        try {
            bExists = FabricDbAccess.verifyFabric((String)fabricID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!bExists) {
            this.throwInvalidParameterException(fabricID, 1, FabricMsgConsts.FABRIC_NOT_FOUND, methodName);
        }
        bExists = false;
        try {
            bExists = FabricDbAccess.verifyZoneSet((String)fabricID, (String)zoneSetName);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return bExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyZone(String fabricID, String zoneName) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "verifyZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneName, "zoneName", 2, methodName);
        boolean bExists = false;
        try {
            bExists = FabricDbAccess.verifyFabric((String)fabricID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!bExists) {
            this.throwInvalidParameterException(fabricID, 1, FabricMsgConsts.FABRIC_NOT_FOUND, methodName);
        }
        bExists = false;
        try {
            bExists = FabricDbAccess.verifyZone((String)fabricID, (String)zoneName);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return bExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPath[] getComputerToSubsystemDataPaths(String computerName, String subsystemName) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getComputerToSubsystemDataPaths";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.checkMandatoryParam(computerName, "computerName", 1, methodName);
        this.checkMandatoryParam(subsystemName, "subsystemName", 2, methodName);
        DataPath[] datapaths = null;
        boolean bExists = false;
        try {
            bExists = FabricDbAccess.verifyComputer((String)computerName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!bExists) {
            this.throwInvalidParameterException(computerName, 1, FabricMsgConsts.COMPUTER_NOT_FOUND, methodName);
        }
        bExists = false;
        try {
            bExists = FabricDbAccess.verifySubsystem((String)subsystemName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!bExists) {
            this.throwInvalidParameterException(subsystemName, 1, FabricMsgConsts.SUBSYSTEM_NOT_FOUND, methodName);
        }
        try {
            datapaths = FabricDbAccess.getComputerToSubsystemDataPaths((String)computerName, (String)subsystemName);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return datapaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPortsConnectedTo(String portWWN) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "getPortsConnectedTo";
        this.checkMandatoryParam(portWWN, "portWWN", 1, methodName);
        boolean bExists = false;
        try {
            bExists = FabricDbAccess.verifyPort((String)portWWN);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!bExists) {
            this.throwInvalidParameterException(portWWN, 1, FabricMsgConsts.PORT_NOT_FOUND, methodName);
        }
        String[] portIds = null;
        try {
            portIds = FabricDbAccess.getPortsConnectedTo((String)portWWN);
        }
        catch (Exception e) {
            this.throwServerException(e, methodName);
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return portIds;
    }

    private void validateParam(String[] inputList, String[] completeList, int paramNum, String msgId, String methodName) throws InvalidParameterException {
        ArrayList<String> myList = new ArrayList<String>();
        for (int i = 0; i < completeList.length; ++i) {
            myList.add(completeList[i]);
        }
        for (int j = 0; j < inputList.length; ++j) {
            if (myList.contains(inputList[j])) continue;
            Object[] msgInserts = new String[]{inputList[j]};
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, msgId, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Invalid parameter " + (String)msgInserts[0]);
            }
            throw new InvalidParameterException(paramNum, j, new SRMMessage(msgId, (String[])msgInserts));
        }
    }

    private void checkMandatoryParam(String param, String paramName, int paramNum, String methodName) throws MissingParameterException {
        if (param == null || param.equals("")) {
            Object[] msgInserts = new String[]{paramName};
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.MISSING_PARAM, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Missing parameter " + paramName);
            }
            throw new MissingParameterException(paramNum, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])msgInserts));
        }
    }

    private void checkMandatoryParam(String[] param, String paramName, int paramNum, String methodName) throws MissingParameterException {
        if (param == null || param.length == 0) {
            Object[] msgInserts = new String[]{paramName};
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.MISSING_PARAM, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Missing parameter " + paramName);
            }
            throw new MissingParameterException(paramNum, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])msgInserts));
        }
    }

    private void checkMandatoryParam(Object[] param, String paramName, int paramNum, String methodName) throws MissingParameterException {
        if (param == null || param.length == 0) {
            Object[] msgInserts = new String[]{paramName};
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.MISSING_PARAM, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Missing parameter " + paramName);
            }
            throw new MissingParameterException(paramNum, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])msgInserts));
        }
    }

    private void throwInvalidParameterException(String param, int paramNum, String msgId, String methodName) throws InvalidParameterException {
        Object[] msgInserts = new String[]{param};
        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, msgId, msgInserts);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Invalid parameter " + (String)msgInserts[0]);
        }
        throw new InvalidParameterException(paramNum, new SRMMessage(msgId, (String[])msgInserts));
    }

    private void throwServerException(Exception e, String methodName) throws ServerException {
        Object[] msgInserts = new String[]{e.getMessage()};
        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.READ_INTERNAL_ERROR, msgInserts);
        throw new ServerException(new SRMMessage(FabricMsgConsts.READ_INTERNAL_ERROR, (String[])msgInserts), (Throwable)e);
    }

    public int startTransaction(String fabricID) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "startTransaction";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "fabricID = " + fabricID);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = FabricManagerService.getZoneControllerProxy().reserve(fabricID, "E4", className, 1);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "token = " + token.toString());
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "tokenId = " + token.getTokenId());
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "jobId = " + token.getJobId());
            }
            if (reservedTokens == null) {
                reservedTokens = new Hashtable();
            }
            reservedTokens.put(fabricID, token);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Reserved Tokens = " + reservedTokens.toString());
            }
            rc = FabricManagerService.getZoneControllerProxy().startTransaction(token);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Return Code = " + rc);
            }
        }
        catch (InvalidParameterException ipe) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)ipe);
            }
            throw ipe;
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
            }
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)fabricID, (int)rc);
        return rc;
    }

    public AsyncResult commitTransaction(String fabricID) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "commitTransaction";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "fabricID = " + fabricID);
        }
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        AsyncResult result = null;
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Fabric ID not found... throwing InvalidParameterExcetpion");
                }
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Reserved token found...");
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "token = " + token.toString());
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "tokenId = " + token.getTokenId());
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "jobId = " + token.getJobId());
                }
            }
            if (token == null) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Reserved token not found... throwing TransactionExpiredException");
                }
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            result = FabricManagerService.getZoneControllerProxy().commitTransaction(token);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Return Code (commitTransaction) = " + result.getRc());
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Status (commitTransaction) = " + result.getStatus());
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "toString (commitTransaction) = " + result.toString());
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Token " + token.getTokenId() + "successfuly remove from list of reserved tokens.");
            }
        }
        catch (InvalidParameterException ipe) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)ipe);
            }
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)tee);
            }
            throw tee;
        }
        catch (InvalidTokenException ite) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)ite);
            }
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)jipe);
            }
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
            }
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)fabricID, (AsyncResult)result);
        return result;
    }

    public int release(String fabricID) throws ServerException, MissingParameterException {
        String methodName = "release";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "fabricID = " + fabricID);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        try {
            if (reservedTokens != null) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ENTRY, (Object)className, methodName, "calling release for reserved token");
                }
                Token reservedToken = (Token)reservedTokens.get(fabricID);
                rc = this.release(reservedToken);
            }
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
            }
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)fabricID, (int)rc);
        return rc;
    }

    public int rollbackTransaction(String fabricID) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "rollbackTransaction";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_ENTRY, (Object)className, methodName, fabricID);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            rc = FabricManagerService.getZoneControllerProxy().rollbackTransaction(token);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Return Code (rollbackTransaction) = " + rc);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Removing token " + token.getTokenId() + "from list of reserved tokens...");
            }
            rc = FabricManagerService.getZoneControllerProxy().release(token);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Return Code (releaseToken) = " + rc);
            }
            reservedTokens.remove(fabricID);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Token " + token.getTokenId() + "successfuly remove from list of reserved tokens.");
            }
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)fabricID, (int)rc);
        return rc;
    }

    public int createZoneSet(String fabricID, String zoneSetName) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "createZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            if (FabricDbAccess.verifyZoneSet((String)fabricID, (String)zoneSetName)) {
                String[] params = new String[]{zoneSetName};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONESET_EXISTS, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            rc = FabricManagerService.getZoneControllerProxy().createZoneSet(token, zoneSetName);
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneSetName});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int createZone(String fabricID, String zoneName, short zoneType, short zoneSubtype) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "createZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "fabricID = " + fabricID);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "zoneName = " + zoneName);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "zoneType = " + zoneType);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "zoneSubtype = " + zoneSubtype);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneName, "zoneName", 2, methodName);
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            if (FabricDbAccess.verifyZone((String)fabricID, (String)zoneName)) {
                String[] params = new String[]{zoneName};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONE_EXISTS, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            rc = FabricManagerService.getZoneControllerProxy().createZone(token, zoneName, zoneType, zoneSubtype);
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneName, Short.toString(zoneType), Short.toString(zoneSubtype)});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int addZoneToZoneSet(String fabricID, String zoneSetName, String zoneName) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "addZoneToZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(fabricID, "zoneSetName", 2, methodName);
        this.checkMandatoryParam(fabricID, "zoneName", 3, methodName);
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            rc = FabricManagerService.getZoneControllerProxy().addZoneToZoneSet(token, zoneSetName, zoneName);
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneSetName, zoneName});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int addZoneMembersToZone(String fabricID, String zoneName, String[] zoneMemberNames, short[] zoneMemberType) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "addZoneMembersToZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "fabricID = " + fabricID);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "zoneName = " + zoneName);
        }
        int rc = -999;
        boolean zoneExists = true;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneName, "zoneName", 2, methodName);
        this.checkMandatoryParam(zoneMemberNames, "zoneMemberNames", 3, methodName);
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Fabric ID not found... throwing InvalidParameterExcetpion");
                }
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            if (!FabricDbAccess.verifyZone((String)fabricID, (String)zoneName)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "zone  not found, but continue transaction");
                }
                zoneExists = false;
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Reserved token found...");
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "token = " + token.toString());
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "tokenId = " + token.getTokenId());
                }
            }
            if (token == null) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Reserved token not found... throwing TransactionExpiredException");
                }
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            HashMap[] existingZoneMembers = null;
            if (zoneExists) {
                existingZoneMembers = this.getZoneMembers(fabricID, zoneName, false);
            }
            for (int i = 0; i < zoneMemberNames.length; ++i) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "zoneMemberName = " + zoneMemberNames[i]);
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "zoneMemberType = " + zoneMemberType[i]);
                }
                if (!zoneExists || existingZoneMembers != null && !this.zoneMemberExists(zoneMemberNames[i], zoneMemberType[i], existingZoneMembers)) {
                    rc = FabricManagerService.getZoneControllerProxy().createZoneMemberSettingData(token, zoneMemberType[i], zoneMemberNames[i], (short)0, zoneName);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "rc (createZoneMemberSettingData) = " + rc);
                    }
                }
                rc = FabricManagerService.getZoneControllerProxy().addZoneMemberToZone(token, zoneName, zoneMemberNames[i], zoneMemberType[i]);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "rc (addZoneMemberToZone) = " + rc);
                }
                if (rc != 0) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Failed to add zone member " + zoneMemberNames[i] + " to zone " + zoneName);
                    }
                    break;
                }
                if (traceLogger == null || !traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Zone member " + zoneMemberNames[i] + " successfuly added to zone " + zoneName);
            }
        }
        catch (InvalidParameterException ipe) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)ipe);
            }
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)tee);
            }
            throw tee;
        }
        catch (InvalidTokenException ite) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)ite);
            }
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)jipe);
            }
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
            }
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneName, zoneMemberNames, zoneMemberType});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    private boolean zoneMemberExists(String zoneMember, short zoneMemberType, HashMap[] existingZoneMembers) {
        String methodName = "addZoneMembersToZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        boolean found = false;
        for (int i = 0; i < existingZoneMembers.length; ++i) {
            if (!existingZoneMembers[i].containsKey(zoneMember)) continue;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ENTRY, (Object)className, methodName, "Found zone member type " + zoneMember + " in database");
            }
            Integer type = (Integer)existingZoneMembers[i].get(zoneMember);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ENTRY, (Object)className, methodName, "Comparing zone member type " + zoneMemberType + " to existing zone member type " + type);
            }
            if (zoneMemberType != type.shortValue()) continue;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, " Found zone member " + zoneMember + " with type " + type + " in database");
            }
            found = true;
            break;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        return found;
    }

    public int addZoneMembersToZoneAlias(String fabricID, String zoneAliasName, String[] zoneMemberNames, short[] zoneMemberType) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "addZoneMembersToZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneAliasName, "zoneName", 2, methodName);
        this.checkMandatoryParam(zoneMemberNames, "zoneMemberNames", 3, methodName);
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            for (int i = 0; i < zoneMemberNames.length; ++i) {
                rc = FabricManagerService.getZoneControllerProxy().addZoneMemberToZoneAlias(token, zoneAliasName, zoneMemberNames[i], zoneMemberType[i]);
            }
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneAliasName, zoneMemberNames, zoneMemberType});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int removeZoneFromZoneSet(String fabricID, String zoneSetName, String zoneName) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "removeZoneFromZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(fabricID, "zoneSetName", 2, methodName);
        this.checkMandatoryParam(fabricID, "zoneName", 3, methodName);
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            if (!FabricDbAccess.verifyZoneSet((String)fabricID, (String)zoneSetName)) {
                String[] params = new String[]{zoneSetName};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONESET_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            if (!FabricDbAccess.verifyZone((String)fabricID, (String)zoneName)) {
                String[] params = new String[]{zoneName};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONE_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            rc = FabricManagerService.getZoneControllerProxy().removeZoneFromZoneSet(token, zoneSetName, zoneName);
            if (rc == 0) {
                rc = this.checkLastZoneInZoneSet(token, fabricID, zoneName);
            }
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneSetName, zoneName});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int removeZoneMembersFromZone(String fabricID, String zoneName, String[] zoneMemberNames, short[] zoneMemberType) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "removeZoneMembersFromZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "fabricID = " + fabricID);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "zoneName = " + zoneName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneName, "zoneName", 2, methodName);
        this.checkMandatoryParam(zoneMemberNames, "zoneMemberNames", 3, methodName);
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Fabric ID not found... throwing InvalidParameterExcetpion");
                }
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            if (!FabricDbAccess.verifyZone((String)fabricID, (String)zoneName)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Zone not found... throwing InvalidParameterExcetpion");
                }
                String[] params = new String[]{zoneName};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONE_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            HashMap[] allMembers = FabricDbAccess.getZoneMembers((String)fabricID, (String)zoneName, (boolean)false);
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Reserved token found...");
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "token = " + token.toString());
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "tokenId = " + token.getTokenId());
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "jobId = " + token.getJobId());
                }
            }
            if (token == null) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Reserved token not found... throwing TransactionExpiredException");
                }
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            ArrayList<String> membersRemoved = new ArrayList<String>();
            for (int i = 0; i < zoneMemberNames.length; ++i) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Removing zone member " + zoneMemberNames[i]);
                }
                if ((rc = FabricManagerService.getZoneControllerProxy().removeZoneMemberFromZone(token, zoneName, zoneMemberNames[i], zoneMemberType[i])) != 0) continue;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Successfully removed zone member " + zoneMemberNames[i]);
                }
                membersRemoved.add(zoneMemberNames[i]);
            }
            boolean bAll = true;
            for (int j = 0; j < allMembers.length; ++j) {
                if (membersRemoved.contains(allMembers[j].get("NAME"))) continue;
                bAll = false;
                break;
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Still have members in the zone");
            }
            if (bAll) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "All zone members removed");
                }
                rc = this.checkLastZoneInZoneSet(token, fabricID, zoneName);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "rc ( checkLastZoneInZoneSet) = " + rc);
                }
            }
        }
        catch (InvalidParameterException ipe) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)ipe);
            }
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)tee);
            }
            throw tee;
        }
        catch (InvalidTokenException ite) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)ite);
            }
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)jipe);
            }
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
            }
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneName, zoneMemberNames, zoneMemberType});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int removeZoneMembersFromZoneAlias(String fabricID, String zoneAliasName, String[] zoneMemberNames, short[] zoneMemberType) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "removeZoneMembersFromZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneAliasName, "zoneAliasName", 2, methodName);
        this.checkMandatoryParam(zoneMemberNames, "zoneMemberNames", 3, methodName);
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            for (int i = 0; i < zoneMemberNames.length; ++i) {
                rc = FabricManagerService.getZoneControllerProxy().removeZoneMemberFromZoneAlias(token, zoneAliasName, zoneMemberNames[i], zoneMemberType[i]);
            }
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneAliasName, zoneMemberNames, zoneMemberType});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int deleteZoneSet(String fabricID, String zoneSetName) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "deleteZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneSetName, "zoneSetName", 2, methodName);
        this.checkFabric(fabricID, methodName);
        try {
            if (!FabricDbAccess.verifyZoneSet((String)fabricID, (String)zoneSetName)) {
                String[] params = new String[]{zoneSetName};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONESET_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            rc = FabricManagerService.getZoneControllerProxy().deleteZoneSet(token, zoneSetName);
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneSetName});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int deleteZone(String fabricID, String zoneName) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "deleteZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "fabricID = " + fabricID);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "zoneName = " + zoneName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneName, "zoneName", 2, methodName);
        this.checkFabric(fabricID, methodName);
        try {
            if (!FabricDbAccess.verifyZone((String)fabricID, (String)zoneName)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Fabric ID not found... throwing InvalidParameterExcetpion");
                }
                String[] params = new String[]{zoneName};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONE_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Reserved token found... " + token.toString());
                }
            }
            if (token == null) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Reserved token not found... throwing TransactionExpiredException");
                }
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            rc = FabricManagerService.getZoneControllerProxy().deleteZone(token, zoneName);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "rc(deleteZone) = " + rc);
            }
            if (rc == 0) {
                rc = this.checkLastZoneInZoneSet(token, fabricID, zoneName);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "rc(checkLastZoneInZoneSet) = " + rc);
                }
            }
        }
        catch (InvalidParameterException ipe) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)ipe);
            }
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)tee);
            }
            throw tee;
        }
        catch (InvalidTokenException ite) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)ite);
            }
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)jipe);
            }
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
            }
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneName});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int deleteZoneAlias(String fabricID, String zoneAliasName) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "deleteZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneAliasName, "zoneAliasName", 2, methodName);
        this.checkFabric(fabricID, methodName);
        try {
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            rc = FabricManagerService.getZoneControllerProxy().deleteZoneAlias(token, zoneAliasName);
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneAliasName});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int activateZoneSet(String fabricID, String zoneSetName) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "activateZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneSetName, "zoneSetName", 2, methodName);
        this.checkFabric(fabricID, methodName);
        try {
            if (!FabricDbAccess.verifyZoneSet((String)fabricID, (String)zoneSetName)) {
                String[] params = new String[]{zoneSetName};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONESET_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            rc = FabricManagerService.getZoneControllerProxy().activateZoneSet(token, zoneSetName);
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneSetName, zoneSetName});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int deactivateZoneSet(String fabricID, String zoneSetName) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "activateZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneSetName, "zoneSetName", 2, methodName);
        this.checkFabric(fabricID, methodName);
        try {
            if (!FabricDbAccess.verifyZoneSet((String)fabricID, (String)zoneSetName)) {
                String[] params = new String[]{zoneSetName};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONESET_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            rc = FabricManagerService.getZoneControllerProxy().deactivateZoneSet(token, zoneSetName);
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneSetName});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public int createZoneAlias(String fabricID, String zoneAliasName) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "createZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "fabricID = " + fabricID);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "zoneAliasName = " + zoneAliasName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneAliasName, "zoneAliasName", 2, methodName);
        try {
            if (!FabricDbAccess.verifyFabric((String)fabricID)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Fabric ID not found... throwing InvalidParameterExcetpion");
                }
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            if (FabricDbAccess.verifyZoneAlias((String)fabricID, (String)zoneAliasName)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Zone Alias already exist... throwing InvalidParameterExcetpion");
                }
                String[] params = new String[]{zoneAliasName};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONEALIAS_EXISTS, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            Token token = null;
            if (reservedTokens != null) {
                if (reservedTokens.containsKey(fabricID)) {
                    token = (Token)reservedTokens.get(fabricID);
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Reserved token found... " + token.toString());
                }
            }
            if (token == null) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Reserved token not found... throwing TransactionExpiredException");
                }
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Creating Zone Alias...");
            }
            rc = FabricManagerService.getZoneControllerProxy().createZoneAlias(token, zoneAliasName);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Return Code = " + rc);
            }
        }
        catch (InvalidParameterException ipe) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)ipe);
            }
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)tee);
            }
            throw tee;
        }
        catch (InvalidTokenException ite) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)ite);
            }
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)jipe);
            }
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e);
            }
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneAliasName});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (int)rc);
        return rc;
    }

    public Result removePortsFromZone(String fabricID, String zoneName, String[] portWWNs) throws RemoteException, ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String methodName = "removePortsInZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        int rc = -999;
        this.checkMandatoryParam(fabricID, "fabricID", 1, methodName);
        this.checkMandatoryParam(zoneName, "zoneName", 2, methodName);
        this.checkFabric(fabricID, methodName);
        ArrayList additionalPorts = new ArrayList();
        try {
            if (!FabricDbAccess.verifyZone((String)fabricID, (String)zoneName)) {
                String[] params = new String[]{zoneName};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONE_NOT_FOUND, params);
                throw new InvalidParameterException(2, tpcMsg);
            }
            HashMap[] allMembers = FabricDbAccess.getZoneMembers((String)fabricID, (String)zoneName, (boolean)false);
            HashMap portToMember = FabricDbAccess.getPortsWithMembersInZone((String)fabricID, (String)zoneName, (boolean)false);
            Token token = null;
            if (reservedTokens != null && reservedTokens.containsKey(fabricID)) {
                token = (Token)reservedTokens.get(fabricID);
            }
            if (token == null) {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
                throw new TransactionExpiredException(tpcMsg);
            }
            ArrayList<String> membersRemoved = new ArrayList<String>();
            for (int i = 0; i < portWWNs.length; ++i) {
                String currPort = portWWNs[i];
                HashMap member = (HashMap)portToMember.get(currPort);
                if (member == null || member.isEmpty()) {
                    String[] params = new String[]{portWWNs[i]};
                    SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.ZONEMEMBER_NOT_FOUND, params);
                    throw new InvalidParameterException(3, i, tpcMsg);
                }
                String memberName = (String)member.get("NAME");
                int memberType = (Integer)member.get("TYPE");
                ArrayList allPorts = (ArrayList)member.get("AllPorts");
                if (!membersRemoved.contains(memberName)) {
                    rc = FabricManagerService.getZoneControllerProxy().removeZoneMemberFromZone(token, zoneName, memberName, (short)memberType);
                    if (rc != 0) continue;
                    membersRemoved.add(memberName);
                    allPorts.remove(currPort);
                    if (allPorts.isEmpty()) continue;
                    additionalPorts.addAll(allPorts);
                    continue;
                }
                if (!additionalPorts.contains(currPort)) continue;
                additionalPorts.remove(currPort);
            }
            boolean bAll = true;
            for (int i = 0; i < allMembers.length; ++i) {
                if (membersRemoved.contains(allMembers[i].get("NAME"))) continue;
                bAll = false;
                break;
            }
            if (bAll) {
                rc = this.checkLastZoneInZoneSet(token, fabricID, zoneName);
            }
        }
        catch (InvalidParameterException ipe) {
            throw ipe;
        }
        catch (TransactionExpiredException tee) {
            throw tee;
        }
        catch (InvalidTokenException ite) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, params);
            throw new TransactionExpiredException(tpcMsg);
        }
        catch (JobInProgressException jipe) {
            String[] params = new String[]{fabricID};
            SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, params);
            throw new TransactionInProgressException(tpcMsg);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{methodName};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        Result result = new Result();
        result.setRc(rc);
        if (!additionalPorts.isEmpty()) {
            Object[] extraPorts = additionalPorts.toArray(new String[0]);
            result.setResults(extraPorts);
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricID, zoneName, portWWNs});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (String)result.toString());
        return result;
    }

    private int checkLastZoneInZoneSet(Token token, String fabricID, String zoneName) throws Exception {
        int rc = 0;
        String[] zoneset = FabricDbAccess.getZoneSets((String)fabricID, (boolean)true);
        if (zoneset != null && zoneset.length == 1) {
            String activeZoneset = zoneset[0];
            String[] allZones = FabricDbAccess.getZones((String)fabricID, (String)activeZoneset, (boolean)true);
            if (allZones.length == 1 && allZones[0].equals(zoneName)) {
                rc = FabricManagerService.getZoneControllerProxy().deactivateZoneSet(token, activeZoneset);
            }
            if (rc == 0) {
                rc = 1;
            }
        }
        return rc;
    }

    private void checkFabric(String fabricID, String action) {
        String methodName = "checkFabric";
        boolean access = false;
        try {
            access = FabricDbAccess.verifyFabric((String)fabricID);
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
            String[] params = new String[]{action};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
        }
        if (!access) {
            try {
                String[] params = new String[]{fabricID};
                SRMMessage tpcMsg = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, params);
                throw new InvalidParameterException(1, tpcMsg);
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, (Throwable)e);
                String[] params = new String[]{action};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
            }
        }
    }

    public static IZoneControl getZoneControllerProxy() {
        if (zoneControllerProxy == null) {
            zoneControllerProxy = (IZoneControl)ControlRouter.getControllerProxy(IZoneControl.class, (ClassLoader)FabricManagerService.class.getClassLoader());
        }
        return zoneControllerProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMissingDevices(String[] entitySet) throws ServerException, InvalidParameterException {
        String methodName = "deleteMissingDevices";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Object[] msgInserts = new String[2];
        FabricManagerService fabricManagerService = this;
        synchronized (fabricManagerService) {
            try {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Calling Device Server delete missing.");
                }
                RemoveMissingProcessor missP = new RemoveMissingProcessor();
                missP.performDeletionForSelectedMissingEntities(entitySet);
            }
            catch (Exception exc) {
                msgInserts[0] = "FabricManagerService.deleteMissingDevices";
                msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
                }
                throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
            }
            String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{entitySet});
            ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (String)"");
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return;
        }
    }

    public Token reserve(String fabricId, String clientId) throws ResourceLockedException, ResourceNotAvailableException, ServerException {
        String methodName = "reserve";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Token result = null;
        Object[] msgInserts = new String[2];
        if (fabricId == null) {
            msgInserts[0] = "fabricId";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Missing parameter " + (String)msgInserts[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])msgInserts));
        }
        if (clientId == null) {
            msgInserts[0] = "clientId";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Missing parameter " + (String)msgInserts[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])msgInserts));
        }
        try {
            IZoneControl zc = FabricManagerService.getZoneControllerProxy();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Obtained ZC proxy with id " + zc.toString());
            }
            result = zc.reserve(fabricId, "E4", clientId, 1);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Reserve finished, token = " + result.toString());
            }
        }
        catch (LockedException lockedExc) {
            msgInserts[0] = fabricId;
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.FABRIC_LOCKED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)lockedExc);
            }
            throw new ResourceLockedException(new SRMMessage(FabricMsgConsts.FABRIC_LOCKED, (String[])msgInserts));
        }
        catch (NotAvailableException naExc) {
            msgInserts[0] = fabricId;
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.AGENT_UNAVAILABLE, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)naExc);
            }
            throw new ResourceNotAvailableException(new SRMMessage(FabricMsgConsts.AGENT_UNAVAILABLE, (String[])msgInserts));
        }
        catch (Exception exc) {
            msgInserts[0] = "FabricManagerService.reserve";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        String inputParms = DiskMessageHelper.toMsgString((Object)new Object[]{fabricId, clientId});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)inputParms, (String)result.toString());
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public AsyncResult setZoneInfo(Token token, ZoneDefinition definition, int zone_db_code) throws ResourceNotAvailableException, ResourceLockedException, InvalidTokenException, JobInProgressException, ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "setZoneInfo";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        AsyncResult result = null;
        Object[] msgInserts = new String[2];
        if (token == null) {
            msgInserts[0] = "token";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Missing parameter " + (String)msgInserts[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])msgInserts));
        }
        if (definition == null) {
            msgInserts[0] = "definition";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Missing parameter " + (String)msgInserts[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])msgInserts));
        }
        try {
            IZoneControl zc = FabricManagerService.getZoneControllerProxy();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Obtained ZC proxy with id " + zc.toString());
            }
            result = zc.setZoneInfo(token, definition, zone_db_code);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "setZoneInfo finished, Result = " + result.toString());
            }
        }
        catch (org.eclipse.aperi.control.interfaces.InvalidTokenException invTokExc) {
            msgInserts[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.TOKEN_EXPIRED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)invTokExc);
            }
            throw new InvalidTokenException(new SRMMessage(FabricMsgConsts.TOKEN_EXPIRED, (String[])msgInserts));
        }
        catch (org.eclipse.aperi.control.interfaces.JobInProgressException jipExc) {
            msgInserts[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.JOB_IN_PROGRESS, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)jipExc);
            }
            throw new JobInProgressException(new SRMMessage(FabricMsgConsts.JOB_IN_PROGRESS, (String[])msgInserts));
        }
        catch (Exception exc) {
            msgInserts[0] = "FabricManagerService.setZoneInfo";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)"", (AsyncResult)result);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public int release(Token token) {
        String methodName = "setZoneInfo";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        int result = 0;
        Object[] msgInserts = new String[2];
        if (token == null) {
            msgInserts[0] = "token";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Missing parameter " + (String)msgInserts[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])msgInserts));
        }
        try {
            IZoneControl zc = FabricManagerService.getZoneControllerProxy();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Obtained ZC proxy with id " + zc.toString());
            }
            result = zc.release(token);
            if (reservedTokens != null) {
                Enumeration keys = reservedTokens.keys();
                while (keys.hasMoreElements()) {
                    String fabricID = (String)keys.nextElement();
                    Token reservedToken = (Token)reservedTokens.get(fabricID);
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Comparing release token " + token.toString() + " to reserved token (" + fabricID + ") " + reservedToken.toString());
                    }
                    if (!token.equals((Object)reservedToken)) continue;
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Removing token " + token.toString() + " for fabric " + fabricID + " from list of reserved tokens.");
                    }
                    reservedTokens.remove(fabricID);
                    break;
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "release finished, result = " + result);
            }
        }
        catch (Exception exc) {
            msgInserts[0] = "FabricManagerService.release";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)token.toString(), (int)result);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public AsyncResult testZoneControlCapabilities(Token token) throws ResourceNotAvailableException, ResourceLockedException, InvalidTokenException, JobInProgressException, ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "testZoneControlCapabilities";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        AsyncResult result = null;
        Object[] msgInserts = new String[2];
        if (token == null) {
            msgInserts[0] = "token";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Missing parameter " + (String)msgInserts[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])msgInserts));
        }
        try {
            IZoneControl zc = FabricManagerService.getZoneControllerProxy();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Obtained ZC proxy with id " + zc.toString());
            }
            result = zc.ping(token);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "release finished, result = " + result);
            }
        }
        catch (NotAvailableException naExc) {
            msgInserts[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.AGENT_UNAVAILABLE, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)naExc);
            }
            throw new ResourceNotAvailableException(new SRMMessage(FabricMsgConsts.AGENT_UNAVAILABLE, (String[])msgInserts));
        }
        catch (org.eclipse.aperi.control.interfaces.InvalidTokenException invTokExc) {
            msgInserts[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.TOKEN_EXPIRED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)invTokExc);
            }
            throw new InvalidTokenException(new SRMMessage(FabricMsgConsts.TOKEN_EXPIRED, (String[])msgInserts));
        }
        catch (org.eclipse.aperi.control.interfaces.JobInProgressException jipExc) {
            msgInserts[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.JOB_IN_PROGRESS, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)jipExc);
            }
            throw new JobInProgressException(new SRMMessage(FabricMsgConsts.JOB_IN_PROGRESS, (String[])msgInserts));
        }
        catch (Exception exc) {
            msgInserts[0] = "FabricManagerService.testZoneControlCapabilities";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public AsyncResult discoverCIMOMs(String[] DAs, Boolean localSubnet) throws RemoteException, ServerException {
        return this.discoverCIMOMs(DAs, (boolean)localSubnet);
    }

    public AsyncResult discoverCIMOMs(String[] DAs, boolean localSubnet) throws RemoteException, ServerException {
        String methodName = "discoverCIMOMS";
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        AsyncResult result = mCM.discoverCIMOMs(DAs, localSubnet);
        HashMap<String, String> input = new HashMap<String, String>();
        if (DAs != null) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < DAs.length; ++i) {
                if (i == 0) {
                    buff.append(DAs[i]);
                    continue;
                }
                buff.append("," + DAs[i]);
            }
            input.put("DAs", buff.toString());
        }
        input.put("Local", new Boolean(localSubnet).toString());
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)input.toString(), (AsyncResult)result);
        return result;
    }

    public CIMOM[] getCIMOMs() throws RemoteException, ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.getCIMOMsWithoutPW();
    }

    public String[] getCIMOMIDs() throws RemoteException, ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.getCIMOMIDs();
    }

    public void modifyCIMOMs(CIMOM[] cimoms) throws RemoteException, ServerException {
        String methodName = "modifyCIMOMs";
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        mCM.modifyCIMOMs(cimoms);
        HashMap<String, String> input = new HashMap<String, String>();
        if (cimoms != null) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < cimoms.length; ++i) {
                if (i == 0) {
                    buff.append(cimoms[i]);
                    continue;
                }
                buff.append("," + cimoms[i]);
            }
            input.put("cimoms", buff.toString());
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)input.toString(), (String)"");
    }

    public String[] addCIMOMs(CIMOM[] cimoms) throws RemoteException, ServerException {
        String methodName = "addCIMOMs";
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        HashMap<String, String> input = new HashMap<String, String>();
        if (cimoms != null) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < cimoms.length; ++i) {
                if (i == 0) {
                    buff.append(cimoms[i]);
                    continue;
                }
                buff.append("," + cimoms[i]);
            }
            input.put("cimoms", buff.toString());
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)input.toString(), (String)"");
        return mCM.addCIMOMs(cimoms);
    }

    public void deleteCIMOMs(String[] cimoms) throws RemoteException, ServerException {
        String methodName = "deleteCIMOMs";
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        mCM.deleteCIMOMs(cimoms);
        HashMap<String, String> input = new HashMap<String, String>();
        if (cimoms != null) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < cimoms.length; ++i) {
                if (i == 0) {
                    buff.append(cimoms[i]);
                    continue;
                }
                buff.append("," + cimoms[i]);
            }
            input.put("cimoms", buff.toString());
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)input.toString(), (String)"");
    }

    public CIMOMConnectionStatus[] testCIMOMConnection(CIMOM[] cimoms) throws RemoteException, ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.testCIMOMConnection(cimoms);
    }

    public CimomAndDeviceStatus testCIMOMConnection(CIMOM[] cimoms, CIMObjectPath device) throws RemoteException, ServerException {
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        return mCM.testCIMOMConnection(cimoms, device);
    }

    public AsyncResult discoverDevicesFromCIMOM(String[] cimoms) throws ServerException, InvalidParameterException, MissingParameterException {
        String methodName = "discoverDevicesFromCIMOM";
        CIMOMManager mCM = CIMOMManager.getCIMOMManager();
        HashMap<String, String> input = new HashMap<String, String>();
        if (cimoms != null) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < cimoms.length; ++i) {
                if (i == 0) {
                    buff.append(cimoms[i]);
                    continue;
                }
                buff.append("," + cimoms[i]);
            }
            input.put("cimoms", buff.toString());
        }
        AsyncResult result = mCM.discoverDevicesFromCIMOM(cimoms);
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)methodName, (String)input.toString(), (AsyncResult)result);
        return result;
    }

    static {
        reservedTokens = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }
}

