/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric.discovery;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.OutbandScannerProperty;
import org.eclipse.aperi.discovery.tsanm.OutbandScanner;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.fabric.discovery.Discover;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

class DiscoverViaSNMP
extends DiscoverProcess {
    private static String MSG_FILE = FabricManagerConstants.MSG_FILE;
    private final String className = "DiscoverViaSNMP";
    public static final String MESSAGE_NAME = "aperi.logger.message.FabricManager";
    public static final String TRACE_NAME = "aperi.logger.trace.FabricManager";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    boolean trace = false;

    public DiscoverViaSNMP() {
        super("Discover Via SNMP", false, new String[]{"IPADDRESS", "SCANNER"}, new String[]{String[].class.getName(), String.class.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        String methodName = "process";
        String snmpCommunity = null;
        String snmpWriteCommunity = null;
        String[] ipAddress = (String[])DiscoverViaSNMP.getParameter((Map)parameters, (String)"IPADDRESS", (String)String[].class.getName());
        String scannerKey = (String)DiscoverViaSNMP.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        String scanner = (String)Discover.snmpScannerToScannerClassMapping.get(scannerKey);
        DBConnection connection = ServiceUtils.getConnection();
        String schema = connection.getSchema();
        IpTarget ipTarget = new IpTarget();
        Hashtable<ColumnInfo, String> htWhereClause = new Hashtable<ColumnInfo, String>();
        htWhereClause.put(IpTarget.getColumnInfo((String)"IP_ADDRESS"), ipAddress[0]);
        try {
            IpTarget target = IpTarget.retrieve((DBConnection)connection, htWhereClause);
            if (target != null) {
                snmpCommunity = target.getReadCommunityName();
                snmpWriteCommunity = target.getRwCommunityName();
            }
            if (snmpCommunity == null || snmpWriteCommunity == null) {
                if (this.trace) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)"DiscoverViaSNMP", "process", "Could not read SNMP Community and SNMP Write Community from the DB. Trying to read from the properties file ");
                }
                snmpCommunity = OutbandScannerProperty.getSnmpCommunityName();
                snmpWriteCommunity = OutbandScannerProperty.getSnmpWriteCommunityName();
            }
        }
        catch (Exception dbe) {
            if (this.trace) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)"DiscoverViaSNMP", "process", (Throwable)dbe);
            }
            dbe.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ignore) {}
            }
        }
        Hashtable<String, String> outbandParams = new Hashtable<String, String>();
        outbandParams.put("SCANNER", scanner);
        outbandParams.put("SNMP Community", snmpCommunity);
        outbandParams.put("SNMP Write Community", snmpWriteCommunity);
        JobInfo job = new JobInfo();
        job.setDiscoverRequest(new Integer(discoverRequest.getId()).toString());
        job.setResourceQueue(OutbandScanner.queueName);
        job.setResourceId(ipAddress[0]);
        String scannerId = this.getScannerId(parameters);
        if (scannerId == null) {
            if (this.trace) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)"DiscoverViaSNMP", "process", "Unsupported scanner type " + scanner);
            }
            return new Result(-100);
        }
        job.setRequestId(scannerId);
        job.setRequest((Response)new ObjectResponse(outbandParams, job));
        job.setTarget(ipAddress);
        JobInfo processJob = (JobInfo)job.clone();
        processJob.setResourceQueue(TSANMLegacyParser.queueName);
        job.setNextJob(processJob);
        JobEngine.getInstance().addJob(job);
        return new Result(0);
    }

    public String getScannerId(Map parameters) throws ParameterException {
        String[] ipAddress = (String[])DiscoverViaSNMP.getParameter((Map)parameters, (String)"IPADDRESS", (String)String[].class.getName());
        String scannerKey = (String)DiscoverViaSNMP.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        String scanner = (String)Discover.snmpScannerToScannerClassMapping.get(scannerKey);
        String scannerId = null;
        if (OutbandScanner.CiscoMDSScanner.equals(scanner)) {
            scannerId = "PO4:" + ipAddress[0];
        } else if (OutbandScanner.TopologyScanner.equals(scanner)) {
            scannerId = "PO2:" + ipAddress[0];
        }
        return scannerId;
    }

    static {
        String methodName = "Initialization";
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }
}

