/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric.discovery;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.fabric.discovery.Discover;
import org.eclipse.aperi.interfaces.ParameterException;

class ProbeFabricWithAgents
extends DiscoverProcess {
    public ProbeFabricWithAgents() {
        super("Probe Fabric With Agents", false, new String[]{"AGENTS"}, new String[]{ArrayList.class.getName()});
    }

    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        ArrayList agents = (ArrayList)ProbeFabricWithAgents.getParameter((Map)parameters, (String)"AGENTS", (String)ArrayList.class.getName());
        for (String[] agent : agents) {
            Hashtable<String, Object> parms = new Hashtable<String, Object>();
            if (agent[0].equals("PO2")) {
                parms.put("IPADDRESS", new String[]{agent[1], agent[4], agent[5]});
                parms.put("SCANNER", Discover.snmpTopology);
                Router.getRouter().perform(Discover.discoverViaSNMP, parms, new Integer(discoverRequest.getId()).toString());
                continue;
            }
            if (agent[0].equals("PO4")) {
                parms.put("IPADDRESS", new String[]{agent[1], agent[4], agent[5]});
                parms.put("SCANNER", Discover.snmpCisco);
                Router.getRouter().perform(Discover.discoverViaSNMP, parms, new Integer(discoverRequest.getId()).toString());
                continue;
            }
            if (agent[0].equals("PI1")) {
                parms.put("AGENT", new String[]{agent[1], agent[2]});
                parms.put("SCANNER", "Topology");
                Router.getRouter().perform(Discover.discoverViaInband, parms, new Integer(discoverRequest.getId()).toString());
                continue;
            }
            if (agent[0].equals("PI2")) {
                parms.put("AGENT", new String[]{agent[1], agent[2]});
                parms.put("SCANNER", "AttributePEOnly");
                Router.getRouter().perform(Discover.discoverViaInband, parms, new Integer(discoverRequest.getId()).toString());
                continue;
            }
            if (!agent[0].equals("DF1")) continue;
            parms.put("CIMOM", new String[]{agent[1], agent[2], agent[3], agent[4]});
            String[] requestIds = Router.getRouter().perform(Discover.discoverCimomMetadata, parms, new Integer(discoverRequest.getId()).toString());
            Router.getRouter().waitTilComplete(requestIds);
            Router.getRouter().perform(Discover.discoverFabricViaSMIS, parms, new Integer(discoverRequest.getId()).toString());
        }
        return new Result(0);
    }
}

