/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric.discovery;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;

class ProcessMissingInbandAgent
extends DiscoverProcess {
    public static final HashMap mapping = new HashMap();

    public ProcessMissingInbandAgent() {
        super("Process a Missing INBAND Agent", false, new String[]{"AGENT", "SCANNER"}, new String[]{String[].class.getName(), String.class.getName()});
    }

    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        String[] agent = (String[])ProcessMissingInbandAgent.getParameter((Map)parameters, (String)"AGENT", (String)String[].class.getName());
        String scanner = (String)ProcessMissingInbandAgent.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        JobInfo job = new JobInfo();
        job.setDiscoverRequest(new Integer(discoverRequest.getId()).toString());
        job.setResourceQueue(TSANMLegacyParser.queueName);
        job.setResourceId(agent[0]);
        String prefix = (String)mapping.get(scanner);
        if (prefix == null) {
            prefix = "Unknown";
        }
        job.setRequestId(prefix + ":" + agent[0]);
        org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response dummyResponse = new org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response(org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_INACTIVE_SCANNER, "");
        Header hdr = new Header();
        hdr.setScannerName(scanner);
        hdr.setAgentAddress(agent[0]);
        hdr.setScannerId(job.getRequestId());
        dummyResponse.setHeader(hdr);
        job.setRequest((Response)new ObjectResponse((Object)dummyResponse, job));
        job.setTarget(agent);
        JobEngine.getInstance().addJob(job);
        return new Result(0);
    }

    public String getScannerId(Map parameters) throws ParameterException {
        String[] agent = (String[])ProcessMissingInbandAgent.getParameter((Map)parameters, (String)"AGENT", (String)String[].class.getName());
        String scanner = (String)ProcessMissingInbandAgent.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        String prefix = (String)mapping.get(scanner);
        if (prefix == null) {
            throw new ParameterException("Scanner " + scanner + " not recognized.");
        }
        return prefix + ":" + agent[0];
    }

    public int getAuthoritativeReferenceType(Map parameters) throws ParameterException {
        String[] agent = (String[])ProcessMissingInbandAgent.getParameter((Map)parameters, (String)"AGENT", (String)String[].class.getName());
        String scanner = (String)ProcessMissingInbandAgent.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        String prefix = (String)mapping.get(scanner);
        if (prefix == null) {
            throw new ParameterException("Scanner " + scanner + " not recognized.");
        }
        if (prefix.equals("PI2")) {
            return 5;
        }
        return -1;
    }

    public int getAuthoritativeReferenceId(Map parameters) throws ParameterException {
        String[] agent = (String[])ProcessMissingInbandAgent.getParameter((Map)parameters, (String)"AGENT", (String)String[].class.getName());
        String scanner = (String)ProcessMissingInbandAgent.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        String prefix = (String)mapping.get(scanner);
        if (prefix == null) {
            throw new ParameterException("Scanner " + scanner + " not recognized.");
        }
        if (prefix.equals("PI2")) {
            return Integer.parseInt(agent[2]);
        }
        return -1;
    }

    static {
        mapping.put("Topology", "PI1");
        mapping.put("AttributePEOnly", "PI2");
    }
}

