/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric.discovery;

import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.discovery.tsanm.OutbandScanner;
import org.eclipse.aperi.fabric.discovery.Discover;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;

class ProcessMissingSNMPAgent
extends DiscoverProcess {
    public ProcessMissingSNMPAgent() {
        super("Process a missing SNMP agent", false, new String[]{"IPADDRESS", "SCANNER"}, new String[]{String[].class.getName(), String.class.getName()});
    }

    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        String[] ipAddress = (String[])ProcessMissingSNMPAgent.getParameter((Map)parameters, (String)"IPADDRESS", (String)String[].class.getName());
        String scannerKey = (String)ProcessMissingSNMPAgent.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        String scanner = (String)Discover.snmpScannerToScannerClassMapping.get(scannerKey);
        JobInfo job = new JobInfo();
        job.setDiscoverRequest(new Integer(discoverRequest.getId()).toString());
        job.setResourceQueue(TSANMLegacyParser.queueName);
        job.setResourceId(ipAddress[0]);
        job.setRequestId(ipAddress[0] + ":" + scanner);
        org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response dummyResponse = new org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response(org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_INACTIVE_SCANNER, "");
        Header hdr = new Header();
        hdr.setScannerName(scanner);
        hdr.setAgentAddress(ipAddress[0]);
        hdr.setScannerId(job.getRequestId());
        dummyResponse.setHeader(hdr);
        job.setRequest((Response)new ObjectResponse((Object)dummyResponse, job));
        job.setTarget(ipAddress);
        JobEngine.getInstance().addJob(job);
        return new Result(0);
    }

    public String getScannerId(Map parameters) throws ParameterException {
        String[] ipAddress = (String[])ProcessMissingSNMPAgent.getParameter((Map)parameters, (String)"IPADDRESS", (String)String[].class.getName());
        String scannerKey = (String)ProcessMissingSNMPAgent.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        String scanner = (String)Discover.snmpScannerToScannerClassMapping.get(scannerKey);
        String scannerId = null;
        if (OutbandScanner.CiscoMDSScanner.equals(scanner)) {
            scannerId = "PO4:" + ipAddress[0];
        } else if (OutbandScanner.TopologyScanner.equals(scanner)) {
            scannerId = "PO2:" + ipAddress[0];
        }
        return scannerId;
    }
}

