/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Database;
import org.eclipse.aperi.sanmgmt.event.data.SANEvent;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

class SANEventFilter {
    private static final long serialVersionUID = 20001130L;
    protected transient ILogger msgLogger;
    protected transient ILogger traceLogger;
    static final String className = SANEventFilter.class.getName();
    private static final String TEC_EVENT = "tec";
    private static final String SNMP_TRAP = "trap";
    private static final String SUPPRESS_EVENT = "suppress";
    private static final String PUBLISH_EVENT = "publish";
    private static final String UNSPECIFIED = "unspecified";
    private static String severity = null;
    private static String entityType = null;
    private static String eventCategory = null;
    private static String uniqueId = null;
    static final String EVENT_ACTION = "EVENT_ACTION";
    DBPreparedStatement stmt;
    DBConnection connection;
    private static SANEventFilter instance = new SANEventFilter();

    public static SANEventFilter getInstance() {
        return instance;
    }

    private SANEventFilter() {
        block5: {
            this.msgLogger = null;
            this.traceLogger = null;
            this.stmt = null;
            this.connection = null;
            String methodName = "SANEventFilter";
            this.traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.event");
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, "SANEventFilter");
            }
            this.msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.event");
            if (this.msgLogger != null) {
                this.msgLogger.setMessageFile("org.eclipse.aperi.sanmgmt.event.resources.SANEventService");
            }
            Database db = new Database("", "", "");
            db.setAutoCommit(true);
            try {
                this.connection = db.getConnection();
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "SANEventFilter", (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block5;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "SANEventFilter", (Throwable)e);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "SANEventFilter");
        }
    }

    private void getTECAttributes(SANEvent sanEvent) {
        String methodName = "getTECAttributes";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "getTECAttributes");
        }
        String tecEvent = sanEvent.serializedTEC;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "getTECAttributes", "Event Filter received TEC event: " + tecEvent);
            String msg = "tecMessage = " + sanEvent.tecMessage + ";\n" + "tecMessageId = " + sanEvent.tecMessageId + ";\n" + "tecComponent = " + sanEvent.tecComponent + ";\n" + "tecFunction = " + sanEvent.tecFunction + ";\n" + "tecHostName = " + sanEvent.tecHostName + ";\n" + "tecIPAddress = " + sanEvent.tecIPAddress + ";\n" + "tecSeverity = " + sanEvent.tecSeverity + ".\n";
            String messageInfo = "Received an event with the following data:\n" + msg;
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "getTECAttributes", messageInfo);
        }
        Hashtable eventAttributes = sanEvent.getTECAttributes();
        severity = null;
        eventCategory = null;
        entityType = null;
        uniqueId = null;
        severity = sanEvent.tecSeverity.toLowerCase();
        eventCategory = sanEvent.getTECEventClass();
        if (eventAttributes != null) {
            entityType = (String)eventAttributes.get("entityType");
            uniqueId = (String)eventAttributes.get("uniqueId");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "getTECAttributes", "severity = " + severity + " category = " + eventCategory + " type = " + entityType + " uniqueId = " + uniqueId);
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "getTECAttributes");
        }
    }

    boolean snmpTrapSuppressed(SANEvent sanEvent) {
        String methodName = "snmpTrapSuppressed";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "snmpTrapSuppressed");
        }
        this.getTECAttributes(sanEvent);
        boolean suppressed = this.eventSuppressed(SNMP_TRAP);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "snmpTrapSuppressed", (Object)("suppressed = " + suppressed));
        }
        return suppressed;
    }

    boolean tecEventSuppressed(SANEvent sanEvent) {
        String methodName = "tecEventSuppressed";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "tecEventSuppressed");
        }
        this.getTECAttributes(sanEvent);
        boolean suppressed = this.eventSuppressed(TEC_EVENT);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "tecEventSuppressed", (Object)("suppressed = " + suppressed));
        }
        return suppressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean eventSuppressed(String eventType) {
        String methodName = "eventSuppressed";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "eventSuppressed");
        }
        String action = null;
        boolean suppressEvent = false;
        DBResultSet resultSet = null;
        try {
            String query = new String(" SELECT ITSANM.SANM_EVENT_FILTER.RULE_ID AS RULE_ID, ITSANM.SANM_EVENT_ACTION.NAME AS EVENT_ACTION FROM ITSANM.SANM_EVENT_FILTER, ITSANM.SANM_EVENT_ACTION  WHERE ((ITSANM.SANM_EVENT_ACTION.ID = ITSANM.SANM_EVENT_FILTER.EVENT_ACTION)  AND (ITSANM.SANM_EVENT_FILTER.EVENT_SEVERITY =  (SELECT ID FROM ITSANM.SANM_EVENT_SEVERITY WHERE NAME = ?)  OR ITSANM.SANM_EVENT_FILTER.EVENT_SEVERITY =  (SELECT ID FROM ITSANM.SANM_EVENT_SEVERITY WHERE NAME = 'unspecified')  OR (ITSANM.SANM_EVENT_FILTER.EVENT_SEVERITY IS NULL))  AND (ITSANM.SANM_EVENT_FILTER.EVENT_CATEGORY =   (SELECT ID FROM ITSANM.SANM_EVENT_CATEGORY WHERE NAME = ?)  OR ITSANM.SANM_EVENT_FILTER.EVENT_CATEGORY =   (SELECT ID FROM ITSANM.SANM_EVENT_CATEGORY WHERE NAME = 'unspecified')  OR (ITSANM.SANM_EVENT_FILTER.EVENT_CATEGORY IS NULL))  AND (ITSANM.SANM_EVENT_FILTER.EVENT_TYPE =  (SELECT ID FROM ITSANM.SANM_EVENT_TYPE WHERE NAME = ?)  OR ITSANM.SANM_EVENT_FILTER.EVENT_TYPE =  (SELECT ID FROM ITSANM.SANM_EVENT_TYPE WHERE NAME = 'unspecified')  OR (ITSANM.SANM_EVENT_FILTER.EVENT_TYPE IS NULL))  AND (ITSANM.SANM_EVENT_FILTER.UNIQUE_ID = ?  OR (ITSANM.SANM_EVENT_FILTER.UNIQUE_ID IS NULL))  AND (ITSANM.SANM_EVENT_FILTER.ENTITY_TYPE =  (SELECT ID FROM ITSANM.SANM_DEV_KEYS WHERE NAME = ?)  OR (ITSANM.SANM_EVENT_FILTER.ENTITY_TYPE IS NULL)))  ORDER BY RULE_ID ASC");
            if (this.stmt == null) {
                this.stmt = this.connection.prepareStatement(query);
            }
            if (this.stmt != null) {
                this.stmt.setString(1, severity);
                this.stmt.setString(2, eventCategory);
                this.stmt.setString(3, eventType);
                this.stmt.setString(4, uniqueId);
                this.stmt.setString(5, entityType);
                resultSet = this.stmt.executeQuery();
                if (resultSet != null && resultSet.next()) {
                    action = resultSet.getString(EVENT_ACTION);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "eventSuppressed", "action = " + action);
                    }
                    if (action != null && action.equalsIgnoreCase(SUPPRESS_EVENT)) {
                        suppressEvent = true;
                    }
                }
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "eventSuppressed", (Throwable)e);
            if (this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "eventSuppressed", (Throwable)e);
            }
        }
        finally {
            block21: {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, "eventSuppressed", (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block21;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "eventSuppressed", (Throwable)e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "eventSuppressed");
        }
        return suppressEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBResultSet executeQuery(DBPreparedStatement stmt) {
        String methodName = "executeQuery";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int retry = 3;
        boolean done = false;
        DBResultSet rs = null;
        while (!done && retry > 0) {
            rs = null;
            try {
                rs = stmt.executeQuery();
                done = true;
            }
            catch (SQLException e) {
                if (--retry != 0) continue;
                e.printStackTrace();
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                retry = 0;
            }
            finally {
                try {
                    this.connection.commit();
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        if (done) {
            return rs;
        }
        return null;
    }
}

