/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmpagent.manager;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPConfig;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPScanner;
import org.eclipse.aperi.discovery.snmp.scanner.TopologyScanner;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.OutbandScannerProperty;
import org.eclipse.aperi.fabric.FabricActivator;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.infrastructure.database.objects.Scanner;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmpagent.manager.DiscoverAgents;
import org.eclipse.aperi.snmpagent.manager.data.IPCapability;
import org.eclipse.aperi.snmpagent.manager.interfaces.ISNMPAgentManager;
import org.eclipse.aperi.snmpagent.manager.util.SqlUtil;
import org.eclipse.aperi.util.SRMCrypto;

public class SNMPAgentManager
implements ISNMPAgentManager,
IService,
ICliDispatcher,
Runnable {
    public static String className = SNMPAgentManager.class.getName();
    public static final String MESSAGE_NAME = "aperi.logger.message.SnmpAgentManager";
    public static final String TRACE_NAME = "aperi.logger.trace.SnmpAgentManager";
    public static String MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.MibQueryEngineTMS";
    public Status status = new Status(5, 6);
    public static String DEFAULT_SNMP_COMMUNITY = "public";
    public static String DEFAULT_SNMP_RW_COMMUNITY = "private";
    private Thread iWorkerThread;
    private boolean doingRefresh = false;
    private int pollingInterval;
    private static SNMPAgentManager snmpAgentManager = null;
    private static final HashMap capabilityMapping = new HashMap();
    private static final HashMap capabilityTypeName = new HashMap();
    private static boolean trace = true;
    private static boolean message = true;
    private OutbandScannerProperty outbandProp = null;
    private Hashtable activeCapabilityScans = new Hashtable();
    private static Object acsLock = new Object();
    protected static Object lock = new Object();
    private static final String ADD = "-add";
    private static final String UID = "-uid";
    private static final String PWD = "-pwd";
    private static final String TIMEOUT = "-timeout";
    private static final String SWITCHFILTER = "-switchfilter";
    public static final int SUCCESS = 0;
    public static final int INVALID_BROCADE_ID_PW = 2;
    public static final int NOT_BROCADE_SWITCH = 3;
    public static final int CANNOT_LOAD_SCANNER = -25;
    public static final int CANNOT_VALIDATE_LINUX_ID_PW = -42;
    public static IEventMonitorService monitorServiceProxy;
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    public SNMPAgentManager thisSnmpMgr = null;
    protected boolean isShuttingDown = false;
    private String[] SCANNERS = new String[]{"PO2", "PO3", "PO4"};

    public void initialize() {
        String methodName = "initialize";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        acsLock = new Object();
        capabilityMapping.put("PO2", new Integer(1));
        capabilityMapping.put("PO3", new Integer(4));
        capabilityMapping.put("PO4", new Integer(32));
        capabilityTypeName.put(new Integer(1), "Topology");
        capabilityTypeName.put(new Integer(4), "Brocade");
        capabilityTypeName.put(new Integer(2), "Statistics");
        capabilityTypeName.put(new Integer(32), "CiscoMDS");
        monitorServiceProxy = SNMPAgentManager.getMonitorServiceProxy();
        this.iWorkerThread = new Thread((Runnable)this, "IpTarget Monitor");
        this.iWorkerThread.start();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public static IEventMonitorService getMonitorServiceProxy() {
        if (monitorServiceProxy == null) {
            monitorServiceProxy = (IEventMonitorService)FabricActivator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return monitorServiceProxy;
    }

    private int getMonitorInterval() {
        String methodName = "getMonitorInterval";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int pollingInterval = Integer.valueOf("60000");
        if (this.outbandProp == null) {
            this.outbandProp = new OutbandScannerProperty();
        }
        if (this.outbandProp != null) {
            pollingInterval = this.outbandProp.getOutbandAgentMonitorInterval();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Outband IpTarget monitor interval is " + pollingInterval + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return pollingInterval;
    }

    public String getDescription() {
        return "Service that monitors SNMP Agents";
    }

    public String getName() {
        return "SNMPAgentManager";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("SNMPAgentManager_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("SNMPAgentManager_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public boolean startup() {
        String methodName;
        block5: {
            methodName = "startup";
            boolean started = false;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            this.status.setRunStatus(9);
            try {
                SnmpV1API.initialize((String)"", (int)-1, (boolean)true, null, (String)"org.eclipse.aperi.discovery.snmp.scanner.SNMPConfig", (ClassLoader)SNMPConfig.class.getClassLoader());
            }
            catch (Exception snmpE) {
                if (message) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)snmpE);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block5;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)snmpE);
            }
        }
        this.initialize();
        this.status.setRunStatus(8);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dispatch(String method, String[] args) {
        String methodName = "dispatch";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, methodName);
        }
        StringBuffer output = new StringBuffer();
        boolean failed = false;
        if (method.equalsIgnoreCase("help")) {
            output.append("\nThe SNMPAgentManager CLI supports the following commands:\n");
            output.append("\n");
            output.append("    addTargets    targetIp1 targetIp2 ... targetIpn\n");
            output.append("    removeTargets targetIp1 targetIp2 ... targetIpn\n");
            output.append("    setUserIdPassword  targetIp userId password\n");
            output.append("    updateCapabilities targetIp capability1 capability2 capability3\n");
            output.append("\n");
            output.append("    ping targetIp\n");
            output.append("\n");
            output.append("    discoverAgents startingIp [-add -t <timeoutInMillis> -switchFilter <ON|OFF> -uid <userid> -pwd <password> ]\n");
            output.append("\n");
        } else if (method.equalsIgnoreCase("addTargets")) {
            String[] targets = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                targets[i] = args[i];
            }
            this.addTargets(targets);
            output.append("Added " + args.length + " Outband agents");
        } else if (method.equalsIgnoreCase("removeTargets")) {
            String[] targets = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                targets[i] = args[i];
            }
            this.removeTargets(targets);
            output.append("Removed " + args.length + " Outband agents");
        } else if (method.equalsIgnoreCase("setUserIdPassword")) {
            if (args.length < 1) {
                output.append("Invalid number of parameters");
            } else {
                String address = args[0];
                String userId = null;
                String password = null;
                if (args.length > 1) {
                    userId = args[1];
                    if (args.length > 2) {
                        password = args[2];
                    }
                }
                if (password != null) {
                    try {
                        password = SRMCrypto.encrypt(password);
                    }
                    catch (Exception e) {
                        output.append("Could not encrypt the password.  The userId and password were not set for " + address);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, methodName);
                        }
                        return output.toString();
                    }
                }
                this.setUserIdPassword(address, userId, password);
                output.append("The userId and password were set for " + address);
            }
        } else if (method.equalsIgnoreCase("updateCapabilities")) {
            if (args.length < 1) {
                output.append("Invalid number of parameters");
            } else {
                String address = this.getIpAddress(args[0]);
                String[] devTypes = new String[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    devTypes[i - 1] = args[i];
                }
                boolean result = false;
                Object e = lock;
                synchronized (e) {
                    result = SqlUtil.updateCapability((String)address, (String[])devTypes);
                }
                output.append("The capabilities for " + address + " were ");
                if (!result) {
                    output.append("not ");
                }
                output.append("changed.");
            }
        } else if (method.equalsIgnoreCase("ping")) {
            if (args.length != 1) {
                output.append("Invalid number of parameters");
            } else {
                String address = args[0];
                boolean ok = this.ping(address);
                output.append("The ping of " + address + " was ");
                if (!ok) {
                    output.append("not ");
                }
                output.append("successful.");
            }
        } else if (method.equalsIgnoreCase("discoverAgents")) {
            if (args.length < 1) {
                output.append("Invalid number of parameters");
            } else {
                String startingIp = args[0].trim();
                Object[] address = new String[4];
                Vector<String> addresses = new Vector<String>();
                StringTokenizer st = new StringTokenizer(startingIp.trim(), ".");
                while (st.hasMoreTokens()) {
                    addresses.addElement(st.nextToken());
                    if (addresses.size() != 3) continue;
                }
                if (addresses.size() < 3) {
                    output.append("\n Invalid Ip address entered.");
                } else {
                    int timeout = 500;
                    boolean addToDatabase = false;
                    boolean setUserIdPassword = false;
                    String userId = null;
                    String password = null;
                    boolean switchFilterOn = true;
                    for (int i = 1; i < args.length; ++i) {
                        if (args[i].equalsIgnoreCase(ADD)) {
                            addToDatabase = true;
                            continue;
                        }
                        if (args[i].equalsIgnoreCase(SWITCHFILTER)) {
                            if (i + 1 >= args.length || args[i + 1].equalsIgnoreCase(ADD) || args[i + 1].equalsIgnoreCase(UID) || args[i + 1].equalsIgnoreCase(PWD) || args[i + 1].equalsIgnoreCase(SWITCHFILTER) || args[i + 1].equalsIgnoreCase(TIMEOUT)) continue;
                            switchFilterOn = args[++i].equalsIgnoreCase("ON");
                            continue;
                        }
                        if (args[i].equalsIgnoreCase(TIMEOUT)) {
                            if (i + 1 >= args.length || args[i + 1].equalsIgnoreCase(ADD) || args[i + 1].equalsIgnoreCase(UID) || args[i + 1].equalsIgnoreCase(SWITCHFILTER) || args[i + 1].equalsIgnoreCase(PWD) || args[i + 1].equalsIgnoreCase(TIMEOUT)) continue;
                            timeout = Integer.valueOf(args[++i]);
                            continue;
                        }
                        if (args[i].equalsIgnoreCase(UID)) {
                            setUserIdPassword = true;
                            if (i + 1 >= args.length || args[i + 1].equalsIgnoreCase(ADD) || args[i + 1].equalsIgnoreCase(UID) || args[i + 1].equalsIgnoreCase(SWITCHFILTER) || args[i + 1].equalsIgnoreCase(PWD) || args[i + 1].equalsIgnoreCase(TIMEOUT)) continue;
                            userId = args[++i];
                            continue;
                        }
                        if (!args[i].equalsIgnoreCase(PWD)) continue;
                        setUserIdPassword = true;
                        if (i + 1 >= args.length) continue;
                        if (!(args[i + 1].equalsIgnoreCase(ADD) || args[i + 1].equalsIgnoreCase(UID) || args[i + 1].equalsIgnoreCase(SWITCHFILTER) || args[i + 1].equalsIgnoreCase(PWD) || args[i + 1].equalsIgnoreCase(TIMEOUT))) {
                            password = args[++i];
                        }
                        if (password == null) continue;
                        try {
                            password = SRMCrypto.encrypt(password);
                            continue;
                        }
                        catch (Exception e) {
                            output.append("Could not encrypt the password.");
                            return output.toString();
                        }
                    }
                    addresses.copyInto(address);
                    String[] agents = DiscoverAgents.scan((String[])address, timeout, switchFilterOn);
                    if (agents.length > 0) {
                        int i;
                        if (addToDatabase) {
                            if (setUserIdPassword) {
                                for (i = 0; i < agents.length; ++i) {
                                    this.setUserIdPassword(agents[i], userId, password);
                                }
                            } else {
                                this.addTargets(agents);
                            }
                        }
                        output.append("\n  Outband agents found:");
                        for (i = 0; i < agents.length; ++i) {
                            String ip = agents[i];
                            String hostName = "";
                            try {
                                InetAddress ia = InetAddress.getByName(ip);
                                hostName = ia.getHostName();
                            }
                            catch (Exception ipe) {
                                // empty catch block
                            }
                            output.append("\n    " + ip + "   " + hostName);
                        }
                    } else {
                        output = output.append("\n  No outband agents found.");
                    }
                }
            }
        } else {
            output.append("Invalid command, Valid values are set, get, addTargets, removeTargets, setUserIdPassword, updateCapabilities, getActiveOutbandScanners, ping, discover, registerScan, and registerAllScans.");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, methodName);
        }
        return output.toString();
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> roleMap = new Hashtable<String, Integer>();
        roleMap.put("SNMPAgentManager", new Integer(RoleChecker.FABRIC_ADMIN));
        return roleMap;
    }

    public String getIpAddress(String address) {
        String ipaddress;
        String methodName;
        block8: {
            methodName = "getIpAddress";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            ipaddress = address;
            try {
                InetAddress ia = InetAddress.getByName(address);
                ipaddress = ia.getHostAddress();
            }
            catch (UnknownHostException uhe) {
                if (message) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "QueryEngine_invalidIPAddress", (Object)address);
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)uhe);
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)uhe);
                }
            }
            catch (Exception se) {
                if (message) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "QueryEngine_invalidIPAddress", (Object)address);
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)se);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block8;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)se);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return ipaddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IPCapability[] getTargets() {
        String methodName = "getTargets";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Vector<IPCapability> iptV = new Vector<IPCapability>();
        Object object = lock;
        synchronized (object) {
            DBConnection connection = ServiceUtils.getConnection();
            try {
                ArrayList targets = SqlUtil.getTargets((DBConnection)connection);
                for (IpTarget target : targets) {
                    int cap;
                    IPCapability ipt;
                    block45: {
                        String ipAddress = target.getIpAddress();
                        String userId = target.getUserId();
                        String password = target.getPassword();
                        ipt = new IPCapability(ipAddress, userId, password);
                        cap = 0;
                        DBResultSet capability = null;
                        capability = SqlUtil.getCapability((DBConnection)connection, (String)ipAddress, (String[])this.SCANNERS);
                        while (capability.next()) {
                            String scanner = capability.getString("SCANNER").trim();
                            int enabled = capability.getInt("ENABLED");
                            if (enabled == 0) continue;
                            cap |= ((Integer)capabilityMapping.get(scanner)).intValue();
                        }
                        Object var17_22 = null;
                        try {
                            if (capability != null) {
                                capability.closeAll();
                            }
                            break block45;
                        }
                        catch (Exception e) {
                            if (message) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "IpTarget_getCapabilitiesError", (Object)ipAddress);
                                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                            }
                            break block45;
                        }
                        {
                            catch (Exception dbe) {
                                if (message) {
                                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "IpTarget_getCapabilitiesError", (Object)ipAddress);
                                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)dbe);
                                }
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)dbe);
                                }
                                var17_22 = null;
                                try {
                                    if (capability != null) {
                                        capability.closeAll();
                                    }
                                    break block45;
                                }
                                catch (Exception e) {
                                    if (message) {
                                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "IpTarget_getCapabilitiesError", (Object)ipAddress);
                                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                                    }
                                    if (traceLogger != null && traceLogger.isLogging()) {
                                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block46: {
                                var17_22 = null;
                                try {
                                    if (capability != null) {
                                        capability.closeAll();
                                    }
                                }
                                catch (Exception e) {
                                    if (message) {
                                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "IpTarget_getCapabilitiesError", (Object)ipAddress);
                                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                                    }
                                    if (traceLogger == null || !traceLogger.isLogging()) break block46;
                                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                                }
                            }
                            throw throwable;
                        }
                    }
                    ipt.setInitialCapabilities(cap);
                    iptV.addElement(ipt);
                }
            }
            catch (Exception dbe) {
                if (message) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "IpTarget_getTargetsError");
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)dbe);
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)dbe);
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.commit();
                    }
                    catch (SQLException ignore) {}
                    try {
                        connection.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
        }
        IPCapability[] ipt = new IPCapability[iptV.size()];
        iptV.toArray(ipt);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return ipt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IPCapability getTarget(String address) {
        String methodName = "getTarget";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        String ipAddress = address;
        String userId = null;
        String password = null;
        IPCapability ipt = null;
        DBResultSet capability = null;
        Object object = lock;
        synchronized (object) {
            block44: {
                DBConnection connection = ServiceUtils.getConnection();
                try {
                    int cap;
                    block45: {
                        IpTarget target = SqlUtil.getTarget((String)ipAddress);
                        if (target == null) break block44;
                        ipAddress = target.getIpAddress();
                        userId = target.getUserId();
                        password = target.getPassword();
                        ipt = new IPCapability(ipAddress, userId, password);
                        cap = 0;
                        capability = SqlUtil.getCapability((DBConnection)connection, (String)ipAddress, (String[])this.SCANNERS);
                        while (capability.next()) {
                            String scanner = capability.getString("SCANNER").trim();
                            int enabled = capability.getInt("ENABLED");
                            if (enabled == 0) continue;
                            cap |= ((Integer)capabilityMapping.get(scanner)).intValue();
                        }
                        Object var15_20 = null;
                        try {
                            if (capability != null) {
                                capability.closeAll();
                            }
                            break block45;
                        }
                        catch (Exception e) {
                            if (msgLogger != null) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "IpTarget_getCapabilitiesError", (Object)address);
                                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                            }
                            break block45;
                        }
                        {
                            catch (Exception dbe) {
                                if (msgLogger != null) {
                                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "IpTarget_getCapabilitiesError", (Object)address);
                                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)dbe);
                                }
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)dbe);
                                }
                                Object var15_21 = null;
                                try {
                                    if (capability != null) {
                                        capability.closeAll();
                                    }
                                    break block45;
                                }
                                catch (Exception e) {
                                    if (msgLogger != null) {
                                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "IpTarget_getCapabilitiesError", (Object)address);
                                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                                    }
                                    if (traceLogger != null && traceLogger.isLogging()) {
                                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block46: {
                                Object var15_22 = null;
                                try {
                                    if (capability != null) {
                                        capability.closeAll();
                                    }
                                }
                                catch (Exception e) {
                                    if (msgLogger != null) {
                                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "IpTarget_getCapabilitiesError", (Object)address);
                                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                                    }
                                    if (traceLogger == null || !traceLogger.isLogging()) break block46;
                                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                                }
                            }
                            throw throwable;
                        }
                    }
                    ipt.setInitialCapabilities(cap);
                }
                catch (Exception dbe) {
                    if (message) {
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "IpTarget_getTargetError", (Object)address);
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)dbe);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)dbe);
                    }
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.commit();
                        }
                        catch (SQLException ignore) {}
                        try {
                            connection.close();
                        }
                        catch (SQLException ignore) {}
                    }
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return ipt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargets(String[] targets) {
        String methodName = "addTargets";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < targets.length; ++i) {
            String host;
            String address;
            boolean added;
            block12: {
                added = false;
                address = targets[i];
                host = null;
                try {
                    InetAddress ia = InetAddress.getByName(address);
                    String ipaddress = ia.getHostAddress();
                    ia = InetAddress.getByName(ipaddress);
                    address = ipaddress;
                    host = ia.getHostName();
                }
                catch (UnknownHostException uhe) {
                    if (message) {
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "QueryEngine_invalidIPAddress", (Object)address);
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)uhe);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)uhe);
                    }
                }
                catch (Exception se) {
                    if (message) {
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "QueryEngine_invalidIPAddress", (Object)address);
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)se);
                    }
                    if (traceLogger == null || !traceLogger.isLogging()) break block12;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)se);
                }
            }
            String userId = null;
            String password = null;
            Object object = lock;
            synchronized (object) {
                added = SqlUtil.addTarget((String)host, (String)address, userId, password);
            }
            if (!added) continue;
            this.refreshCapabilities(address);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTargets(String[] targets) {
        String methodName = "removeTargets";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < targets.length; ++i) {
            String address = this.getIpAddress(targets[i]);
            IPCapability ipt = this.getTarget(address);
            boolean eventFlag = false;
            if (ipt == null) continue;
            Object object = lock;
            synchronized (object) {
                eventFlag = SqlUtil.removeTarget((String)address);
                this.ipTargetEventGenerator(address, ipt.getInitialCapabilities(), 0, eventFlag);
                SNMPScanner.removeSnmpTimeout(address);
                continue;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUserIdPassword(String target, String userId, String password) {
        String methodName = "setUserIdPassword";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        boolean checkCapabilities = false;
        String address = this.getIpAddress(target);
        String[] targets = new String[]{address};
        this.addTargets(targets);
        Object object = lock;
        synchronized (object) {
            checkCapabilities = SqlUtil.setUseridPassword((String)address, (String)userId, (String)password);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return checkCapabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performIpTargetCapabiltyScan(IPCapability ipt) {
        String methodName = "performIpTargetCapabiltyScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.refreshIpTargetCapabilities(ipt, true);
        Object object = acsLock;
        synchronized (object) {
            this.activeCapabilityScans.remove(ipt.getIpAddress());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAllIpTargetCapabilities() {
        String methodName = "refreshAllIpTargetCapabilities";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        IPCapability[] targets = this.getTargets();
        for (int i = 0; i < targets.length; ++i) {
            Object object = acsLock;
            synchronized (object) {
                if (!this.activeCapabilityScans.containsKey(targets[i].getIpAddress())) {
                    IpTargetCapabilityScan ics = new IpTargetCapabilityScan(this, targets[i]);
                    this.activeCapabilityScans.put(targets[i].getIpAddress(), ics);
                    ics.start();
                }
                continue;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCapabilities(String ipAddress) {
        IPCapability ipt;
        String methodName = "refreshCapabilities(address)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Vector caps = new Vector();
        if (ipAddress != null && (ipt = this.getTarget(ipAddress)) != null) {
            if (this.checkShutdown()) {
                return;
            }
            Object object = acsLock;
            synchronized (object) {
                if (!this.activeCapabilityScans.containsKey(ipAddress)) {
                    IpTargetCapabilityScan ics = new IpTargetCapabilityScan(this, ipt);
                    this.activeCapabilityScans.put(ipAddress, ics);
                    ics.start();
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void refreshIpTargetCapabilities(IPCapability ipt, boolean generateEvents) {
        String methodName = "refreshIpTargetCapabilities";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (ipt != null) {
            boolean result = false;
            boolean isTopology = false;
            boolean isCisco = false;
            Vector caps = new Vector();
            this.setInitialCaps(ipt.getInitialCapabilities(), caps);
            int CiscoCap = this.CiscoCapabilityScan(ipt);
            if (this.checkShutdown()) {
                return;
            }
            isCisco = CiscoCap == 1;
            int CiscoMDSCapability = this.setCapability(ipt, "PO4", caps, isCisco);
            if (CiscoMDSCapability == 1) {
                result = this.updateCapability(ipt, caps);
                this.ipTargetEventGenerator(ipt.getIpAddress(), ipt.getInitialCapabilities(), ipt.getCapabilities(), generateEvents);
            } else if (CiscoMDSCapability == 2) {
                result = this.updateCapability(ipt, caps);
                this.ipTargetEventGenerator(ipt.getIpAddress(), ipt.getInitialCapabilities(), ipt.getCapabilities(), generateEvents);
            }
            if (isCisco) {
                int brocadeCapability;
                int topologyCapability = this.setCapability(ipt, "PO2", caps, false);
                if (topologyCapability == 2) {
                    result = this.updateCapability(ipt, caps);
                    this.ipTargetEventGenerator(ipt.getIpAddress(), ipt.getInitialCapabilities(), ipt.getCapabilities(), generateEvents);
                }
                if ((brocadeCapability = this.setCapability(ipt, "PO3", caps, false)) == 2) {
                    result = this.updateCapability(ipt, caps);
                    this.ipTargetEventGenerator(ipt.getIpAddress(), ipt.getInitialCapabilities(), ipt.getCapabilities(), generateEvents);
                }
            } else {
                int topologyCapability;
                if (CiscoCap == 2) {
                    topologyCapability = this.setCapability(ipt, "PO2", caps, false);
                    if (topologyCapability == 2) {
                        result = this.updateCapability(ipt, caps);
                        this.ipTargetEventGenerator(ipt.getIpAddress(), ipt.getInitialCapabilities(), ipt.getCapabilities(), generateEvents);
                    }
                } else {
                    if (this.checkShutdown()) {
                        return;
                    }
                    isTopology = this.topologyCapabilityScan(ipt) == 1;
                    topologyCapability = this.setCapability(ipt, "PO2", caps, isTopology);
                    if (topologyCapability == 1) {
                        result = this.updateCapability(ipt, caps);
                        if (result) {
                            this.ipTargetEventGenerator(ipt.getIpAddress(), ipt.getInitialCapabilities(), ipt.getCapabilities(), generateEvents);
                        }
                    } else if (topologyCapability == 2) {
                        result = this.updateCapability(ipt, caps);
                        this.ipTargetEventGenerator(ipt.getIpAddress(), ipt.getInitialCapabilities(), ipt.getCapabilities(), generateEvents);
                    }
                }
                if (this.checkShutdown()) {
                    return;
                }
                int brocadeCapability = this.setCapability(ipt, "PO3", caps, this.BrocadeApiCapabilityScan(ipt));
                if (brocadeCapability == 1) {
                    result = this.updateCapability(ipt, caps);
                    this.ipTargetEventGenerator(ipt.getIpAddress(), ipt.getInitialCapabilities(), ipt.getCapabilities(), generateEvents);
                } else if (brocadeCapability == 2) {
                    result = this.updateCapability(ipt, caps);
                    this.ipTargetEventGenerator(ipt.getIpAddress(), ipt.getInitialCapabilities(), ipt.getCapabilities(), generateEvents);
                }
            }
            if (this.checkShutdown()) {
                return;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private int setCapability(IPCapability ipt, String scanner, Vector caps, boolean set) {
        String methodName = "setCapability";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int type = (Integer)capabilityMapping.get(scanner);
        int capability = 3;
        if (this.checkShutdown()) {
            return capability;
        }
        if (set) {
            capability = ipt.addCapability(type);
            if (!caps.contains(scanner)) {
                caps.addElement(scanner);
            }
        } else {
            capability = ipt.removeCapability(type);
            if (caps.contains(scanner)) {
                caps.removeElement(scanner);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            if (capability == 1) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Added capability " + capabilityTypeName.get(new Integer(type)) + " to IpTarget " + ipt.getIpAddress());
            } else if (capability == 2) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Removed capability " + capabilityTypeName.get(new Integer(type)) + " from IpTarget " + ipt.getIpAddress());
            } else {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "No capability change of " + capabilityTypeName.get(new Integer(type)) + " to IpTarget " + ipt.getIpAddress());
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return capability;
    }

    private void ipTargetEventGenerator(String ipAddress, int oldCap, int newCap, boolean generateEvent) {
        String methodName = "ipTargetEventGenerator";
        if (!generateEvent) {
            return;
        }
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (this.checkShutdown()) {
            return;
        }
        SNMPAgentManager.getMonitorServiceProxy();
        if (monitorServiceProxy == null) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Monitor Service is down. Unable to generate capability change event for  IpTarget " + ipAddress);
        } else {
            monitorServiceProxy.handleDeviceStateChange("DummyProcessId", IpTarget.getTablename(), ipAddress, oldCap, newCap);
        }
    }

    private void setInitialCaps(int initCap, Vector caps) {
        int type;
        String methodName = "setInitialCaps";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((initCap & (type = ((Integer)capabilityMapping.get("PO2")).intValue())) == type) {
            caps.addElement("PO2");
        }
        if ((initCap & (type = ((Integer)capabilityMapping.get("PO3")).intValue())) == type) {
            caps.addElement("PO3");
        }
        if ((initCap & (type = ((Integer)capabilityMapping.get("PO4")).intValue())) == type) {
            caps.addElement("PO4");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private boolean updateCapability(IPCapability ipt, Vector caps) {
        String methodName = "updateCapability";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        String[] capabilities = new String[caps.size()];
        caps.toArray(capabilities);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return SqlUtil.updateCapability((String)ipt.getIpAddress(), (String[])capabilities);
    }

    public boolean ping(String ipAddress) {
        String methodName = "ping";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        boolean ok = false;
        String address = this.getIpAddress(ipAddress);
        IPCapability ipt = new IPCapability(address, null, null);
        boolean bl = ok = this.CiscoCapabilityScan(ipt) == 1;
        if (!ok) {
            boolean bl2 = ok = this.topologyCapabilityScan(ipt) == 1;
        }
        if (!ok && message) {
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "Scanner_noResponseFromFCMGMTorCiscoMIB", (Object)address);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return ok;
    }

    public int topologyCapabilityScan(IPCapability ipt) {
        String methodName = "topologyCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int alive = 0;
        try {
            TopologyScanner st = new TopologyScanner();
            alive = st.isTopology(ipt.getIpAddress());
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return 0;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alive;
    }

    public int BrocadeCapabilityScan(IPCapability ipt) {
        String methodName = "BrocadeCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int alive = 0;
        try {
            TopologyScanner st = new TopologyScanner();
            alive = st.isBrocadeSwitch(ipt.getIpAddress());
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return 0;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alive;
    }

    public boolean BrocadeApiCapabilityScan(IPCapability ipt) {
        boolean alive;
        String methodName = "BrocadeApiCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        boolean bl = alive = this.BrocadeUserIdPasswordCapabilityScan(ipt) && this.BrocadeCapabilityScan(ipt) == 1;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alive;
    }

    public boolean BrocadeUserIdPasswordCapabilityScan(IPCapability ipt) {
        String methodName = "BrocadeUserIdPasswordCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        boolean ok = false;
        if (ipt != null) {
            ok = ipt.isUserIdPasswordSet();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return ok;
    }

    public int CiscoCapabilityScan(IPCapability ipt) {
        String methodName = "CiscoCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int alive = 0;
        try {
            TopologyScanner st = new TopologyScanner();
            alive = st.isCiscoMdsSwitch(ipt.getIpAddress());
        }
        catch (Exception e) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return 0;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alive;
    }

    public boolean SharkCapabilityScan(IPCapability ipt) {
        String methodName = "SharkCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        boolean alive = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alive;
    }

    public boolean SharkCliCapabilityScan(IPCapability ipt) {
        boolean alive;
        String methodName = "SharkCliCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        boolean bl = alive = this.SharkUserIdPasswordCapabilityScan(ipt) && this.SharkCapabilityScan(ipt);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alive;
    }

    public boolean SharkUserIdPasswordCapabilityScan(IPCapability ipt) {
        String methodName = "SharkUserIdPasswordCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        boolean ok = false;
        if (ipt != null) {
            ok = ipt.isUserIdPasswordSet();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return ok;
    }

    public boolean NASCapabilityScan(IPCapability ipt) {
        String methodName = "NASCapabilityScan";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        boolean alive = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alive;
    }

    private boolean checkShutdown() {
        String methodName = "checkShutdown";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.isShuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        block14: {
            String methodName = "shutdown";
            this.isShuttingDown = true;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            Object object = this;
            synchronized (object) {
                this.notifyAll();
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)this, methodName, "Stopping all active SNMP capability scans");
            }
            object = acsLock;
            synchronized (object) {
                Enumeration scans = this.activeCapabilityScans.elements();
                while (scans.hasMoreElements()) {
                    IpTargetCapabilityScan ics = (IpTargetCapabilityScan)scans.nextElement();
                    ics.shutdown();
                }
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)this, methodName, "All active IpTarget capability scans stopped.");
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            try {
                SnmpV1API.terminate();
            }
            catch (Exception snmpE) {
                if (message) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)snmpE);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block14;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)snmpE);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String methodName = "run";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.doingRefresh = true;
        while (this.iWorkerThread == Thread.currentThread() && !this.checkShutdown()) {
            this.refreshAllIpTargetCapabilities();
            if (this.checkShutdown()) break;
            SNMPAgentManager sNMPAgentManager = this;
            synchronized (sNMPAgentManager) {
                this.doingRefresh = false;
                this.pollingInterval = this.getMonitorInterval();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Waiting " + this.pollingInterval + " milliseconds to do refreshCapabilities");
                }
                try {
                    this.wait(this.pollingInterval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.doingRefresh = true;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Waking up to do refreshCapabilities");
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private String wrap(String value) {
        String methodName = "wrap";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return value == null ? "null" : "'" + value + "'";
    }

    public String[] discoverAgents(String[] address, String snmpCommunity, String defaultUserid, String defaultPassword) {
        String methodName = "discoverAgents";
        ArrayList<String> allDiscoveredAgents = new ArrayList<String>();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)address.toString());
        }
        defaultUserid = null;
        defaultPassword = null;
        for (int ai = 0; ai < address.length; ++ai) {
            String[] agents = null;
            Object[] baseAddress = new String[4];
            String startingIp = address[ai];
            Vector<String> addresses = new Vector<String>();
            String output = "";
            StringTokenizer st = new StringTokenizer(startingIp.trim(), ".");
            while (st.hasMoreTokens()) {
                addresses.addElement(st.nextToken());
                if (addresses.size() != 3) continue;
            }
            if (addresses.size() < 3) {
                if (traceLogger == null || !traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "The address " + addresses.toString() + "is not valid");
                continue;
            }
            int timeout = 500;
            boolean addToDatabase = true;
            boolean setUserIdPassword = true;
            String userId = defaultUserid;
            String password = defaultPassword;
            boolean switchFilterOn = true;
            if (snmpCommunity == null) {
                snmpCommunity = DEFAULT_SNMP_COMMUNITY;
            }
            addresses.copyInto(baseAddress);
            agents = DiscoverAgents.scan((String[])baseAddress, timeout, switchFilterOn);
            for (int ii = 0; ii < agents.length; ++ii) {
                allDiscoveredAgents.add(agents[ii]);
            }
            if (agents.length <= 0 || !addToDatabase) continue;
            ArrayList<SNMPAgent> snmpAgents = new ArrayList<SNMPAgent>();
            for (int i = 0; i < agents.length; ++i) {
                String ip = agents[i];
                String hostName = "";
                try {
                    InetAddress ia = InetAddress.getByName(ip);
                    hostName = ia.getHostName();
                }
                catch (Exception ipe) {
                    // empty catch block
                }
                SNMPAgent snmpAgent = new SNMPAgent(agents[i], hostName, snmpCommunity, userId, password);
                snmpAgents.add(snmpAgent);
            }
            this.addSNMPAgents(snmpAgents);
        }
        if (traceLogger.isLogging() && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)allDiscoveredAgents.toArray().toString());
        }
        return allDiscoveredAgents.toArray(new String[0]);
    }

    public String[] discoverAgents(String[] address, int timeout, boolean switchFilterOn, String userId, String password) {
        return this.discoverAgents(address, "public", userId, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] addSNMPAgents(ArrayList agents) {
        block33: {
            methodName = "addSNMPAgents";
            connection = ServiceUtils.getConnection();
            target = new IpTarget();
            scanner = new Scanner();
            outbandAgents = new Vector<String>();
            try {
                for (i = 0; i < agents.size(); ++i) {
                    block32: {
                        block34: {
                            dbTarget = SqlUtil.getTarget((String)((SNMPAgent)agents.get(i)).getIpAddress(), (DBConnection)connection);
                            if (dbTarget != null) continue;
                            target.clear();
                            target.setHostName(((SNMPAgent)agents.get(i)).getDnsName());
                            ipAddress = ((SNMPAgent)agents.get(i)).getIpAddress();
                            target.setIpAddress(ipAddress);
                            if (target.getIpAddress() != null || target.getHostName() != null) break block34;
                            if (SNMPAgentManager.traceLogger != null && SNMPAgentManager.traceLogger.isLogging()) {
                                SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "Host name and IP Address of the SNMP Agent to be added are null");
                            }
                            var10_12 = null;
                            var15_18 = null;
                            ** GOTO lbl121
                        }
                        if (target.getIpAddress() == null) {
                            try {
                                inetAdd = InetAddress.getByName(target.getHostName());
                                target.setIpAddress(inetAdd.getHostAddress());
                            }
                            catch (UnknownHostException uhe) {
                                if (SNMPAgentManager.traceLogger != null && SNMPAgentManager.traceLogger.isLogging()) {
                                    SNMPAgentManager.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)this, methodName, uhe.getStackTrace().toString());
                                    SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "Unable to retrieve IP Address from the hostname passed for SNMPAgent");
                                }
                                var11_14 = null;
                                var15_19 = null;
                                try {
                                    if (connection == null) return var11_14;
                                    connection.close();
                                    return var11_14;
                                }
                                catch (Exception e) {
                                    if (SNMPAgentManager.msgLogger != null) {
                                        SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                                    }
                                    if (SNMPAgentManager.traceLogger == null) return var11_14;
                                    if (SNMPAgentManager.traceLogger.isLogging() == false) return var11_14;
                                    SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                                    SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)SNMPAgentManager.className, methodName, "Exception while commiting closing database connection");
                                }
                                return var11_14;
                            }
                        }
                        if ((userId = ((SNMPAgent)agents.get(i)).getUserName()) != null && !userId.trim().equals("")) {
                            target.setUserId(userId);
                        }
                        password = ((SNMPAgent)agents.get(i)).getPassword();
                        encryptedPassword = null;
                        if (password != null && !password.trim().equals("")) {
                            try {
                                encryptedPassword = SRMCrypto.encrypt((String)password);
                                target.setPassword(encryptedPassword);
                            }
                            catch (Exception e) {
                                SNMPAgentManager.msgLogger.message(IRecordType.TYPE_ERR, (Object)SNMPAgentManager.className, methodName, "Scanner_errorEncryptingPassword", (Object)target);
                                SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                                if (SNMPAgentManager.traceLogger == null || !SNMPAgentManager.traceLogger.isLogging()) break block32;
                                SNMPAgentManager.traceLogger.text(IRecordType.TYPE_WARN, (Object)this, methodName, "Could not encrypt Password ");
                            }
                        }
                    }
                    if (((SNMPAgent)agents.get(i)).getCommunityName() == null || ((SNMPAgent)agents.get(i)).getCommunityName().trim().length() == 0) {
                        ((SNMPAgent)agents.get(i)).setCommunityName(SNMPAgentManager.DEFAULT_SNMP_COMMUNITY);
                    }
                    if (((SNMPAgent)agents.get(i)).getRWCommunityName() == null || ((SNMPAgent)agents.get(i)).getRWCommunityName().trim().length() == 0) {
                        ((SNMPAgent)agents.get(i)).setRWCommunityName(SNMPAgentManager.DEFAULT_SNMP_RW_COMMUNITY);
                    }
                    target.setReadCommunityName(((SNMPAgent)agents.get(i)).getCommunityName());
                    target.setRwCommunityName(((SNMPAgent)agents.get(i)).getRWCommunityName());
                    this.insertTarget(target, connection);
                    config = (SNMPConfig)SnmpV1API.getConfig();
                    config.setSnmpCommunityName(ipAddress, target.getReadCommunityName());
                    config.setSnmpWriteCommunityName(ipAddress, target.getRwCommunityName());
                    scanner.clear();
                    scanner.setAgentName(((SNMPAgent)agents.get(i)).getIpAddress());
                    scanner.setScannerId("PO2:" + ((SNMPAgent)agents.get(i)).getIpAddress());
                    scanner.setType("PO2");
                    this.insertScanner(scanner, connection);
                    scanner.setScannerId("PO4:" + ((SNMPAgent)agents.get(i)).getIpAddress());
                    scanner.setType("PO4");
                    this.insertScanner(scanner, connection);
                    outbandAgents.add(target.getIpAddress());
                }
                connection.commit();
                this.updateNewAgentCapabilities(agents, false);
                ** GOTO lbl133
            }
            catch (Exception e) {
                if (SNMPAgentManager.msgLogger != null) {
                    SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                }
                if (SNMPAgentManager.traceLogger != null && SNMPAgentManager.traceLogger.isLogging()) {
                    SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                    SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)SNMPAgentManager.className, methodName, "Exception while commiting the added agents to database");
                }
                var15_21 = null;
                try {}
                catch (Exception e) {
                    if (SNMPAgentManager.msgLogger != null) {
                        SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                    }
                    if (SNMPAgentManager.traceLogger != null && SNMPAgentManager.traceLogger.isLogging()) {
                        SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                        SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)SNMPAgentManager.className, methodName, "Exception while commiting closing database connection");
                    }
                    break block33;
                }
                if (connection != null) {
                    connection.close();
                }
                break block33;
            }
            {
                catch (Throwable var14_28) {
                    var15_22 = null;
                    ** try [egrp 4[TRYBLOCK] [10 : 859->870)] { 
lbl110:
                    // 1 sources

                    if (connection == null) throw var14_28;
                    connection.close();
                    throw var14_28;
lbl113:
                    // 1 sources

                    catch (Exception e) {
                        if (SNMPAgentManager.msgLogger != null) {
                            SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                        }
                        if (SNMPAgentManager.traceLogger == null) throw var14_28;
                        if (SNMPAgentManager.traceLogger.isLogging() == false) throw var14_28;
                        SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                        SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)SNMPAgentManager.className, methodName, "Exception while commiting closing database connection");
                    }
                    throw var14_28;
                }
lbl121:
                // 1 sources

                ** try [egrp 4[TRYBLOCK] [10 : 859->870)] { 
lbl122:
                // 1 sources

                if (connection == null) return var10_12;
                connection.close();
                return var10_12;
lbl125:
                // 1 sources

                catch (Exception e) {
                    if (SNMPAgentManager.msgLogger != null) {
                        SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                    }
                    if (SNMPAgentManager.traceLogger == null) return var10_12;
                    if (SNMPAgentManager.traceLogger.isLogging() == false) return var10_12;
                    SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                    SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)SNMPAgentManager.className, methodName, "Exception while commiting closing database connection");
                }
                return var10_12;
lbl133:
                // 1 sources

                var15_20 = null;
                ** try [egrp 4[TRYBLOCK] [10 : 859->870)] { 
lbl135:
                // 1 sources

                if (connection != null) {
                    connection.close();
                }
lbl139:
                // 1 sources

                catch (Exception e) {}
                if (SNMPAgentManager.msgLogger != null) {
                    SNMPAgentManager.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                }
                if (SNMPAgentManager.traceLogger == null || !SNMPAgentManager.traceLogger.isLogging()) break block33;
                SNMPAgentManager.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)SNMPAgentManager.className, methodName, (Throwable)e);
                SNMPAgentManager.traceLogger.text(IRecordType.TYPE_INFO, (Object)SNMPAgentManager.className, methodName, "Exception while commiting closing database connection");
            }
        }
        ipAddresses = new String[outbandAgents.size()];
        outbandAgents.toArray(ipAddresses);
        if (SNMPAgentManager.traceLogger == null) return ipAddresses;
        if (SNMPAgentManager.traceLogger.isLogging() == false) return ipAddresses;
        SNMPAgentManager.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)SNMPAgentManager.className, methodName, (Object)ipAddresses.toString());
        return ipAddresses;
    }

    private void updateNewAgentCapabilities(ArrayList agents, boolean generateEvents) {
        String methodName = "updateNewAgentCapabilities";
        for (int i = 0; i < agents.size(); ++i) {
            String ipAddress = ((SNMPAgent)agents.get(i)).getIpAddress();
            IPCapability ipt = this.getTarget(ipAddress);
            this.refreshIpTargetCapabilities(ipt, generateEvents);
        }
    }

    public void insertScanner(Scanner scanner, DBConnection connection) {
        block7: {
            String methodName = "insertScanner";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "insertScanner", (Object)scanner.getScannerId());
            }
            try {
                boolean inserted = scanner.insert(connection);
            }
            catch (SQLException dbe) {
                try {
                    int numRows = scanner.update(connection);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block7;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "insertScanner", (Throwable)e);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "insertScanner", (Object)scanner.toString());
        }
    }

    public void insertTarget(IpTarget target, DBConnection connection) {
        block7: {
            String methodName = "insertTarget";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "insertTarget", (Object)target.getIpAddress());
            }
            try {
                boolean inserted = target.insert(connection);
            }
            catch (SQLException dbe) {
                try {
                    int numRows = target.update(connection);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (traceLogger == null || !traceLogger.isLogging()) break block7;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "insertTarget", (Throwable)e);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "insertTarget", (Object)target.toString());
        }
    }

    static {
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    class IpTargetCapabilityScan
    extends Thread {
        private ILogger msgLogger = msgLogger;
        private ILogger traceLogger = traceLogger;
        private final String className = IpTargetCapabilityScan.class.getName();
        SNMPAgentManager ic = null;
        IPCapability ipt = null;

        public IpTargetCapabilityScan(SNMPAgentManager aIc, IPCapability aIpt) {
            this.ic = aIc;
            this.ipt = aIpt;
            this.setName("IpTargetCapabilityScan address=" + this.ipt.getIpAddress());
        }

        public void run() {
            String methodName = "run";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this.className, methodName);
            }
            this.ic.performIpTargetCapabiltyScan(this.ipt);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this.className, methodName);
            }
        }

        public void shutdown() {
            String methodName = "shutdown";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this.className, "shutdown");
                this.traceLogger.text(IRecordType.TYPE_WARN, (Object)this, "shutdown", "Ending IpTargetCapabilityScan address=" + this.ipt.getIpAddress() + " before scan has completed.");
            }
            Thread t = new Thread(this);
            t.interrupt();
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this.className, "shutdown");
            }
        }
    }
}

