/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.exec;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.eclipse.aperi.agent.exec.Pipe;
import org.eclipse.aperi.agent.handler.script.unix.InternalCommandContext;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.WindowsCommandContext;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;

public class CmdExecer {
    public BufferedReader stdout;
    public BufferedReader stderr;
    public BufferedWriter stdin;
    private String[] commandLine;
    private boolean needStdin;
    private InternalCommandContext ctx;
    private long envBlock;

    public CmdExecer(String[] pCommandLine, boolean pNeedStdin, long pEnvBlock) {
        this.commandLine = pCommandLine;
        this.needStdin = pNeedStdin;
        this.envBlock = pEnvBlock;
        this.stdout = null;
        this.stderr = null;
        this.stdin = null;
    }

    public CmdExecer(String[] pCommandLine, boolean pNeedStdin) {
        this(pCommandLine, pNeedStdin, 0L);
    }

    public CmdExecer(String[] pCommandLine) {
        this(pCommandLine, false);
    }

    private native long fork(long[] var1) throws LocalizableException;

    public boolean exec() {
        Pipe standardError;
        Pipe standardOutput;
        Pipe standardInput;
        block19: {
            long handle;
            block18: {
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry((String)CmdExecer.class.getName(), (String)"exec", (String)"");
                }
                standardInput = null;
                standardOutput = null;
                standardError = null;
                try {
                    standardInput = new Pipe();
                    standardOutput = new Pipe();
                    standardError = new Pipe();
                }
                catch (LocalizableException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)CmdExecer.class.getName(), (String)"exec", (Throwable)e);
                    }
                    e.print();
                    if (standardInput != null) {
                        standardInput.close();
                        if (standardOutput != null) {
                            standardOutput.close();
                        }
                    }
                    boolean traceResult = false;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)CmdExecer.class.getName(), (String)"exec", (boolean)traceResult);
                    }
                    return traceResult;
                }
                long[] pipeFDs = new long[]{standardInput.getReadHandle(), standardInput.getWriteHandle(), standardOutput.getReadHandle(), standardOutput.getWriteHandle(), standardError.getReadHandle(), standardError.getWriteHandle()};
                try {
                    handle = this.fork(pipeFDs);
                }
                catch (LocalizableException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)CmdExecer.class.getName(), (String)"exec", (Throwable)e);
                    }
                    e.print();
                    standardInput.close();
                    standardOutput.close();
                    standardError.close();
                    boolean traceResult = false;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)CmdExecer.class.getName(), (String)"exec", (boolean)traceResult);
                    }
                    return traceResult;
                }
                try {
                    standardInput.getInputStream().close();
                    standardOutput.getOutputStream().close();
                    standardError.getOutputStream().close();
                }
                catch (IOException e) {
                    if (!TraceLogger.enableTrace) break block18;
                    TraceLogger.exception((String)CmdExecer.class.getName(), (String)"exec", (Throwable)e);
                }
            }
            this.ctx = Agent.isWindows ? new WindowsCommandContext(null, null, null, null, 0L) : new InternalCommandContext();
            this.ctx.handle = handle;
            if (!this.needStdin) {
                try {
                    standardInput.getOutputStream().close();
                }
                catch (IOException e) {
                    if (!TraceLogger.enableTrace) break block19;
                    TraceLogger.exception((String)CmdExecer.class.getName(), (String)"exec", (Throwable)e);
                }
            }
        }
        InputStreamReader in = new InputStreamReader(standardOutput.getInputStream());
        this.stdout = new BufferedReader(in);
        in = new InputStreamReader(standardError.getInputStream());
        this.stderr = new BufferedReader(in);
        if (this.needStdin) {
            OutputStreamWriter out = new OutputStreamWriter(standardInput.getOutputStream());
            this.stdin = new BufferedWriter(out);
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CmdExecer.class.getName(), (String)"exec", (boolean)traceResult);
        }
        return traceResult;
    }

    public void close() {
        block12: {
            block11: {
                block10: {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.entry((String)CmdExecer.class.getName(), (String)"close", (String)"");
                    }
                    try {
                        this.stdout.close();
                    }
                    catch (IOException ignored) {
                        if (!TraceLogger.enableTrace) break block10;
                        TraceLogger.exception((String)CmdExecer.class.getName(), (String)"close", (Throwable)ignored);
                    }
                }
                try {
                    this.stderr.close();
                }
                catch (IOException ignored) {
                    if (!TraceLogger.enableTrace) break block11;
                    TraceLogger.exception((String)CmdExecer.class.getName(), (String)"close", (Throwable)ignored);
                }
            }
            if (this.stdin != null) {
                try {
                    this.stdin.close();
                }
                catch (IOException ignored) {
                    if (!TraceLogger.enableTrace) break block12;
                    TraceLogger.exception((String)CmdExecer.class.getName(), (String)"close", (Throwable)ignored);
                }
            }
        }
        if (this.ctx != null) {
            this.waitForExitAndReturnStatus();
            this.ctx = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CmdExecer.class.getName(), (String)"close");
        }
    }

    public int waitForExitAndReturnStatus() {
        int result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CmdExecer.class.getName(), (String)"waitForExitAndReturnStatus", (String)"");
        }
        if (this.ctx == null) {
            result = -1;
        } else {
            result = this.ctx.waitForExitAndReturnStatus();
            this.ctx = null;
        }
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CmdExecer.class.getName(), (String)"waitForExitAndReturnStatus", (int)traceResult);
        }
        return traceResult;
    }

    private static native void initIDs();

    static {
        CmdExecer.initIDs();
    }
}

