/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.aperi.xmsg.LocalizableException;

public class Pipe {
    private long reader;
    private long writer;
    private IStream iStream = null;
    private OStream oStream = null;

    private native void create() throws LocalizableException;

    private native void close(long var1) throws LocalizableException;

    private native int readBytes(long var1, byte[] var3, int var4, int var5) throws LocalizableException;

    private native int bytesAvailable(long var1) throws LocalizableException;

    private native int writeBytes(long var1, byte[] var3, int var4, int var5) throws LocalizableException;

    public long getReadHandle() {
        return this.reader;
    }

    public long getWriteHandle() {
        return this.writer;
    }

    private void closeReader() throws IOException {
        if (this.reader < 0L) {
            return;
        }
        long fd = this.reader;
        this.reader = -1L;
        this.close(fd);
    }

    private void closeWriter() throws IOException {
        if (this.writer < 0L) {
            return;
        }
        long fd = this.writer;
        this.writer = -1L;
        this.close(fd);
    }

    public void close() {
        try {
            this.closeReader();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.closeWriter();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Pipe() throws LocalizableException {
        this.create();
    }

    public InputStream getInputStream() {
        if (this.iStream == null) {
            this.iStream = new IStream();
        }
        return this.iStream;
    }

    public OutputStream getOutputStream() {
        if (this.oStream == null) {
            this.oStream = new OStream();
        }
        return this.oStream;
    }

    private class OStream
    extends OutputStream {
        private OStream() {
        }

        private void writeNoCheck(byte[] where, int offset, int length) throws IOException {
            while (length > 0) {
                int written = Pipe.this.writeBytes(Pipe.this.writer, where, offset, length);
                offset += written;
                length -= written;
            }
        }

        private void writeNoCheck(byte[] where) throws IOException {
            this.writeNoCheck(where, 0, where.length);
        }

        public void write(byte[] where, int offset, int length) throws IOException {
            if (where == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || offset + length > where.length) {
                throw new IndexOutOfBoundsException();
            }
            if (length == 0) {
                return;
            }
            this.writeNoCheck(where, offset, length);
        }

        public void write(byte[] where) throws IOException {
            if (where == null) {
                throw new NullPointerException();
            }
            this.writeNoCheck(where);
        }

        public void write(int x) throws IOException {
            byte[] array = new byte[]{(byte)x};
            this.writeNoCheck(array);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
            Pipe.this.closeWriter();
        }
    }

    private class IStream
    extends InputStream {
        private boolean atEOF = false;

        private int readNoCheck(byte[] where, int offset, int length) throws IOException {
            int result = -1;
            if (this.atEOF) {
                return result;
            }
            result = Pipe.this.readBytes(Pipe.this.reader, where, offset, length);
            if (result == 0) {
                this.atEOF = true;
                result = -1;
            }
            return result;
        }

        private int readNoCheck(byte[] where) throws IOException {
            return this.readNoCheck(where, 0, where.length);
        }

        public int read(byte[] where, int offset, int length) throws IOException {
            if (where == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || offset + length > where.length) {
                throw new IndexOutOfBoundsException();
            }
            if (length == 0) {
                return 0;
            }
            return this.readNoCheck(where, offset, length);
        }

        public int read(byte[] where) throws IOException {
            if (where == null) {
                throw new NullPointerException();
            }
            return this.readNoCheck(where);
        }

        public int read() throws IOException {
            byte[] array = new byte[1];
            int x = this.readNoCheck(array);
            if (x <= 0) {
                return x;
            }
            return array[0];
        }

        public int available() throws IOException {
            if (this.atEOF) {
                return -1;
            }
            return Pipe.this.bytesAvailable(Pipe.this.reader);
        }

        public void close() throws IOException {
            Pipe.this.closeReader();
        }

        public void mark(int readlimit) {
        }

        public void reset() throws IOException {
            throw new IOException();
        }

        public boolean markSupported() {
            return false;
        }
    }
}

