/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.job;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import org.eclipse.aperi.agent.handler.job.IExecutable;
import org.eclipse.aperi.agent.handler.job.JobExtensionMgr;
import org.eclipse.aperi.agent.handler.job.JobHandler;
import org.eclipse.aperi.agent.req.RunReq;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Link;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.JobUtils;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.xmsg.MessageLog;

public class JavaJobHandler
extends JobHandler {
    public void handle(Request request, Response response, Socket connection) {
        int tries;
        String dir;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JavaJobHandler.class.getName(), (String)"handle", (String)"request, response, connection");
        }
        this.init(request, response, connection);
        JobRun jobRun = (JobRun)request.requestData;
        StartedJob job = new StartedJob(jobRun, 0L, 0L, 0, -1, 73, 0L);
        String[] commandLine = job.getJobRun().getCommandLine();
        String jobExtensionID = commandLine[0];
        String[] args = new String[commandLine.length - 1];
        System.arraycopy(commandLine, 1, args, 0, args.length);
        IExecutable toRun = null;
        try {
            toRun = (IExecutable)JobExtensionMgr.getExtensionMgr().getExtensionImpl(jobExtensionID);
        }
        catch (ExtensionException e) {
            response.errorMessage = e.getMessage();
        }
        if (toRun == null) {
            MessageLog.logMessage((String)"AGT0259E", (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName(), (Object)Integer.toString(jobRun.getSchedRunNumber()));
            if (response.errorMessage != null) {
                MessageLog.getThreadLog().println(response.errorMessage);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JavaJobHandler.class.getName(), (String)"handle");
            }
            return;
        }
        String errorMessage = null;
        FileOutputStream stream = null;
        if (jobRun.getLogDirectory() != null) {
            dir = jobRun.getLogDirectory();
            tries = 2;
        } else {
            dir = Agent.logFileDirectory;
            tries = 1;
        }
        do {
            String logFileName = JobUtils.generateLogFileName((RunReq)jobRun, (String)dir);
            job.setLogFileName(logFileName);
            try {
                stream = new FileOutputStream(logFileName, true);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)JavaJobHandler.class.getName(), (String)"handle", (Throwable)e);
                }
                errorMessage = MessageLog.getMessageWithException((String)"GEN0036E", (Exception)e);
            }
            if (stream != null) continue;
            dir = Agent.logFileDirectory;
        } while (stream == null && --tries > 0);
        if (stream == null) {
            response.status = (short)12;
            response.errorMessage = errorMessage;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JavaJobHandler.class.getName(), (String)"handle");
            }
            return;
        }
        PrintWriter writer = new PrintWriter(stream, true);
        Link link = Agent.jobManager.jobInit(job);
        if (link == null) {
            response.status = (short)12;
            writer.close();
            response.errorMessage = MessageLog.getMessage((String)"AGT0040E", null);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JavaJobHandler.class.getName(), (String)"handle");
            }
            return;
        }
        response.responseData = job.getLogFileName();
        Executor executor = new Executor(toRun, link, writer, dir, args);
        Agent.breadLine.assign(executor);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JavaJobHandler.class.getName(), (String)"handle");
        }
    }

    private class Executor
    implements IAssignable {
        private IExecutable toRun;
        private Link link;
        private StartedJob job;
        private PrintWriter output;
        private String dir;
        private String[] args;

        public Executor(IExecutable pToRun, Link pLink, PrintWriter pOutput, String pDir, String[] pArgs) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Executor.class.getName(), (String)"Executor", (String)"pToRun, pLink, pOutput, pDir");
            }
            this.toRun = pToRun;
            this.link = pLink;
            this.job = (StartedJob)pLink.datum;
            this.output = pOutput;
            this.dir = pDir;
            this.args = pArgs;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Executor.class.getName(), (String)"Executor");
            }
        }

        public void execute() {
            Error err;
            PrintWriter oldOutput;
            block7: {
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry((String)Executor.class.getName(), (String)"execute", (String)"");
                }
                JobUtil.purgeLogFiles((RunReq)this.job.getJobRun(), (String)this.dir);
                Agent.jobManager.jobWait(this.job);
                Agent.jobManager.jobExec(this.job);
                oldOutput = MessageLog.getThreadLog();
                MessageLog.setThreadLog((PrintWriter)this.output);
                err = null;
                try {
                    this.job.setExitCode(this.toRun.exec(this.job, this.args));
                }
                catch (Throwable e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Executor.class.getName(), (String)"execute", (Throwable)e);
                    }
                    e.printStackTrace(this.output);
                    this.job.setExitCode(8);
                    if (!(e instanceof Error)) break block7;
                    err = (Error)e;
                }
            }
            MessageLog.setThreadLog((PrintWriter)oldOutput);
            this.output.close();
            Agent.jobManager.finalizeJob(this.job.getExitCode(), this.link);
            if (err != null) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Executor.class.getName(), (String)"execute");
                }
                throw err;
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Executor.class.getName(), (String)"execute");
            }
        }
    }
}

