/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.job;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.eclipse.aperi.agent.handler.job.IExecutable;
import org.eclipse.aperi.agent.handler.job.IRestartable;
import org.eclipse.aperi.agent.handler.job.JobExtensionMgr;
import org.eclipse.aperi.agent.handler.job.JobState;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Link;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.xmsg.MessageLog;

public class JavaJobRestart {
    public static void restart() {
        String[] jobFiles;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JavaJobRestart.class.getName(), (String)"restart", (String)"");
        }
        if ((jobFiles = JobState.getSavedJobs()) == null || jobFiles.length == 0) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JavaJobRestart.class.getName(), (String)"restart");
            }
            return;
        }
        Response response = new Response(0, null);
        for (int i = 0; i < jobFiles.length; ++i) {
            JobState state = new JobState(jobFiles[i]);
            if (!state.restoreState()) {
                MessageLog.logMessage((String)"AGT0126E", (Object)jobFiles[i]);
                state.deleteState();
                continue;
            }
            StartedJob job = state.job;
            JobRun jobRun = job.getJobRun();
            IExecutable toRun = null;
            String clazz = jobRun.getCommandLine()[0];
            if (clazz != null) {
                JobExtensionMgr jobExMgr = JobExtensionMgr.getExtensionMgr();
                try {
                    toRun = (IExecutable)jobExMgr.getExtensionImpl(clazz);
                }
                catch (ExtensionException e) {
                    response.errorMessage = e.getMessage();
                }
            }
            if (toRun == null) {
                MessageLog.logMessage((String)"AGT0127E", (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName(), (Object)Integer.toString(jobRun.getSchedRunNumber()));
                if (response.errorMessage != null) {
                    MessageLog.getThreadLog().println(response.errorMessage);
                }
                state.deleteState();
                continue;
            }
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(job.getLogFileName(), true);
            }
            catch (FileNotFoundException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)JavaJobRestart.class.getName(), (String)"restart", (Throwable)e);
                }
                MessageLog.getMessageWithException((String)"GEN0036E", (Exception)e);
                state.deleteState();
                continue;
            }
            PrintWriter writer = new PrintWriter(stream, true);
            Link link = Agent.jobManager.jobInit(job);
            Agent.breadLine.assign(new Executor(toRun, state, link, writer));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JavaJobRestart.class.getName(), (String)"restart");
        }
    }

    private static class Executor
    implements IAssignable {
        private IExecutable toRun;
        private Link link;
        private StartedJob job;
        private PrintWriter output;
        private JobState state;

        public Executor(IExecutable toRun, JobState state, Link link, PrintWriter output) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Executor.class.getName(), (String)"Executor", (String)"toRun, state, link, output");
            }
            this.toRun = toRun;
            this.link = link;
            this.state = state;
            this.output = output;
            this.job = state.job;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Executor.class.getName(), (String)"Executor");
            }
        }

        public void execute() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Executor.class.getName(), (String)"execute", (String)"");
            }
            PrintWriter oldOutput = MessageLog.getThreadLog();
            MessageLog.setThreadLog((PrintWriter)this.output);
            try {
                this.job.setExitCode(((IRestartable)((Object)this.toRun)).restart(this.state));
            }
            catch (Exception e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Executor.class.getName(), (String)"execute", (Throwable)e);
                }
                e.printStackTrace(this.output);
                this.job.setExitCode(-1);
            }
            MessageLog.setThreadLog((PrintWriter)oldOutput);
            this.output.close();
            Agent.jobManager.finalizeJob(this.job.getExitCode(), this.link);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Executor.class.getName(), (String)"execute");
            }
        }
    }
}

