/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.job;

import java.net.Socket;
import java.util.LinkedList;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.AuthChecker;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.LineBreaker;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

abstract class JobHandler
implements IAgentRequestHandler {
    private Class jobRunClass;

    public JobHandler() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JobHandler.class.getName(), (String)"JobHandler", (String)"");
        }
        JobRun jobRun = new JobRun();
        this.jobRunClass = jobRun.getClass();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobHandler.class.getName(), (String)"JobHandler");
        }
    }

    public abstract void handle(Request var1, Response var2, Socket var3);

    protected void init(Request request, Response response, Socket connection) {
        Object traceResult;
        if (!RequestChecker.isDesiredType((Class)this.jobRunClass, (Request)request, (Response)response)) {
            traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JobHandler.class.getName(), (String)"init", traceResult);
            }
        }
        if (!AuthChecker.check(request, response, connection)) {
            traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JobHandler.class.getName(), (String)"init", traceResult);
            }
        }
        if (Agent.reporter.isBacklogged()) {
            response.status = (short)20;
            response.errorMessage = MessageLog.getMessage((String)"AGT0049E", null);
            traceResult = null;
        }
    }

    protected String[] splitEnv(String environment) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JobHandler.class.getName(), (String)"splitEnv", (String)"environment");
        }
        if (environment == null) {
            String[] traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JobHandler.class.getName(), (String)"splitEnv", traceResult);
            }
            return traceResult;
        }
        LinkedList<String> list = new LinkedList<String>();
        int length = environment.length();
        int pos = 0;
        while (pos < length) {
            int end = environment.indexOf(10, pos);
            if (end < 0) {
                end = length;
            }
            list.add(environment.substring(pos, end));
            pos = end + 1;
        }
        String[] traceResult = list.toArray(LineBreaker.template);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobHandler.class.getName(), (String)"splitEnv", (Object)traceResult);
        }
        return traceResult;
    }
}

