/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.job;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class JobState {
    private String stateFile;
    public StartedJob job;
    public Object state;
    public static final String RESTART_JOB_DIR = Agent.logFileDirectory + File.separator + "restart";

    public JobState(StartedJob job, Object state) {
        this.job = job;
        this.state = state;
    }

    public JobState(String stateFile) {
        this.stateFile = stateFile;
    }

    public boolean saveState() {
        boolean written;
        block24: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)JobState.class.getName(), (String)"saveState", (String)"");
            }
            if (this.job.getJobRun().saveJobState()) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)JobState.class.getName(), (String)"saveState", (boolean)traceResult);
                }
                return traceResult;
            }
            File dir = new File(RESTART_JOB_DIR);
            try {
                if (!dir.isDirectory() && !dir.mkdir()) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)JobState.class.getName(), (String)"saveState");
                    }
                    throw new SecurityException();
                }
            }
            catch (SecurityException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)JobState.class.getName(), (String)"saveState", (Throwable)e);
                }
                MessageLog.logException((String)"AGT0124E", (Exception)e, (Object)RESTART_JOB_DIR);
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)JobState.class.getName(), (String)"saveState", (boolean)traceResult);
                }
                return traceResult;
            }
            JobRun jobRun = this.job.getJobRun();
            StringBuffer buffer = new StringBuffer(32);
            buffer.append(RESTART_JOB_DIR);
            buffer.append(File.separatorChar);
            buffer.append("JOB_");
            buffer.append(jobRun.getSchedID());
            buffer.append('_');
            buffer.append(jobRun.getRunNumber());
            this.stateFile = buffer.toString();
            FileOutputStream fileStream = null;
            try {
                fileStream = new FileOutputStream(this.stateFile);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)JobState.class.getName(), (String)"saveState", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0036E", (Exception)e);
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)JobState.class.getName(), (String)"saveState", (boolean)traceResult);
                }
                return traceResult;
            }
            written = false;
            ObjectOutputStream objectStream = null;
            try {
                objectStream = new ObjectOutputStream(fileStream);
                objectStream.writeObject(this.job);
                objectStream.writeObject(this.state);
                written = true;
            }
            catch (ObjectStreamException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)JobState.class.getName(), (String)"saveState", (Throwable)e);
                }
                MessageLog.logException((String)"AGT0043E", (Exception)e, (Object)this.stateFile);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)JobState.class.getName(), (String)"saveState", (Throwable)e);
                }
                MessageLog.logException((String)"AGT0042E", (Exception)e, (Object)this.stateFile);
            }
            if (objectStream != null) {
                try {
                    objectStream.close();
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)JobState.class.getName(), (String)"saveState", (Throwable)e);
                    }
                    if (!written) break block24;
                    MessageLog.logException((String)"AGT0042E", (Exception)e, (Object)this.stateFile);
                    written = false;
                }
            }
        }
        if (!written) {
            this.deleteState();
        }
        boolean traceResult = written;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobState.class.getName(), (String)"saveState", (boolean)traceResult);
        }
        return traceResult;
    }

    boolean restoreState() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JobState.class.getName(), (String)"restoreState", (String)"");
        }
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(RESTART_JOB_DIR);
        buffer.append(File.separatorChar);
        buffer.append(this.stateFile);
        this.stateFile = buffer.toString();
        FileInputStream fileStream = null;
        ObjectInputStream objectStream = null;
        try {
            fileStream = new FileInputStream(this.stateFile);
        }
        catch (FileNotFoundException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobState.class.getName(), (String)"restoreState", (Throwable)e);
            }
            MessageLog.logException((String)"GEN0029E", (Exception)e);
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JobState.class.getName(), (String)"restoreState", (boolean)traceResult);
            }
            return traceResult;
        }
        try {
            objectStream = new ObjectInputStream(fileStream);
        }
        catch (ObjectStreamException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobState.class.getName(), (String)"restoreState", (Throwable)e);
            }
            MessageLog.logException((String)"AGT0036W", (Exception)e, (Object)this.stateFile);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobState.class.getName(), (String)"restoreState", (Throwable)e);
            }
            MessageLog.logException((String)"AGT0035W", (Exception)e, (Object)this.stateFile);
        }
        if (objectStream == null) {
            this.closeInputStream(fileStream);
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JobState.class.getName(), (String)"restoreState", (boolean)traceResult);
            }
            return traceResult;
        }
        boolean readState = false;
        try {
            this.job = (StartedJob)objectStream.readObject();
            this.state = objectStream.readObject();
            readState = true;
        }
        catch (ClassNotFoundException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobState.class.getName(), (String)"restoreState", (Throwable)e);
            }
            MessageLog.logMessage((String)"AGT0038W", (Object)e.getMessage(), (Object)this.stateFile);
        }
        catch (ObjectStreamException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobState.class.getName(), (String)"restoreState", (Throwable)e);
            }
            MessageLog.logException((String)"AGT0036W", (Exception)e, (Object)this.stateFile);
        }
        catch (EOFException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobState.class.getName(), (String)"restoreState", (Throwable)e);
            }
            MessageLog.logException((String)"AGT0037W", (Exception)e, (Object)this.stateFile);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobState.class.getName(), (String)"restoreState", (Throwable)e);
            }
            MessageLog.logException((String)"AGT0035W", (Exception)e, (Object)this.stateFile);
        }
        catch (ClassCastException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobState.class.getName(), (String)"restoreState", (Throwable)e);
            }
            MessageLog.logException((String)"AGT0039W", (Exception)e, (Object)this.stateFile, (Object)"StartedJob");
        }
        this.closeInputStream(objectStream);
        boolean traceResult = readState;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobState.class.getName(), (String)"restoreState", (boolean)traceResult);
        }
        return traceResult;
    }

    private void closeInputStream(InputStream is) {
        block5: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)JobState.class.getName(), (String)"closeInputStream", (String)"is");
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    if (!TraceLogger.enableTrace) break block5;
                    TraceLogger.exception((String)JobState.class.getName(), (String)"closeInputStream", (Throwable)e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobState.class.getName(), (String)"closeInputStream");
        }
    }

    public void deleteState() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JobState.class.getName(), (String)"deleteState", (String)"");
        }
        if (this.stateFile != null) {
            File f = new File(this.stateFile);
            f.delete();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)JobState.class.getName(), (String)"deleteState");
        }
    }

    static String[] getSavedJobs() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)JobState.class.getName(), (String)"getSavedJobs", (String)"");
        }
        File dir = new File(RESTART_JOB_DIR);
        try {
            String[] traceResult = dir.list();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JobState.class.getName(), (String)"getSavedJobs", (Object)traceResult);
            }
            return traceResult;
        }
        catch (SecurityException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)JobState.class.getName(), (String)"getSavedJobs", (Throwable)e);
            }
            MessageLog.logException((String)"AGT0124E", (Exception)e, (Object)RESTART_JOB_DIR);
            String[] traceResult = new String[]{};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)JobState.class.getName(), (String)"getSavedJobs", (Object)traceResult);
            }
            return traceResult;
        }
    }
}

