/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.nas;

import java.net.Socket;
import org.eclipse.aperi.TStorm.common.NasFilerAdmin;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.nas.NasUtil;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class NasLoginHandler
implements IAgentRequestHandler {
    public void handle(Request request, Response response, Socket connection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasLoginHandler.class.getName(), (String)"handle", (String)"request, response, connection");
        }
        if (!Agent.isWindows) {
            response.errorMessage = MessageLog.getMessage((String)"NAA0023E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)NasLoginHandler.class.getName(), (String)"handle");
            }
            return;
        }
        if (!RequestChecker.isDesiredType(NasFilerAdmin.class, (Request)request, (Response)response)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)NasLoginHandler.class.getName(), (String)"handle");
            }
            return;
        }
        NasFilerAdmin nfa = (NasFilerAdmin)request.requestData;
        MutableBoolean alreadyLoggedIn = new MutableBoolean();
        try {
            NasUtil.cifsLogIn(Agent.domain, nfa.nfaNetworkName, nfa.nfaUserName, nfa.nfaPassword, alreadyLoggedIn);
            response.status = 0;
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)NasLoginHandler.class.getName(), (String)"handle", (Throwable)e);
            }
            if (alreadyLoggedIn.value) {
                response.status = (short)4;
            }
            response.errorMessage = e.getMessage();
        }
        if (response.status == 0) {
            NasUtil.cifsLogOut(nfa.nfaNetworkName);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasLoginHandler.class.getName(), (String)"handle");
        }
    }
}

