/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.script;

import java.io.PrintWriter;
import java.util.Iterator;
import org.eclipse.aperi.agent.handler.script.ScriptContext;
import org.eclipse.aperi.agent.handler.script.ScriptReaper;
import org.eclipse.aperi.agent.util.Link;
import org.eclipse.aperi.agent.util.ListOfLinks;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class WindowsScriptReaper
extends ScriptReaper {
    private static final int MAX_HANDLES = 63;
    private static ListOfLinks reaperList;
    private Link us;
    private ScriptContext[] managed = new ScriptContext[63];
    private long handleArray;
    private int pendingCount = 0;
    private int oldCount;

    private native void allocHandleArray() throws LocalizableException;

    private native void freeHandleArray();

    private native void addHandle(long var1);

    private void addJobToThis(ScriptContext context) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)WindowsScriptReaper.class.getName(), (String)"addJobToThis", (String)"context");
        }
        this.managed[this.pendingCount] = context;
        this.addHandle(context.handle);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)WindowsScriptReaper.class.getName(), (String)"addJobToThis");
        }
    }

    private WindowsScriptReaper(ScriptContext context) throws LocalizableException {
        this.allocHandleArray();
        this.addJobToThis(context);
        this.us = reaperList.append(this);
    }

    private native ScriptContext reapOne();

    private void reapAll() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)WindowsScriptReaper.class.getName(), (String)"reapAll", (String)"");
        }
        do {
            ScriptContext context = this.reapOne();
            context.scriptExited(this.exitStatus);
        } while (this.oldCount > 0);
        reaperList.unlink(this.us);
        this.freeHandleArray();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)WindowsScriptReaper.class.getName(), (String)"reapAll");
        }
    }

    public static void addJob(ScriptContext context, PrintWriter oldLog, PrintWriter currentLog) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)WindowsScriptReaper.class.getName(), (String)"addJob", (String)"context, oldLog, currentLog");
        }
        WindowsScriptReaper reaper = null;
        boolean going = true;
        LockManager.lockJavaObject((Object)reaperList);
        Iterator iterator = reaperList.iterator();
        while (going && iterator.hasNext()) {
            reaper = (WindowsScriptReaper)iterator.next();
            LockManager.lockJavaObject((Object)reaper);
            if (reaper.pendingCount > 0 && reaper.pendingCount < 63) {
                going = false;
                continue;
            }
            LockManager.unLockJavaObject((Object)reaper);
        }
        if (going) {
            try {
                reaper = new WindowsScriptReaper(context);
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)WindowsScriptReaper.class.getName(), (String)"addJob", (Throwable)e);
                }
                LockManager.unLockJavaObject((Object)reaperList);
                e.print();
                WindowsScriptReaper.removeTempFiles(context);
                MessageLog.setThreadLog((PrintWriter)oldLog);
                currentLog.close();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)WindowsScriptReaper.class.getName(), (String)"addJob");
                }
                return;
            }
            LockManager.unLockJavaObject((Object)reaperList);
            MessageLog.setThreadLog((PrintWriter)oldLog);
            currentLog.close();
            reaper.reapAll();
        } else {
            LockManager.unLockJavaObject((Object)reaperList);
            reaper.addJobToThis(context);
            LockManager.unLockJavaObject((Object)reaper);
            MessageLog.setThreadLog((PrintWriter)oldLog);
            currentLog.close();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)WindowsScriptReaper.class.getName(), (String)"addJob");
        }
    }

    private static native void initIDs();

    static {
        WindowsScriptReaper.initIDs();
        reaperList = new ListOfLinks();
    }
}

