/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.aperi.agent.util.SnmpPeer;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.xmsg.MessageLog;

public class Contactor {
    public NameList vendor;
    public int rc;
    public boolean temporaryError;
    public NameList communities;
    public SnmpPeer peer;
    public SnmpSession listener;
    public int vendorID;
    public static final String PUBLIC = "public";
    private NameList vendors;
    private int socketAllocErrors;
    private NameList tail;
    private boolean forDiscovery;
    private boolean isLast;
    private SnmpPDU sendPdu;
    private static final int MAX_ALLOC_ERRORS = 3;
    private static final String SYS_OID_STRING = ".1.3.6.1.2.1.1.2.0";
    private static final String SYS_NAME_STRING = ".1.3.6.1.2.1.1.5.0";
    private static final int[] enterprises = new int[]{1, 3, 6, 1, 4, 1};
    private static final OID enterprisesOID = new OID(enterprises);
    private static boolean snmpInitialized;
    private static OID sysObjectID_OID;
    private static OID sysName_OID;
    private static Vector OIDs;

    public Contactor(SnmpPeer pPeer, NameList pVendors, NameList pCommunities, boolean pForDiscovery) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Contactor.class.getName(), (String)"Contactor", (String)"pPeer, pVendors, pCommunities, pForDiscovery");
        }
        this.peer = pPeer;
        this.vendors = pVendors;
        this.forDiscovery = pForDiscovery;
        this.socketAllocErrors = 0;
        this.communities = pCommunities;
        boolean noPublic = true;
        NameList next = this.communities;
        while (next != null) {
            this.tail = next;
            if (noPublic && this.tail.nlName.equals(PUBLIC)) {
                noPublic = false;
            }
            next = this.tail.nlNext;
        }
        if (noPublic) {
            NameList publicCommunity = new NameList();
            publicCommunity.nlName = PUBLIC;
            publicCommunity.nlID = -1;
            if (this.tail != null) {
                this.tail.nlNext = publicCommunity;
            } else {
                this.communities = publicCommunity;
            }
            this.tail = publicCommunity;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Contactor.class.getName(), (String)"Contactor");
        }
    }

    public Contactor(SnmpPeer pPeer, NameList pVendors, NameList pCommunities) {
        this(pPeer, pVendors, pCommunities, true);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Contactor.class.getName(), (String)"Contactor", (String)"pPeer, pVendors, pCommunities");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Contactor.class.getName(), (String)"Contactor");
        }
    }

    private static boolean valueEqualsOID(Serializable value, OID oid) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Contactor.class.getName(), (String)"valueEqualsOID", (String)"value, oid");
        }
        if (value == null) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Contactor.class.getName(), (String)"valueEqualsOID", (boolean)traceResult);
            }
            return traceResult;
        }
        boolean traceResult = oid.equals((Object)value);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Contactor.class.getName(), (String)"valueEqualsOID", (boolean)traceResult);
        }
        return traceResult;
    }

    private String tryOneCommunity() {
        OID oid;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Contactor.class.getName(), (String)"tryOneCommunity", (String)"");
        }
        this.listener.changeCommName(this.communities.nlName);
        this.vendor = this.vendors;
        Object array = null;
        if (this.sendPdu == null) {
            this.sendPdu = this.listener.makePDU();
        }
        this.sendPdu.operation = 0;
        this.sendPdu.varBindList = OIDs;
        this.sendPdu.communityString = null;
        SnmpPDU respPdu = this.listener.send(this.sendPdu);
        if (respPdu != null && respPdu.errorStatus != 0) {
            if (!this.forDiscovery && this.isLast) {
                MessageLog.logMessage((String)"NAA0078E", (Object)this.peer.name);
                this.rc = 4;
            }
            String traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Contactor.class.getName(), (String)"tryOneCommunity", traceResult);
            }
            return traceResult;
        }
        if (respPdu == null || respPdu.varBindListSize() == 0) {
            if (!this.forDiscovery && this.isLast) {
                MessageLog.logMessage((String)"NAA0078E", (Object)this.peer.name);
                this.rc = 4;
            }
            String traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Contactor.class.getName(), (String)"tryOneCommunity", traceResult);
            }
            return traceResult;
        }
        Serializable sysName = null;
        Object sysObjectID = null;
        for (int i = 0; i < respPdu.varBindListSize(); ++i) {
            SnmpVarBind vb = respPdu.varBindAt(i);
            if (vb == null) continue;
            Serializable value = vb.getVar();
            oid = vb.getOID();
            if (sysObjectID == null && Contactor.valueEqualsOID((Serializable)oid, sysObjectID_OID)) {
                sysObjectID = value;
                continue;
            }
            if (sysName != null || !Contactor.valueEqualsOID((Serializable)oid, sysName_OID)) continue;
            sysName = value;
        }
        if (sysObjectID == null) {
            MessageLog.logMessage((String)"NAA0003W", (Object)this.peer.name, (Object)"sysObjectID");
            this.rc = 4;
            String traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Contactor.class.getName(), (String)"tryOneCommunity", traceResult);
            }
            return traceResult;
        }
        if (!(sysObjectID instanceof OID)) {
            this.rc = 4;
            String s = sysObjectID.getClass().getName();
            MessageLog.logMessage((String)"NAA0008W", (Object)this.peer.name, (Object)s);
            String traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Contactor.class.getName(), (String)"tryOneCommunity", traceResult);
            }
            return traceResult;
        }
        oid = (OID)sysObjectID;
        if (!oid.startsWith(enterprisesOID)) {
            this.rc = 4;
            MessageLog.logMessage((String)"NAA0009W", (Object)this.peer.name);
            String traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Contactor.class.getName(), (String)"tryOneCommunity", traceResult);
            }
            return traceResult;
        }
        this.vendorID = (int)oid.value[enterprises.length];
        if (this.vendors != null) {
            while (this.vendor != null && this.vendor.nlID != this.vendorID) {
                this.vendor = this.vendor.nlNext;
            }
            if (this.vendor == null) {
                if (!this.forDiscovery && this.isLast) {
                    Object[] args = new Object[]{this.peer.name, new Integer(this.vendorID)};
                    MessageLog.logMessage((String)"NAA0077E", (Object[])args);
                    this.rc = 4;
                }
                String traceResult = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Contactor.class.getName(), (String)"tryOneCommunity", traceResult);
                }
                return traceResult;
            }
        }
        if (sysName != null && sysName instanceof OctetString) {
            this.peer.name = ((OctetString)sysName).toDisplayString();
        }
        String traceResult = this.peer.name;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Contactor.class.getName(), (String)"tryOneCommunity", (Object)traceResult);
        }
        return traceResult;
    }

    private void cycleCommunities() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Contactor.class.getName(), (String)"cycleCommunities", (String)"");
        }
        this.tail.nlNext = this.communities;
        this.tail = this.communities;
        this.communities = this.communities.nlNext;
        this.tail.nlNext = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Contactor.class.getName(), (String)"cycleCommunities");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String contact() {
        String result;
        boolean going;
        block20: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Contactor.class.getName(), (String)"contact", (String)"");
            }
            this.rc = 0;
            this.temporaryError = false;
            this.listener = null;
            try {
                if (!snmpInitialized) {
                    Class<Contactor> clazz = Contactor.class;
                    // MONITORENTER : org.eclipse.aperi.agent.nas.Contactor.class
                    if (!snmpInitialized) {
                        SnmpV1API.initialize((int)-1);
                        snmpInitialized = true;
                    }
                    // MONITOREXIT : clazz
                }
                this.listener = SnmpSession.open((String)this.peer.name);
            }
            catch (SnmpUnknownHostException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Contactor.class.getName(), (String)"contact", (Throwable)e);
                }
                if (!this.forDiscovery) {
                    MessageLog.logException((String)"NAA0075E", (Exception)((Object)e), (Object)this.peer.name);
                }
            }
            catch (SnmpSocketException e) {
                String msgID;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Contactor.class.getName(), (String)"contact", (Throwable)e);
                }
                ++this.socketAllocErrors;
                if (this.socketAllocErrors < 3) {
                    this.temporaryError = true;
                    this.rc = 4;
                    msgID = "NAA0025W";
                } else {
                    this.rc = 8;
                    msgID = "NAA0025E";
                }
                MessageLog.logException((String)msgID, (Exception)((Object)e));
            }
            catch (Exception e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)Contactor.class.getName(), (String)"contact", (Throwable)e);
                }
                if (this.forDiscovery) break block20;
                MessageLog.logException((String)"NAA0114E", (Exception)e);
            }
        }
        if (this.listener == null) {
            String traceResult = null;
            if (!TraceLogger.enableTrace) return traceResult;
            TraceLogger.exit((String)Contactor.class.getName(), (String)"contact", traceResult);
            return traceResult;
        }
        this.socketAllocErrors = 0;
        NameList original = this.communities;
        do {
            this.isLast = this.communities.nlNext == null || this.communities.nlNext == original;
            result = this.tryOneCommunity();
            if (this.vendors == null) {
                going = result == null && this.rc == 0;
            } else {
                boolean bl = going = result == null && this.rc == 0 && this.vendor != null;
            }
            if (!going) continue;
            this.cycleCommunities();
        } while (going && !this.isLast);
        if (this.forDiscovery || result == null) {
            this.listener.close();
        }
        String traceResult = result;
        if (!TraceLogger.enableTrace) return traceResult;
        TraceLogger.exit((String)Contactor.class.getName(), (String)"contact", (Object)traceResult);
        return traceResult;
    }

    static {
        sysObjectID_OID = new OID(SYS_OID_STRING);
        sysName_OID = new OID(SYS_NAME_STRING);
        OIDs = new Vector();
        OIDs.addElement(new SnmpVarBind(sysObjectID_OID));
        OIDs.addElement(new SnmpVarBind(sysName_OID));
    }
}

